/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.operamasks.util.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanProperty {
    private final Class<?> type;
    private final Class<?> owner;
    private PropertyDescriptor descriptor;
    private Method read;
    private Method write;
    private String name;

    public BeanProperty(Class<?> owner, String propName, Method read, Method write) {
        this.owner = owner;
        this.name = propName;
        this.read = read;
        this.write = write;
        this.type = read.getReturnType();
    }

    public BeanProperty(Class<?> owner, PropertyDescriptor descriptor) {
        this.owner = owner;
        this.descriptor = descriptor;
        this.type = descriptor.getPropertyType();
        this.name = descriptor.getName();
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    public boolean isReadOnly() {
        return this.write == null && BeanUtils.getMethod(this.type, this.descriptor.getWriteMethod()) == null;
    }

    public Method getWriteMethod() {
        if (this.write == null) {
            this.write = BeanUtils.getMethod(this.owner, this.descriptor.getWriteMethod());
        }
        return this.write;
    }

    public Method getReadMethod() {
        if (this.read == null) {
            this.read = BeanUtils.getMethod(this.owner, this.descriptor.getReadMethod());
        }
        return this.read;
    }
}

