/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class XmlWriter
extends BufferedWriter {
    private Writer out;
    private CharsetEncoder encoder;
    private int indentStep = 2;
    private int tabSize = 8;
    private int indent = 0;
    private boolean beginingOfLine = true;
    private int state = 2;
    private static final int START_TAG = 0;
    private static final int END_TAG = 1;
    private static final int TEXT = 2;

    public XmlWriter(Writer out) {
        super(out);
        String encoding;
        this.out = out;
        if (out instanceof OutputStreamWriter && (encoding = ((OutputStreamWriter)out).getEncoding()) != null && !encoding.equalsIgnoreCase("utf-8")) {
            try {
                this.encoder = Charset.forName(encoding).newEncoder();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public XmlWriter(Writer out, int step) {
        this(out);
        this.indentStep = step;
    }

    public void write(int c) throws IOException {
        this.checkWrite();
        super.write(c);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (len > 0) {
            this.checkWrite();
        }
        super.write(cbuf, off, len);
    }

    public void write(String s, int off, int len) throws IOException {
        if (len > 0) {
            this.checkWrite();
        }
        super.write(s, off, len);
    }

    public void newLine() throws IOException {
        if (this.indentStep >= 0) {
            super.newLine();
            this.beginingOfLine = true;
        }
    }

    protected void checkWrite() throws IOException {
        if (this.indentStep < 0) {
            return;
        }
        if (this.beginingOfLine) {
            int i;
            this.beginingOfLine = false;
            for (i = this.indent; i >= this.tabSize; i -= this.tabSize) {
                super.write(9);
            }
            while (i > 0) {
                super.write(32);
                --i;
            }
        }
    }

    public void indentPlus() {
        if (this.indentStep > 0) {
            this.indent += this.indentStep;
        }
    }

    public void indentMinus() {
        if (this.indentStep > 0) {
            this.indent -= this.indentStep;
            if (this.indent < 0) {
                this.indent = 0;
            }
        }
    }

    public void writeln() throws IOException {
        this.newLine();
    }

    public void writeln(String s) throws IOException {
        this.write(s);
        this.newLine();
    }

    public void writeXmlDeclaration(String encoding) throws IOException {
        this.writeXmlDeclaration("1.0", encoding);
    }

    public void writeXmlDeclaration(String version, String encoding) throws IOException {
        if (version == null) {
            version = "1.0";
        }
        if (encoding == null && this.out instanceof OutputStreamWriter) {
            encoding = ((OutputStreamWriter)this.out).getEncoding();
        }
        this.write("<?xml version=\"");
        this.write(version);
        this.write(34);
        if (encoding != null) {
            this.write(" encoding=\"");
            this.write(encoding);
            this.write(34);
        }
        this.write("?>");
        this.writeln();
        this.writeln();
    }

    public void writeDocType(String rootElementName, String publicId, String systemId) throws IOException {
        this.write("<!DOCTYPE ");
        this.write(rootElementName);
        if (systemId != null) {
            if (publicId != null) {
                this.write(" PUBLIC '");
                this.write(publicId);
                this.write("' '");
            } else {
                this.write(" SYSTEM '");
            }
            this.write(systemId);
            this.write("'");
        }
        this.write(">");
        this.writeln();
    }

    private void finishStartTag() throws IOException {
        if (this.state == 0) {
            this.write(62);
        }
    }

    public void writeText(char[] data, int off, int len) throws IOException {
        this.finishStartTag();
        this.state = 2;
        int start = off;
        int last = off;
        int end = off + len;
        while (last < end) {
            char c2;
            char c = data[last];
            if (last + 1 < end && c >= '\ud800' && c <= '\udbff' && (c2 = data[last + 1]) >= '\udc00' && c2 <= '\udfff') {
                int cp = (c - 55296 << 10) + (c2 - 56320) + 65536;
                this.write(data, start, last - start);
                this.write("&#x");
                this.write(Integer.toHexString(cp));
                this.write(59);
                start = last += 2;
                continue;
            }
            if (!this.canEncode(c)) {
                this.write(data, start, last - start);
                start = last + 1;
                this.write("&#x");
                this.write(Integer.toHexString(c));
                this.write(59);
            } else if (c == '<') {
                this.write(data, start, last - start);
                start = last + 1;
                this.write("&lt;");
            } else if (c == '>') {
                this.write(data, start, last - start);
                start = last + 1;
                this.write("&gt;");
            } else if (c == '&') {
                this.write(data, start, last - start);
                start = last + 1;
                this.write("&amp;");
            }
            ++last;
        }
        this.write(data, start, last - start);
    }

    public void writeText(String text) throws IOException {
        this.finishStartTag();
        this.state = 2;
        int len = text.length();
        int start = 0;
        int last = 0;
        while (last < len) {
            char c2;
            char c = text.charAt(last);
            if (last + 1 < len && c >= '\ud800' && c <= '\udbff' && (c2 = text.charAt(last + 1)) >= '\udc00' && c2 <= '\udfff') {
                int cp = (c - 55296 << 10) + (c2 - 56320) + 65536;
                this.write(text, start, last - start);
                this.write("&#x");
                this.write(Integer.toHexString(cp));
                this.write(59);
                start = last += 2;
                continue;
            }
            if (!this.canEncode(c)) {
                this.write(text, start, last - start);
                start = last + 1;
                this.write("&#x");
                this.write(Integer.toHexString(c));
                this.write(59);
            } else if (c == '<') {
                this.write(text, start, last - start);
                start = last + 1;
                this.write("&lt;");
            } else if (c == '>') {
                this.write(text, start, last - start);
                start = last + 1;
                this.write("&gt;");
            } else if (c == '&') {
                this.write(text, start, last - start);
                start = last + 1;
                this.write("&amp;");
            }
            ++last;
        }
        this.write(text, start, last - start);
    }

    private boolean canEncode(char c) {
        if (this.encoder != null && !this.encoder.canEncode(c)) {
            return false;
        }
        if (c >= '\u0001' && c <= '\u001f' && c != '\t' && c != '\n' && c != '\r') {
            return false;
        }
        return c < '\u007f' || c > '\u009f' || c == '\u0085';
    }

    public void writeCDATA(char[] data, int off, int len) throws IOException {
        this.finishStartTag();
        this.state = 2;
        this.write("<![CDATA[");
        int end = off + len;
        for (int i = off; i < end; ++i) {
            char c = data[i];
            if (c == ']' && i + 2 < end && data[i + 1] == ']' && data[i + 2] == '>') {
                this.write("]]]]><![CDATA[>");
                i += 2;
                continue;
            }
            this.write(c);
        }
        this.write("]]>");
    }

    public void writeCDATA(String data) throws IOException {
        this.finishStartTag();
        this.state = 2;
        int length = data.length();
        this.write("<![CDATA[");
        for (int i = 0; i < length; ++i) {
            char c = data.charAt(i);
            if (c == ']' && i + 2 < length && data.charAt(i + 1) == ']' && data.charAt(i + 2) == '>') {
                this.write("]]]]><![CDATA[>");
                i += 2;
                continue;
            }
            this.write(c);
        }
        this.write("]]>");
    }

    public void writeStartTag(String tag) throws IOException {
        if (this.state == 0) {
            this.write(62);
            this.writeln();
            this.indentPlus();
        } else if (this.state == 1) {
            this.writeln();
        }
        this.write(60);
        this.write(tag);
        this.state = 0;
    }

    public void writeEndTag(String tag) throws IOException {
        if (this.state == 0) {
            this.write("/>");
        } else {
            if (this.state == 1) {
                this.writeln();
                this.indentMinus();
            }
            this.write("</");
            this.write(tag);
            this.write(62);
        }
        this.state = 1;
    }

    public void writeAttribute(String name, String value) throws IOException {
        this.write(32);
        this.write(name);
        this.write("=\"");
        int len = value.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '<': {
                    this.write("&lt;");
                    continue block7;
                }
                case '>': {
                    this.write("&gt;");
                    continue block7;
                }
                case '&': {
                    this.write("&amp;");
                    continue block7;
                }
                case '\'': {
                    this.write("&apos;");
                    continue block7;
                }
                case '\"': {
                    this.write("&quot;");
                    continue block7;
                }
                default: {
                    char c2;
                    if (i + 1 < len && c >= '\ud800' && c <= '\udbff' && (c2 = value.charAt(i + 1)) >= '\udc00' && c2 <= '\udfff') {
                        int cp = (c - 55296 << 10) + (c2 - 56320) + 65536;
                        this.write("&#x");
                        this.write(Integer.toHexString(cp));
                        this.write(59);
                        ++i;
                        continue block7;
                    }
                    if (!this.canEncode(c)) {
                        this.write("&#x");
                        this.write(Integer.toHexString(c));
                        this.write(59);
                        continue block7;
                    }
                    this.write(c);
                }
            }
        }
        this.write(34);
    }

    public void writeTaggedText(String tag, String text) throws IOException {
        this.writeStartTag(tag);
        if (text != null) {
            this.writeText(text);
        }
        this.writeEndTag(tag);
    }

    public void writeEmptyTag(String tag) throws IOException {
        this.writeStartTag(tag);
        this.writeEndTag(tag);
    }

    public void writeProcessingInstruction(String target, String data) throws IOException {
        this.finishStartTag();
        this.state = 2;
        this.write("<?");
        this.write(target);
        if (data != null) {
            this.write(32);
            this.write(data);
        }
        this.write("?>");
    }

    public void writeComment(String data) throws IOException {
        this.finishStartTag();
        this.state = 2;
        this.write("<!--");
        if (data != null) {
            boolean sawDash = false;
            int length = data.length();
            for (int i = 0; i < length; ++i) {
                char c = data.charAt(i);
                if (c == '-') {
                    if (sawDash) {
                        this.write(32);
                    } else {
                        sawDash = true;
                    }
                } else {
                    sawDash = false;
                }
                this.write(c);
            }
            if (sawDash) {
                this.write(32);
            }
        }
        this.write("-->");
    }
}

