/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.arithmetic.fields;

import com.entrust.toolkit.security.arithmetic.fields.Field;
import com.entrust.toolkit.security.arithmetic.fields.FieldElement;
import com.entrust.toolkit.security.arithmetic.fields.GFp;
import com.entrust.toolkit.security.arithmetic.fields.GFpElement;
import com.entrust.toolkit.security.arithmetic.fields.Polynomial;
import com.entrust.toolkit.security.arithmetic.fields.PolynomialField;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.OCTET_STRING;
import java.math.BigInteger;

public class FieldElementFactory {
    private static FieldElement a(byte[] byArray, Field field) throws IllegalArgumentException, CodingException {
        FieldElement fieldElement = null;
        BigInteger bigInteger = new BigInteger(1, byArray);
        if (field instanceof GFp) {
            fieldElement = new GFpElement(bigInteger, (GFp)field);
        } else if (field instanceof PolynomialField) {
            fieldElement = new Polynomial(bigInteger, (PolynomialField)field);
        } else {
            throw new IllegalArgumentException("unknown field implementation");
        }
        return fieldElement;
    }

    public static FieldElement getInstance(byte[] byArray, Field field) throws IllegalArgumentException, CodingException {
        return FieldElementFactory.a(byArray, field);
    }

    public static FieldElement getInstance(ASN1Object aSN1Object, Field field) throws IllegalArgumentException, CodingException {
        OCTET_STRING oCTET_STRING = (OCTET_STRING)aSN1Object;
        byte[] byArray = (byte[])oCTET_STRING.getValue();
        return FieldElementFactory.a(byArray, field);
    }
}

