/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.arithmetic.groups.ellipticCurve;

import com.entrust.toolkit.security.arithmetic.fields.Field;
import com.entrust.toolkit.security.arithmetic.fields.FieldElement;
import com.entrust.toolkit.security.arithmetic.fields.FieldElementFactory;
import com.entrust.toolkit.security.arithmetic.fields.GFp;
import com.entrust.toolkit.security.arithmetic.fields.Polynomial;
import com.entrust.toolkit.security.arithmetic.fields.PolynomialField;
import com.entrust.toolkit.security.arithmetic.groups.ellipticCurve.ECPoint;
import com.entrust.toolkit.security.arithmetic.groups.ellipticCurve.ECPointGFp;
import com.entrust.toolkit.security.arithmetic.groups.ellipticCurve.EllipticCurve;
import com.entrust.toolkit.security.arithmetic.groups.ellipticCurve.PolynomeECPoint;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.OCTET_STRING;
import java.math.BigInteger;

public class ECPointFactory {
    public static ECPoint getInstance(ASN1Object aSN1Object, EllipticCurve ellipticCurve) throws IllegalArgumentException, CodingException {
        ECPoint eCPoint;
        Field field = ellipticCurve.getField();
        OCTET_STRING oCTET_STRING = (OCTET_STRING)aSN1Object;
        byte[] byArray = (byte[])oCTET_STRING.getValue();
        if (byArray.length == 1 & byArray[0] == 0) {
            eCPoint = ECPointFactory.getInstance(ellipticCurve);
        } else {
            int n2 = byArray.length;
            BigInteger bigInteger = ellipticCurve.getField().getNumberOfElements();
            int n3 = (bigInteger.bitLength() + 7) / 8;
            if (n2 != 2 * n3 + 1) {
                throw new IllegalArgumentException("Bad ASN1Object or the element is of non-supported compressed form.");
            }
            byte[] byArray2 = new byte[1];
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, 1);
            System.arraycopy(byArray, 1, byArray3, 0, n3);
            FieldElement fieldElement = FieldElementFactory.getInstance(byArray3, ellipticCurve.getField());
            byte[] byArray4 = new byte[n3];
            System.arraycopy(byArray, n3 + 1, byArray4, 0, n3);
            if (byArray2[0] == 4 | byArray2[0] == 6 | byArray2[0] == 7) {
                FieldElement fieldElement2 = FieldElementFactory.getInstance(byArray4, field);
                eCPoint = ECPointFactory.getInstance(fieldElement, fieldElement2, ellipticCurve);
            } else {
                throw new IllegalArgumentException("unknown EC point format, possibly compressed");
            }
        }
        return eCPoint;
    }

    public static ECPoint getInstance(EllipticCurve ellipticCurve) {
        if (ellipticCurve.getField() instanceof GFp) {
            return new ECPointGFp(ellipticCurve);
        }
        if (ellipticCurve.getField() instanceof PolynomialField) {
            return new PolynomeECPoint(ellipticCurve);
        }
        throw new IllegalArgumentException("unknown Field implementation");
    }

    public static ECPoint getInstance(FieldElement fieldElement, FieldElement fieldElement2, EllipticCurve ellipticCurve) throws IllegalArgumentException {
        if (ellipticCurve.getField() instanceof GFp) {
            return new ECPointGFp(fieldElement, fieldElement2, ellipticCurve);
        }
        if (ellipticCurve.getField() instanceof PolynomialField) {
            return new PolynomeECPoint((Polynomial)fieldElement, (Polynomial)fieldElement2, ellipticCurve);
        }
        throw new IllegalArgumentException("unknown Field implementation");
    }
}

