/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.arithmetic.groups.ellipticCurve;

import com.entrust.toolkit.security.arithmetic.fields.Field;
import com.entrust.toolkit.security.arithmetic.fields.FieldElement;
import com.entrust.toolkit.security.arithmetic.fields.FieldElementFactory;
import com.entrust.toolkit.security.arithmetic.groups.ellipticCurve.ECPoint;
import com.entrust.toolkit.security.arithmetic.groups.ellipticCurve.ECPointFactory;
import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.SEQUENCE;
import java.math.BigInteger;

public class EllipticCurve {
    Field b;
    BigInteger a;
    FieldElement c;
    FieldElement d;

    public String toString() {
        String string = "(a is " + this.d.getBigInteger().toString(16) + "\n";
        string = String.valueOf(string) + " b is " + this.c.getBigInteger().toString(16) + "\n";
        string = String.valueOf(string) + " field is a " + this.b.toString() + "\n";
        string = this.a == null ? String.valueOf(string) + " seed is empty\n" : String.valueOf(string) + " seed is " + this.a.toString(16) + ")\n";
        return string;
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.d.toASN1Object());
        sEQUENCE.addComponent(this.c.toASN1Object());
        if (this.a != null) {
            sEQUENCE.addComponent(new BIT_STRING(this.a.toByteArray()));
        }
        return sEQUENCE;
    }

    public BigInteger getSeed() {
        return this.a;
    }

    public ECPoint getPointOfInfinity() {
        return ECPointFactory.getInstance(this);
    }

    public Field getField() {
        return this.b;
    }

    public FieldElement getB() {
        return this.c;
    }

    public FieldElement getA() {
        return this.d;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof EllipticCurve)) {
            return false;
        }
        EllipticCurve ellipticCurve = (EllipticCurve)object;
        if (!this.b.equals(ellipticCurve.b)) {
            return false;
        }
        return this.d.equals(ellipticCurve.d) && this.c.equals(ellipticCurve.c);
    }

    public EllipticCurve(ASN1Object aSN1Object, Field field) throws IllegalArgumentException {
        this.b = field;
        if (!aSN1Object.getAsnType().equals(ASN.SEQUENCE)) {
            throw new IllegalArgumentException("ASN1Object is of wrong form.");
        }
        SEQUENCE sEQUENCE = (SEQUENCE)aSN1Object;
        ASN1Object aSN1Object2 = sEQUENCE.getComponentAt(0);
        ASN1Object aSN1Object3 = sEQUENCE.getComponentAt(1);
        try {
            this.d = FieldElementFactory.getInstance(aSN1Object2, this.b);
            this.c = FieldElementFactory.getInstance(aSN1Object3, this.b);
        }
        catch (CodingException codingException) {
            throw new IllegalArgumentException("Problems in retrieving the field element. " + codingException.getMessage());
        }
        if (sEQUENCE.countComponents() == 3) {
            ASN1Object aSN1Object4 = sEQUENCE.getComponentAt(2);
            if (!aSN1Object4.getAsnType().equals(ASN.BIT_STRING)) {
                throw new IllegalArgumentException("ASN1Object is of wrong form.");
            }
            BIT_STRING bIT_STRING = (BIT_STRING)aSN1Object4;
            byte[] byArray = (byte[])bIT_STRING.getValue();
            this.a = new BigInteger(byArray);
        } else {
            this.a = null;
        }
    }

    public EllipticCurve(FieldElement fieldElement, FieldElement fieldElement2, BigInteger bigInteger) {
        this.d = fieldElement;
        this.c = fieldElement2;
        this.a = bigInteger;
        this.b = fieldElement.getField();
    }
}

