/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.arithmetic.groups.ellipticCurve;

import com.entrust.toolkit.security.arithmetic.fields.FieldElement;
import com.entrust.toolkit.security.arithmetic.fields.Polynomial;
import com.entrust.toolkit.security.arithmetic.groups.ellipticCurve.ECPoint;
import com.entrust.toolkit.security.arithmetic.groups.ellipticCurve.EllipticCurve;
import iaik.asn1.ASN1Object;
import iaik.asn1.OCTET_STRING;
import java.math.BigInteger;

public class PolynomeECPoint
extends ECPoint {
    PolynomeECPoint g;
    PolynomeECPoint f;
    Polynomial a;
    Polynomial k;
    Polynomial i;
    Polynomial j;
    volatile Polynomial h;
    volatile Polynomial d;
    volatile Polynomial e;
    EllipticCurve l;
    volatile Polynomial m;
    volatile Polynomial n;
    Polynomial b;
    Polynomial c;

    public String toString() {
        if (this.c == null) {
            return "( 0 )";
        }
        return "(" + this.c.getBigInteger().toString(16) + "," + this.b.getBigInteger().toString(16) + ")";
    }

    public ASN1Object toASN1Object() {
        byte[] byArray = null;
        if (this.c == null) {
            byArray = new byte[]{0};
        } else {
            byte[] byArray2 = (byte[])((OCTET_STRING)this.c.toASN1Object()).getValue();
            byte[] byArray3 = (byte[])((OCTET_STRING)this.b.toASN1Object()).getValue();
            int n2 = byArray2.length + byArray3.length + 1;
            byArray = new byte[n2];
            byArray[0] = 4;
            System.arraycopy(byArray2, 0, byArray, 1, byArray2.length);
            System.arraycopy(byArray3, 0, byArray, 1 + byArray2.length, byArray3.length);
        }
        return new OCTET_STRING(byArray);
    }

    public void setDoublePoint() {
        if (this.c == null) {
            return;
        }
        if (this.c.equals(this.a)) {
            this.c = null;
            this.b = null;
            return;
        }
        this.h.copy(this.c);
        this.h.setMultiplicativeInverse();
        this.h.setMultiply(this.b);
        this.h.setAdd(this.c);
        this.e.copy(this.h);
        this.e.setMultiply(this.h);
        this.e.setAdd(this.h);
        this.e.setAdd((Polynomial)this.l.getA());
        this.d.copy(this.k);
        this.d.setAdd(this.h);
        this.d.setMultiply(this.e);
        this.j.copy(this.c);
        this.j.setMultiply(this.c);
        this.d.setAdd(this.j);
        this.c.copy(this.e);
        this.b.copy(this.d);
    }

    void a(PolynomeECPoint polynomeECPoint) {
        if (polynomeECPoint.c == null) {
            return;
        }
        if (this.c == null) {
            this.c = this.n;
            this.b = this.m;
            this.c.copy(polynomeECPoint.c);
            this.b.copy(polynomeECPoint.b);
            return;
        }
        if (this.c.equals(polynomeECPoint.c)) {
            if (this.b.equals(polynomeECPoint.b)) {
                this.setDoublePoint();
            } else {
                this.c = null;
                this.b = null;
                return;
            }
        }
        this.i.copy(this.c);
        this.i.setAdd(polynomeECPoint.c);
        this.h.copy(this.b);
        this.h.setAdd(polynomeECPoint.b);
        this.j.copy(this.i);
        this.j.setMultiplicativeInverse();
        this.h.setMultiply(this.j);
        this.e.copy(this.h);
        this.e.setMultiply(this.h);
        this.e.setAdd(this.h);
        this.e.setAdd(this.i);
        this.e.setAdd((Polynomial)this.l.getA());
        this.d.copy(this.c);
        this.d.setAdd(this.e);
        this.d.setMultiply(this.h);
        this.d.setAdd(this.e);
        this.d.setAdd(this.b);
        this.c.copy(this.e);
        this.b.copy(this.d);
    }

    public ECPoint multiply(BigInteger bigInteger) {
        if (this.c == null) {
            return this;
        }
        if (bigInteger.compareTo(BigInteger.valueOf(0L)) == 0) {
            return new PolynomeECPoint(this.l);
        }
        BigInteger bigInteger2 = bigInteger.multiply(BigInteger.valueOf(3L));
        PolynomeECPoint polynomeECPoint = new PolynomeECPoint(this.c, this.b, this.l);
        this.f.c.copy(this.c);
        this.f.b.copy(this.b);
        this.g.c.copy(this.c);
        this.g.b.copy(this.b);
        this.g.b.setAdd(this.c);
        int n2 = bigInteger2.bitLength() - 1;
        while (--n2 > 0) {
            polynomeECPoint.setDoublePoint();
            if (bigInteger2.testBit(n2) && !bigInteger.testBit(n2)) {
                polynomeECPoint.a(this.f);
                continue;
            }
            if (!bigInteger.testBit(n2) || bigInteger2.testBit(n2)) continue;
            polynomeECPoint.a(this.g);
        }
        return polynomeECPoint;
    }

    public boolean isPointAtInfinity() {
        return this.c == null;
    }

    public FieldElement getYCoordinate() {
        return this.b;
    }

    public FieldElement getXCoordinate() {
        return this.c;
    }

    public EllipticCurve getCurve() {
        return this.l;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PolynomeECPoint)) {
            return false;
        }
        PolynomeECPoint polynomeECPoint = (PolynomeECPoint)object;
        if (!this.l.equals(polynomeECPoint.l)) {
            return false;
        }
        if (this.c == null) {
            return polynomeECPoint.c == null;
        }
        return this.c.equals(polynomeECPoint.c) && this.b.equals(polynomeECPoint.b);
    }

    public ECPoint doublePoint() {
        if (this.c == null) {
            return this;
        }
        if (this.c.equals(this.a)) {
            return new PolynomeECPoint(this.l);
        }
        this.h.copy(this.c);
        this.h.setMultiplicativeInverse();
        this.h.setMultiply(this.b);
        this.h.setAdd(this.c);
        this.e.copy(this.h);
        this.e.setMultiply(this.h);
        this.e.setAdd(this.h);
        this.e.setAdd((Polynomial)this.l.getA());
        this.d.copy(this.k);
        this.d.setAdd(this.h);
        this.d.setMultiply(this.e);
        this.j.copy(this.c);
        this.j.setMultiply(this.c);
        this.d.setAdd(this.j);
        return new PolynomeECPoint(this.e, this.d, this.l);
    }

    public ECPoint add(ECPoint eCPoint) {
        if (!(eCPoint instanceof PolynomeECPoint)) {
            throw new IllegalArgumentException();
        }
        PolynomeECPoint polynomeECPoint = (PolynomeECPoint)eCPoint;
        if (!this.l.equals(polynomeECPoint.l)) {
            throw new IllegalArgumentException();
        }
        if (this.c == null) {
            return polynomeECPoint;
        }
        if (polynomeECPoint.c == null) {
            return this;
        }
        if (this.c.equals(polynomeECPoint.c)) {
            if (this.b.equals(polynomeECPoint.b)) {
                return this.doublePoint();
            }
            return new PolynomeECPoint(this.l);
        }
        Polynomial polynomial = new Polynomial(this.b);
        polynomial.setAdd(polynomeECPoint.b);
        Polynomial polynomial2 = new Polynomial(this.c);
        polynomial2.setAdd(polynomeECPoint.c);
        polynomial2.setMultiplicativeInverse();
        polynomial.setMultiply(polynomial2);
        Polynomial polynomial3 = new Polynomial(polynomial);
        polynomial3.setMultiply(polynomial);
        polynomial3.setAdd(polynomial);
        polynomial3.setAdd(this.c);
        polynomial3.setAdd(polynomeECPoint.c);
        polynomial3.setAdd((Polynomial)this.l.getA());
        Polynomial polynomial4 = new Polynomial(this.c);
        polynomial4.setAdd(polynomial3);
        polynomial4.setMultiply(polynomial);
        polynomial4.setAdd(polynomial3);
        polynomial4.setAdd(this.b);
        return new PolynomeECPoint(polynomial3, polynomial4, this.l);
    }

    private PolynomeECPoint(PolynomeECPoint polynomeECPoint) {
        this.n = new Polynomial(polynomeECPoint.n);
        this.m = new Polynomial(polynomeECPoint.m);
        if (polynomeECPoint.c == null) {
            this.c = null;
            this.b = null;
        } else {
            this.c = this.n;
            this.b = this.m;
        }
        this.l = polynomeECPoint.l;
        this.e = null;
        this.d = null;
        this.h = null;
        this.j = null;
        this.i = null;
        this.k = null;
        this.a = null;
        this.f = null;
        this.g = null;
    }

    public PolynomeECPoint(EllipticCurve ellipticCurve) {
        this.c = null;
        this.b = null;
        this.l = ellipticCurve;
        this.e = new Polynomial((Polynomial)this.l.d);
        this.d = new Polynomial(this.e);
        this.h = new Polynomial(this.e);
        this.j = new Polynomial(this.e);
        this.i = new Polynomial(this.e);
        this.k = (Polynomial)ellipticCurve.b.getOneElement();
        this.a = (Polynomial)ellipticCurve.b.getZeroElement();
        this.n = new Polynomial(this.e);
        this.m = new Polynomial(this.e);
        this.f = new PolynomeECPoint(this);
        this.g = new PolynomeECPoint(this);
    }

    public PolynomeECPoint(Polynomial polynomial, Polynomial polynomial2, EllipticCurve ellipticCurve) {
        this.c = new Polynomial(polynomial);
        this.b = new Polynomial(polynomial2);
        this.l = ellipticCurve;
        this.e = new Polynomial((Polynomial)this.l.d);
        this.d = new Polynomial(this.e);
        this.h = new Polynomial(this.e);
        this.j = new Polynomial(this.e);
        this.i = new Polynomial(this.e);
        this.k = (Polynomial)ellipticCurve.b.getOneElement();
        this.a = (Polynomial)ellipticCurve.b.getZeroElement();
        this.n = this.c;
        this.m = this.b;
        this.f = new PolynomeECPoint(this);
        this.g = new PolynomeECPoint(this);
    }
}

