/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.provider;

import com.entrust.toolkit.security.provider.ECDSAPrivateKey;
import com.entrust.toolkit.security.provider.ECDSAPublicKey;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class ECDSAKeyFactory
extends KeyFactorySpi {
    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        throw new InvalidKeyException("Method engineTranslateKey is not yet implemented in ECDSAKeyFactory");
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        throw new InvalidKeySpecException("Method engineGetKeySpec is not yet implemented in ECDSAKeyFactory");
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof ECDSAPublicKey) {
                return (ECDSAPublicKey)keySpec;
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new ECDSAPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Only ECDSA key specs allowed.");
        }
        catch (Exception exception) {
            throw new InvalidKeySpecException("Invalid KeySpec. Does not fit to ECDSA.");
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof ECDSAPrivateKey) {
                return (ECDSAPrivateKey)keySpec;
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                return new ECDSAPrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Only ECDSA key specs allowed.");
        }
        catch (Exception exception) {
            throw new InvalidKeySpecException("Invalid KeySpec. Does not fit to ECDSA.");
        }
    }
}

