/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.provider;

import com.entrust.toolkit.security.arithmetic.groups.ellipticCurve.ECPoint;
import com.entrust.toolkit.security.fips.SecurityEngine;
import com.entrust.toolkit.security.provider.ECDSAPrivateKey;
import com.entrust.toolkit.security.provider.ECDSAPublicKey;
import com.entrust.toolkit.security.provider.ECParameters;
import com.entrust.toolkit.security.provider.NamedCurveFactory;
import iaik.asn1.ObjectID;
import iaik.security.random.SecRandom;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;

public class ECDSAKeyPairGenerator
extends KeyPairGenerator {
    private static final byte[] g;
    private static BigInteger f;
    private static BigInteger e;
    private static ObjectID d;
    private SecureRandom a;
    private int c;
    private ECParameters b = null;

    private void a(KeyPair keyPair) {
        try {
            Signature signature = Signature.getInstance("ECDSA");
            signature.initSign(keyPair.getPrivate());
            signature.update(g);
            byte[] byArray = signature.sign();
            signature.initVerify(keyPair.getPublic());
            signature.update(g);
            if (!signature.verify(byArray)) {
                SecurityEngine.setErrorState("ECDSA pair-wise consistency test failed");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            SecurityEngine.setErrorState("Unable to perform pair-wise consistency test - please ensure all required Providers are registered");
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (SignatureException signatureException) {}
    }

    public void initialize(ECParameters eCParameters, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (eCParameters instanceof ECParameters) {
            if (eCParameters.getField().getNumberOfElements().bitLength() < 160) {
                throw new InvalidAlgorithmParameterException("The key size contained in param is less than 160 bit. This is too small.");
            }
        } else {
            throw new InvalidAlgorithmParameterException("The input value param shall be a ECParameter object.");
        }
        this.b = eCParameters;
    }

    public void initialize(ECParameters eCParameters) throws InvalidAlgorithmParameterException {
        this.initialize(eCParameters, null);
    }

    public void initialize(int n2, SecureRandom secureRandom) throws InvalidParameterException {
        if (n2 < 160) {
            throw new InvalidParameterException("Don't support this key size. It is too small.");
        }
        this.c = n2;
        this.b = NamedCurveFactory.getInstance(n2);
        if (this.b == null) {
            throw new InvalidParameterException("Don't support a named curve with that length. You have to register a curve with this length in class NamedCurveFactory.");
        }
    }

    public void initialize(int n2) throws InvalidParameterException {
        this.initialize(n2, null);
    }

    public KeyPair generateKeyPair() {
        ECPoint eCPoint;
        BigInteger bigInteger;
        SecurityEngine.assertCryptoOperationsAllowed();
        if (this.b == null) {
            this.b = NamedCurveFactory.getInstance(d);
        }
        this.a = SecRandom.getDefault();
        this.a.nextBytes(new byte[5]);
        BigInteger bigInteger2 = this.b.getOrder();
        byte[] byArray = new byte[bigInteger2.bitLength()];
        ECPoint eCPoint2 = this.b.getBase();
        byte[] byArray2 = new byte[20];
        byte[] byArray3 = new byte[20];
        byte[] byArray4 = new byte[40];
        do {
            this.a.nextBytes(byArray2);
            this.a.nextBytes(byArray3);
            System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
            System.arraycopy(byArray3, 0, byArray4, byArray2.length, byArray3.length);
            BigInteger bigInteger3 = new BigInteger(1, byArray4);
            bigInteger = bigInteger3.mod(bigInteger2);
            if (bigInteger.compareTo(e) == -1) {
                bigInteger = bigInteger.add(bigInteger2);
            }
            eCPoint = eCPoint2.multiply(bigInteger);
        } while (bigInteger.compareTo(e) == 0 | eCPoint.isPointAtInfinity());
        ECDSAPrivateKey eCDSAPrivateKey = new ECDSAPrivateKey(this.b, bigInteger);
        ECDSAPublicKey eCDSAPublicKey = new ECDSAPublicKey(this.b, eCPoint);
        bigInteger = null;
        int n2 = 0;
        while (n2 < 20) {
            byArray4[n2 + 20] = 0;
            byArray4[n2] = 0;
            byArray2[n2] = 0;
            byArray3[n2] = 0;
            ++n2;
        }
        KeyPair keyPair = new KeyPair(eCDSAPublicKey, eCDSAPrivateKey);
        if (SecurityEngine.isInFIPSMode()) {
            this.a(keyPair);
        }
        return keyPair;
    }

    public ECDSAKeyPairGenerator() {
        super("ECDSA");
    }

    static {
        d = new ObjectID("1.2.840.10045.3.1.1");
        e = BigInteger.valueOf(0L);
        f = BigInteger.valueOf(1L);
        g = new byte[]{97, 98, 99};
    }
}

