/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.provider;

import com.entrust.toolkit.security.provider.ECDSAPublicKey;
import com.entrust.toolkit.security.provider.ECParameters;
import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.spec.KeySpec;

public class ECDSAPrivateKey
extends PrivateKeyInfo
implements Cloneable,
Serializable,
PrivateKey,
KeySpec,
Key {
    private BigInteger a;

    public BigInteger getPrivateExponent() {
        return this.a;
    }

    public String getFormat() {
        return new String("PKCS#8");
    }

    public ECParameters getECParameters() throws CodingException {
        ECParameters eCParameters = new ECParameters(this.private_key_algorithm.getParameter());
        return eCParameters;
    }

    public String getAlgorithm() {
        return new String("ECDSA");
    }

    public byte[] encode() {
        INTEGER iNTEGER = new INTEGER(this.a);
        ASN1 aSN1 = null;
        try {
            aSN1 = new ASN1(iNTEGER);
        }
        catch (CodingException codingException) {
            throw new IllegalArgumentException("Fatal internal error.");
        }
        return aSN1.toByteArray();
    }

    public void decode(byte[] byArray) throws InvalidKeyException {
        ASN1 aSN1 = null;
        try {
            aSN1 = new ASN1(byArray);
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException(codingException.getMessage());
        }
        ASN1Object aSN1Object = aSN1.toASN1Object();
        if (!aSN1Object.isA(ASN.INTEGER)) {
            throw new InvalidKeyException("Given object is illformed. Private Expoenent is not encoded as a wrapped INTEGER.");
        }
        INTEGER iNTEGER = (INTEGER)aSN1Object;
        BigInteger bigInteger = (BigInteger)iNTEGER.getValue();
        byte[] byArray2 = bigInteger.toByteArray();
        this.a = new BigInteger(1, byArray2);
    }

    public ECDSAPrivateKey(byte[] byArray) throws InvalidKeyException {
        super(byArray);
    }

    public ECDSAPrivateKey(InputStream inputStream) throws IOException, InvalidKeyException {
        super(inputStream);
    }

    public ECDSAPrivateKey(ASN1Object aSN1Object) throws InvalidKeyException {
        super(aSN1Object);
    }

    public ECDSAPrivateKey(ECParameters eCParameters, BigInteger bigInteger) {
        this.private_key_algorithm = new AlgorithmID(ECDSAPublicKey.EC_PUBLIC_KEY, eCParameters.toASN1Object());
        this.a = bigInteger;
        this.createPrivateKeyInfo();
    }
}

