/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.provider;

import com.entrust.toolkit.security.arithmetic.groups.ellipticCurve.ECPoint;
import com.entrust.toolkit.security.arithmetic.groups.ellipticCurve.ECPointFactory;
import com.entrust.toolkit.security.provider.ECParameters;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.x509.PublicKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.spec.KeySpec;

public class ECDSAPublicKey
extends PublicKeyInfo
implements KeySpec,
Serializable {
    public static final ObjectID EC_PUBLIC_KEY = new ObjectID("1.2.840.10045.2.1");
    private ECPoint a;

    public ECPoint getECPublicPoint() {
        return this.a;
    }

    public ECParameters getECParameters() throws CodingException {
        ECParameters eCParameters = new ECParameters(this.public_key_algorithm.getParameter());
        return eCParameters;
    }

    public String getAlgorithm() {
        return new String("ECDSA");
    }

    public byte[] encode() {
        OCTET_STRING oCTET_STRING = (OCTET_STRING)this.a.toASN1Object();
        byte[] byArray = (byte[])oCTET_STRING.getValue();
        return byArray;
    }

    public void decode(byte[] byArray) throws InvalidKeyException {
        try {
            OCTET_STRING oCTET_STRING = new OCTET_STRING(byArray);
            this.a = ECPointFactory.getInstance(oCTET_STRING, this.getECParameters().getCurve());
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException(codingException.getMessage());
        }
    }

    public ECDSAPublicKey(byte[] byArray) throws InvalidKeyException {
        super(byArray);
    }

    public ECDSAPublicKey(InputStream inputStream) throws IOException, InvalidKeyException {
        super(inputStream);
    }

    public ECDSAPublicKey(ASN1Object aSN1Object) throws InvalidKeyException {
        super(aSN1Object);
    }

    public ECDSAPublicKey(ECParameters eCParameters, ECPoint eCPoint) {
        this.public_key_algorithm = new AlgorithmID(EC_PUBLIC_KEY, eCParameters.toASN1Object());
        this.a = eCPoint;
        this.createPublicKeyInfo();
    }
}

