/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.provider;

import com.entrust.toolkit.security.arithmetic.fields.Field;
import com.entrust.toolkit.security.arithmetic.fields.FieldFactory;
import com.entrust.toolkit.security.arithmetic.groups.ellipticCurve.ECPoint;
import com.entrust.toolkit.security.arithmetic.groups.ellipticCurve.ECPointFactory;
import com.entrust.toolkit.security.arithmetic.groups.ellipticCurve.EllipticCurve;
import com.entrust.toolkit.security.provider.EntrustECDSA;
import com.entrust.toolkit.security.provider.NamedCurveFactory;
import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;

public class ECParameters
implements AlgorithmParameterSpec {
    private ObjectID b = null;
    private BigInteger e = null;
    private BigInteger a;
    private ECPoint f;
    private EllipticCurve d;
    private Field c;

    public String toString() {
        String string = "ECParameter is given by \n";
        string = String.valueOf(string) + "Version is 1\n";
        string = String.valueOf(string) + "Elliptic Curve is\n" + this.d.toString() + "\n";
        string = String.valueOf(string) + "Base is " + this.f.toString() + "\n";
        string = String.valueOf(string) + "Order is " + this.a.toString(16) + "\n";
        string = this.e == null ? String.valueOf(string) + "No Cofactor given\n" : String.valueOf(string) + "Cofactor  is " + this.e.toString(16) + "\n";
        string = this.b == null ? String.valueOf(string) + "No Named Curve OID given\n" : String.valueOf(string) + "Named Curve " + this.b.toString() + "\n";
        return string;
    }

    public ASN1Object toASN1Object() {
        if (this.getNamedCurve() == null) {
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(new INTEGER(1));
            sEQUENCE.addComponent(this.c.toASN1Object());
            sEQUENCE.addComponent(this.d.toASN1Object());
            sEQUENCE.addComponent(this.f.toASN1Object());
            sEQUENCE.addComponent(new INTEGER(this.a));
            if (this.e != null) {
                sEQUENCE.addComponent(new INTEGER(this.e));
            }
            return sEQUENCE;
        }
        return this.getNamedCurve();
    }

    public void setNamedCurve(ObjectID objectID) {
        this.b = objectID;
    }

    private boolean a() {
        ECPoint eCPoint = this.f.multiply(this.a);
        return eCPoint.isPointAtInfinity();
    }

    public int getVersion() {
        return 1;
    }

    public BigInteger getOrder() {
        return this.a;
    }

    public ObjectID getNamedCurve() {
        return this.b;
    }

    public Field getField() {
        return this.c;
    }

    public EllipticCurve getCurve() {
        return this.d;
    }

    public BigInteger getCofactor() {
        return this.e;
    }

    public ECPoint getBase() {
        return this.f;
    }

    public ECParameters(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object.isA(ASN.ObjectID)) {
            ObjectID objectID = (ObjectID)aSN1Object;
            ECParameters eCParameters = NamedCurveFactory.getInstance(objectID);
            if (eCParameters == null) {
                throw new CodingException("Don't know this named curve.");
            }
            this.c = eCParameters.getField();
            this.d = eCParameters.getCurve();
            this.f = eCParameters.getBase();
            this.a = eCParameters.getOrder();
            this.e = eCParameters.getCofactor();
            this.b = objectID;
        } else if (aSN1Object.isA(ASN.SEQUENCE)) {
            Object object;
            INTEGER iNTEGER;
            this.b = null;
            SEQUENCE sEQUENCE = (SEQUENCE)aSN1Object;
            ASN1Object[] aSN1ObjectArray = new ASN1Object[6];
            int n2 = 0;
            while (n2 < sEQUENCE.countComponents()) {
                aSN1ObjectArray[n2] = sEQUENCE.getComponentAt(n2);
                ++n2;
            }
            if (aSN1ObjectArray[0].isA(ASN.INTEGER)) {
                iNTEGER = (INTEGER)aSN1ObjectArray[0];
                object = (BigInteger)iNTEGER.getValue();
                if (((BigInteger)object).compareTo(EntrustECDSA.i) != 0) {
                    throw new CodingException("Support only version 1 of ECParameters. Sorry ...");
                }
            } else {
                throw new CodingException("This illformed ASN1Object can't be parsed as a ECParameter object.");
            }
            this.c = FieldFactory.getInstance(aSN1ObjectArray[1]);
            this.d = new EllipticCurve(aSN1ObjectArray[2], this.c);
            this.f = ECPointFactory.getInstance(aSN1ObjectArray[3], this.d);
            iNTEGER = (INTEGER)aSN1ObjectArray[4];
            this.a = (BigInteger)iNTEGER.getValue();
            if (sEQUENCE.countComponents() == 6) {
                object = (INTEGER)aSN1ObjectArray[5];
                this.e = (BigInteger)((INTEGER)object).getValue();
            } else {
                this.e = null;
            }
            if (!this.a()) {
                throw new CodingException("The ASN1Object inserted for generating EC parameters could be parsed, but the parsed values (curve, base point, order) are not well defined.");
            }
        } else {
            throw new CodingException("Illformed ASN1Object inserted for generating EC parameters. Sorry ...");
        }
    }

    public ECParameters(ECPoint eCPoint, BigInteger bigInteger, BigInteger bigInteger2) throws IllegalArgumentException {
        this.d = eCPoint.getCurve();
        this.c = this.d.getField();
        this.f = eCPoint;
        this.a = bigInteger;
        this.e = bigInteger2;
        this.b = null;
        if (!this.a()) {
            throw new IllegalArgumentException("The input value order and base do not match.");
        }
    }
}

