/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.provider;

import com.entrust.toolkit.security.fips.SecurityEngine;
import com.entrust.toolkit.security.provider.EntrustRawDSA;
import iaik.security.md.SHA;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public final class EntrustDSA
extends Signature {
    private EntrustRawDSA a = new EntrustRawDSA();
    private MessageDigest b = new SHA();

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        SecurityEngine.assertCryptoOperationsAllowed();
        this.a.update(this.b.digest());
        return this.a.verify(byArray);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        SecurityEngine.assertCryptoOperationsAllowed();
        this.b.update(byArray, n2, n3);
    }

    protected void engineUpdate(byte by) throws SignatureException {
        SecurityEngine.assertCryptoOperationsAllowed();
        this.b.update(by);
    }

    protected byte[] engineSign() throws SignatureException {
        SecurityEngine.assertCryptoOperationsAllowed();
        this.a.update(this.b.digest());
        return this.a.sign();
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.a.engineSetParameter(algorithmParameterSpec);
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        this.a.setParameter(string, object);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.a.initVerify(publicKey);
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.a.initSign(privateKey);
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        SecurityEngine.assertCryptoOperationsAllowed();
        return this.a.getParameter(string);
    }

    public EntrustDSA() {
        super("SHAwithDSA");
    }
}

