/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.provider;

import com.entrust.toolkit.security.arithmetic.groups.ellipticCurve.ECPoint;
import com.entrust.toolkit.security.fips.SecurityEngine;
import com.entrust.toolkit.security.provider.ConfinedKey;
import com.entrust.toolkit.security.provider.ECDSAPrivateKey;
import com.entrust.toolkit.security.provider.ECDSAPublicKey;
import com.entrust.toolkit.security.provider.ECParameters;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ConstructedType;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.security.random.SecRandom;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class EntrustECDSA
extends Signature {
    private byte[] d;
    public static final ObjectID ecdsa;
    public static final ObjectID ecdsaWithSHA1;
    static BigInteger i;
    static BigInteger h;
    private boolean e = false;
    private boolean c = false;
    private MessageDigest f = null;
    private ECDSAPrivateKey b;
    private ConfinedKey g;
    private ECDSAPublicKey a;

    public boolean engineVerify(byte[] byArray) throws SignatureException {
        BigInteger bigInteger;
        byte[] byArray2;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        Object object;
        Object object2;
        SecurityEngine.assertCryptoOperationsAllowed();
        try {
            if (this.e ^ true | this.a == null) {
                throw new SignatureException("Not initialized or wrongly initialized.");
            }
            object2 = new ASN1(byArray).toASN1Object();
            object = (SEQUENCE)object2;
            bigInteger3 = (BigInteger)((INTEGER)((ConstructedType)object).getComponentAt(0)).getValue();
            bigInteger2 = (BigInteger)((INTEGER)((ConstructedType)object).getComponentAt(1)).getValue();
        }
        catch (Exception exception) {
            throw new SignatureException("Can't parse the given ASN1 object.");
        }
        object2 = null;
        try {
            object2 = this.a.getECParameters();
        }
        catch (CodingException codingException) {
            throw new SignatureException("Fatal internal error. Can't grab ECParameters from the ECDSA public key !.");
        }
        object = ((ECParameters)object2).getOrder();
        if (bigInteger3.compareTo((BigInteger)object) > -1 | bigInteger2.compareTo((BigInteger)object) > -1 | bigInteger2.compareTo(h) != 1 | bigInteger2.compareTo(h) != 1) {
            return false;
        }
        byte[] byArray3 = this.f.digest();
        BigInteger bigInteger4 = new BigInteger(1, byArray3);
        if (((BigInteger)object).bitLength() > byArray3.length * 8 - 1) {
            byArray2 = byArray3;
        } else {
            byArray2 = new byte[(((BigInteger)object).bitLength() + 7) / 8];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
        }
        BigInteger bigInteger5 = new BigInteger(1, byArray2);
        bigInteger5 = bigInteger5.mod((BigInteger)object);
        BigInteger bigInteger6 = bigInteger2.modInverse((BigInteger)object);
        BigInteger bigInteger7 = bigInteger6.multiply(bigInteger5).mod((BigInteger)object);
        if (bigInteger7.compareTo(h) < 0) {
            bigInteger7 = bigInteger7.add((BigInteger)object);
        }
        if ((bigInteger = bigInteger6.multiply(bigInteger3).mod((BigInteger)object)).compareTo(h) < 0) {
            bigInteger = bigInteger7.add((BigInteger)object);
        }
        ECPoint eCPoint = ((ECParameters)object2).getBase();
        ECPoint eCPoint2 = this.a.getECPublicPoint();
        ECPoint eCPoint3 = null;
        eCPoint3 = eCPoint.multiply(bigInteger7).add(eCPoint2.multiply(bigInteger));
        if (eCPoint3.isPointAtInfinity()) {
            return false;
        }
        BigInteger bigInteger8 = eCPoint3.getXCoordinate().getBigInteger();
        BigInteger bigInteger9 = bigInteger8.mod((BigInteger)object);
        return bigInteger9.compareTo(bigInteger3) == 0;
    }

    public void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        SecurityEngine.assertCryptoOperationsAllowed();
        if (n2 + n3 > byArray.length) {
            throw new SignatureException("Bad input values.");
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        this.f.update(byArray2);
        this.d = byArray2;
    }

    public void engineUpdate(byte by) {
        SecurityEngine.assertCryptoOperationsAllowed();
        this.f.update(by);
    }

    public byte[] engineSign() throws SignatureException {
        BigInteger bigInteger;
        Object object;
        Object object2;
        SecurityEngine.assertCryptoOperationsAllowed();
        BigInteger bigInteger2 = null;
        if (this.e ^ true | this.b == null & this.g == null) {
            throw new SignatureException("Can't sign. Not initialized or wrongly initialized.");
        }
        byte[] byArray = this.f.digest();
        this.f.reset();
        if (this.c) {
            try {
                byte[] byArray2 = this.g.b(byArray);
                return byArray2;
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new SignatureException(invalidKeyException.getMessage());
            }
        }
        try {
            bigInteger2 = this.b.getECParameters().getOrder();
        }
        catch (Exception exception) {
            throw new SignatureException(exception.getMessage());
        }
        BigInteger bigInteger3 = null;
        while (true) {
            ECPoint eCPoint;
            BigInteger bigInteger4;
            boolean bl = false;
            object2 = SecRandom.getDefault();
            ((SecureRandom)object2).nextBytes(new byte[5]);
            try {
                object = this.b.getECParameters().getBase();
            }
            catch (Exception exception) {
                throw new SignatureException(exception.getMessage());
            }
            Object object3 = new byte[20];
            Object object4 = new byte[20];
            byte[] byArray3 = new byte[40];
            do {
                ((SecureRandom)object2).nextBytes((byte[])object3);
                ((SecureRandom)object2).nextBytes((byte[])object4);
                System.arraycopy(object3, 0, byArray3, 0, ((byte[])object3).length);
                System.arraycopy(object4, 0, byArray3, ((byte[])object3).length, ((byte[])object4).length);
                BigInteger bigInteger5 = new BigInteger(1, byArray3);
                bigInteger4 = bigInteger5.mod(bigInteger2);
                if (bigInteger4.compareTo(h) == -1) {
                    bigInteger4 = bigInteger4.add(bigInteger2);
                }
                eCPoint = ((ECPoint)object).multiply(bigInteger4);
            } while (bigInteger4.compareTo(h) == 0 | eCPoint.isPointAtInfinity());
            int n2 = 0;
            while (n2 < 20) {
                byArray3[n2 + 20] = 0;
                byArray3[n2] = 0;
                object3[n2] = 0;
                object4[n2] = 0;
                ++n2;
            }
            BigInteger bigInteger6 = eCPoint.getXCoordinate().getBigInteger();
            bigInteger3 = bigInteger6.mod(bigInteger2);
            if (bigInteger3.compareTo(h) == -1) {
                bigInteger3 = bigInteger3.add(bigInteger2);
            }
            if (bigInteger3.compareTo(h) == 0) {
                bl = true;
            }
            if (bigInteger4.compareTo(h) == 0) {
                bl = true;
            }
            if (bl) continue;
            if (bigInteger2.bitLength() > byArray.length * 8 - 1) {
                object2 = byArray;
            } else {
                object2 = new byte[(bigInteger2.bitLength() + 7) / 8];
                System.arraycopy(byArray, 0, object2, 0, ((Object)object2).length);
            }
            object = new BigInteger(1, (byte[])object2);
            object = ((BigInteger)object).mod(bigInteger2);
            bigInteger = bigInteger3.multiply(this.b.getPrivateExponent()).add((BigInteger)object).mod(bigInteger2);
            object3 = bigInteger4;
            object4 = ((BigInteger)object3).modInverse(bigInteger2);
            if ((bigInteger = bigInteger.multiply((BigInteger)object4).mod(bigInteger2)).compareTo(h) != 0) break;
        }
        if (bigInteger.compareTo(h) == -1) {
            bigInteger = bigInteger.add(bigInteger2);
        }
        object2 = new SEQUENCE();
        ((ConstructedType)object2).addComponent(new INTEGER(bigInteger3));
        ((ConstructedType)object2).addComponent(new INTEGER(bigInteger));
        object = null;
        try {
            object = new ASN1((ASN1Object)object2).toByteArray();
        }
        catch (CodingException codingException) {
            throw new IllegalArgumentException("Fatal internal error.");
        }
        return object;
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("The method engineSetParameter is not supported.");
    }

    public void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("The method engineSetParameter is not supported.");
    }

    public void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof ECDSAPublicKey)) {
            throw new InvalidKeyException("Wrong key type.");
        }
        this.a = (ECDSAPublicKey)publicKey;
        this.e = true;
        this.f.reset();
        this.b = null;
        this.g = null;
        this.c = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof ConfinedKey) {
            if (!(((ConfinedKey)privateKey).c() & ((ConfinedKey)privateKey).getAlgorithm() == "ECDSA")) throw new InvalidKeyException("You inserted an obfuscated private key of form ConfinedKey but either it is not an ECDSA key or you are not allowed sign with that key due to the key usage flag in the corresponding certificate !");
            this.c = true;
            this.g = (ConfinedKey)privateKey;
            this.e = true;
            this.f.reset();
            this.a = null;
            this.b = null;
            return;
        } else {
            if (!(privateKey instanceof ECDSAPrivateKey)) throw new InvalidKeyException("You inserted an private key that is neither a ConfinedKey nor an ECDSAPrivateKey.");
            this.c = false;
            this.g = null;
            this.e = true;
            this.f.reset();
            this.a = null;
            this.b = (ECDSAPrivateKey)privateKey;
        }
    }

    public Object engineGetParameter(String string) throws InvalidParameterException {
        SecurityEngine.assertCryptoOperationsAllowed();
        return null;
    }

    public EntrustECDSA() {
        super("SHAwithECDSA");
        try {
            this.f = MessageDigest.getInstance("SHA", "Entrust");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Can't initalise this signature object.");
        }
    }

    static {
        h = BigInteger.valueOf(0L);
        i = BigInteger.valueOf(1L);
        ecdsaWithSHA1 = new ObjectID("1.2.840.10045.4.1");
        ecdsa = new ObjectID("1.2.840.10045.4");
    }
}

