/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.provider;

import com.entrust.toolkit.security.fips.SecurityEngine;
import com.entrust.toolkit.security.provider.ConfinedKey;
import com.entrust.toolkit.security.provider.Entrust;
import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.security.random.SecRandom;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;

public final class EntrustRawDSA
extends Signature {
    private static final BigInteger m;
    private static final BigInteger l;
    boolean g = false;
    private PrivateKey k;
    private byte[] f;
    private byte[] i;
    private int h;
    private SecureRandom c;
    private BigInteger j;
    private BigInteger d;
    private BigInteger e;
    private BigInteger a;
    private BigInteger b;

    private void a(DSAParams dSAParams) {
        this.e = dSAParams.getP();
        this.d = dSAParams.getQ();
        this.j = dSAParams.getG();
    }

    private BigInteger d(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = bigInteger2.modInverse(this.d);
        return bigInteger3;
    }

    private BigInteger c(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = this.j.modPow(bigInteger, this.e);
        BigInteger bigInteger4 = this.a.modPow(bigInteger2, this.e);
        BigInteger bigInteger5 = bigInteger3.multiply(bigInteger4);
        BigInteger bigInteger6 = bigInteger5.mod(this.e);
        BigInteger bigInteger7 = bigInteger6.mod(this.d);
        return bigInteger7;
    }

    private BigInteger b(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BigInteger bigInteger4 = bigInteger.multiply(bigInteger3);
        BigInteger bigInteger5 = bigInteger4.mod(this.d);
        return bigInteger5;
    }

    private BigInteger a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        BigInteger bigInteger4 = new BigInteger(1, this.i);
        BigInteger bigInteger5 = bigInteger4.multiply(bigInteger3);
        BigInteger bigInteger6 = bigInteger5.mod(this.d);
        return bigInteger6;
    }

    private BigInteger b(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = bigInteger.modInverse(this.d);
        BigInteger bigInteger4 = new BigInteger(1, this.i);
        BigInteger bigInteger5 = this.b.multiply(bigInteger2);
        BigInteger bigInteger6 = bigInteger4.add(bigInteger5);
        BigInteger bigInteger7 = bigInteger3.multiply(bigInteger6);
        BigInteger bigInteger8 = bigInteger7.mod(this.d);
        return bigInteger8;
    }

    private BigInteger a(BigInteger bigInteger) {
        BigInteger bigInteger2 = this.j.modPow(bigInteger, this.e);
        BigInteger bigInteger3 = bigInteger2.mod(this.d);
        return bigInteger3;
    }

    private BigInteger a() {
        byte[] byArray = new byte[10];
        int n2 = (this.d.bitLength() + 7) / 8;
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        byte[] byArray4 = new byte[2 * n2];
        this.c.nextBytes(byArray);
        this.c.nextBytes(byArray2);
        this.c.nextBytes(byArray3);
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, byArray2.length, byArray3.length);
        BigInteger bigInteger = new BigInteger(1, byArray4);
        return bigInteger.mod(this.d);
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        SecurityEngine.assertCryptoOperationsAllowed();
        if (this.h != 20) {
            throw new SignatureException("Data has to be exactly 20 Bytes in total!");
        }
        this.h = 0;
        return this.dsaVerifyRS(this.a(byArray));
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        SecurityEngine.assertCryptoOperationsAllowed();
        try {
            int n4 = n2;
            while (n4 < n3) {
                this.i[this.h++] = byArray[n4];
                ++n4;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SignatureException("Data has to be exactly 20 Bytes in total!");
        }
    }

    protected void engineUpdate(byte by) throws SignatureException {
        SecurityEngine.assertCryptoOperationsAllowed();
        try {
            this.i[this.h++] = by;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SignatureException("Data has to be exactly 20 Bytes in total!");
        }
    }

    protected byte[] engineSign() throws SignatureException {
        SecurityEngine.assertCryptoOperationsAllowed();
        if (this.h != 20) {
            throw new SignatureException("Data has to be exactly 20 Bytes in total!");
        }
        this.h = 0;
        BigInteger[] bigIntegerArray = this.dsaSignRS();
        return this.a(bigIntegerArray);
    }

    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Not a DSAParameterSpec");
        }
        this.a((DSAParameterSpec)algorithmParameterSpec);
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("The setParameter(String param, Object value) method is not supported for security reasons.");
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof DSAPublicKey)) {
            throw new InvalidKeyException("Key must be an instance of java.security.interfaces.DSAPublicKey!");
        }
        DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
        this.a = dSAPublicKey.getY();
        DSAParams dSAParams = dSAPublicKey.getParams();
        if (dSAParams != null) {
            this.a(dSAParams);
        }
        this.h = 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof ConfinedKey) {
            if (!(((ConfinedKey)privateKey).c() & ((ConfinedKey)privateKey).getAlgorithm() == "DSA")) throw new InvalidKeyException("You inserted an obfuscated private key of form ConfinedKey, but either it is not a DSA key or you are not allowed sign with that key due to the key usage flag in the corresponding certificate !");
            this.h = 0;
            this.g = true;
            this.k = privateKey;
            return;
        } else {
            if (!(privateKey instanceof DSAPrivateKey)) {
                throw new InvalidKeyException("Key must be an instance of java.security.interfaces.DSAPrivateKey!");
            }
            DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
            this.b = dSAPrivateKey.getX();
            this.a(dSAPrivateKey.getParams());
            this.h = 0;
            this.g = false;
        }
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        SecurityEngine.assertCryptoOperationsAllowed();
        throw new InvalidParameterException("The getParameter(String param) method is not supported for security reasons.");
    }

    public boolean dsaVerifyRS(BigInteger[] bigIntegerArray) {
        SecurityEngine.assertCryptoOperationsAllowed();
        return this.dsaVerifyRS(bigIntegerArray[0], bigIntegerArray[1]);
    }

    public boolean dsaVerifyRS(BigInteger bigInteger, BigInteger bigInteger2) {
        SecurityEngine.assertCryptoOperationsAllowed();
        if (bigInteger.signum() != 1 || bigInteger2.signum() != 1) {
            return false;
        }
        if (bigInteger.compareTo(this.d) >= 0 || bigInteger2.compareTo(this.d) >= 0) {
            return false;
        }
        BigInteger bigInteger3 = this.d(bigInteger, bigInteger2);
        BigInteger bigInteger4 = this.a(bigInteger, bigInteger2, bigInteger3);
        BigInteger bigInteger5 = this.b(bigInteger, bigInteger2, bigInteger3);
        BigInteger bigInteger6 = this.c(bigInteger4, bigInteger5);
        return bigInteger.equals(bigInteger6);
    }

    public BigInteger[] dsaSignRS() {
        SecurityEngine.assertCryptoOperationsAllowed();
        if (this.g) {
            try {
                return ((ConfinedKey)this.k).a(this.i);
            }
            catch (InvalidKeyException invalidKeyException) {
                return null;
            }
        }
        if (this.c == null) {
            this.c = SecRandom.getDefault();
        }
        BigInteger bigInteger = this.a();
        BigInteger bigInteger2 = this.a(bigInteger);
        BigInteger bigInteger3 = this.b(bigInteger, bigInteger2);
        BigInteger[] bigIntegerArray = new BigInteger[]{bigInteger2, bigInteger3};
        return bigIntegerArray;
    }

    byte[] a(BigInteger[] bigIntegerArray) throws SignatureException {
        SecurityEngine.assertCryptoOperationsAllowed();
        return this.a(bigIntegerArray[0], bigIntegerArray[1]);
    }

    byte[] a(BigInteger bigInteger, BigInteger bigInteger2) throws SignatureException {
        SecurityEngine.assertCryptoOperationsAllowed();
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new INTEGER(bigInteger));
        sEQUENCE.addComponent(new INTEGER(bigInteger2));
        try {
            byte[] byArray = new ASN1(sEQUENCE).toByteArray();
            return byArray;
        }
        catch (CodingException codingException) {
            throw new SignatureException();
        }
    }

    BigInteger[] a(byte[] byArray) throws SignatureException {
        SecurityEngine.assertCryptoOperationsAllowed();
        try {
            ASN1 aSN1 = new ASN1(byArray);
            if (aSN1.toASN1Object().isA(ASN.SEQUENCE) && aSN1.countComponents() == 2) {
                ASN1Object aSN1Object = aSN1.getComponentAt(0);
                ASN1Object aSN1Object2 = aSN1.getComponentAt(1);
                BigInteger bigInteger = (BigInteger)aSN1Object.getValue();
                BigInteger bigInteger2 = (BigInteger)aSN1Object2.getValue();
                BigInteger[] bigIntegerArray = new BigInteger[]{bigInteger, bigInteger2};
                return bigIntegerArray;
            }
        }
        catch (Exception exception) {}
        throw new SignatureException();
    }

    public EntrustRawDSA() {
        super("EntrustDSA");
        if (System.getProperty("os.name").equals("OS/390")) {
            Entrust.a();
        }
        this.i = new byte[20];
    }

    static {
        l = BigInteger.valueOf(0L);
        m = BigInteger.valueOf(1L);
    }
}

