/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.provider;

import com.entrust.toolkit.security.spec.IDEAParameterSpec;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.security.cipher.IvParameters;
import iaik.utils.Util;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public class IDEAParameters
extends IvParameters {
    protected byte[] iv;

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("iv: ");
        if (this.iv != null) {
            stringBuffer.append(Util.toString(this.iv));
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            ASN1Object aSN1Object = DerCoder.decode(byArray);
            IDEAParameterSpec iDEAParameterSpec = new IDEAParameterSpec(aSN1Object);
            this.iv = iDEAParameterSpec.getIV();
        }
        catch (CodingException codingException) {
            throw new IOException("DER decoding error: " + codingException.getMessage());
        }
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof IDEAParameterSpec) {
            IDEAParameterSpec iDEAParameterSpec = (IDEAParameterSpec)algorithmParameterSpec;
            this.iv = iDEAParameterSpec.getIV();
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
            this.iv = ivParameterSpec.getIV();
        } else {
            throw new InvalidParameterSpecException("Parameter must be IvParameterSpec or IDEAParameterSpec");
        }
        if (this.iv != null && this.iv.length != 8) {
            throw new InvalidParameterSpecException("IV must be 8 octets long!");
        }
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        IDEAParameterSpec iDEAParameterSpec = new IDEAParameterSpec(this.iv);
        if (!iDEAParameterSpec.getClass().isAssignableFrom(clazz)) {
            throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
        }
        return iDEAParameterSpec;
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected byte[] engineGetEncoded() {
        IDEAParameterSpec iDEAParameterSpec = new IDEAParameterSpec(this.iv);
        return DerCoder.encode(iDEAParameterSpec.toASN1Object());
    }
}

