/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.provider;

import com.entrust.toolkit.security.provider.JCEVerifier;
import com.entrust.toolkit.security.provider.e;
import com.entrust.toolkit.security.provider.f;
import com.entrust.toolkit.security.provider.g;
import com.entrust.toolkit.security.provider.h;
import com.entrust.toolkit.util.ByteArray;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedActionException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public final class JCEVerifierImpl
extends JCEVerifier {
    private final X509Certificate[] c;
    private static final String[] b;
    private final X509Certificate[] d = new X509Certificate[e.length];
    private static final String[] e;
    private static final String[] g;
    private static final String h = "javax/crypto/Cipher.class";
    private static boolean a;
    private static boolean f;

    private void a(JarFile jarFile) throws CertificateException, IOException {
        Object object;
        Object object2;
        Vector<Object> vector = new Vector<Object>();
        Manifest manifest = jarFile.getManifest();
        if (manifest == null) {
            throw new SecurityException("The JCE framework is not signed");
        }
        if (JCEVerifier.DEBUG) {
            System.out.println("Ensuring all jar entries' signatures verify correctly...");
        }
        byte[] byArray = new byte[8192];
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            int n2;
            object2 = enumeration.nextElement();
            if (JCEVerifier.TRACE_LEVEL > 1) {
                System.out.println("reading: \"" + ((ZipEntry)object2).toString() + "\"");
            }
            vector.addElement(object2);
            object = jarFile.getInputStream((ZipEntry)object2);
            while ((n2 = ((InputStream)object).read(byArray, 0, byArray.length)) != -1) {
            }
            ((InputStream)object).close();
        }
        object2 = vector.elements();
        while (object2.hasMoreElements()) {
            object = (JarEntry)object2.nextElement();
            if (((ZipEntry)object).isDirectory()) continue;
            Certificate[] certificateArray = ((JarEntry)object).getCertificates();
            if (certificateArray == null || certificateArray.length == 0) {
                if (((ZipEntry)object).getName().startsWith("META-INF")) continue;
                throw new SecurityException("The JCE framework contains at least one unsigned class file -- " + ((ZipEntry)object).getName());
            }
            Certificate[] certificateArray2 = this.a(certificateArray);
            boolean bl = false;
            int n3 = 0;
            while (n3 < certificateArray2.length) {
                if (this.a((X509Certificate)certificateArray2[n3])) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                throw new SecurityException("The JCE framework is not signed by a trusted signer");
            }
            if (JCEVerifier.TRACE_LEVEL <= 1) continue;
            System.out.println(String.valueOf(((ZipEntry)object).getName()) + " is signed as expected.");
        }
        if (JCEVerifier.DEBUG) {
            System.out.println("JCE VERIFIED: " + jarFile.getName());
        }
    }

    public final synchronized void verifyJCEJar(Object object) {
        if (JCEVerifier.DEBUG) {
            System.out.println("Entering JCEVerifierImpl.verifyJCEJar() for: \"" + object.getClass().getName() + "\"");
        }
        if (a) {
            if (JCEVerifier.DEBUG) {
                System.out.println("JCE was already verified or verification was not required");
            }
            return;
        }
        if (this.c[0] == null) {
            this.b();
        }
        try {
            Class<?> clazz = Class.forName("javax.crypto.Cipher");
            CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                if (JCEVerifier.DEBUG) {
                    System.out.println("It's a JCE -- verify it.");
                }
                this.a(object);
            } else if (JCEVerifier.DEBUG) {
                System.out.println("It's JDK 1.4 framework -- do not need to verify it.");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SecurityException("Cannot verify JCE extension: " + classNotFoundException);
        }
        a = true;
        if (JCEVerifier.DEBUG) {
            System.out.println("Leaving JCEVerifierImpl.verifyJCEJar()");
        }
    }

    private final synchronized URL a(URL uRL) throws MalformedURLException {
        if (uRL == null) {
            throw new MalformedURLException("No URL was provided");
        }
        URL uRL2 = null;
        String string = uRL.toString();
        int n2 = string.lastIndexOf(".jar!/");
        if (n2 == -1) {
            throw new SecurityException("Invalid jar file URL -- " + string);
        }
        int n3 = n2 + 5;
        uRL2 = new URL(string.substring(0, n3 + 1));
        int n4 = 4;
        URL uRL3 = new URL(uRL2.toString().substring(n4, n3 - 1));
        if (!uRL3.getProtocol().equalsIgnoreCase("file")) {
            throw new SecurityException(String.valueOf(uRL2.toString()) + " must be deployed " + "as an installed extension or on the class path");
        }
        return uRL2;
    }

    private boolean a(X509Certificate x509Certificate) {
        int n2;
        if (JCEVerifier.TRACE_LEVEL > 4) {
            try {
                if (x509Certificate != null) {
                    System.out.println("Certificate: \n" + x509Certificate.toString() + "\n\n");
                    String string = new BigInteger(x509Certificate.getEncoded()).toString(16);
                    n2 = 0;
                    while (n2 < string.length()) {
                        System.out.print(string.charAt(n2));
                        if ((n2 + 1) % 64 == 0) {
                            System.out.println();
                        }
                        ++n2;
                    }
                    System.out.println();
                }
            }
            catch (CertificateEncodingException certificateEncodingException) {}
        }
        int n3 = 0;
        while (n3 < this.c.length) {
            if (x509Certificate.getSubjectDN().equals(this.c[n3].getSubjectDN()) && x509Certificate.equals(this.c[n3])) {
                return true;
            }
            ++n3;
        }
        n2 = 0;
        while (n2 < this.c.length) {
            if (x509Certificate.getIssuerDN().equals(this.c[n2].getSubjectDN())) {
                try {
                    x509Certificate.verify(this.c[n2].getPublicKey());
                    return true;
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
        return false;
    }

    private synchronized void b() {
        CertificateFactory certificateFactory = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
            if (JCEVerifier.DEBUG) {
                System.out.println(certificateFactory.getProvider());
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Can't even get a CertificateFactory: " + exception);
        }
        byte[] byArray = null;
        ByteArray byteArray = new ByteArray();
        int n2 = 0;
        while (n2 < b.length) {
            byteArray.fromHexString(b[n2]);
            byArray = byteArray.getArray();
            Certificate certificate = null;
            try {
                certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(byArray));
            }
            catch (CertificateException certificateException) {
                throw new SecurityException("Cannot initialize embedded code signer root certificates: " + certificateException);
            }
            this.c[n2] = (X509Certificate)certificate;
            if (JCEVerifier.TRACE_LEVEL > 3) {
                System.out.println("\nTrusted cert: " + n2);
                System.out.println("Serial number: " + this.c[n2].getSerialNumber());
                System.out.println("Issuer: " + this.c[n2].getIssuerDN());
                System.out.println("Subject: " + this.c[n2].getSubjectDN());
                System.out.println("\nCertificate: \n" + this.c[n2].toString() + "\n");
            }
            ++n2;
        }
        byteArray.fromHexString(e[0]);
        try {
            this.d[0] = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(byteArray.getArray()));
        }
        catch (CertificateException certificateException) {
            throw new SecurityException("Cannot initialize Entrust's embedded code-signer certificate: " + certificateException);
        }
    }

    private Certificate[] a(Certificate[] certificateArray) {
        Vector<Certificate> vector = new Vector<Certificate>(3);
        int n2 = 0;
        while (n2 < certificateArray.length - 1) {
            if (!((X509Certificate)certificateArray[n2 + 1]).getSubjectDN().equals(((X509Certificate)certificateArray[n2]).getIssuerDN())) {
                vector.addElement(certificateArray[n2]);
            }
            ++n2;
        }
        vector.addElement(certificateArray[certificateArray.length - 1]);
        Object[] objectArray = new Certificate[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private final synchronized void a(Object object) {
        Object object2;
        Object object3;
        URL uRL = null;
        URL uRL2 = null;
        try {
            object3 = object.getClass();
            if (JCEVerifier.DEBUG) {
                System.out.println("Class: " + ((Class)object3).getName());
            }
            object2 = ((Class)object3).getClassLoader();
            if (JCEVerifier.DEBUG) {
                System.out.println("Get the URL to the JCE...");
            }
            if ((uRL2 = (URL)AccessController.doPrivileged(new g((ClassLoader)object2))) == null) {
                throw new SecurityException("Cannot get the URL to the JCE framework.  Please ensure your application has privilege to read the JCE framework");
            }
            uRL = this.a(uRL2);
            if (JCEVerifier.DEBUG) {
                System.out.println("URL to JCE jar: " + uRL);
            }
        }
        catch (Exception exception) {
            throw new SecurityException("Cannot authenticate the JCE framework" + exception);
        }
        try {
            object2 = uRL;
            object3 = (JarFile)AccessController.doPrivileged(new f((URL)object2));
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new SecurityException("Cannot authenticate the JCE framework " + privilegedActionException);
        }
        try {
            this.a((JarFile)object3);
        }
        catch (Exception exception) {
            throw new SecurityException("Cannot authenticate JCE framework: " + exception);
        }
    }

    public synchronized void checkIntegrity(Object object) {
        ClassLoader classLoader;
        URL[] uRLArray;
        if (JCEVerifier.DEBUG) {
            System.out.println("Starting self-integrity check...");
        }
        if (f) {
            if (JCEVerifier.DEBUG) {
                System.out.println("Self-Integrity Check PASSED (checked previously).");
            }
            return;
        }
        Class<?> clazz = object.getClass();
        if (JCEVerifier.DEBUG) {
            System.out.println("Class: " + clazz.getName());
        }
        if ((uRLArray = (URL[])AccessController.doPrivileged(new h(classLoader = clazz.getClassLoader(), this))) == null || uRLArray[0] == null) {
            throw new SecurityException("Self-Integrity Check FAILED. Could not even find the Toolkit base jar file");
        }
        int n2 = 0;
        while (n2 < uRLArray.length) {
            if (uRLArray[n2] != null) {
                if (JCEVerifier.DEBUG) {
                    System.out.println("Performing self-integrity check: " + uRLArray[n2]);
                }
                e e2 = new e(uRLArray[n2]);
                try {
                    e2.a(this.d[0]);
                }
                catch (Exception exception) {
                    throw new SecurityException("Self-Integrity Check FAILED: " + exception);
                }
            }
            ++n2;
        }
        if (JCEVerifier.DEBUG) {
            System.out.println("Self-Integrity Check PASSED.");
        }
        f = true;
    }

    static URL a(JCEVerifierImpl jCEVerifierImpl, URL uRL) throws MalformedURLException {
        return jCEVerifierImpl.a(uRL);
    }

    static String[] a() {
        return g;
    }

    public JCEVerifierImpl() {
        this.c = new X509Certificate[b.length];
    }

    static {
        f = false;
        a = false;
        g = new String[]{"com/entrust/toolkit/security/provider/Entrust.class", "iaik/security/cipher/PbeWithSHAAnd3_KeyTripleDES_CBC.class", "iaik/pkcs/pkcs8/EncryptedPrivateKeyInfo.class", "com/entrust/toolkit/ssl/EntrustChainVerifier.class", "com/entrust/toolkit/roaming/speke/SPEKEPrivateKey.class"};
        e = new String[]{"308203b13082036fa00302010202020109300b06072a8648ce3804030500308190310b3009060355040613025553310b3009060355040813024341311230100603550407130950616c6f20416c746f311d301b060355040a131453756e204d6963726f73797374656d7320496e6331233021060355040b131a4a61766120536f66747761726520436f6465205369676e696e67311c301a060355040313134a434520436f6465205369676e696e67204341301e170d3031313131323133353731345a170d3036313131363133353731345a3056311d301b060355040a131453756e204d6963726f73797374656d7320496e6331233021060355040b131a4a61766120536f66747761726520436f6465205369676e696e673110300e06035504031307456e7472757374308201b83082012c06072a8648ce3804013082011f02818100fd7f53811d75122952df4a9c2eece4e7f611b7523cef4400c31e3f80b6512669455d402251fb593d8d58fabfc5f5ba30f6cb9b556cd7813b801d346ff26660b76b9950a5a49f9fe8047b1022c24fbba9d7feb7c61bf83b57e7c6a8a6150f04fb83f6d3c51ec3023554135a169132f675f3ae2b61d72aeff22203199dd14801c70215009760508f15230bccb292b982a2eb840bf0581cf502818100f7e1a085d69b3ddecbbcab5c36b857b97994afbbfa3aea82f9574c0b3d0782675159578ebad4594fe67107108180b449167123e84c281613b7cf09328cc8a6e13c167a8b547c8d28e0a3ae1e2bb3a675916ea37f0bfa213562f1fb627a01243bcca4f1bea8519089a883dfe15ae59f06928b665e807b552564014c3bfecf492a0381850002818100975a94a3ce6fd0a28cc9538b922c7bc739b34c7f5a00cdebbc08d25866604a8d9dc5e594c2d61edc614c3dc9496474567242af495cfc540b81f3dc1cd0be4cf8f37f5369ebe2f6290fca5e5153e326726c0469adf9abf89ce58b3f4fd29d73fdfb28b15b2c5533805318b99053c5cfab7deafc5f22b130dd2c89ca966bd2a13aa3818f30818c301106096086480186f8420101040403020410300e0603551d0f0101ff0404030205e0301d0603551d0e04160414e3b74e46fd0a6f7b90d0e2e0b3642ea74f689309301f0603551d2304183016801465e2f486c9d34ef0914e58a26af5d8785a9ac1a630270603551d110420301e811c426c616b652e5375746865726c616e6440656e74727573742e636f6d300b06072a8648ce3804030500032f00302c02140e9d30b9ac3229577129dd67376b79804ad3224b02147eaa9b729200e92a9d681e34057b50685efe1084"};
        b = new String[]{"308203c03082037ea003020102020101300b06072a8648ce3804030500308190310b3009060355040613025553310b3009060355040813024341311230100603550407130950616c6f20416c746f311d301b060355040a131453756e204d6963726f73797374656d7320496e6331233021060355040b131a4a61766120536f66747761726520436f6465205369676e696e67311c301a060355040313134a434520436f6465205369676e696e67204341301e170d3030303431323037303030305a170d3036303431323037303030305a308190310b3009060355040613025553310b3009060355040813024341311230100603550407130950616c6f20416c746f311d301b060355040a131453756e204d6963726f73797374656d7320496e6331233021060355040b131a4a61766120536f66747761726520436f6465205369676e696e67311c301a060355040313134a434520436f6465205369676e696e67204341308201b73082012c06072a8648ce3804013082011f02818100ebaf37041eca511e695db0f28ff6b5491fc6a49905d729bf74b76af519d81ee41bf80a019a98ff70abe24a56866c53b3fce1c8818c31f0c4f3b08be67006ecf76968db834c7229892936175c3b4a07a020022a4697511d70c808180bce0c6e9b76f705e3e7fbd36179e1609a248d0695833c5120e130cf385782a61a720dced3021500842545e1bab9a962ab79e85b30b8896b1bff7b7502818100abc9747b74efee42b56a534d3bdd90067268910f0ba429762e553bd5ae4d655c7e2a3a04a667a6d071aaa5d7b7e2c1720da4d1aa1e92544c200009a2b00941193300b2c35cae42f8b18bca7c96d8107f37445baacc78c8d77276376b4099a85566faa8031e8b4a110269cb4cb825061ca077d2c9acd23de90a10fa7670b7fbdc038184000281802d09985cacb89cc7997eee20192a3490f9d7ababaedd6b72950d66f8ef278f44b2ed2844c7feafb0a6276f006745825b07a856563bd22951615e6939d72e747712cf194af52dc8cb7261c44e6ffa47433f14bbfabc186628c2d9668b7a2d2fc260924b14fe583e217f6862be6c4849f9a04b5e859d1910f91545511b71d4f70ba3663064301106096086480186f8420101040403020007300f0603551d130101ff040530030101ff301f0603551d2304183016801465e2f486c9d34ef0914e58a26af5d8785a9ac1a6301d0603551d0e0416041465e2f486c9d34ef0914e58a26af5d8785a9ac1a6300b06072a8648ce3804030500032f00302c0214249f02c3fb31d5913bf97e566f96df640a0498b402146e7984a7ee68a302723163db43ab08ec4def163a", "308203c03082037ea003020102020110300b06072a8648ce3804030500308190310b3009060355040613025553310b3009060355040813024341311230100603550407130950616c6f20416c746f311d301b060355040a131453756e204d6963726f73797374656d7320496e6331233021060355040b131a4a61766120536f66747761726520436f6465205369676e696e67311c301a060355040313134a434520436f6465205369676e696e67204341301e170d3031303432353037303030305a170d3230303432353037303030305a308190310b3009060355040613025553310b3009060355040813024341311230100603550407130950616c6f20416c746f311d301b060355040a131453756e204d6963726f73797374656d7320496e6331233021060355040b131a4a61766120536f66747761726520436f6465205369676e696e67311c301a060355040313134a434520436f6465205369676e696e67204341308201b73082012c06072a8648ce3804013082011f02818100ebaf37041eca511e695db0f28ff6b5491fc6a49905d729bf74b76af519d81ee41bf80a019a98ff70abe24a56866c53b3fce1c8818c31f0c4f3b08be67006ecf76968db834c7229892936175c3b4a07a020022a4697511d70c808180bce0c6e9b76f705e3e7fbd36179e1609a248d0695833c5120e130cf385782a61a720dced3021500842545e1bab9a962ab79e85b30b8896b1bff7b7502818100abc9747b74efee42b56a534d3bdd90067268910f0ba429762e553bd5ae4d655c7e2a3a04a667a6d071aaa5d7b7e2c1720da4d1aa1e92544c200009a2b00941193300b2c35cae42f8b18bca7c96d8107f37445baacc78c8d77276376b4099a85566faa8031e8b4a110269cb4cb825061ca077d2c9acd23de90a10fa7670b7fbdc038184000281802d09985cacb89cc7997eee20192a3490f9d7ababaedd6b72950d66f8ef278f44b2ed2844c7feafb0a6276f006745825b07a856563bd22951615e6939d72e747712cf194af52dc8cb7261c44e6ffa47433f14bbfabc186628c2d9668b7a2d2fc260924b14fe583e217f6862be6c4849f9a04b5e859d1910f91545511b71d4f70ba3663064301106096086480186f8420101040403020007300f0603551d130101ff040530030101ff301f0603551d2304183016801465e2f486c9d34ef0914e58a26af5d8785a9ac1a6301d0603551d0e0416041465e2f486c9d34ef0914e58a26af5d8785a9ac1a6300b06072a8648ce3804030500032f00302c02142af7cf3c975df978b608d741b4d90d454ce4b49c021445cd75690e21fa1dd6b329b2e9f7331d33fdfc49", "30820337308202f5a00302010202043925b99b300b06072a8648ce38040305003060310b300906035504061302555331183016060355040a130f49424d20436f72706f726174696f6e31193017060355040b131049424d20436f6465205369676e696e67311c301a060355040313134a434520436f6465205369676e696e67204341301e170d3030303531393231353931395a170d3036303531383231353931395a3069310b300906035504061302555331183016060355040a130f49424d20436f72706f726174696f6e31193017060355040b131049424d20436f6465205369676e696e67312530230603550403131c4a434520436f6465205369676e696e67202d204672616d65776f726b308201b83082012c06072a8648ce3804013082011f02818100fd7f53811d75122952df4a9c2eece4e7f611b7523cef4400c31e3f80b6512669455d402251fb593d8d58fabfc5f5ba30f6cb9b556cd7813b801d346ff26660b76b9950a5a49f9fe8047b1022c24fbba9d7feb7c61bf83b57e7c6a8a6150f04fb83f6d3c51ec3023554135a169132f675f3ae2b61d72aeff22203199dd14801c70215009760508f15230bccb292b982a2eb840bf0581cf502818100f7e1a085d69b3ddecbbcab5c36b857b97994afbbfa3aea82f9574c0b3d0782675159578ebad4594fe67107108180b449167123e84c281613b7cf09328cc8a6e13c167a8b547c8d28e0a3ae1e2bb3a675916ea37f0bfa213562f1fb627a01243bcca4f1bea8519089a883dfe15ae59f06928b665e807b552564014c3bfecf492a0381850002818100900d213784c3601f6e2cb48c576c7165c2b11ff1327452b4aec37c2b6f5edf6d4ec5cd1581ff2a9eebb8763c7d3d85ce9292008562d3e0126c5140d826e24b81803b02a515b0a685e87a9f473fbdc54984425d30a53c14724d32f18f57103919821df9990e2073e4b0ec33c8014bf705974981e6c066fc300c9082cdfeb7c031a3323030300f0603551d0f0101ff04050303068000301d0603551d0e04160414232c65101e59eab8a3139ac48e7e0bdb9ef44371300b06072a8648ce3804030500032f00302c0214083a7700a7ccf998b5666778a0d659cb74682ead021433041eb5f9206aba85dbdb942ee2d29166f56e9d"};
    }
}

