/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.provider;

import com.entrust.toolkit.security.arithmetic.fields.FieldElement;
import com.entrust.toolkit.security.arithmetic.fields.GFp;
import com.entrust.toolkit.security.arithmetic.fields.GFpElement;
import com.entrust.toolkit.security.arithmetic.fields.Polynomial;
import com.entrust.toolkit.security.arithmetic.fields.PolynomialField;
import com.entrust.toolkit.security.arithmetic.groups.ellipticCurve.ECPointGFp;
import com.entrust.toolkit.security.arithmetic.groups.ellipticCurve.EllipticCurve;
import com.entrust.toolkit.security.arithmetic.groups.ellipticCurve.PolynomeECPoint;
import com.entrust.toolkit.security.provider.ECParameters;
import iaik.asn1.ObjectID;
import java.math.BigInteger;
import java.util.Hashtable;

public class NamedCurveFactory {
    private static Hashtable b;
    private static Hashtable a;

    private static ECParameters y() {
        BigInteger bigInteger = new BigInteger("080000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000425", 16);
        PolynomialField polynomialField = new PolynomialField(bigInteger);
        Polynomial polynomial = new Polynomial(new BigInteger("01", 16), polynomialField);
        Polynomial polynomial2 = new Polynomial(new BigInteger("2F40E7E2221F295DE297117B7F3D62F5C6A97FFCB8CEFF1CD6BA8CE4A9A18AD84FFABBD8EFA59332BE7AD6756A66E294AFD185A78FF12AA520E4DE739BACA0C7FFEFF7F2955727A", 16), polynomialField);
        BigInteger bigInteger2 = new BigInteger("2AA058F73A0E33AB486B0F610410C53A7F132310", 16);
        EllipticCurve ellipticCurve = new EllipticCurve(polynomial, polynomial2, bigInteger2);
        Polynomial polynomial3 = new Polynomial(new BigInteger("303001D34B856296C16C0D40D3CD7750A93D1D2955FA80AA5F40FC8DB7B2ABDBDE53950F4C0D293CDD711A35B67FB1499AE60038614F1394ABFA3B4C850D927E1E7769C8EEC2D19", 16), polynomialField);
        Polynomial polynomial4 = new Polynomial(new BigInteger("37BF27342DA639B6DCCFFFEB73D69D78C6C27A6009CBBCA1980F8533921E8A684423E43BAB08A576291AF8F461BB2A8B3531D2F0485C19B16E2F1516E23DD3C1A4827AF1B8AC15B", 16), polynomialField);
        PolynomeECPoint polynomeECPoint = new PolynomeECPoint(polynomial3, polynomial4, ellipticCurve);
        BigInteger bigInteger3 = new BigInteger("3864537523017258344695351890931987344298927329706434998657235251451519142289560424536143999389415773083133881121926944486246872462816813070234528288303332411393191105285703");
        BigInteger bigInteger4 = BigInteger.valueOf(2L);
        ECParameters eCParameters = new ECParameters(polynomeECPoint, bigInteger3, bigInteger4);
        eCParameters.setNamedCurve(NamedCurveFactory.b(39, "x962t571r1"));
        return eCParameters;
    }

    private static ECParameters x() {
        BigInteger bigInteger = new BigInteger("080000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000425", 16);
        PolynomialField polynomialField = new PolynomialField(bigInteger);
        FieldElement fieldElement = polynomialField.getZeroElement();
        FieldElement fieldElement2 = polynomialField.getOneElement();
        EllipticCurve ellipticCurve = new EllipticCurve(fieldElement, fieldElement2, null);
        Polynomial polynomial = new Polynomial(new BigInteger("026EB7A859923FBC82189631F8103FE4AC9CA2970012D5D46024804801841CA44370958493B205E647DA304DB4CEB08CBBD1BA39494776FB988B47174DCA88C7E2945283A01C8972", 16), polynomialField);
        Polynomial polynomial2 = new Polynomial(new BigInteger("349DC807F4FBF374F4AEADE3BCA95314DD58CEC9F307A54FFC61EFC006D8A2C9D4979C0AC44AEA74FBEBBB9F772AEDCB620B01A7BA7AF1B320430C8591984F601CD4C143EF1C7A3", 16), polynomialField);
        PolynomeECPoint polynomeECPoint = new PolynomeECPoint(polynomial, polynomial2, ellipticCurve);
        BigInteger bigInteger2 = new BigInteger("1932268761508629172347675945465993672149463664853217499328617625725759571144780212268133978522706711834706712800825351461273674974066617311929682421617092503555733685276673");
        BigInteger bigInteger3 = BigInteger.valueOf(4L);
        ECParameters eCParameters = new ECParameters(polynomeECPoint, bigInteger2, bigInteger3);
        eCParameters.setNamedCurve(NamedCurveFactory.b(38, "x962t571k1"));
        return eCParameters;
    }

    private static ECParameters w() {
        BigInteger bigInteger = new BigInteger("02000000000000000000000000000000000000000000000000000000000000000000000000000000008000000000000000000001", 16);
        PolynomialField polynomialField = new PolynomialField(bigInteger);
        Polynomial polynomial = new Polynomial(new BigInteger("1", 16), polynomialField);
        Polynomial polynomial2 = new Polynomial(new BigInteger("021A5C2C8EE9FEB5C4B9A753B7B476B7FD6422EF1F3DD674761FA99D6AC27C8A9A197B272822F6CD57A55AA4F50AE317B13545F", 16), polynomialField);
        BigInteger bigInteger2 = new BigInteger("4099B5A457F9D69F79213D094C4BCD4D4262210B", 16);
        EllipticCurve ellipticCurve = new EllipticCurve(polynomial, polynomial2, bigInteger2);
        Polynomial polynomial3 = new Polynomial(new BigInteger("15D4860D088DDB3496B0C6064756260441CDE4AF1771D4DB01FFE5B34E59703DC255A868A1180515603AEAB60794E54BB7996A7", 16), polynomialField);
        Polynomial polynomial4 = new Polynomial(new BigInteger("061B1CFAB6BE5F32BBFA78324ED106A7636B9C5A7BD198D0158AA4F5488D08F38514F1FDF4B4F40D2181B3681C364BA0273C706", 16), polynomialField);
        PolynomeECPoint polynomeECPoint = new PolynomeECPoint(polynomial3, polynomial4, ellipticCurve);
        BigInteger bigInteger3 = new BigInteger("661055968790248598951915308032771039828404682964281219284648798304157774827374805208143723762179110965979867288366567526771");
        BigInteger bigInteger4 = BigInteger.valueOf(2L);
        ECParameters eCParameters = new ECParameters(polynomeECPoint, bigInteger3, bigInteger4);
        eCParameters.setNamedCurve(NamedCurveFactory.b(37, "x962t409r1"));
        return eCParameters;
    }

    private static ECParameters v() {
        BigInteger bigInteger = new BigInteger("02000000000000000000000000000000000000000000000000000000000000000000000000000000008000000000000000000001", 16);
        PolynomialField polynomialField = new PolynomialField(bigInteger);
        FieldElement fieldElement = polynomialField.getZeroElement();
        FieldElement fieldElement2 = polynomialField.getOneElement();
        EllipticCurve ellipticCurve = new EllipticCurve(fieldElement, fieldElement2, null);
        Polynomial polynomial = new Polynomial(new BigInteger("060F05F658F49C1AD3AB1890F7184210EFD0987E307C84C27ACCFB8F9F67CC2C460189EB5AAAA62EE222EB1B35540CFE9023746", 16), polynomialField);
        Polynomial polynomial2 = new Polynomial(new BigInteger("1E369050B7C4E42ACBA1DACBF04299C3460782F918EA427E6325165E9EA10E3DA5F6C42E9C55215AA9CA27A5863EC48D8E0286B", 16), polynomialField);
        PolynomeECPoint polynomeECPoint = new PolynomeECPoint(polynomial, polynomial2, ellipticCurve);
        BigInteger bigInteger2 = new BigInteger("330527984395124299475957654016385519914202341482140609642324395022880711289249191050673258457777458014096366590617731358671");
        BigInteger bigInteger3 = BigInteger.valueOf(4L);
        ECParameters eCParameters = new ECParameters(polynomeECPoint, bigInteger2, bigInteger3);
        eCParameters.setNamedCurve(NamedCurveFactory.b(36, "x962t409k1"));
        return eCParameters;
    }

    private static ECParameters u() {
        BigInteger bigInteger = new BigInteger("0800000000000000000000000000000000000000000000000000000000000000000010A1", 16);
        PolynomialField polynomialField = new PolynomialField(bigInteger);
        FieldElement fieldElement = polynomialField.getOneElement();
        Polynomial polynomial = new Polynomial(new BigInteger("027B680AC8B8596DA5A4AF8A19A0303FCA97FD7645309FA2A581485AF6263E313B79A2F5", 16), polynomialField);
        BigInteger bigInteger2 = new BigInteger("77E2B07370EB0F832A6DD5B62DFC88CD06BB84BE", 16);
        EllipticCurve ellipticCurve = new EllipticCurve(fieldElement, polynomial, bigInteger2);
        Polynomial polynomial2 = new Polynomial(new BigInteger("05F939258DB7DD90E1934F8C70B0DFEC2EED25B8557EAC9C80E2E198F8CDBECD86B12053", 16), polynomialField);
        Polynomial polynomial3 = new Polynomial(new BigInteger("03676854FE24141CB98FE6D4B20D02B4516FF702350EDDB0826779C813F0DF45BE8112F4", 16), polynomialField);
        PolynomeECPoint polynomeECPoint = new PolynomeECPoint(polynomial2, polynomial3, ellipticCurve);
        BigInteger bigInteger3 = new BigInteger("03FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEF90399660FC938A90165B042A7CEFADB307", 16);
        BigInteger bigInteger4 = BigInteger.valueOf(2L);
        ECParameters eCParameters = new ECParameters(polynomeECPoint, bigInteger3, bigInteger4);
        eCParameters.setNamedCurve(NamedCurveFactory.b(17, "x962t283r1"));
        return eCParameters;
    }

    private static ECParameters t() {
        BigInteger bigInteger = new BigInteger("0800000000000000000000000000000000000000000000000000000000000000000010A1", 16);
        PolynomialField polynomialField = new PolynomialField(bigInteger);
        FieldElement fieldElement = polynomialField.getZeroElement();
        FieldElement fieldElement2 = polynomialField.getOneElement();
        EllipticCurve ellipticCurve = new EllipticCurve(fieldElement, fieldElement2, null);
        Polynomial polynomial = new Polynomial(new BigInteger("0503213F78CA44883F1A3B8162F188E553CD265F23C1567A16876913B0C2AC2458492836", 16), polynomialField);
        Polynomial polynomial2 = new Polynomial(new BigInteger("01CCDA380F1C9E318D90F95D07E5426FE87E45C0E8184698E45962364E34116177DD2259", 16), polynomialField);
        PolynomeECPoint polynomeECPoint = new PolynomeECPoint(polynomial, polynomial2, ellipticCurve);
        BigInteger bigInteger2 = new BigInteger("01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFE9AE2ED07577265DFF7F94451E061E163C61", 16);
        BigInteger bigInteger3 = BigInteger.valueOf(4L);
        ECParameters eCParameters = new ECParameters(polynomeECPoint, bigInteger2, bigInteger3);
        eCParameters.setNamedCurve(NamedCurveFactory.b(16, "x962t283k1"));
        return eCParameters;
    }

    private static ECParameters s() {
        BigInteger bigInteger = new BigInteger("800000000000000000004000000000000000000000000000000000000001", 16);
        PolynomialField polynomialField = new PolynomialField(bigInteger);
        FieldElement fieldElement = polynomialField.getZeroElement();
        FieldElement fieldElement2 = polynomialField.getOneElement();
        EllipticCurve ellipticCurve = new EllipticCurve(fieldElement, fieldElement2, null);
        Polynomial polynomial = new Polynomial(new BigInteger("29A0B6A887A983E9730988A68727A8B2D126C44CC2CC7B2A6555193035DC", 16), polynomialField);
        Polynomial polynomial2 = new Polynomial(new BigInteger("76310804F12E549BDB011C103089E73510ACB275FC312A5DC6B76553F0CA", 16), polynomialField);
        PolynomeECPoint polynomeECPoint = new PolynomeECPoint(polynomial, polynomial2, ellipticCurve);
        BigInteger bigInteger2 = new BigInteger("2000000000000000000000000000005A79FEC67CB6E91F1C1DA800E478A5", 16);
        BigInteger bigInteger3 = BigInteger.valueOf(4L);
        ECParameters eCParameters = new ECParameters(polynomeECPoint, bigInteger2, bigInteger3);
        eCParameters.setNamedCurve(NamedCurveFactory.b(3, "x962t239k1"));
        return eCParameters;
    }

    private static ECParameters r() {
        BigInteger bigInteger = new BigInteger("020000000000000000000000000000000000000004000000000000000001", 16);
        PolynomialField polynomialField = new PolynomialField(bigInteger);
        FieldElement fieldElement = polynomialField.getOneElement();
        Polynomial polynomial = new Polynomial(new BigInteger("0066647EDE6C332C7F8C0923BB58213B333B20E9CE4281FE115F7D8F90AD", 16), polynomialField);
        BigInteger bigInteger2 = new BigInteger("74D59FF07F6B413D0EA14B344B20A2DB049B50C3", 16);
        EllipticCurve ellipticCurve = new EllipticCurve(fieldElement, polynomial, bigInteger2);
        Polynomial polynomial2 = new Polynomial(new BigInteger("00FAC9DFCBAC8313BB2139F1BB755FEF65BC391F8B36F8F8EB7371FD558B", 16), polynomialField);
        Polynomial polynomial3 = new Polynomial(new BigInteger("01006A08A41903350678E58528BEBF8A0BEFF867A7CA36716F7E01F81052", 16), polynomialField);
        PolynomeECPoint polynomeECPoint = new PolynomeECPoint(polynomial2, polynomial3, ellipticCurve);
        BigInteger bigInteger3 = new BigInteger("01000000000000000000000000000013E974E72F8A6922031D2603CFE0D7", 16);
        BigInteger bigInteger4 = BigInteger.valueOf(2L);
        ECParameters eCParameters = new ECParameters(polynomeECPoint, bigInteger3, bigInteger4);
        eCParameters.setNamedCurve(NamedCurveFactory.b(27, "x962t233r1"));
        return eCParameters;
    }

    private static ECParameters q() {
        BigInteger bigInteger = new BigInteger("020000000000000000000000000000000000000004000000000000000001", 16);
        PolynomialField polynomialField = new PolynomialField(bigInteger);
        FieldElement fieldElement = polynomialField.getZeroElement();
        FieldElement fieldElement2 = polynomialField.getOneElement();
        EllipticCurve ellipticCurve = new EllipticCurve(fieldElement, fieldElement2, null);
        Polynomial polynomial = new Polynomial(new BigInteger("017232BA853A7E731AF129F22FF4149563A419C26BF50A4C9D6EEFAD6126", 16), polynomialField);
        Polynomial polynomial2 = new Polynomial(new BigInteger("01DB537DECE819B7F70F555A67C427A8CD9BF18AEB9B56E0C11056FAE6A3", 16), polynomialField);
        PolynomeECPoint polynomeECPoint = new PolynomeECPoint(polynomial, polynomial2, ellipticCurve);
        BigInteger bigInteger2 = new BigInteger("8000000000000000000000000000069D5BB915BCD46EFB1AD5F173ABDF", 16);
        BigInteger bigInteger3 = BigInteger.valueOf(4L);
        ECParameters eCParameters = new ECParameters(polynomeECPoint, bigInteger2, bigInteger3);
        eCParameters.setNamedCurve(NamedCurveFactory.b(26, "x962t233k1"));
        return eCParameters;
    }

    private static ECParameters p() {
        BigInteger bigInteger = new BigInteger("02000000000000000000000000000000000000000000008001", 16);
        PolynomialField polynomialField = new PolynomialField(bigInteger);
        Polynomial polynomial = new Polynomial(new BigInteger("0163F35A5137C2CE3EA6ED8667190B0BC43ECD69977702709B", 16), polynomialField);
        Polynomial polynomial2 = new Polynomial(new BigInteger("00C9BB9E8927D4D64C377E2AB2856A5B16E3EFB7F61D4316AE", 16), polynomialField);
        BigInteger bigInteger2 = new BigInteger("10B7B4D696E676875615175137C8A16FD0DA2211", 16);
        EllipticCurve ellipticCurve = new EllipticCurve(polynomial, polynomial2, bigInteger2);
        Polynomial polynomial3 = new Polynomial(new BigInteger("00D9B67D192E0367C803F39E1A7E82CA14A651350AAE617E8F", 16), polynomialField);
        Polynomial polynomial4 = new Polynomial(new BigInteger("01CE94335607C304AC29E7DEFBD9CA01F596F927224CDECF6C", 16), polynomialField);
        PolynomeECPoint polynomeECPoint = new PolynomeECPoint(polynomial3, polynomial4, ellipticCurve);
        BigInteger bigInteger3 = new BigInteger("010000000000000000000000015AAB561B005413CCD4EE99D5", 16);
        BigInteger bigInteger4 = BigInteger.valueOf(2L);
        ECParameters eCParameters = new ECParameters(polynomeECPoint, bigInteger3, bigInteger4);
        eCParameters.setNamedCurve(NamedCurveFactory.b(25, "x962t193r2"));
        return eCParameters;
    }

    private static ECParameters o() {
        BigInteger bigInteger = new BigInteger("02000000000000000000000000000000000000000000008001", 16);
        PolynomialField polynomialField = new PolynomialField(bigInteger);
        Polynomial polynomial = new Polynomial(new BigInteger("0017858FEB7A98975169E171F77B4087DE098AC8A911DF7B01", 16), polynomialField);
        Polynomial polynomial2 = new Polynomial(new BigInteger("00FDFB49BFE6C3A89FACADAA7A1E5BBC7CC1C2E5D831478814", 16), polynomialField);
        BigInteger bigInteger2 = new BigInteger("103FAEC74D696E676875615175777FC5B191EF30", 16);
        EllipticCurve ellipticCurve = new EllipticCurve(polynomial, polynomial2, bigInteger2);
        Polynomial polynomial3 = new Polynomial(new BigInteger("01F481BC5F0FF84A74AD6CDF6FDEF4BF6179625372D8C0C5E1", 16), polynomialField);
        Polynomial polynomial4 = new Polynomial(new BigInteger("0025E399F2903712CCF3EA9E3A1AD17FB0B3201B6AF7CE1B05", 16), polynomialField);
        PolynomeECPoint polynomeECPoint = new PolynomeECPoint(polynomial3, polynomial4, ellipticCurve);
        BigInteger bigInteger3 = new BigInteger("01000000000000000000000000C7F34A778F443ACC920EBA49", 16);
        BigInteger bigInteger4 = BigInteger.valueOf(2L);
        ECParameters eCParameters = new ECParameters(polynomeECPoint, bigInteger3, bigInteger4);
        eCParameters.setNamedCurve(NamedCurveFactory.b(24, "x962t193r1"));
        return eCParameters;
    }

    private static ECParameters n() {
        BigInteger bigInteger = new BigInteger("0800000000000000000000000000000000000000C9", 16);
        PolynomialField polynomialField = new PolynomialField(bigInteger);
        FieldElement fieldElement = polynomialField.getOneElement();
        Polynomial polynomial = new Polynomial(new BigInteger("020A601907B8C953CA1481EB10512F78744A3205FD", 16), polynomialField);
        BigInteger bigInteger2 = new BigInteger("85E25BFE5C86226CDB12016F7553F9D0E693A268", 16);
        EllipticCurve ellipticCurve = new EllipticCurve(fieldElement, polynomial, bigInteger2);
        Polynomial polynomial2 = new Polynomial(new BigInteger("03F0EBA16286A2D57EA0991168D4994637E8343E36", 16), polynomialField);
        Polynomial polynomial3 = new Polynomial(new BigInteger("00D51FBC6C71A0094FA2CDD545B11C5C0C797324F1", 16), polynomialField);
        PolynomeECPoint polynomeECPoint = new PolynomeECPoint(polynomial2, polynomial3, ellipticCurve);
        BigInteger bigInteger3 = new BigInteger("040000000000000000000292FE77E70C12A4234C33", 16);
        BigInteger bigInteger4 = BigInteger.valueOf(2L);
        ECParameters eCParameters = new ECParameters(polynomeECPoint, bigInteger3, bigInteger4);
        eCParameters.setNamedCurve(NamedCurveFactory.b(15, "x962t163r2"));
        return eCParameters;
    }

    private static ECParameters m() {
        BigInteger bigInteger = new BigInteger("0800000000000000000000000000000000000000C9", 16);
        PolynomialField polynomialField = new PolynomialField(bigInteger);
        Polynomial polynomial = new Polynomial(new BigInteger("07B6882CAAEFA84F9554FF8428BD88E246D2782AE2", 16), polynomialField);
        Polynomial polynomial2 = new Polynomial(new BigInteger("0713612DCDDCB40AAB946BDA29CA91F73AF958AFD9", 16), polynomialField);
        BigInteger bigInteger2 = new BigInteger("24B7B137C8A14D696E6768756151756FD0DA2E5C", 16);
        EllipticCurve ellipticCurve = new EllipticCurve(polynomial, polynomial2, bigInteger2);
        Polynomial polynomial3 = new Polynomial(new BigInteger("0369979697AB43897789566789567F787A7876A654", 16), polynomialField);
        Polynomial polynomial4 = new Polynomial(new BigInteger("00435EDB42EFAFB2989D51FEFCE3C80988F41FF883", 16), polynomialField);
        PolynomeECPoint polynomeECPoint = new PolynomeECPoint(polynomial3, polynomial4, ellipticCurve);
        BigInteger bigInteger3 = new BigInteger("03FFFFFFFFFFFFFFFFFFFF48AAB689C29CA710279B", 16);
        BigInteger bigInteger4 = BigInteger.valueOf(2L);
        ECParameters eCParameters = new ECParameters(polynomeECPoint, bigInteger3, bigInteger4);
        eCParameters.setNamedCurve(NamedCurveFactory.b(2, "x962t163r1"));
        return eCParameters;
    }

    private static ECParameters l() {
        FieldElement fieldElement;
        BigInteger bigInteger = new BigInteger("0800000000000000000000000000000000000000C9", 16);
        PolynomialField polynomialField = new PolynomialField(bigInteger);
        FieldElement fieldElement2 = fieldElement = polynomialField.getOneElement();
        EllipticCurve ellipticCurve = new EllipticCurve(fieldElement, fieldElement2, null);
        Polynomial polynomial = new Polynomial(new BigInteger("02FE13C0537BBC11ACAA07D793DE4E6D5E5C94EEE8", 16), polynomialField);
        Polynomial polynomial2 = new Polynomial(new BigInteger("0289070FB05D38FF58321F2E800536D538CCDAA3D9", 16), polynomialField);
        PolynomeECPoint polynomeECPoint = new PolynomeECPoint(polynomial, polynomial2, ellipticCurve);
        BigInteger bigInteger2 = new BigInteger("04000000000000000000020108A2E0CC0D99F8A5EF", 16);
        BigInteger bigInteger3 = BigInteger.valueOf(2L);
        ECParameters eCParameters = new ECParameters(polynomeECPoint, bigInteger2, bigInteger3);
        eCParameters.setNamedCurve(NamedCurveFactory.b(1, "x962t163k1"));
        return eCParameters;
    }

    private static ECParameters k() throws IllegalArgumentException {
        BigInteger bigInteger = new BigInteger("6864797660130609714981900799081393217269435300143305409394463459185543183397656052122559640661454554977296311391480858037121987999716643812574028291115057151", 10);
        GFp gFp = new GFp(bigInteger);
        GFpElement gFpElement = new GFpElement(new BigInteger("01FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC", 16), gFp);
        GFpElement gFpElement2 = new GFpElement(new BigInteger("051953EB9618E1C9A1F929A21A0B68540EEA2DA725B99B315F3B8B489918EF109E156193951EC7E937B1652C0BD3BB1BF073573DF883D2C34F1EF451FD46B503F00", 16), gFp);
        BigInteger bigInteger2 = new BigInteger("D09E8800291CB85396CC6717393284AAA0DA64BA", 16);
        EllipticCurve ellipticCurve = new EllipticCurve(gFpElement, gFpElement2, bigInteger2);
        GFpElement gFpElement3 = new GFpElement(new BigInteger("C6858E06B70404E9CD9E3ECB662395B4429C648139053FB521F828AF606B4D3DBAA14B5E77EFE75928FE1DC127A2FFA8DE3348B3C1856A429BF97E7E31C2E5BD66", 16), gFp);
        GFpElement gFpElement4 = new GFpElement(new BigInteger("11839296A789A3BC0045C8A5FB42C7D1BD998F54449579B446817AFBD17273E662C97EE72995EF42640C550B9013FAD0761353C7086A272C24088BE94769FD16650", 16), gFp);
        ECPointGFp eCPointGFp = new ECPointGFp(gFpElement3, gFpElement4, ellipticCurve);
        BigInteger bigInteger3 = new BigInteger("6864797660130609714981900799081393217269435300143305409394463459185543183397655394245057746333217197532963996371363321113864768612440380340372808892707005449", 10);
        BigInteger bigInteger4 = new BigInteger("1", 16);
        ECParameters eCParameters = new ECParameters(eCPointGFp, bigInteger3, bigInteger4);
        eCParameters.setNamedCurve(NamedCurveFactory.b(35, "X962p521r1"));
        return eCParameters;
    }

    private static ECParameters j() throws IllegalArgumentException {
        BigInteger bigInteger = new BigInteger("39402006196394479212279040100143613805079739270465446667948293404245721771496870329047266088258938001861606973112319", 10);
        GFp gFp = new GFp(bigInteger);
        GFpElement gFpElement = new GFpElement(new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFC", 16), gFp);
        GFpElement gFpElement2 = new GFpElement(new BigInteger("B3312FA7E23EE7E4988E056BE3F82D19181D9C6EFE8141120314088F5013875AC656398D8A2ED19D2A85C8EDD3EC2AEF", 16), gFp);
        BigInteger bigInteger2 = new BigInteger("A335926AA319A27A1D00896A6773A4827ACDAC73", 16);
        EllipticCurve ellipticCurve = new EllipticCurve(gFpElement, gFpElement2, bigInteger2);
        GFpElement gFpElement3 = new GFpElement(new BigInteger("AA87CA22BE8B05378EB1C71EF320AD746E1D3B628BA79B9859F741E082542A385502F25DBF55296C3A545E3872760AB7", 16), gFp);
        GFpElement gFpElement4 = new GFpElement(new BigInteger("3617DE4A96262C6F5D9E98BF9292DC29F8F41DBD289A147CE9DA3113B5F0B8C00A60B1CE1D7E819D7A431D7C90EA0E5F", 16), gFp);
        ECPointGFp eCPointGFp = new ECPointGFp(gFpElement3, gFpElement4, ellipticCurve);
        BigInteger bigInteger3 = new BigInteger("39402006196394479212279040100143613805079739270465446667946905279627659399113263569398956308152294913554433653942643", 10);
        BigInteger bigInteger4 = new BigInteger("1", 16);
        ECParameters eCParameters = new ECParameters(eCPointGFp, bigInteger3, bigInteger4);
        eCParameters.setNamedCurve(NamedCurveFactory.b(34, "X962p384r1"));
        return eCParameters;
    }

    private static ECParameters i() throws IllegalArgumentException {
        BigInteger bigInteger = new BigInteger("115792089210356248762697446949407573530086143415290314195533631308867097853951", 10);
        GFp gFp = new GFp(bigInteger);
        GFpElement gFpElement = new GFpElement(new BigInteger("FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFC", 16), gFp);
        GFpElement gFpElement2 = new GFpElement(new BigInteger("5AC635D8AA3A93E7B3EBBD55769886BC651D06B0CC53B0F63BCE3C3E27D2604B", 16), gFp);
        BigInteger bigInteger2 = new BigInteger("C49D360886E704936A6678E1139D26B7819F7E90", 16);
        EllipticCurve ellipticCurve = new EllipticCurve(gFpElement, gFpElement2, bigInteger2);
        GFpElement gFpElement3 = new GFpElement(new BigInteger("6B17D1F2E12C4247F8BCE6E563A440F277037D812DEB33A0F4A13945D898C296", 16), gFp);
        GFpElement gFpElement4 = new GFpElement(new BigInteger("4FE342E2FE1A7F9B8EE7EB4A7C0F9E162BCE33576B315ECECBB6406837BF51F5", 16), gFp);
        ECPointGFp eCPointGFp = new ECPointGFp(gFpElement3, gFpElement4, ellipticCurve);
        BigInteger bigInteger3 = new BigInteger("FFFFFFFF00000000FFFFFFFFFFFFFFFFBCE6FAADA7179E84F3B9CAC2FC632551", 16);
        BigInteger bigInteger4 = new BigInteger("1", 16);
        ECParameters eCParameters = new ECParameters(eCPointGFp, bigInteger3, bigInteger4);
        eCParameters.setNamedCurve(NamedCurveFactory.a(7, "X962p256r1"));
        return eCParameters;
    }

    private static ECParameters h() throws IllegalArgumentException {
        BigInteger bigInteger = new BigInteger("115792089237316195423570985008687907853269984665640564039457584007908834671663", 10);
        GFp gFp = new GFp(bigInteger);
        GFpElement gFpElement = new GFpElement(new BigInteger("0"), gFp);
        GFpElement gFpElement2 = new GFpElement(new BigInteger("7"), gFp);
        EllipticCurve ellipticCurve = new EllipticCurve(gFpElement, gFpElement2, null);
        GFpElement gFpElement3 = new GFpElement(new BigInteger("79BE667EF9DCBBAC55A06295CE870B07029BFCDB2DCE28D959F2815B16F81798", 16), gFp);
        GFpElement gFpElement4 = new GFpElement(new BigInteger("483ADA7726A3C4655DA4FBFC0E1108A8FD17B448A68554199C47D08FFB10D4B8", 16), gFp);
        ECPointGFp eCPointGFp = new ECPointGFp(gFpElement3, gFpElement4, ellipticCurve);
        BigInteger bigInteger2 = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEBAAEDCE6AF48A03BBFD25E8CD0364141", 16);
        BigInteger bigInteger3 = new BigInteger("1", 16);
        ECParameters eCParameters = new ECParameters(eCPointGFp, bigInteger2, bigInteger3);
        eCParameters.setNamedCurve(NamedCurveFactory.b(10, "X962p256k1"));
        return eCParameters;
    }

    private static ECParameters g() throws IllegalArgumentException {
        BigInteger bigInteger = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000001", 16);
        GFp gFp = new GFp(bigInteger);
        GFpElement gFpElement = new GFpElement(new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFE", 16), gFp);
        GFpElement gFpElement2 = new GFpElement(new BigInteger("B4050A850C04B3ABF54132565044B0B7D7BFD8BA270B39432355FFB4", 16), gFp);
        BigInteger bigInteger2 = new BigInteger("BD71344799D5C7FCDC45B59FA3B9AB8F6A948BC5", 16);
        EllipticCurve ellipticCurve = new EllipticCurve(gFpElement, gFpElement2, bigInteger2);
        GFpElement gFpElement3 = new GFpElement(new BigInteger("B70E0CBD6BB4BF7F321390B94A03C1D356C21122343280D6115C1D21", 16), gFp);
        GFpElement gFpElement4 = new GFpElement(new BigInteger("BD376388B5F723FB4C22DFE6CD4375A05A07476444D5819985007E34", 16), gFp);
        ECPointGFp eCPointGFp = new ECPointGFp(gFpElement3, gFpElement4, ellipticCurve);
        BigInteger bigInteger3 = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFF16A2E0B8F03E13DD29455C5C2A3D", 16);
        BigInteger bigInteger4 = new BigInteger("1", 16);
        ECParameters eCParameters = new ECParameters(eCPointGFp, bigInteger3, bigInteger4);
        eCParameters.setNamedCurve(NamedCurveFactory.b(33, "X962p224r1"));
        return eCParameters;
    }

    private static ECParameters f() throws IllegalArgumentException {
        BigInteger bigInteger = new BigInteger("26959946667150639794667015087019630673637144422540572481099315275117", 10);
        GFp gFp = new GFp(bigInteger);
        GFpElement gFpElement = new GFpElement(new BigInteger("0"), gFp);
        GFpElement gFpElement2 = new GFpElement(new BigInteger("5"), gFp);
        EllipticCurve ellipticCurve = new EllipticCurve(gFpElement, gFpElement2, null);
        GFpElement gFpElement3 = new GFpElement(new BigInteger("A1455B334DF099DF30FC28A169A467E9E47075A90F7E650EB6B7A45C", 16), gFp);
        GFpElement gFpElement4 = new GFpElement(new BigInteger("7E089FED7FBA344282CAFBD6F7E319F7C0B0BD59E2CA4BDB556D61A5", 16), gFp);
        ECPointGFp eCPointGFp = new ECPointGFp(gFpElement3, gFpElement4, ellipticCurve);
        BigInteger bigInteger2 = new BigInteger("010000000000000000000000000001DCE8D2EC6184CAF0A971769FB1F7", 16);
        BigInteger bigInteger3 = new BigInteger("1", 16);
        ECParameters eCParameters = new ECParameters(eCPointGFp, bigInteger2, bigInteger3);
        eCParameters.setNamedCurve(NamedCurveFactory.b(32, "X962p224k1"));
        return eCParameters;
    }

    private static ECParameters e() throws IllegalArgumentException {
        BigInteger bigInteger = new BigInteger("6277101735386680763835789423207666416083908700390324961279", 10);
        GFp gFp = new GFp(bigInteger);
        GFpElement gFpElement = new GFpElement(new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFFFFFFFFFC", 16), gFp);
        GFpElement gFpElement2 = new GFpElement(new BigInteger("64210519E59C80E70FA7E9AB72243049FEB8DEECC146B9B1", 16), gFp);
        BigInteger bigInteger2 = new BigInteger("3045AE6FC8422F64ED579528D38120EAE12196D5", 16);
        EllipticCurve ellipticCurve = new EllipticCurve(gFpElement, gFpElement2, bigInteger2);
        GFpElement gFpElement3 = new GFpElement(new BigInteger("188DA80EB03090F67CBF20EB43A18800F4FF0AFD82FF1012", 16), gFp);
        GFpElement gFpElement4 = new GFpElement(new BigInteger("07192B95FFC8DA78631011ED6B24CDD573F977A11E794811", 16), gFp);
        ECPointGFp eCPointGFp = new ECPointGFp(gFpElement3, gFpElement4, ellipticCurve);
        BigInteger bigInteger3 = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFF99DEF836146BC9B1B4D22831", 16);
        BigInteger bigInteger4 = new BigInteger("1", 16);
        ECParameters eCParameters = new ECParameters(eCPointGFp, bigInteger3, bigInteger4);
        eCParameters.setNamedCurve(NamedCurveFactory.a(1, "X962p192r1"));
        return eCParameters;
    }

    private static ECParameters d() throws IllegalArgumentException {
        BigInteger bigInteger = new BigInteger("6277101735386680763835789423207666416102355444459739541047", 10);
        GFp gFp = new GFp(bigInteger);
        GFpElement gFpElement = new GFpElement(new BigInteger("0"), gFp);
        GFpElement gFpElement2 = new GFpElement(new BigInteger("3"), gFp);
        EllipticCurve ellipticCurve = new EllipticCurve(gFpElement, gFpElement2, null);
        GFpElement gFpElement3 = new GFpElement(new BigInteger("DB4FF10EC057E9AE26B07D0280B7F4341DA5D1B1EAE06C7D", 16), gFp);
        GFpElement gFpElement4 = new GFpElement(new BigInteger("9B2F2F6D9C5628A7844163D015BE86344082AA88D95E2F9D", 16), gFp);
        ECPointGFp eCPointGFp = new ECPointGFp(gFpElement3, gFpElement4, ellipticCurve);
        BigInteger bigInteger2 = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFE26F2FC170F69466A74DEFD8D", 16);
        BigInteger bigInteger3 = new BigInteger("1", 16);
        ECParameters eCParameters = new ECParameters(eCPointGFp, bigInteger2, bigInteger3);
        eCParameters.setNamedCurve(NamedCurveFactory.b(31, "X962p192k1"));
        return eCParameters;
    }

    private static ECParameters c() throws IllegalArgumentException {
        BigInteger bigInteger = new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFAC73", 16);
        BigInteger bigInteger2 = new BigInteger("B99B99B099B323E02709A4D696E6768756151751", 16);
        GFp gFp = new GFp(bigInteger);
        GFpElement gFpElement = new GFpElement(new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFAC70", 16), gFp);
        GFpElement gFpElement2 = new GFpElement(new BigInteger("B4E134D3FB59EB8BAB57274904664D5AF50388BA", 16), gFp);
        EllipticCurve ellipticCurve = new EllipticCurve(gFpElement, gFpElement2, bigInteger2);
        GFpElement gFpElement3 = new GFpElement(new BigInteger("52DCB034293A117E1F4FF11B30F7199D3144CE6D", 16), gFp);
        GFpElement gFpElement4 = new GFpElement(new BigInteger("FEAFFEF2E331F296E071FA0DF9982CFEA7D43F2E", 16), gFp);
        ECPointGFp eCPointGFp = new ECPointGFp(gFpElement3, gFpElement4, ellipticCurve);
        BigInteger bigInteger3 = new BigInteger("100000000000000000000351EE786A818F3A1A16B", 16);
        BigInteger bigInteger4 = new BigInteger("1", 16);
        ECParameters eCParameters = new ECParameters(eCPointGFp, bigInteger3, bigInteger4);
        eCParameters.setNamedCurve(NamedCurveFactory.b(30, "X962p160r2"));
        return eCParameters;
    }

    private static ECParameters b() throws IllegalArgumentException {
        BigInteger bigInteger = new BigInteger("1461501637330902918203684832716283019653785059327", 10);
        BigInteger bigInteger2 = new BigInteger("1053CDE42C14D696E67687561517533BF3F83345", 16);
        GFp gFp = new GFp(bigInteger);
        GFpElement gFpElement = new GFpElement(new BigInteger("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF7FFFFFFC", 16), gFp);
        GFpElement gFpElement2 = new GFpElement(new BigInteger("1C97BEFC54BD7A8B65ACF89F81D4D4ADC565FA45", 16), gFp);
        EllipticCurve ellipticCurve = new EllipticCurve(gFpElement, gFpElement2, bigInteger2);
        GFpElement gFpElement3 = new GFpElement(new BigInteger("4A96B5688EF573284664698968C38BB913CBFC82", 16), gFp);
        GFpElement gFpElement4 = new GFpElement(new BigInteger("23A628553168947D59DCC912042351377AC5FB32", 16), gFp);
        ECPointGFp eCPointGFp = new ECPointGFp(gFpElement3, gFpElement4, ellipticCurve);
        BigInteger bigInteger3 = new BigInteger("0100000000000000000001F4C8F927AED3CA752257", 16);
        BigInteger bigInteger4 = new BigInteger("1", 16);
        ECParameters eCParameters = new ECParameters(eCPointGFp, bigInteger3, bigInteger4);
        eCParameters.setNamedCurve(NamedCurveFactory.b(8, "X962p160r1"));
        return eCParameters;
    }

    private static ECParameters a() throws IllegalArgumentException {
        BigInteger bigInteger = new BigInteger("1461501637330902918203684832716283019651637554291", 10);
        GFp gFp = new GFp(bigInteger);
        GFpElement gFpElement = new GFpElement(new BigInteger("0"), gFp);
        GFpElement gFpElement2 = new GFpElement(new BigInteger("7"), gFp);
        EllipticCurve ellipticCurve = new EllipticCurve(gFpElement, gFpElement2, null);
        GFpElement gFpElement3 = new GFpElement(new BigInteger("3B4C382CE37AA192A4019E763036F4F5DD4D7EBB", 16), gFp);
        GFpElement gFpElement4 = new GFpElement(new BigInteger("938CF935318FDCED6BC28286531733C3F03C4FEE", 16), gFp);
        ECPointGFp eCPointGFp = new ECPointGFp(gFpElement3, gFpElement4, ellipticCurve);
        BigInteger bigInteger2 = new BigInteger("0100000000000000000001B8FA16DFAB9ACA16B6B3", 16);
        BigInteger bigInteger3 = new BigInteger("1", 16);
        ECParameters eCParameters = new ECParameters(eCPointGFp, bigInteger2, bigInteger3);
        eCParameters.setNamedCurve(NamedCurveFactory.b(9, "X962p160k1"));
        return eCParameters;
    }

    public static void register(ObjectID objectID, ECParameters eCParameters) {
        try {
            ECParameters eCParameters2 = NamedCurveFactory.getInstance(objectID);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            a.put(objectID, eCParameters);
            int n2 = eCParameters.getField().getNumberOfElements().bitLength();
            b.put(new Integer(n2), eCParameters);
        }
    }

    private static ObjectID b(int n2, String string) {
        return new ObjectID("1.3.132.0." + n2, string);
    }

    private static ObjectID b(int n2) {
        return new ObjectID("1.3.132.0." + n2);
    }

    private static ObjectID a(int n2, String string) {
        return new ObjectID("1.2.840.10045.3.1." + n2, string);
    }

    private static ObjectID a(int n2) {
        return new ObjectID("1.2.840.10045.3.1." + n2);
    }

    public static ECParameters getInstance(ObjectID objectID) throws IllegalArgumentException {
        ECParameters eCParameters = (ECParameters)a.get(objectID);
        if (eCParameters == null) {
            if (objectID.equals(NamedCurveFactory.b(9))) {
                eCParameters = NamedCurveFactory.a();
                a.put(objectID, eCParameters);
                b.put(new Integer(160), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.b(8))) {
                eCParameters = NamedCurveFactory.b();
                a.put(objectID, eCParameters);
                b.put(new Integer(160), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.b(30))) {
                eCParameters = NamedCurveFactory.c();
                a.put(objectID, eCParameters);
                b.put(new Integer(160), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.b(31))) {
                eCParameters = NamedCurveFactory.d();
                a.put(objectID, eCParameters);
                b.put(new Integer(192), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.a(1))) {
                eCParameters = NamedCurveFactory.e();
                a.put(objectID, eCParameters);
                b.put(new Integer(192), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.b(32))) {
                eCParameters = NamedCurveFactory.f();
                a.put(objectID, eCParameters);
                b.put(new Integer(224), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.b(33))) {
                eCParameters = NamedCurveFactory.g();
                a.put(objectID, eCParameters);
                b.put(new Integer(224), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.b(10))) {
                eCParameters = NamedCurveFactory.h();
                a.put(objectID, eCParameters);
                b.put(new Integer(256), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.a(7))) {
                eCParameters = NamedCurveFactory.i();
                a.put(objectID, eCParameters);
                b.put(new Integer(256), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.b(34))) {
                eCParameters = NamedCurveFactory.j();
                a.put(objectID, eCParameters);
                b.put(new Integer(384), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.b(35))) {
                eCParameters = NamedCurveFactory.k();
                a.put(objectID, eCParameters);
                b.put(new Integer(521), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.b(1))) {
                eCParameters = NamedCurveFactory.l();
                a.put(objectID, eCParameters);
                b.put(new Integer(163), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.b(2))) {
                eCParameters = NamedCurveFactory.m();
                a.put(objectID, eCParameters);
                b.put(new Integer(163), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.b(15))) {
                eCParameters = NamedCurveFactory.n();
                a.put(objectID, eCParameters);
                b.put(new Integer(163), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.b(24))) {
                eCParameters = NamedCurveFactory.o();
                a.put(objectID, eCParameters);
                b.put(new Integer(193), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.b(25))) {
                eCParameters = NamedCurveFactory.p();
                a.put(objectID, eCParameters);
                b.put(new Integer(193), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.b(26))) {
                eCParameters = NamedCurveFactory.q();
                a.put(objectID, eCParameters);
                b.put(new Integer(233), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.b(27))) {
                eCParameters = NamedCurveFactory.r();
                a.put(objectID, eCParameters);
                b.put(new Integer(233), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.b(3))) {
                eCParameters = NamedCurveFactory.s();
                a.put(objectID, eCParameters);
                b.put(new Integer(239), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.b(16))) {
                eCParameters = NamedCurveFactory.t();
                a.put(objectID, eCParameters);
                b.put(new Integer(283), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.b(17))) {
                eCParameters = NamedCurveFactory.u();
                a.put(objectID, eCParameters);
                b.put(new Integer(283), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.b(36))) {
                eCParameters = NamedCurveFactory.v();
                a.put(objectID, eCParameters);
                b.put(new Integer(409), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.b(37))) {
                eCParameters = NamedCurveFactory.w();
                a.put(objectID, eCParameters);
                b.put(new Integer(409), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.b(38))) {
                eCParameters = NamedCurveFactory.x();
                a.put(objectID, eCParameters);
                b.put(new Integer(571), eCParameters);
            } else if (objectID.equals(NamedCurveFactory.b(39))) {
                eCParameters = NamedCurveFactory.y();
                a.put(objectID, eCParameters);
                b.put(new Integer(571), eCParameters);
            } else {
                throw new IllegalArgumentException("Don't know this named curve. Please register it by your own first.");
            }
        }
        return eCParameters;
    }

    public static ECParameters getInstance(int n2) throws IllegalArgumentException {
        ECParameters eCParameters = (ECParameters)b.get(new Integer(n2));
        if (eCParameters == null) {
            switch (n2) {
                case 160: {
                    eCParameters = NamedCurveFactory.a();
                    a.put(NamedCurveFactory.b(9), eCParameters);
                    b.put(new Integer(160), eCParameters);
                    break;
                }
                case 192: {
                    eCParameters = NamedCurveFactory.e();
                    a.put(NamedCurveFactory.a(1), eCParameters);
                    b.put(new Integer(192), eCParameters);
                    break;
                }
                case 224: {
                    eCParameters = NamedCurveFactory.f();
                    a.put(NamedCurveFactory.b(32), eCParameters);
                    b.put(new Integer(224), eCParameters);
                    break;
                }
                case 256: {
                    eCParameters = NamedCurveFactory.h();
                    a.put(NamedCurveFactory.b(10), eCParameters);
                    b.put(new Integer(256), eCParameters);
                    break;
                }
                case 384: {
                    eCParameters = NamedCurveFactory.j();
                    a.put(NamedCurveFactory.b(34), eCParameters);
                    b.put(new Integer(384), eCParameters);
                    break;
                }
                case 521: {
                    eCParameters = NamedCurveFactory.k();
                    a.put(NamedCurveFactory.b(35), eCParameters);
                    b.put(new Integer(521), eCParameters);
                    break;
                }
                case 163: {
                    eCParameters = NamedCurveFactory.l();
                    a.put(NamedCurveFactory.b(1), eCParameters);
                    b.put(new Integer(163), eCParameters);
                    break;
                }
                case 193: {
                    eCParameters = NamedCurveFactory.o();
                    a.put(NamedCurveFactory.b(24), eCParameters);
                    b.put(new Integer(193), eCParameters);
                    break;
                }
                case 233: {
                    eCParameters = NamedCurveFactory.q();
                    a.put(NamedCurveFactory.b(26), eCParameters);
                    b.put(new Integer(233), eCParameters);
                    break;
                }
                case 239: {
                    eCParameters = NamedCurveFactory.s();
                    a.put(NamedCurveFactory.b(3), eCParameters);
                    b.put(new Integer(239), eCParameters);
                    break;
                }
                case 283: {
                    eCParameters = NamedCurveFactory.t();
                    a.put(NamedCurveFactory.b(16), eCParameters);
                    b.put(new Integer(283), eCParameters);
                    break;
                }
                case 409: {
                    eCParameters = NamedCurveFactory.v();
                    a.put(NamedCurveFactory.b(36), eCParameters);
                    b.put(new Integer(409), eCParameters);
                    break;
                }
                case 571: {
                    eCParameters = NamedCurveFactory.x();
                    a.put(NamedCurveFactory.b(38), eCParameters);
                    b.put(new Integer(571), eCParameters);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Don't know a named curve of length " + n2 + ".");
                }
            }
        }
        return eCParameters;
    }

    static {
        a = new Hashtable();
        b = new Hashtable();
    }
}

