/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.security.provider;

import com.entrust.toolkit.security.fips.SecurityEngine;
import com.entrust.toolkit.util.ByteArray;
import iaik.security.random.SecRandom;
import iaik.security.rsa.RSAPrivateKey;
import iaik.security.rsa.RSAPublicKey;
import iaik.utils.CryptoUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RSAKeyPairGenerator
extends KeyPairGenerator {
    private static final byte[] g;
    private static final int[] c;
    private static final BigInteger f;
    private static final BigInteger h;
    private boolean e = false;
    private BigInteger b = null;
    private SecureRandom a;
    private int d;

    private void a(KeyPair keyPair) {
        try {
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, keyPair.getPublic());
            byte[] byArray = cipher.doFinal(g);
            if (CryptoUtils.equalsBlock(g, byArray)) {
                SecurityEngine.setErrorState("RSA pair-wise consistency test failed");
            }
            cipher.init(2, keyPair.getPrivate());
            byte[] byArray2 = cipher.doFinal(byArray);
            if (!CryptoUtils.equalsBlock(g, byArray2)) {
                SecurityEngine.setErrorState("RSA pair-wise consistency test failed");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            SecurityEngine.setErrorState("Unable to perform RSA pair-wise consistency test - please ensure all required Providers are registered");
        }
        catch (InvalidKeyException invalidKeyException) {
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
        }
        catch (BadPaddingException badPaddingException) {}
    }

    private boolean a(RSAPublicKey rSAPublicKey, RSAPrivateKey rSAPrivateKey) {
        try {
            if (rSAPublicKey == null | rSAPrivateKey == null) {
                return true;
            }
            byte[] byArray = new BigInteger("2389429834959435ADDD", 16).toByteArray();
            Cipher cipher = Cipher.getInstance("RSA/1/PKCS1Padding");
            cipher.init(1, rSAPublicKey);
            byte[] byArray2 = cipher.doFinal(byArray, 0, byArray.length);
            cipher.init(2, rSAPrivateKey);
            byte[] byArray3 = cipher.doFinal(byArray2, 0, byArray2.length);
            ByteArray byteArray = new ByteArray(byArray3);
            return !byteArray.isEqual(byArray);
        }
        catch (Exception exception) {
            return true;
        }
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        this.initialize(n2, null, null);
    }

    public void initialize(int n2, BigInteger bigInteger, SecureRandom secureRandom) throws InvalidParameterException {
        this.e = true;
        if (bigInteger == null) {
            bigInteger = BigInteger.valueOf(65537L);
        } else if (bigInteger.mod(f).compareTo(h) == 0) {
            throw new InvalidParameterException("Sorry, even public exponents are not supported.");
        }
        this.a = SecRandom.getDefault();
        this.d = n2;
        this.b = bigInteger;
    }

    public void initialize(int n2) {
        this.initialize(n2, null);
    }

    /*
     * Unable to fully structure code
     */
    private BigInteger a() {
        var8_1 = this.d / 2;
        var9_2 = (int)Math.floor(5.0 * (double)var8_1);
        if (var8_1 > 1600) {
            var10_3 = 2;
        }
        var10_3 = (var8_1 > 1023 & var8_1 < 1601) != false ? 3 : ((var8_1 > 767 & var8_1 < 1024) != false ? 4 : ((var8_1 > 511 & var8_1 < 768) != false ? 6 : 13));
        block0: while (true) {
            var1_4 = new BigInteger(this.d / 2, this.a);
            var3_6 = new byte[var9_2];
            var1_4 = var1_4.setBit(this.d / 2 - 1);
            var1_4 = var1_4.setBit(this.d / 2 - 2);
            if ((var1_4 = var1_4.setBit(0)).add(BigInteger.valueOf(4000L)).bitLength() > this.d / 2) continue;
            var6_9 = 0;
            while (var6_9 < RSAKeyPairGenerator.c.length) {
                var4_7 = var1_4.mod(BigInteger.valueOf(RSAKeyPairGenerator.c[var6_9])).intValue();
                var11_10 = var5_8 = RSAKeyPairGenerator.c[var6_9] - var4_7;
                while (var11_10 < var3_6.length) {
                    var3_6[var11_10] = 1;
                    var11_10 += RSAKeyPairGenerator.c[var6_9];
                }
                ++var6_9;
            }
            var6_9 = 0;
            while (true) {
                if (var6_9 < var3_6.length) ** break;
                continue block0;
                if (var3_6[var6_9] == 0 && (var2_5 = var1_4.add(BigInteger.valueOf(var6_9))).isProbablePrime(2 * var10_3)) {
                    return var2_5;
                }
                var6_9 += 2;
            }
            break;
        }
    }

    public KeyPair generateKeyPair() {
        Serializable serializable;
        SecurityEngine.assertCryptoOperationsAllowed();
        if (!this.e) {
            this.initialize(1024);
        }
        if (this.d < 512) {
            this.d = 512;
        }
        if (this.d % 2 == 1) {
            ++this.d;
        }
        RSAPublicKey rSAPublicKey = null;
        RSAPrivateKey rSAPrivateKey = null;
        do {
            BigInteger bigInteger;
            BigInteger bigInteger2;
            BigInteger bigInteger3;
            BigInteger bigInteger4;
            BigInteger bigInteger5;
            if ((bigInteger5 = this.a()).compareTo(bigInteger4 = this.a()) < 0) {
                serializable = bigInteger5;
                bigInteger5 = bigInteger4;
                bigInteger4 = serializable;
            }
            if (this.b.gcd(bigInteger3 = (bigInteger2 = bigInteger5.subtract(h)).multiply(bigInteger = bigInteger4.subtract(h))).compareTo(h) != 0) continue;
            serializable = bigInteger5.multiply(bigInteger4);
            BigInteger bigInteger6 = this.b.modInverse(bigInteger3);
            BigInteger bigInteger7 = bigInteger6.mod(bigInteger2);
            BigInteger bigInteger8 = bigInteger6.mod(bigInteger);
            BigInteger bigInteger9 = bigInteger4.modInverse(bigInteger5);
            rSAPublicKey = new RSAPublicKey((BigInteger)serializable, this.b);
            rSAPrivateKey = new RSAPrivateKey((BigInteger)serializable, this.b, bigInteger6, bigInteger5, bigInteger4, bigInteger7, bigInteger8, bigInteger9);
        } while (this.a(rSAPublicKey, rSAPrivateKey));
        serializable = new KeyPair(rSAPublicKey, rSAPrivateKey);
        if (SecurityEngine.isInFIPSMode()) {
            this.a((KeyPair)serializable);
        }
        return serializable;
    }

    public RSAKeyPairGenerator() {
        super("RSA");
    }

    static {
        h = BigInteger.valueOf(1L);
        f = BigInteger.valueOf(2L);
        c = new int[]{3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 199, 211, 223, 227, 229, 233, 239, 241, 251, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 349, 353, 359, 367, 373, 379, 383, 389, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499};
        byte[] byArray = new byte[8];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[3] = 3;
        byArray[4] = 4;
        byArray[5] = 5;
        byArray[6] = 6;
        byArray[7] = 7;
        g = byArray;
    }
}

