/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.util;

import com.entrust.toolkit.util.SecureUtils;
import java.math.BigInteger;

public class ByteArray {
    byte[] a;

    public void wipe() {
        if (this.a == null) {
            return;
        }
        SecureUtils.wipe(this.a);
        this.a = null;
    }

    public void truncate(int n2) throws IllegalArgumentException {
        if (this.a != null) {
            int n3 = this.a.length;
            if (n2 < 0) {
                throw new IllegalArgumentException("'length' cannot be less than zero");
            }
            if (n2 > n3) {
                throw new IllegalArgumentException("'length' cannot be larger than the size of the byte array");
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(this.a, 0, byArray, 0, n2);
            this.wipe();
            this.a = byArray;
        }
    }

    public static int toInt(byte by) {
        if (by < 0) {
            return by + 256;
        }
        return by;
    }

    public String toHexString() {
        if (this.a == null) {
            return null;
        }
        int n2 = this.a.length;
        StringBuffer stringBuffer = new StringBuffer(2 * n2);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = (this.a[n3] & 0xF0) >> 4;
            int n5 = this.a[n3] & 0xF;
            stringBuffer.append(new Character((char)(n4 > 9 ? 65 + n4 - 10 : 48 + n4)));
            stringBuffer.append(new Character((char)(n5 > 9 ? 65 + n5 - 10 : 48 + n5)));
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static byte toByte(int n2) {
        if (n2 > 127) {
            return (byte)(n2 - 256);
        }
        return (byte)n2;
    }

    public void tail(int n2) throws IllegalArgumentException {
        if (this.a != null) {
            int n3 = this.a.length;
            if (n2 < 0) {
                throw new IllegalArgumentException("'offset' cannot be less than zero");
            }
            if (n2 > n3) {
                throw new IllegalArgumentException("'offset' cannot be after the end of the byte array");
            }
            byte[] byArray = new byte[n3 - n2];
            System.arraycopy(this.a, n2, byArray, 0, n3 - n2);
            this.wipe();
            this.a = byArray;
        }
    }

    public void setArray(byte[] byArray) {
        this.wipe();
        if (byArray == null) {
            this.a = null;
        } else {
            int n2 = byArray.length;
            this.a = new byte[n2];
            System.arraycopy(byArray, 0, this.a, 0, n2);
        }
    }

    public void removeLeadingZeros() {
        int n2 = 0;
        while (this.a[n2] == 0) {
            ++n2;
        }
        this.tail(n2);
    }

    public boolean isEqual(byte[] byArray) {
        if (this.a == null && byArray == null) {
            return true;
        }
        if (this.a == null || byArray == null) {
            return false;
        }
        int n2 = byArray.length;
        if (this.a.length != n2) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this.a[n3] != byArray[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public boolean isEqual(ByteArray byteArray) {
        return this.isEqual(byteArray.getArray());
    }

    public int getLength() {
        if (this.a == null) {
            return 0;
        }
        return this.a.length;
    }

    public byte[] getArray() {
        return this.a;
    }

    public void fromHexString(String string) throws NumberFormatException, IllegalArgumentException {
        if (string == null) {
            this.a = null;
            return;
        }
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("The length of 'hexString' must be an even number");
        }
        int n2 = string.length() / 2;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            String string2 = string.substring(n4 * 2, n4 * 2 + 2);
            try {
                n3 = Integer.parseInt(string2, 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NumberFormatException("'hexString' must contain only hexidecimal digits - [0..9],[a..f],[A..F]; found - '" + numberFormatException.getMessage() + "'");
            }
            byArray[n4] = (byte)n3;
            ++n4;
        }
        this.setArray(byArray);
        SecureUtils.wipe(byArray);
        byArray = null;
    }

    public int calculateASNLength() {
        int n2;
        int n3 = 1;
        byte by = this.a[0];
        int n4 = ByteArray.toInt(by);
        if ((n4 & 0x1F) == 31) {
            do {
                n4 = ByteArray.toInt(this.a[n3]);
                ++n3;
            } while (n4 > 128);
        }
        if ((n2 = ByteArray.toInt(this.a[n3])) < 128) {
            return n2 + 2;
        }
        int n5 = 0;
        int n6 = n3 + 1;
        int n7 = (n2 -= 128) + 2;
        --n2;
        while (n2 >= 0) {
            int n8 = 1;
            int n9 = 0;
            while (n9 < n2) {
                n8 *= 256;
                ++n9;
            }
            int n10 = ByteArray.toInt(this.a[n6]) * n8;
            n5 += n10;
            --n2;
            ++n6;
        }
        return n5 + n7;
    }

    public void append(byte[] byArray) {
        if (this.a == null && byArray == null) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        if (this.a != null) {
            n2 = this.a.length;
        }
        if (byArray != null) {
            n3 = byArray.length;
        }
        byte[] byArray2 = new byte[n2 + n3];
        if (n2 > 0) {
            System.arraycopy(this.a, 0, byArray2, 0, n2);
        }
        if (n3 > 0) {
            System.arraycopy(byArray, 0, byArray2, n2, n3);
        }
        this.wipe();
        this.a = byArray2;
    }

    public void append(ByteArray byteArray) {
        if (byteArray != null) {
            this.append(byteArray.getArray());
        }
    }

    public void append(byte by) {
        byte[] byArray = new byte[]{by};
        this.append(byArray);
        SecureUtils.wipe(byArray);
        byArray = null;
    }

    public ByteArray(byte[] byArray) {
        this.setArray(byArray);
    }

    public ByteArray(BigInteger bigInteger) {
        if (bigInteger != null) {
            this.a = bigInteger.toByteArray();
        }
    }

    public ByteArray(ByteArray byteArray) {
        if (byteArray != null) {
            byte[] byArray = byteArray.getArray();
            this.setArray(byArray);
        }
    }

    public ByteArray(long l2) {
        this.a = new byte[8];
        int n2 = 7;
        while (n2 > 0) {
            this.a[n2] = (byte)l2;
            l2 >>>= 8;
            --n2;
        }
    }

    public ByteArray() {
    }
}

