/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.util;

import com.entrust.toolkit.security.fips.SecurityEngine;
import com.entrust.toolkit.util.ByteArray;
import com.entrust.toolkit.util.SecureUtils;
import iaik.security.md.SHA;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ExtendedHasher {
    private ByteArray c;
    private ByteArray b;
    private int d;
    private MessageDigest a;

    public final void wipe() {
        this.d = 0;
        if (this.b != null) {
            this.b.wipe();
            this.b = null;
        }
        if (this.c != null) {
            this.c.wipe();
            this.c = null;
        }
    }

    public static final byte[] truncate(byte[] byArray, int n2) throws IllegalArgumentException {
        if (byArray == null) {
            return null;
        }
        int n3 = byArray.length;
        if (n2 < 0) {
            throw new IllegalArgumentException("'length' cannot be less than zero");
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("'length' cannot be larger than the size of the byte array");
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2);
        return byArray2;
    }

    public static final byte[] tail(byte[] byArray, int n2) throws IllegalArgumentException {
        if (byArray == null) {
            return null;
        }
        int n3 = byArray.length;
        if (n2 < 0) {
            throw new IllegalArgumentException("'offset' cannot be less than zero");
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("'offset' cannot be after the end of the byte array");
        }
        byte[] byArray2 = new byte[n3 - n2];
        System.arraycopy(byArray, n2, byArray2, 0, n3 - n2);
        return byArray2;
    }

    public void setInput(byte[] byArray) throws IllegalArgumentException {
        if (byArray == null) {
            throw new IllegalArgumentException("'input' cannot be null");
        }
        this.b = new ByteArray(byArray);
        this.c = new ByteArray();
        this.d = 0;
    }

    public byte[] getOutput(int n2, int n3) throws NullPointerException, IllegalArgumentException {
        SecurityEngine.assertCryptoOperationsAllowed();
        if (n2 < 0) {
            throw new IllegalArgumentException("'numBytes' cannot be less than zero");
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("'iterations' cannot less than one, at lease one iteration must be done");
        }
        if (this.b == null) {
            throw new NullPointerException("The input byte array must be set before this method can be called");
        }
        if (n2 == 0) {
            return new byte[0];
        }
        ByteArray byteArray = new ByteArray();
        while (this.c.getLength() < n2) {
            int n4;
            byteArray.append(this.b);
            ++this.d;
            while (n4 > 0) {
                byteArray.append((byte)n4);
                n4 >>= 8;
            }
            int n5 = 0;
            while (n5 < n3) {
                byte[] byArray = this.a.digest(byteArray.getArray());
                byteArray.wipe();
                byteArray = new ByteArray(byArray);
                SecureUtils.wipe(byArray);
                ++n5;
            }
            this.c.append(byteArray);
            byteArray.wipe();
        }
        ByteArray byteArray2 = new ByteArray(this.c);
        byteArray2.truncate(n2);
        this.c.tail(n2);
        return byteArray2.getArray();
    }

    public static final byte[] concatenate(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        if (byArray != null) {
            n2 = byArray.length;
        }
        if (byArray2 != null) {
            n3 = byArray2.length;
        }
        byte[] byArray3 = new byte[n2 + n3];
        if (n2 > 0) {
            System.arraycopy(byArray, 0, byArray3, 0, n2);
        }
        if (n3 > 0) {
            System.arraycopy(byArray2, 0, byArray3, n2, n3);
        }
        return byArray3;
    }

    public ExtendedHasher(MessageDigest messageDigest) throws IllegalArgumentException {
        if (messageDigest == null) {
            throw new IllegalArgumentException("'messageDigest' cannot be null");
        }
        this.a = messageDigest;
    }

    public ExtendedHasher(String string) throws NoSuchAlgorithmException {
        try {
            this.a = MessageDigest.getInstance(string, "Entrust");
        }
        catch (Exception exception) {
            try {
                this.a = MessageDigest.getInstance(string, "IAIK");
            }
            catch (Exception exception2) {
                this.a = MessageDigest.getInstance(string);
            }
        }
    }

    public ExtendedHasher() {
        this(new SHA());
    }
}

