/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.util;

import com.entrust.toolkit.security.fips.SecurityEngine;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public class MacGenerator {
    public static final String ALG_STRING_IDEA = "pbeWithSHA1AndIDEA-CBC";
    public static final String ALG_STRING_3DES = "pbeWithSHA1AndDES-EDE3-CBC";
    public static final String ALG_STRING_DES = "pbeWithSHA1AndDES-CBC";
    public static final String ALG_STRING_CAST = "pbeWithSHA1AndCAST5-CBC";

    private static synchronized byte[] a(byte[] byArray) {
        int n2 = 8 - byArray.length % 8;
        if (n2 == 8) {
            return byArray;
        }
        byte[] byArray2 = new byte[byArray.length + n2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        int n3 = 0;
        while (n3 < n2) {
            byArray2[byArray.length + n3] = 0;
            ++n3;
        }
        return byArray2;
    }

    public static synchronized byte[] generate(String string, Key key, byte[] byArray, AlgorithmParameterSpec algorithmParameterSpec) throws ShortBufferException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchPaddingException {
        SecurityEngine.assertCryptoOperationsAllowed();
        Cipher cipher = null;
        if (string.equals(ALG_STRING_CAST)) {
            cipher = Cipher.getInstance("CAST5/CBC/NoPadding");
        } else if (string.equals(ALG_STRING_DES)) {
            cipher = Cipher.getInstance("DES/CBC/NoPadding");
        } else if (string.equals(ALG_STRING_3DES)) {
            cipher = Cipher.getInstance("3DES/CBC/NoPadding");
        } else if (string.equals(ALG_STRING_IDEA)) {
            cipher = Cipher.getInstance("IDEA/CBC/NoPadding");
        } else {
            throw new NoSuchAlgorithmException("Unknown algortithm: " + string);
        }
        byte[] byArray2 = MacGenerator.a(byArray);
        cipher.init(1, key, algorithmParameterSpec);
        int n2 = 0;
        byte[] byArray3 = new byte[8];
        while (n2 < byArray2.length) {
            cipher.update(byArray2, n2, 8, byArray3, 0);
            n2 += 8;
        }
        return byArray3;
    }

    public static synchronized byte[] generate(String string, Key key, byte[] byArray) throws ShortBufferException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchPaddingException, NoSuchAlgorithmException {
        SecurityEngine.assertCryptoOperationsAllowed();
        byte[] byArray2 = new byte[8];
        int n2 = 0;
        while (n2 < 8) {
            byArray2[n2] = 0;
            ++n2;
        }
        IvParameterSpec ivParameterSpec = null;
        if (string.equals(ALG_STRING_CAST)) {
            ivParameterSpec = new IvParameterSpec(byArray2);
        } else if (string.equals(ALG_STRING_DES)) {
            ivParameterSpec = new IvParameterSpec(byArray2);
        } else if (string.equals(ALG_STRING_3DES)) {
            ivParameterSpec = new IvParameterSpec(byArray2);
        } else if (string.equals(ALG_STRING_IDEA)) {
            ivParameterSpec = new IvParameterSpec(byArray2);
        } else {
            throw new NoSuchAlgorithmException("Unknown algortithm: " + string);
        }
        return MacGenerator.generate(string, key, byArray, ivParameterSpec);
    }
}

