/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.util;

import com.entrust.toolkit.util.SecureByteArray;
import com.entrust.toolkit.util.SecureUtils;
import java.io.IOException;
import java.io.OutputStream;

public class SecureByteArrayOutputStream
extends OutputStream {
    private boolean a = false;
    protected int count;
    protected byte[] buf;

    public synchronized void write(byte[] byArray, int n2, int n3) throws IOException {
        this.a();
        if (byArray == null) {
            return;
        }
        if (n2 < 0 || n2 > byArray.length || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        int n4 = this.count + n3;
        if (n4 > this.buf.length) {
            byte[] byArray2 = new byte[Math.max(this.buf.length << 1, n4)];
            System.arraycopy(this.buf, 0, byArray2, 0, this.count);
            SecureUtils.wipe(this.buf);
            this.buf = byArray2;
        }
        System.arraycopy(byArray, n2, this.buf, this.count, n3);
        this.count = n4;
    }

    public synchronized void write(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.write(byArray, 0, 0);
        } else {
            this.write(byArray, 0, byArray.length);
        }
    }

    public synchronized void write(int n2) throws IOException {
        this.a();
        int n3 = this.count + 1;
        if (n3 > this.buf.length) {
            byte[] byArray = new byte[Math.max(this.buf.length << 1, n3)];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            SecureUtils.wipe(this.buf);
            this.buf = byArray;
        }
        this.buf[this.count] = (byte)n2;
        this.count = n3;
    }

    public synchronized SecureByteArray toSecureByteArray(int n2) {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return new SecureByteArray(byArray, n2);
    }

    public synchronized SecureByteArray toSecureByteArray() {
        return this.toSecureByteArray(0);
    }

    public int size() {
        return this.count;
    }

    public synchronized void reset() throws IOException {
        this.a();
        this.count = 0;
        SecureUtils.wipe(this.buf);
    }

    private void a() throws IOException {
        if (this.a) {
            throw new IOException("The output stream is closed!");
        }
    }

    public synchronized void close() {
        this.a = true;
    }

    public SecureByteArrayOutputStream(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Initial buffer size connot be negative: " + n2);
        }
        this.buf = new byte[n2];
    }

    public SecureByteArrayOutputStream() {
        this(32);
    }
}

