/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.util;

import com.entrust.toolkit.util.SecureByteArray;
import com.entrust.toolkit.util.SecureUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class SecureStringBuffer
implements Serializable,
Cloneable {
    private SecureByteArray a = null;
    public static final int HIGH = 2;
    public static final int MEDIUM = 1;
    public static final int BASE = 0;

    public void wipe() {
        this.a.wipe();
    }

    public String toString() {
        StringBuffer stringBuffer = this.getStringBuffer();
        String string = stringBuffer.toString();
        SecureUtils.wipe(stringBuffer);
        return string;
    }

    public SecureByteArray toSecureByteArray(String string) throws UnsupportedEncodingException {
        return new SecureByteArray(this.toByteArray(string), this.getSensitivity());
    }

    public SecureByteArray toSecureByteArray() {
        return new SecureByteArray(this.toByteArray(), this.getSensitivity());
    }

    public char[] toCharArray() {
        byte[] byArray = this.a.getByteArray();
        char[] cArray = new char[]{};
        if (byArray.length > 0) {
            cArray = SecureStringBuffer.a(byArray);
        }
        return cArray;
    }

    public byte[] toByteArray(String string) throws UnsupportedEncodingException {
        char[] cArray = this.toCharArray();
        byte[] byArray = new byte[]{};
        if (cArray.length > 0) {
            byArray = SecureUtils.charToByte(cArray, string);
        }
        return byArray;
    }

    public byte[] toByteArray() {
        char[] cArray = this.toCharArray();
        byte[] byArray = new byte[]{};
        if (cArray.length > 0) {
            byArray = SecureUtils.charToByte(cArray);
        }
        return byArray;
    }

    private static byte[] a(char[] cArray) {
        byte[] byArray = new byte[2 * cArray.length];
        int n2 = 0;
        while (n2 < cArray.length) {
            byArray[2 * n2] = (byte)(cArray[n2] >> 8);
            byArray[2 * n2 + 1] = (byte)cArray[n2];
            ++n2;
        }
        SecureUtils.wipe(cArray);
        return byArray;
    }

    private static char[] a(byte[] byArray) {
        char[] cArray = new char[byArray.length / 2];
        int n2 = 0;
        while (n2 < cArray.length) {
            cArray[n2] = (char)(byArray[2 * n2] << 8 | byArray[2 * n2 + 1]);
            ++n2;
        }
        SecureUtils.wipe(byArray);
        return cArray;
    }

    public StringBuffer getStringBuffer() {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = this.toCharArray();
        stringBuffer.append(cArray);
        SecureUtils.wipe(cArray);
        return stringBuffer;
    }

    public int getSensitivity() {
        return this.a.getSensitivity();
    }

    public Object clone() {
        return new SecureStringBuffer(this);
    }

    public SecureStringBuffer(char[] cArray, int n2) {
        if (cArray == null) {
            throw new IllegalArgumentException("ca cannot be null");
        }
        byte[] byArray = SecureStringBuffer.a(cArray);
        this.a = new SecureByteArray(byArray, n2);
    }

    public SecureStringBuffer(char[] cArray) {
        this(cArray, 0);
    }

    public SecureStringBuffer(StringBuffer stringBuffer, int n2) {
        if (stringBuffer == null) {
            throw new IllegalArgumentException("sb cannot be null");
        }
        int n3 = stringBuffer.length();
        char[] cArray = new char[n3];
        if (n3 > 0) {
            stringBuffer.getChars(0, n3, cArray, 0);
        }
        byte[] byArray = SecureStringBuffer.a(cArray);
        this.a = new SecureByteArray(byArray, n2);
        SecureUtils.wipe(stringBuffer);
    }

    public SecureStringBuffer(StringBuffer stringBuffer) {
        this(stringBuffer, 0);
    }

    public SecureStringBuffer(String string) {
        if (string == null) {
            throw new IllegalArgumentException("s cannot be null");
        }
        byte[] byArray = SecureStringBuffer.a(string.toCharArray());
        this.a = new SecureByteArray(byArray, 0);
    }

    public SecureStringBuffer(InputStream inputStream) throws IOException {
        Object[] objectArray;
        if (inputStream == null) {
            throw new IllegalArgumentException("is cannot be null");
        }
        byte[] byArray = new byte[]{};
        while (inputStream.available() > 0) {
            objectArray = new byte[inputStream.available()];
            inputStream.read((byte[])objectArray);
            byArray = SecureUtils.append(byArray, objectArray);
        }
        objectArray = new String(byArray).toCharArray();
        byte[] byArray2 = SecureStringBuffer.a((char[])objectArray);
        this.a = new SecureByteArray(byArray2, 0);
    }

    public SecureStringBuffer(SecureStringBuffer secureStringBuffer) {
        if (secureStringBuffer == null) {
            throw new IllegalArgumentException("ssb cannot be null");
        }
        byte[] byArray = SecureStringBuffer.a(secureStringBuffer.toCharArray());
        this.a = new SecureByteArray(byArray, secureStringBuffer.getSensitivity());
    }
}

