/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.x509.extensions;

import com.entrust.toolkit.asn1.structures.DistributionPointName;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import java.math.BigInteger;

public class IssuingDistributionPoint
extends V3Extension {
    private boolean d = false;
    private int a = -1;
    private boolean c = false;
    private boolean b = false;
    private DistributionPointName e = null;
    public static final ObjectID oid = new ObjectID("2.5.29.28", "IssuingDistributionPoint");

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.e != null) {
            stringBuffer.append(String.valueOf(this.e.toString()) + "\n");
        }
        stringBuffer.append("onlyContainsUserCerts = " + this.b + "\n");
        stringBuffer.append("onlyContainsCACerts = " + this.c + "\n");
        stringBuffer.append("onlySomeReasons = " + this.a + "\n");
        stringBuffer.append("indirectCRL = " + this.d);
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws X509ExtensionException {
        BigInteger bigInteger = BigInteger.valueOf(1L);
        BigInteger bigInteger2 = BigInteger.valueOf(0L);
        try {
            ASN1Object aSN1Object;
            SEQUENCE sEQUENCE = new SEQUENCE();
            if (this.e != null) {
                aSN1Object = this.e.toASN1Object();
                sEQUENCE.addComponent(new CON_SPEC(0, aSN1Object));
            }
            if (this.b) {
                sEQUENCE.addComponent(new CON_SPEC(1, new OCTET_STRING(bigInteger.toByteArray()), true));
            } else {
                sEQUENCE.addComponent(new CON_SPEC(1, new OCTET_STRING(bigInteger2.toByteArray()), true));
            }
            if (this.c) {
                sEQUENCE.addComponent(new CON_SPEC(2, new OCTET_STRING(bigInteger.toByteArray()), true));
            } else {
                sEQUENCE.addComponent(new CON_SPEC(2, new OCTET_STRING(bigInteger2.toByteArray()), true));
            }
            if (this.a != 0) {
                byte[] byArray = new byte[]{(byte)this.a};
                aSN1Object = new BIT_STRING(byArray);
                sEQUENCE.addComponent(new CON_SPEC(3, aSN1Object));
            }
            if (this.d) {
                sEQUENCE.addComponent(new CON_SPEC(4, new OCTET_STRING(bigInteger.toByteArray()), true));
            } else {
                sEQUENCE.addComponent(new CON_SPEC(4, new OCTET_STRING(bigInteger2.toByteArray()), true));
            }
            return sEQUENCE;
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException(codingException.getMessage());
        }
    }

    public void setReasons(int n2) {
        this.a = n2;
    }

    public void setOnlyContainsUserCerts(boolean bl) {
        this.b = bl;
    }

    public void setOnlyContainsCACerts(boolean bl) {
        this.c = bl;
    }

    public void setDistributionPoint(DistributionPointName distributionPointName) {
        this.e = distributionPointName;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        try {
            int n2 = 0;
            while (n2 < aSN1Object.countComponents()) {
                ASN1Object aSN1Object2 = aSN1Object.getComponentAt(n2);
                switch (aSN1Object2.getAsnType().getTag()) {
                    case 0: {
                        this.e = new DistributionPointName((ASN1Object)aSN1Object2.getValue());
                        break;
                    }
                    case 1: {
                        byte[] byArray = (byte[])aSN1Object2.getValue();
                        this.b = byArray[0] != 0;
                        break;
                    }
                    case 2: {
                        byte[] byArray = (byte[])aSN1Object2.getValue();
                        this.c = byArray[0] != 0;
                        break;
                    }
                    case 3: {
                        BIT_STRING bIT_STRING = (BIT_STRING)((ASN1Object)aSN1Object2.getValue());
                        this.a = ((byte[])bIT_STRING.getValue())[0];
                        break;
                    }
                    case 4: {
                        byte[] byArray = (byte[])aSN1Object2.getValue();
                        this.d = byArray[0] != 0;
                        break;
                    }
                }
                ++n2;
            }
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException(codingException.getMessage());
        }
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public int getReasons() {
        return this.a;
    }

    public boolean getOnlyContainsUserCerts() {
        return this.b;
    }

    public boolean getOnlyContainsCACerts() {
        return this.c;
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public boolean getIndirectCRL() {
        return this.d;
    }

    public DistributionPointName getDistributionPoint() {
        return this.e;
    }
}

