/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SET;
import iaik.asn1.structures.AVA;
import iaik.utils.RFC2253NameParserException;
import java.util.Enumeration;
import java.util.Hashtable;

public class RDN
implements ASN1Type {
    protected Hashtable avas = new Hashtable();

    /*
     * Enabled aggressive block sorting
     */
    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.avas.elements();
        if (!enumeration.hasMoreElements()) {
            return stringBuffer.toString();
        }
        stringBuffer.append(((AVA)enumeration.nextElement()).toString(bl));
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("+" + ((AVA)enumeration.nextElement()).toString(bl));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public ASN1Object toASN1Object() {
        SET sET = new SET();
        Enumeration enumeration = this.avas.elements();
        while (enumeration.hasMoreElements()) {
            sET.addComponent(((AVA)enumeration.nextElement()).toASN1Object());
        }
        return sET;
    }

    public int hashCode() {
        return this.toString().toLowerCase().hashCode();
    }

    /*
     * Enabled aggressive block sorting
     */
    public String getRFC2253String() throws RFC2253NameParserException {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.avas.elements();
        if (!enumeration.hasMoreElements()) {
            return stringBuffer.toString();
        }
        stringBuffer.append(((AVA)enumeration.nextElement()).getRFC2253String());
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("+" + ((AVA)enumeration.nextElement()).getRFC2253String());
        }
        return stringBuffer.toString();
    }

    public AVA getAVA(ObjectID objectID) {
        return (AVA)this.avas.get(objectID);
    }

    public AVA getAVA() {
        return (AVA)this.avas.elements().nextElement();
    }

    public boolean equals(Object object) {
        if (!(object instanceof RDN)) {
            return false;
        }
        RDN rDN = (RDN)object;
        if (this.avas.size() != rDN.avas.size()) {
            return false;
        }
        Enumeration enumeration = this.avas.keys();
        while (enumeration.hasMoreElements()) {
            ObjectID objectID = (ObjectID)enumeration.nextElement();
            if (!rDN.avas.containsKey(objectID)) {
                return false;
            }
            if (this.avas.get(objectID).equals(rDN.avas.get(objectID))) continue;
            return false;
        }
        return true;
    }

    public Enumeration elements() {
        return this.avas.elements();
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        AVA aVA = null;
        int n2 = 0;
        while (n2 < aSN1Object.countComponents()) {
            aVA = new AVA(aSN1Object.getComponentAt(n2));
            this.avas.put(aVA.getType(), aVA);
            ++n2;
        }
    }

    public void addAVA(AVA aVA) {
        this.avas.put(aVA.getType(), aVA);
    }

    public void addAVA(ObjectID objectID, Object object) {
        this.avas.put(objectID, new AVA(objectID, object));
    }

    public RDN(String string) {
        this();
        int n2 = -1;
        String string2 = string;
        AVA aVA = null;
        do {
            if ((n2 = string2.lastIndexOf(43)) == -1) {
                aVA = new AVA(string2.trim());
            } else {
                aVA = new AVA(string2.substring(n2 + 1).trim());
                string2 = string2.substring(0, n2);
            }
            this.avas.put(aVA.getType(), aVA);
        } while (n2 >= 0);
    }

    public RDN(ObjectID objectID, Object object) {
        this();
        this.avas.put(objectID, new AVA(objectID, object));
    }

    public RDN(ASN1Object aSN1Object) throws CodingException {
        this();
        this.decode(aSN1Object);
    }

    public RDN() {
    }
}

