/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import com.entrust.toolkit.security.fips.SecurityEngine;
import iaik.security.cipher.j;
import iaik.security.cipher.r;
import iaik.security.md.SHA;
import iaik.security.random.SecRandom;
import iaik.utils.CriticalObject;
import iaik.utils.CryptoUtils;
import iaik.utils.InternalErrorException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

abstract class q
extends r {
    public static final byte[] CMS_KEY_WRAP_IV = new byte[]{74, -35, -94, 44, 121, -24, 33, 5};
    protected byte[] keyWrapIV;
    protected SecureRandom random;
    protected int cipherTextLength;
    protected Key kek;
    private String a;

    public String toString() {
        SecurityEngine.assertCryptoOperationsAllowed();
        return "CMS " + this.a;
    }

    protected abstract byte[] prepareWrap(Key var1) throws InvalidKeyException;

    protected SecureRandom getRandom() {
        SecurityEngine.assertCryptoOperationsAllowed();
        if (this.random == null) {
            this.random = SecRandom.getDefault();
        }
        return this.random;
    }

    protected abstract Key finishUnWrap(byte[] var1, String var2, int var3) throws InvalidKeyException;

    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        SecurityEngine.assertCryptoOperationsAllowed();
        if (this.d != 1) {
            throw new InvalidKeyException("Invalid mode used for initializing the cipher. Must be ENCRYPT_MODE or WRAP_MODE!");
        }
        byte[] byArray = key.getEncoded();
        if (byArray == null || byArray.length == 0) {
            throw new InvalidKeyException("Could not encode key for wrapping!");
        }
        try {
            byte[] byArray2 = this.prepareWrap(key);
            byte[] byArray3 = new byte[byArray2.length + ((r)this).a.d];
            CryptoUtils.copyBlock(byArray2, 0, byArray3, 0, byArray2.length);
            q.a(byArray2, byArray3, byArray2.length, ((r)this).a.d);
            byte[] byArray4 = new byte[((r)this).a.d + this.a(byArray3.length, true)];
            super.engineDoFinal(byArray3, 0, byArray3.length, byArray4, ((r)this).a.d);
            CryptoUtils.copyBlock(super.engineGetIV(), 0, byArray4, 0, ((r)this).a.d);
            CryptoUtils.reverseArray(byArray4, 0, byArray4.length);
            this.engineInit(1, this.kek, this.keyWrapIV, this.getRandom());
            byte[] byArray5 = super.engineDoFinal(byArray4, 0, byArray4.length);
            CriticalObject.destroy(byArray2);
            CriticalObject.destroy(byArray3);
            CriticalObject.destroy(byArray4);
            if (this.cipherTextLength > 0 && byArray5.length != this.cipherTextLength) {
                throw new InvalidKeyException("Error wrapping key: invalid cipher text length!");
            }
            return byArray5;
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException("Could not wrap key: " + badPaddingException.toString());
        }
        catch (ShortBufferException shortBufferException) {
            throw new InvalidKeyException("Could not wrap key: " + shortBufferException.toString());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException("Could not wrap key: " + invalidAlgorithmParameterException.toString());
        }
    }

    public int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        SecurityEngine.assertCryptoOperationsAllowed();
        throw new RuntimeException("update not supported by this key wrap cipher!");
    }

    public byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        SecurityEngine.assertCryptoOperationsAllowed();
        throw new RuntimeException("update not supported by this key wrap cipher!");
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n2) throws NoSuchAlgorithmException, InvalidKeyException {
        SecurityEngine.assertCryptoOperationsAllowed();
        if (this.d != 2) {
            throw new NoSuchAlgorithmException("Invalid mode used for initializing the cipher. Must be DECRYPT_MODE or UNWRAP_MODE!");
        }
        if (n2 != 3) {
            throw new InvalidKeyException("Wrong key type. Only secret keys may be wrapped by this cipher!");
        }
        if (this.cipherTextLength > 0 && byArray.length != this.cipherTextLength) {
            throw new InvalidKeyException("Wrapped key has invalid length; expected " + this.cipherTextLength);
        }
        if (byArray.length % ((r)this).a.d != 0) {
            throw new InvalidKeyException("Wrapped key has invalid length; expected multiple of " + ((r)this).a.d);
        }
        try {
            byte[] byArray2 = super.engineDoFinal(byArray, 0, byArray.length);
            CryptoUtils.reverseArray(byArray2, 0, byArray2.length);
            byte[] byArray3 = new byte[((r)this).a.d];
            CryptoUtils.copyBlock(byArray2, 0, byArray3, 0, ((r)this).a.d);
            byte[] byArray4 = new byte[byArray2.length - byArray3.length];
            CryptoUtils.copyBlock(byArray2, byArray3.length, byArray4, 0, byArray4.length);
            this.engineInit(2, this.kek, byArray3, this.getRandom());
            byte[] byArray5 = super.engineDoFinal(byArray4, 0, byArray4.length);
            byte[] byArray6 = new byte[byArray5.length - ((r)this).a.d];
            CryptoUtils.copyBlock(byArray5, 0, byArray6, 0, byArray6.length);
            q.a(byArray6, byArray4, 0, ((r)this).a.d);
            if (!CryptoUtils.equalsBlock(byArray4, 0, byArray5, byArray6.length, ((r)this).a.d)) {
                throw new InvalidKeyException("Could not unwrap key: checksum error!");
            }
            CriticalObject.destroy(byArray2);
            CriticalObject.destroy(byArray4);
            CriticalObject.destroy(byArray5);
            return this.finishUnWrap(byArray6, string, n2);
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException("Could not unwrap key: " + badPaddingException.toString());
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException("Could not unwrap key: " + illegalBlockSizeException.toString());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException("Could not unwrap key: " + invalidAlgorithmParameterException.toString());
        }
    }

    public void engineSetPadding(String string) throws NoSuchPaddingException {
        super.engineSetPadding("NoPadding");
    }

    public void engineSetMode(String string) throws NoSuchAlgorithmException {
        super.engineSetMode("CBC");
    }

    protected abstract void engineInit(int var1, Key var2, byte[] var3, SecureRandom var4) throws InvalidAlgorithmParameterException, InvalidKeyException;

    public void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.kek = key;
        this.random = secureRandom;
        this.d = r.a(n2);
        try {
            IvParameterSpec ivParameterSpec = null;
            if (this.d == 2) {
                ivParameterSpec = new IvParameterSpec(this.keyWrapIV);
            }
            ((r)this).a.a(this.d, key, ivParameterSpec, this.getRandom());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.toString());
        }
    }

    public AlgorithmParameters engineGetParameters() {
        SecurityEngine.assertCryptoOperationsAllowed();
        return null;
    }

    public byte[] engineGetIV() {
        SecurityEngine.assertCryptoOperationsAllowed();
        return null;
    }

    public int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws BadPaddingException, IllegalBlockSizeException, ShortBufferException {
        SecurityEngine.assertCryptoOperationsAllowed();
        throw new RuntimeException("doFinal not supported by this key wrap cipher!");
    }

    public byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws BadPaddingException, IllegalBlockSizeException {
        SecurityEngine.assertCryptoOperationsAllowed();
        throw new RuntimeException("doFinal not supported by this key wrap cipher!");
    }

    protected byte[] decomposeLCEKPAD(byte[] byArray) throws BadPaddingException {
        SecurityEngine.assertCryptoOperationsAllowed();
        int n2 = byArray[0] & 0xFF;
        if (byArray.length - n2 - 1 > 7) {
            throw new BadPaddingException("LCEKPAD padding length has to be shorter than 8!");
        }
        byte[] byArray2 = new byte[n2];
        CryptoUtils.copyBlock(byArray, 1, byArray2, 0, n2);
        return byArray2;
    }

    protected byte[] computeLCEKPAD(Key key) {
        SecurityEngine.assertCryptoOperationsAllowed();
        byte[] byArray = key.getEncoded();
        int n2 = byArray.length;
        int n3 = n2 + 1;
        int n4 = n3 % 8;
        int n5 = n3 + (n4 == 0 ? 0 : 8 - n4);
        byte[] byArray2 = new byte[n5];
        byArray2[0] = (byte)n2;
        CryptoUtils.copyBlock(byArray, 0, byArray2, 1, n2);
        SecureRandom secureRandom = SecRandom.getDefault();
        int n6 = n3;
        while (n6 < n5) {
            byArray2[n6] = (byte)secureRandom.nextInt();
            ++n6;
        }
        return byArray2;
    }

    private static final void a(byte[] byArray, byte[] byArray2, int n2, int n3) {
        if (n3 < 0) {
            n3 = 8;
        }
        if (n3 > 20) {
            throw new IndexOutOfBoundsException("Only 20 bytes available from SHA-1!");
        }
        SHA sHA = new SHA();
        CryptoUtils.copyBlock(sHA.digest(byArray), 0, byArray2, n2, n3);
    }

    q(j j2, String string, int n2, byte[] byArray) {
        super(j2);
        try {
            this.engineSetMode("CBC");
            this.engineSetPadding("NoPadding");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalErrorException("Cipher mode CBC not supported", noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new InternalErrorException("Padding scheme 'PKCS5Padding' not supported", noSuchPaddingException);
        }
        this.a = string;
        this.cipherTextLength = n2;
        this.keyWrapIV = byArray;
        if (byArray == null) {
            byArray = CMS_KEY_WRAP_IV;
        }
    }
}

