/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import iaik.utils.Util;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Random;

public final class NumberTheory {
    private static BigInteger[] b;
    private static int[] a;
    public static final BigInteger TWO;
    public static final BigInteger ONE;
    public static final BigInteger ZERO;

    public static BigInteger nextPrime(BigInteger bigInteger) {
        bigInteger = bigInteger.setBit(0);
        while (!NumberTheory.isProbablePrime(bigInteger)) {
            bigInteger = bigInteger.add(TWO);
        }
        return bigInteger;
    }

    public static boolean millerRabin(BigInteger bigInteger) {
        int n2 = bigInteger.bitLength();
        int n3 = n2 <= 500 ? (n2 <= 100 ? 27 : (n2 <= 150 ? 18 : (n2 <= 200 ? 15 : (n2 <= 250 ? 12 : (n2 <= 300 ? 9 : (n2 <= 350 ? 8 : (n2 <= 400 ? 7 : 6))))))) : (n2 <= 600 ? 5 : (n2 <= 800 ? 4 : (n2 <= 1250 ? 3 : 2)));
        BigInteger bigInteger2 = BigInteger.valueOf(1L);
        BigInteger bigInteger3 = BigInteger.valueOf(2L);
        BigInteger bigInteger4 = bigInteger.subtract(bigInteger2);
        int n4 = bigInteger4.getLowestSetBit();
        BigInteger bigInteger5 = bigInteger4.shiftRight(n4);
        BigInteger bigInteger6 = bigInteger.subtract(BigInteger.valueOf(4L));
        Random random = new Random();
        int n5 = 1;
        while (n5 <= n3) {
            BigInteger bigInteger7 = new BigInteger(n2 + 4, random);
            BigInteger bigInteger8 = (bigInteger7 = bigInteger7.mod(bigInteger6).add(bigInteger3)).modPow(bigInteger5, bigInteger);
            if (bigInteger8.compareTo(bigInteger2) != 0 && bigInteger8.compareTo(bigInteger4) != 0) {
                int n6 = 1;
                while (n6 <= n4 - 1 && (n6 == 1 || bigInteger8.compareTo(bigInteger4) != 0)) {
                    if ((bigInteger8 = bigInteger8.modPow(bigInteger3, bigInteger)).compareTo(bigInteger2) == 0) {
                        return false;
                    }
                    ++n6;
                }
                if (bigInteger8.compareTo(bigInteger4) != 0) {
                    return false;
                }
            }
            ++n5;
        }
        return true;
    }

    public static boolean isProbablePrime(BigInteger bigInteger) {
        if (bigInteger.compareTo(ONE) <= 0) {
            return false;
        }
        if (NumberTheory.hasSmallFactors(bigInteger)) {
            return false;
        }
        return NumberTheory.millerRabin(bigInteger);
    }

    private static void a() {
        if (b[0] != null) {
            return;
        }
        int n2 = b.length;
        int n3 = 0;
        while (n3 < n2) {
            NumberTheory.b[n3] = BigInteger.valueOf(a[n3]);
            ++n3;
        }
    }

    public static boolean hasSmallFactors(BigInteger bigInteger) {
        if (!bigInteger.testBit(0)) {
            return true;
        }
        NumberTheory.a();
        if (bigInteger.compareTo(b[b.length - 1]) <= 0) {
            int n2 = bigInteger.intValue();
            if (n2 <= 1) {
                return true;
            }
            if (n2 == 2) {
                return false;
            }
            int n3 = 0;
            while (n3 < a.length) {
                int n4 = a[n3];
                if (n2 <= n4) {
                    return false;
                }
                if (n2 % n4 == 0) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
        int n5 = 0;
        while (n5 < b.length) {
            if (bigInteger.mod(b[n5]).signum() == 0) {
                return true;
            }
            ++n5;
        }
        return false;
    }

    public static BigInteger getStrongPrime(int n2, Random random) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = ZERO.setBit(511 + 128 * n2);
        BigDecimal bigDecimal = new BigDecimal(Math.sqrt(2.0));
        BigInteger bigInteger3 = new BigDecimal(bigInteger2).multiply(bigDecimal).toBigInteger();
        while ((bigInteger = new BigInteger(512 + 128 * n2, random)).compareTo(bigInteger3) == -1) {
        }
        BigInteger bigInteger4 = NumberTheory.nextPrime(new BigInteger(101, random));
        BigInteger bigInteger5 = NumberTheory.nextPrime(new BigInteger(101, random));
        BigInteger bigInteger6 = bigInteger5.modInverse(bigInteger4).multiply(bigInteger5).subtract(bigInteger4.modInverse(bigInteger5).multiply(bigInteger4));
        BigInteger bigInteger7 = bigInteger4.multiply(bigInteger5);
        BigInteger bigInteger8 = bigInteger.add(bigInteger6.subtract(bigInteger).mod(bigInteger7));
        while (!NumberTheory.isProbablePrime(bigInteger8)) {
            bigInteger8 = bigInteger8.add(bigInteger7);
        }
        return bigInteger8;
    }

    public static int gcd(int n2, int n3) {
        while (n3 != 0) {
            int n4 = n2 % n3;
            n2 = n3;
            n3 = n4;
        }
        return n2;
    }

    public static int[] extGcd(int n2, int n3) {
        if (n3 == 0) {
            int[] nArray = new int[3];
            nArray[0] = n2;
            nArray[1] = 1;
            return nArray;
        }
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 1;
        while (n3 > 0) {
            int n8 = n2 / n3;
            int n9 = n2 - n8 * n3;
            int n10 = n4 - n8 * n5;
            int n11 = n6 - n8 * n7;
            n2 = n3;
            n3 = n9;
            n4 = n5;
            n5 = n10;
            n6 = n7;
            n7 = n11;
        }
        return new int[]{n2, n4, n6};
    }

    private NumberTheory() {
    }

    static {
        ZERO = BigInteger.valueOf(0L);
        ONE = BigInteger.valueOf(1L);
        TWO = BigInteger.valueOf(2L);
        String string = "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";
        a = Util.decodeIntArray(string);
        b = new BigInteger[a.length];
    }
}

