/*
 * Decompiled with CFR 0.152.
 */
package iaik.utils;

import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AVA;
import iaik.asn1.structures.Name;
import iaik.asn1.structures.RDN;
import iaik.utils.InternalErrorException;
import iaik.utils.RFC2253NameParser$AVA;
import iaik.utils.RFC2253NameParser$ParsedName;
import iaik.utils.RFC2253NameParser$ParsedRDN;
import iaik.utils.RFC2253NameParserException;

public class RFC2253NameParser {
    protected StringBuffer nameStrBuf_;
    protected int position_ = 0;
    protected RFC2253NameParser$ParsedName name_ = new RFC2253NameParser$ParsedName(this);
    private static final char o = '#';
    private static final char p = '\\';
    private static final char g = '.';
    private static final char h = '-';
    private static final char k = '=';
    private static final char d = ';';
    private static final char n = ',';
    private static final char f = '+';
    private static final char c = ' ';
    private static final char e = '\"';
    private static final String i = "0123456789ABCDEFabcdef";
    private static final String l = "0123456789";
    private static final String q = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final String j = "# ,+\"\\<>;";
    private static final String b = "<>\"";
    private static final String a = ",;+";
    private static final boolean m = false;

    protected void skipSpace() {
        while (this.position_ < this.nameStrBuf_.length() && this.nameStrBuf_.charAt(this.position_) == ' ') {
            ++this.position_;
        }
    }

    protected void skipOIDIntro() {
        if (this.nameStrBuf_.length() - this.position_ < 4) {
            return;
        }
        String string = this.nameStrBuf_.toString().substring(this.position_, this.position_ + 4);
        if (string.equalsIgnoreCase("oid.")) {
            this.position_ += 4;
        }
    }

    protected RFC2253NameParser$ParsedRDN parseRDN() throws RFC2253NameParserException {
        RFC2253NameParser$ParsedRDN rFC2253NameParser$ParsedRDN = new RFC2253NameParser$ParsedRDN(this);
        boolean bl = false;
        do {
            rFC2253NameParser$ParsedRDN.aVAs_.addElement(this.parseAVA());
            this.skipSpace();
            if (this.position_ < this.nameStrBuf_.length() && this.nameStrBuf_.charAt(this.position_) == '+') {
                ++this.position_;
                this.skipSpace();
                if (this.position_ == this.nameStrBuf_.length()) {
                    Object[] objectArray = new Object[]{new Integer(this.position_)};
                    throw new RFC2253NameParserException("Cannot find another AVA after having parsed a plus (position {0,number,integer}).", objectArray);
                }
                bl = true;
                continue;
            }
            bl = false;
        } while (bl);
        return rFC2253NameParser$ParsedRDN;
    }

    protected char parseHexPairEscapeSequence() throws RFC2253NameParserException {
        char c2 = this.parseHexPair();
        if ((c2 & 0x80) == 0) {
            return c2;
        }
        if ((c2 & 0xE0) == 192) {
            ++this.position_;
            char c3 = this.parseHexPair();
            int n2 = (c2 & 0x1F) << 6;
            return (char)(n2 += c3 & 0x3F);
        }
        ++this.position_;
        char c4 = this.parseHexPair();
        ++this.position_;
        char c5 = this.parseHexPair();
        int n3 = (c2 & 0xF) << 12;
        n3 += (c4 & 0x3F) << 6;
        return (char)(n3 += c5 & 0x3F);
    }

    protected char parseHexPair() throws RFC2253NameParserException {
        if (this.nameStrBuf_.length() - this.position_ < 2) {
            Object[] objectArray = new Object[]{new Integer(this.position_)};
            throw new RFC2253NameParserException("Cannot parse hex pair (position {0,number,integer}).", objectArray);
        }
        if (i.indexOf(this.nameStrBuf_.charAt(this.position_)) == -1 || i.indexOf(this.nameStrBuf_.charAt(this.position_ + 1)) == -1) {
            Object[] objectArray = new Object[]{new Integer(this.position_)};
            throw new RFC2253NameParserException("Invalid hex pair character found when parsing a hex pair (position {0,number,integer}).", objectArray);
        }
        char c2 = (char)Integer.parseInt(this.nameStrBuf_.toString().substring(this.position_, this.position_ + 2), 16);
        this.position_ += 2;
        return c2;
    }

    /*
     * Unable to fully structure code
     */
    protected RFC2253NameParser$AVA parseAttrValue() throws RFC2253NameParserException {
        block19: {
            block18: {
                var1_1 = new StringBuffer();
                var2_2 = new RFC2253NameParser$AVA(this);
                if (this.position_ == this.nameStrBuf_.length()) {
                    var2_2.value_ = var1_1.toString();
                    return var2_2;
                }
                var3_3 = this.nameStrBuf_.charAt(this.position_) == '\"';
                v0 = var4_4 = this.nameStrBuf_.charAt(this.position_) == '#';
                if (!var3_3) break block18;
                ++this.position_;
                if (this.position_ != this.nameStrBuf_.length()) ** GOTO lbl32
                var5_5 = new Object[]{new Integer(this.position_)};
                throw new RFC2253NameParserException("Cannot find closing quote for attribute value ((position {0,number,integer}).", var5_5);
lbl-1000:
                // 1 sources

                {
                    if (this.nameStrBuf_.charAt(this.position_) == '\\') {
                        ++this.position_;
                        if (this.position_ == this.nameStrBuf_.length()) {
                            var5_6 = new Object[]{new Integer(this.position_)};
                            throw new RFC2253NameParserException("Cannot find escape character after having parsed a backslash (position {0,number,integer}).", var5_6);
                        }
                        if (this.nameStrBuf_.charAt(this.position_) == '\\' || this.nameStrBuf_.charAt(this.position_) == '\"') {
                            var1_1.append(this.nameStrBuf_.charAt(this.position_));
                            ++this.position_;
                        } else {
                            var1_1.append(this.parseHexPairEscapeSequence());
                        }
                    } else {
                        var1_1.append(this.nameStrBuf_.charAt(this.position_));
                        ++this.position_;
                    }
                    if (this.position_ != this.nameStrBuf_.length()) continue;
                    var5_7 = new Object[]{new Integer(this.position_)};
                    throw new RFC2253NameParserException("Cannot find closing quote for attribute value ((position {0,number,integer}).", var5_7);
lbl32:
                    // 2 sources

                    ** while (this.nameStrBuf_.charAt((int)this.position_) != '\"')
                }
lbl33:
                // 1 sources

                ++this.position_;
                break block19;
            }
            if (!var4_4) ** GOTO lbl78
            var2_2.hasHexValue_ = true;
            ++this.position_;
            var1_1.append(this.parseHexPair());
            while (this.position_ != this.nameStrBuf_.length() && "0123456789ABCDEFabcdef".indexOf(this.nameStrBuf_.charAt(this.position_)) != -1) {
                var1_1.append(this.parseHexPair());
            }
            break block19;
lbl-1000:
            // 1 sources

            {
                if ("<>\"".indexOf(this.nameStrBuf_.charAt(this.position_)) != -1) {
                    var5_9 = new Object[]{new Integer(this.position_)};
                    throw new RFC2253NameParserException("Invalid character (<>\") found in attribute value (position {0,number,integer}).", var5_9);
                }
                if (this.nameStrBuf_.charAt(this.position_) == ' ') {
                    if (this.position_ + 1 == this.nameStrBuf_.length() || ",;+".indexOf(this.nameStrBuf_.charAt(this.position_ + 1)) != -1) {
                        var5_8 = this.position_;
                        while (this.nameStrBuf_.charAt(var5_8 - 1) == ' ') {
                            --var5_8;
                        }
                        var1_1.setLength(var1_1.length() - this.position_ + var5_8);
                        ++this.position_;
                        continue;
                    }
                    var1_1.append(this.nameStrBuf_.charAt(this.position_));
                    ++this.position_;
                    continue;
                }
                if (this.nameStrBuf_.charAt(this.position_) == '\\') {
                    ++this.position_;
                    if (this.position_ == this.nameStrBuf_.length()) {
                        var5_10 = new Object[]{new Integer(this.position_)};
                        throw new RFC2253NameParserException("Cannot find escape character after having parsed a backslash (position {0,number,integer}).", var5_10);
                    }
                    if ("# ,+\"\\<>;".indexOf(this.nameStrBuf_.charAt(this.position_)) != -1) {
                        var1_1.append(this.nameStrBuf_.charAt(this.position_));
                        ++this.position_;
                        continue;
                    }
                    var1_1.append(this.parseHexPairEscapeSequence());
                    continue;
                }
                var1_1.append(this.nameStrBuf_.charAt(this.position_));
                ++this.position_;
lbl78:
                // 6 sources

                ** while (this.position_ != this.nameStrBuf_.length() && ",;+".indexOf((int)this.nameStrBuf_.charAt((int)this.position_)) == -1)
            }
        }
        try {
            var2_2.value_ = var1_1.toString();
            return var2_2;
        }
        catch (Exception var5_11) {
            throw new InternalErrorException(var5_11);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected String parseAttrType() throws RFC2253NameParserException {
        this.skipOIDIntro();
        if ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".indexOf(this.nameStrBuf_.charAt(this.position_)) != -1) {
            var1_1 = this.position_;
            while (this.nameStrBuf_.charAt(var1_1) == '-' || "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".indexOf(this.nameStrBuf_.charAt(var1_1)) != -1 || "0123456789".indexOf(this.nameStrBuf_.charAt(var1_1)) != -1) {
                ++var1_1;
            }
            var2_3 = this.nameStrBuf_.toString().substring(this.position_, var1_1);
            this.position_ = var1_1;
            return var2_3;
        }
        var1_2 = this.position_;
        var2_4 = this.position_;
        var3_5 = this.position_;
        var4_6 = false;
        if (this.position_ != this.nameStrBuf_.length()) ** GOTO lbl18
        var5_7 = new Object[]{new Integer(this.position_)};
        throw new RFC2253NameParserException("Cannot find attribute type (position {0,number,integer}).", var5_7);
        {
            ++var3_5;
lbl18:
            // 2 sources

            do {
                if ("0123456789".indexOf(this.nameStrBuf_.charAt(var3_5)) != -1) continue block1;
                if (var3_5 - var2_4 < 1) {
                    var5_8 = new Object[]{new Integer(this.position_)};
                    throw new RFC2253NameParserException("Object Identifier representing attribute type is corrupt (position {0,number,integer}).", var5_8);
                }
                var1_2 = var3_5;
                if (this.nameStrBuf_.charAt(var3_5) == '.') {
                    var4_6 = true;
                    var2_4 = ++var3_5;
                    continue;
                }
                var4_6 = false;
            } while (var4_6);
        }
        var5_9 = this.nameStrBuf_.toString().substring(this.position_, var1_2);
        this.position_ = var1_2;
        return var5_9;
    }

    protected RFC2253NameParser$AVA parseAVA() throws RFC2253NameParserException {
        String string = this.parseAttrType();
        this.skipSpace();
        if (this.position_ < this.nameStrBuf_.length() && this.nameStrBuf_.charAt(this.position_) == '=') {
            ++this.position_;
        } else {
            Object[] objectArray = new Object[]{new Integer(this.position_)};
            throw new RFC2253NameParserException("Cannot find attribute value after having parsed an equal (position {0,number,integer}).", objectArray);
        }
        this.skipSpace();
        if (this.position_ == this.nameStrBuf_.length()) {
            Object[] objectArray = new Object[]{new Integer(this.position_)};
            throw new RFC2253NameParserException("Cannot find attribute value after having parsed an equal (position {0,number,integer}).", objectArray);
        }
        RFC2253NameParser$AVA rFC2253NameParser$AVA = this.parseAttrValue();
        rFC2253NameParser$AVA.type_ = string;
        this.skipSpace();
        return rFC2253NameParser$AVA;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Name parse() throws RFC2253NameParserException {
        var1_1 = false;
        do {
            this.name_.rDNs_.addElement(this.parseRDN());
            this.skipSpace();
            if (this.position_ == this.nameStrBuf_.length()) {
                var1_1 = false;
            } else if (this.nameStrBuf_.charAt(this.position_) == ',' || this.nameStrBuf_.charAt(this.position_) == ';') {
                ++this.position_;
                var1_1 = true;
            } else {
                var2_2 = new Object[]{new Integer(this.position_)};
                throw new RFC2253NameParserException("RDNs are not separated by comma or semicolon (position {0,number,integer}).", var2_2);
            }
            this.skipSpace();
        } while (var1_1);
        var2_3 = new Name();
        var3_4 = this.name_.rDNs_.size() - 1;
        while (var3_4 >= 0) {
            var4_5 = new RDN();
            var5_6 = (RFC2253NameParser$ParsedRDN)this.name_.rDNs_.elementAt(var3_4);
            var6_7 = 0;
            while (var6_7 < var5_6.aVAs_.size()) {
                block12: {
                    var7_8 = (RFC2253NameParser$AVA)var5_6.aVAs_.elementAt(var6_7);
                    var8_9 = ObjectID.getObjectID(var7_8.type_);
                    if (var7_8.hasHexValue_) {
                        block13: {
                            var10_11 /* !! */  = null;
                            try {
                                var10_11 /* !! */  = var7_8.value_.getBytes("ISO8859_1");
                                var9_10 = DerCoder.decode(var10_11 /* !! */ );
                                break block12;
                            }
                            catch (Exception v0) {
                                var11_12 = new StringBuffer();
                                if (var10_11 /* !! */  == null) break block13;
                                var12_13 = 0;
                                ** while (var12_13 < var10_11 /* !! */ .length)
                            }
lbl-1000:
                            // 1 sources

                            {
                                if (var10_11 /* !! */ [var12_13] < 16) {
                                    var11_12.append("0");
                                }
                                var11_12.append(Integer.toHexString(var10_11 /* !! */ [var12_13]));
                                ++var12_13;
                                continue;
                            }
                        }
                        var12_14 = new Object[]{var11_12.toString()};
                        throw new RFC2253NameParserException("Cannot create AVA due to invalid hex value in attribute value (\"{0}\")", var12_14);
                    }
                    var9_10 = var7_8.value_;
                }
                var10_11 /* !! */  = (byte[])new AVA(var8_9, var9_10);
                var4_5.addAVA((AVA)var10_11 /* !! */ );
                ++var6_7;
            }
            var2_3.addRDN(var4_5);
            --var3_4;
        }
        return var2_3;
    }

    public RFC2253NameParser(String string) {
        try {
            this.nameStrBuf_ = new StringBuffer(string);
        }
        catch (Exception exception) {
            throw new InternalErrorException(exception);
        }
    }
}

