/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509;

import iaik.asn1.ASN1Object;
import iaik.asn1.BOOLEAN;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.utils.InternalErrorException;
import iaik.x509.UnknownExtension;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.a;
import iaik.x509.extensions.AuthorityInfoAccess;
import iaik.x509.extensions.AuthorityKeyIdentifier;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.CRLDistributionPoints;
import iaik.x509.extensions.CRLNumber;
import iaik.x509.extensions.CertificateIssuer;
import iaik.x509.extensions.CertificatePolicies;
import iaik.x509.extensions.DeltaCRLIndicator;
import iaik.x509.extensions.ErrorExtension;
import iaik.x509.extensions.ExtendedKeyUsage;
import iaik.x509.extensions.HoldInstructionCode;
import iaik.x509.extensions.InvalidityDate;
import iaik.x509.extensions.IssuerAltName;
import iaik.x509.extensions.IssuingDistributionPoint;
import iaik.x509.extensions.KeyUsage;
import iaik.x509.extensions.NameConstraints;
import iaik.x509.extensions.PolicyConstraints;
import iaik.x509.extensions.PolicyMappings;
import iaik.x509.extensions.PrivateKeyUsagePeriod;
import iaik.x509.extensions.ReasonCode;
import iaik.x509.extensions.SubjectAltName;
import iaik.x509.extensions.SubjectDirectoryAttributes;
import iaik.x509.extensions.SubjectKeyIdentifier;
import iaik.x509.extensions.qualified.BiometricInfo;
import iaik.x509.extensions.qualified.QCStatements;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class X509Extensions {
    static /* synthetic */ Class bb;
    static /* synthetic */ Class d;
    static /* synthetic */ Class e;
    static /* synthetic */ Class v;
    static /* synthetic */ Class q;
    static /* synthetic */ Class r;
    static /* synthetic */ Class i;
    static /* synthetic */ Class o;
    static /* synthetic */ Class t;
    static /* synthetic */ Class w;
    static /* synthetic */ Class ab;
    static /* synthetic */ Class g;
    static /* synthetic */ Class f;
    static /* synthetic */ Class h;
    static /* synthetic */ Class j;
    static /* synthetic */ Class k;
    static /* synthetic */ Class l;
    static /* synthetic */ Class m;
    static /* synthetic */ Class n;
    static /* synthetic */ Class p;
    static /* synthetic */ Class s;
    static /* synthetic */ Class x;
    static /* synthetic */ Class u;
    static /* synthetic */ Class y;
    static /* synthetic */ Class z;
    private Hashtable a;
    private Hashtable c = new Hashtable(20);
    private static a b = new a();

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        V3Extension v3Extension = null;
        Enumeration enumeration = this.listExtensions();
        int n2 = 1;
        while (enumeration.hasMoreElements()) {
            v3Extension = (V3Extension)enumeration.nextElement();
            stringBuffer.append("Extension " + n2 + ":     ");
            if (v3Extension.isCritical()) {
                stringBuffer.append("critical        ");
            } else {
                stringBuffer.append("not critical    ");
            }
            String string = v3Extension.getName();
            if (string == null || string.trim().length() == 0) {
                stringBuffer.append("Unknown Extension");
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append("\n");
            stringBuffer.append(String.valueOf(String.valueOf(v3Extension)) + "\n\n");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws X509ExtensionException {
        Object object;
        Object object2;
        SEQUENCE sEQUENCE = null;
        SEQUENCE sEQUENCE2 = null;
        sEQUENCE2 = new SEQUENCE();
        Enumeration enumeration = this.c.keys();
        while (enumeration.hasMoreElements()) {
            sEQUENCE = new SEQUENCE();
            object2 = (ObjectID)enumeration.nextElement();
            sEQUENCE.addComponent((ASN1Object)object2);
            sEQUENCE.addComponent(new BOOLEAN(true));
            object = (byte[])this.c.get(object2);
            if (object == null) {
                throw new InternalErrorException("Extension value = null!");
            }
            sEQUENCE.addComponent(new OCTET_STRING((byte[])object));
            sEQUENCE2.addComponent(sEQUENCE);
        }
        object2 = this.a.keys();
        while (object2.hasMoreElements()) {
            sEQUENCE = new SEQUENCE();
            object = (ObjectID)object2.nextElement();
            sEQUENCE.addComponent((ASN1Object)object);
            byte[] byArray = (byte[])this.a.get(object);
            if (byArray == null) {
                throw new InternalErrorException("Extension value = null!");
            }
            sEQUENCE.addComponent(new OCTET_STRING(byArray));
            sEQUENCE2.addComponent(sEQUENCE);
        }
        return sEQUENCE2;
    }

    public boolean removeExtension(ObjectID objectID) {
        if (this.c.remove(objectID) != null) {
            return true;
        }
        if (this.a.remove(objectID) != null) {
            return true;
        }
        return true;
    }

    public void removeAllExtensions() {
        this.c.clear();
        this.a.clear();
    }

    public static void register(ObjectID objectID, Class clazz) {
        b.register(bb != null ? bb : (bb = X509Extensions.a("iaik.x509.V3Extension")), objectID, clazz);
    }

    protected void parseExtensions(ASN1Object aSN1Object) throws X509ExtensionException {
        try {
            int n2 = 0;
            while (n2 < aSN1Object.countComponents()) {
                boolean bl = false;
                ASN1Object aSN1Object2 = aSN1Object.getComponentAt(n2);
                ObjectID objectID = (ObjectID)aSN1Object2.getComponentAt(0);
                int n3 = aSN1Object2.countComponents();
                if (n3 == 3) {
                    bl = (Boolean)aSN1Object2.getComponentAt(1).getValue();
                }
                byte[] byArray = (byte[])aSN1Object2.getComponentAt(n3 - 1).getValue();
                if (bl) {
                    this.c.put(objectID, byArray);
                } else {
                    this.a.put(objectID, byArray);
                }
                ++n2;
            }
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException(codingException.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new X509ExtensionException("Error parsing X509Extensions: missing components.");
        }
    }

    public Enumeration listExtensions() {
        ObjectID objectID;
        Vector<V3Extension> vector = new Vector<V3Extension>();
        Enumeration enumeration = this.c.keys();
        while (enumeration.hasMoreElements()) {
            objectID = (ObjectID)enumeration.nextElement();
            try {
                vector.addElement(this.getExtension(objectID));
            }
            catch (X509ExtensionInitException x509ExtensionInitException) {
                vector.addElement(new ErrorExtension(objectID, true, x509ExtensionInitException.getMessage()));
            }
        }
        enumeration = this.a.keys();
        while (enumeration.hasMoreElements()) {
            objectID = (ObjectID)enumeration.nextElement();
            try {
                vector.addElement(this.getExtension(objectID));
            }
            catch (X509ExtensionInitException x509ExtensionInitException) {
                vector.addElement(new ErrorExtension(objectID, true, x509ExtensionInitException.getMessage()));
            }
        }
        return vector.elements();
    }

    public boolean hasUnsupportedCriticalExtension() {
        try {
            Enumeration enumeration = this.c.keys();
            while (enumeration.hasMoreElements()) {
                V3Extension v3Extension = this.getExtension((ObjectID)enumeration.nextElement());
                if (!(v3Extension instanceof UnknownExtension)) continue;
                return true;
            }
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            return true;
        }
        return false;
    }

    public boolean hasExtensions() {
        return (this.c.isEmpty() && this.a.isEmpty()) ^ true;
    }

    public Set getNonCriticalExtensionOIDs() {
        HashSet hashSet = new HashSet();
        Enumeration enumeration = this.a.keys();
        while (enumeration.hasMoreElements()) {
            hashSet.add(enumeration.nextElement());
        }
        return hashSet;
    }

    public byte[] getExtensionValue(String string) {
        Object v = this.c.get(new ObjectID(string));
        if (v != null) {
            return (byte[])v;
        }
        return (byte[])this.a.get(new ObjectID(string));
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        boolean bl = true;
        byte[] byArray = (byte[])this.c.get(objectID);
        if (byArray == null) {
            byArray = (byte[])this.a.get(objectID);
            if (byArray == null) {
                return null;
            }
            bl = false;
        }
        V3Extension v3Extension = null;
        try {
            v3Extension = X509Extensions.create(objectID);
        }
        catch (InstantiationException instantiationException) {
            v3Extension = new UnknownExtension(objectID);
        }
        v3Extension.setCritical(bl);
        try {
            ASN1Object aSN1Object = DerCoder.decode(byArray);
            v3Extension.init(aSN1Object);
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new X509ExtensionInitException(objectID, bl, x509ExtensionException.toString());
        }
        catch (CodingException codingException) {
            throw new X509ExtensionInitException(objectID, bl, codingException.toString());
        }
        return v3Extension;
    }

    public Set getCriticalExtensionOIDs() {
        HashSet hashSet = new HashSet();
        Enumeration enumeration = this.c.keys();
        while (enumeration.hasMoreElements()) {
            hashSet.add(enumeration.nextElement());
        }
        return hashSet;
    }

    public static V3Extension create(ObjectID objectID) throws InstantiationException {
        return (V3Extension)b.create(bb != null ? bb : (bb = X509Extensions.a("iaik.x509.V3Extension")), objectID, false);
    }

    public int countExtensions() {
        return this.c.size() + this.a.size();
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public boolean addExtension(V3Extension v3Extension) throws X509ExtensionException {
        byte[] byArray = DerCoder.encode(v3Extension.toASN1Object());
        if (v3Extension.isCritical()) {
            return this.c.put(v3Extension.getObjectID(), byArray) != null;
        }
        return this.a.put(v3Extension.getObjectID(), byArray) != null;
    }

    public X509Extensions(ASN1Object aSN1Object) throws X509ExtensionException {
        this();
        this.parseExtensions(aSN1Object);
    }

    public X509Extensions() {
        this.a = new Hashtable(20);
    }

    static {
        X509Extensions.register(AuthorityKeyIdentifier.oid, z != null ? z : (z = X509Extensions.a("iaik.x509.extensions.AuthorityKeyIdentifier")));
        X509Extensions.register(BasicConstraints.oid, y != null ? y : (y = X509Extensions.a("iaik.x509.extensions.BasicConstraints")));
        X509Extensions.register(CertificatePolicies.oid, u != null ? u : (u = X509Extensions.a("iaik.x509.extensions.CertificatePolicies")));
        X509Extensions.register(CRLDistributionPoints.oid, x != null ? x : (x = X509Extensions.a("iaik.x509.extensions.CRLDistributionPoints")));
        X509Extensions.register(ExtendedKeyUsage.oid, s != null ? s : (s = X509Extensions.a("iaik.x509.extensions.ExtendedKeyUsage")));
        X509Extensions.register(IssuerAltName.oid, p != null ? p : (p = X509Extensions.a("iaik.x509.extensions.IssuerAltName")));
        X509Extensions.register(KeyUsage.oid, n != null ? n : (n = X509Extensions.a("iaik.x509.extensions.KeyUsage")));
        X509Extensions.register(NameConstraints.oid, m != null ? m : (m = X509Extensions.a("iaik.x509.extensions.NameConstraints")));
        X509Extensions.register(PolicyConstraints.oid, l != null ? l : (l = X509Extensions.a("iaik.x509.extensions.PolicyConstraints")));
        X509Extensions.register(PolicyMappings.oid, k != null ? k : (k = X509Extensions.a("iaik.x509.extensions.PolicyMappings")));
        X509Extensions.register(PrivateKeyUsagePeriod.oid, j != null ? j : (j = X509Extensions.a("iaik.x509.extensions.PrivateKeyUsagePeriod")));
        X509Extensions.register(SubjectAltName.oid, h != null ? h : (h = X509Extensions.a("iaik.x509.extensions.SubjectAltName")));
        X509Extensions.register(SubjectKeyIdentifier.oid, f != null ? f : (f = X509Extensions.a("iaik.x509.extensions.SubjectKeyIdentifier")));
        X509Extensions.register(SubjectDirectoryAttributes.oid, g != null ? g : (g = X509Extensions.a("iaik.x509.extensions.SubjectDirectoryAttributes")));
        X509Extensions.register(AuthorityInfoAccess.oid, ab != null ? ab : (ab = X509Extensions.a("iaik.x509.extensions.AuthorityInfoAccess")));
        X509Extensions.register(CRLNumber.oid, w != null ? w : (w = X509Extensions.a("iaik.x509.extensions.CRLNumber")));
        X509Extensions.register(DeltaCRLIndicator.oid, t != null ? t : (t = X509Extensions.a("iaik.x509.extensions.DeltaCRLIndicator")));
        X509Extensions.register(IssuingDistributionPoint.oid, o != null ? o : (o = X509Extensions.a("iaik.x509.extensions.IssuingDistributionPoint")));
        X509Extensions.register(ReasonCode.oid, i != null ? i : (i = X509Extensions.a("iaik.x509.extensions.ReasonCode")));
        X509Extensions.register(HoldInstructionCode.oid, r != null ? r : (r = X509Extensions.a("iaik.x509.extensions.HoldInstructionCode")));
        X509Extensions.register(InvalidityDate.oid, q != null ? q : (q = X509Extensions.a("iaik.x509.extensions.InvalidityDate")));
        X509Extensions.register(CertificateIssuer.oid, v != null ? v : (v = X509Extensions.a("iaik.x509.extensions.CertificateIssuer")));
        X509Extensions.register(BiometricInfo.oid, e != null ? e : (e = X509Extensions.a("iaik.x509.extensions.qualified.BiometricInfo")));
        X509Extensions.register(QCStatements.oid, d != null ? d : (d = X509Extensions.a("iaik.x509.extensions.qualified.QCStatements")));
    }
}

