/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.BOOLEAN;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import java.math.BigInteger;

public class BasicConstraints
extends V3Extension {
    private int a = -1;
    private boolean b = false;
    public static final ObjectID oid = new ObjectID("2.5.29.19", "BasicConstraints");

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CA: ").append(this.b ? "yes" : "no").append("\n");
        if (this.a >= 0) {
            stringBuffer.append("PathLenConstraint: ");
            stringBuffer.append(String.valueOf(new Integer(this.a).toString()) + "\n");
        }
        stringBuffer.setLength(stringBuffer.length() - 1);
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.b) {
            sEQUENCE.addComponent(new BOOLEAN(this.b));
        }
        if (this.a != -1) {
            sEQUENCE.addComponent(new INTEGER(this.a));
        }
        return sEQUENCE;
    }

    public void setPathLenConstraint(int n2) {
        this.a = n2;
    }

    public void setCa(boolean bl) {
        this.b = bl;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        try {
            int n2 = 0;
            while (n2 < aSN1Object.countComponents()) {
                ASN1Object aSN1Object2 = aSN1Object.getComponentAt(n2);
                if (aSN1Object2.isA(ASN.BOOLEAN)) {
                    this.b = (Boolean)aSN1Object2.getValue();
                } else if (aSN1Object2.isA(ASN.INTEGER)) {
                    this.a = ((BigInteger)aSN1Object2.getValue()).intValue();
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            throw new X509ExtensionException(exception.toString());
        }
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public int getPathLenConstraint() {
        return this.a;
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public boolean ca() {
        return this.b;
    }

    public BasicConstraints(boolean bl, int n2) {
        this.b = bl;
        this.a = n2;
    }

    public BasicConstraints(boolean bl) {
        this.b = bl;
    }

    public BasicConstraints() {
    }
}

