/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit;

import com.entrust.toolkit.LoginCounter;
import com.entrust.toolkit.credentials.CredentialReader;
import com.entrust.toolkit.credentials.CredentialWriter;
import com.entrust.toolkit.credentials.FilenameProfileReader;
import com.entrust.toolkit.credentials.FilenameProfileWriter;
import com.entrust.toolkit.credentials.LogoutListener;
import com.entrust.toolkit.credentials.Profile;
import com.entrust.toolkit.exceptions.CertificationException;
import com.entrust.toolkit.exceptions.CertificationRootException;
import com.entrust.toolkit.exceptions.UserBadPasswordException;
import com.entrust.toolkit.exceptions.UserCertificateRevokedException;
import com.entrust.toolkit.exceptions.UserFatalException;
import com.entrust.toolkit.exceptions.UserNotLoggedInException;
import com.entrust.toolkit.util.IniFile;
import com.entrust.toolkit.util.ManagerTransport;
import com.entrust.toolkit.util.SecureStringBuffer;
import com.entrust.toolkit.x509.CertVerifier;
import com.entrust.toolkit.x509.LdapDirectory;
import com.entrust.toolkit.x509.ValidationInfo;
import com.entrust.toolkit.x509.certstore.CollectionCS;
import com.entrust.toolkit.x509.directory.JNDIDirectory;
import com.entrust.toolkit.x509.policies.ClientSettings;
import com.entrust.toolkit.x509.revocation.CollectionRS;
import com.entrust.toolkit.x509.testlets.ExtensionTester;
import iaik.asn1.CodingException;
import iaik.asn1.structures.Name;
import iaik.utils.Base64Exception;
import iaik.x509.X509Certificate;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.util.Vector;

public final class User {
    private X509Certificate[] l = null;
    private CertVerifier k = null;
    private Vector d = null;
    public static final int WARNING_DIRECTORY_IS_OLD = 2048;
    public static final int WARNING_DN_CHANGE_REQUIRED = 1024;
    public static final int WARNING_DN_CHANGED = 512;
    public static final int WARNING_PW_NOT_VALID = 256;
    public static final int WARNING_ENCRYPTION_KEY_NEEDS_UPDATE = 128;
    public static final int WARNING_SIGNING_KEY_NEEDS_UPDATE = 64;
    public static final int WARNING_PW_EXPIRED = 32;
    public static final int WARNING_SIGN_KEY_UPDATED = 16;
    public static final int WARNING_ENC_KEY_UPDATED = 8;
    public static final int WARNING_X500NAME_CHANGED = 4;
    public static final int WARNING_OPTIONS_NOT_AVAILABLE = 2;
    public static final int WARNING_OPTIONS_CHANGED = 1;
    private boolean e = false;
    private boolean b = false;
    private CredentialReader i = null;
    private CredentialWriter h = null;
    private ClientSettings j = null;
    private IniFile m = null;
    private LdapDirectory g = null;
    private ManagerTransport c = null;
    private Profile a = null;
    private IniFile f = null;

    public synchronized void write() throws UserNotLoggedInException, UserFatalException {
        if (this.a == null || !this.a.isLoggedOn()) {
            throw new UserNotLoggedInException("The user is not logged in!");
        }
        this.a.writeProfile();
    }

    public X509Certificate[] validate(X509Certificate x509Certificate) throws UserNotLoggedInException, CertificationException {
        if (this.a != null && this.a.isLoggedOn()) {
            return this.k.validate(x509Certificate);
        }
        throw new UserNotLoggedInException("The user is not logged in!");
    }

    public synchronized boolean updateSigningKeys() throws UserBadPasswordException, UserNotLoggedInException, UserFatalException {
        if (this.a != null && this.a.isLoggedOn()) {
            boolean bl = this.a.updateSigningKeys();
            if (bl) {
                this.e = true;
            }
            return bl;
        }
        throw new UserNotLoggedInException("The user is not logged in!");
    }

    public synchronized boolean updateEncryptionKeys() throws UserBadPasswordException, UserNotLoggedInException, UserFatalException {
        if (this.a != null && this.a.isLoggedOn()) {
            boolean bl = this.a.updateEncryptionKeys();
            if (bl) {
                this.e = true;
            }
            return bl;
        }
        throw new UserNotLoggedInException("The user is not logged in!");
    }

    public synchronized void unblockELILogout() throws UserNotLoggedInException {
        if (this.a == null || !this.a.isLoggedOn()) {
            throw new UserNotLoggedInException("The user is not logged in!");
        }
        this.a.unblockELILogout();
    }

    public synchronized boolean signingKeyUpdateRequired() throws UserBadPasswordException, UserNotLoggedInException {
        if (this.a != null && this.a.isLoggedOn()) {
            return this.a.signingKeyUpdateRequired();
        }
        throw new UserNotLoggedInException("The user is not logged in!");
    }

    public synchronized void setPolicyCertificate(IniFile iniFile) {
        this.m = iniFile;
    }

    public synchronized void setCredentialWriter(CredentialWriter credentialWriter) throws UserBadPasswordException {
        this.h = credentialWriter;
        if (this.isLoggedIn()) {
            this.a.checkPwd(credentialWriter);
        }
    }

    public synchronized void setConnections(String string) throws FileNotFoundException, UserFatalException {
        this.f = new IniFile(string);
        String string2 = this.f.getString("Entrust Settings", "Authority");
        if (string2 == null || string2.length() == 0) {
            string2 = this.f.getString("Entrust Settings", "Manager");
        }
        String string3 = this.f.getString("Entrust Settings", "Server");
        if (string2 == "" || string3 == "") {
            throw new UserFatalException("Error parsing ini file: " + string + ". Cannot parse the ip address of the PKI or Directory.");
        }
        int n2 = string2.indexOf(43);
        String string4 = string2.substring(0, n2);
        int n3 = Integer.parseInt(string2.substring(n2 + 1));
        n2 = string3.indexOf(43);
        String string5 = string3.substring(0, n2);
        int n4 = Integer.parseInt(string3.substring(n2 + 1));
        JNDIDirectory jNDIDirectory = new JNDIDirectory(string5, n4);
        ManagerTransport managerTransport = new ManagerTransport(string4, n3);
        this.setConnections(jNDIDirectory, managerTransport);
    }

    public synchronized void setConnections(LdapDirectory ldapDirectory, ManagerTransport managerTransport) throws UserFatalException {
        if (ldapDirectory == null || !ldapDirectory.isAvailable()) {
            throw new UserFatalException("Directory is not available.");
        }
        this.g = ldapDirectory;
        this.c = managerTransport;
        this.b = true;
        if (this.k != null) {
            this.k.setDirectory(this.g);
            this.k.getRevocationStore().requireCRL(true);
        }
    }

    public void requireCRL(boolean bl) throws UserNotLoggedInException {
        if (this.a == null || !this.a.isLoggedOn()) {
            throw new UserNotLoggedInException("The user is not logged in!");
        }
        this.k.getRevocationStore().requireCRL(bl);
    }

    public synchronized void logout() throws UserNotLoggedInException {
        if (this.d != null) {
            int n2 = 0;
            while (n2 < this.d.size()) {
                ((LogoutListener)this.d.elementAt(n2)).logout();
                ++n2;
            }
            this.d = null;
        }
        if (this.a == null || !this.a.isLoggedOn()) {
            throw new UserNotLoggedInException("The user is not logged in!");
        }
        this.a.logout();
    }

    public synchronized int login(CredentialReader credentialReader, SecureStringBuffer secureStringBuffer) throws KeyException, CertificateException, UserCertificateRevokedException, UserFatalException, UserBadPasswordException {
        if (credentialReader == null) {
            throw new NullPointerException("CredentialReader must not be null!");
        }
        this.i = credentialReader;
        this.j = new ClientSettings();
        this.l = null;
        this.a = new Profile(credentialReader, this, secureStringBuffer);
        this.k = this.a.getRootCertificate() != null ? new CertVerifier(this.a.getRootCertificate(), this.g, this.j) : new CertVerifier(this.a.getCaCertificate(), this.g, this.j);
        this.a.doRequiredKeyUpdates();
        LoginCounter.getInstance().trigger(0);
        return this.a.getStatus();
    }

    public synchronized boolean keyUpdateRequired() throws UserBadPasswordException, UserNotLoggedInException {
        if (this.a != null && this.a.isLoggedOn()) {
            return this.a.keyUpdateRequired();
        }
        throw new UserNotLoggedInException("The user is not logged in!");
    }

    public boolean keyUpdatePerformed() {
        return this.e;
    }

    public synchronized boolean isOnline() {
        return this.b;
    }

    public synchronized boolean isLoggedIn() {
        if (this.a == null) {
            return false;
        }
        return this.a.isLoggedOn();
    }

    public synchronized X509Certificate getVerificationCertificate() throws UserBadPasswordException, UserNotLoggedInException {
        if (this.a != null && this.a.isLoggedOn()) {
            return this.a.getVerificationCertificate();
        }
        throw new UserNotLoggedInException("The user is not logged in!");
    }

    public synchronized PrivateKey getSigningKey() throws UserNotLoggedInException, KeyException {
        if (this.a != null && this.a.isLoggedOn()) {
            try {
                return this.a.getSigningKey();
            }
            catch (Exception exception) {
                throw new KeyException("Could not return signing key: " + exception.getMessage());
            }
        }
        throw new UserNotLoggedInException("The user is not logged in!");
    }

    public synchronized X509Certificate getRootCaCertificate() throws UserNotLoggedInException {
        if (this.a != null && this.a.isLoggedOn()) {
            if (this.a.getRootCertificate() != null) {
                return this.a.getRootCertificate();
            }
            return this.a.getCaCertificate();
        }
        throw new UserNotLoggedInException("The user is not logged in!");
    }

    public synchronized CollectionRS getRevocationStore() throws UserNotLoggedInException {
        if (this.a != null && this.a.isLoggedOn()) {
            return this.k.getRevocationStore();
        }
        throw new UserNotLoggedInException("The user is not logged in!");
    }

    public synchronized IniFile getPolicyCertificate() {
        return this.m;
    }

    public synchronized ManagerTransport getManagerTransport() {
        return this.c;
    }

    public IniFile getIniFile() {
        return this.f;
    }

    public synchronized ExtensionTester getExtensionTester() throws UserNotLoggedInException {
        if (this.a != null && this.a.isLoggedOn()) {
            return this.k.getExtensionTester();
        }
        throw new UserNotLoggedInException("The user is not logged in!");
    }

    public synchronized X509Certificate getEncryptionCertificate() throws UserBadPasswordException, UserNotLoggedInException {
        if (this.a != null && this.a.isLoggedOn()) {
            return this.a.getEncryptionCertificate();
        }
        throw new UserNotLoggedInException("The user is not logged in!");
    }

    public synchronized LdapDirectory getDirectory() {
        return this.g;
    }

    public String[] getDecryptionSerialNumbers() throws UserNotLoggedInException {
        if (this.a != null && this.a.isLoggedOn()) {
            return this.a.getDecryptionSerialNumbers();
        }
        throw new UserNotLoggedInException("The user is not logged in!");
    }

    public synchronized PrivateKey[] getDecryptionKeys() throws UserNotLoggedInException, KeyException {
        if (this.a != null && this.a.isLoggedOn()) {
            try {
                return this.a.getDecryptionKeys();
            }
            catch (Exception exception) {
                throw new KeyException("Could not return decryption keys: " + exception.getMessage());
            }
        }
        throw new UserNotLoggedInException("The user is not logged in!");
    }

    public synchronized PrivateKey getDecryptionKey(Name name, String string) throws UserNotLoggedInException, KeyException {
        if (this.a != null && this.a.isLoggedOn()) {
            try {
                return this.a.getDecryptionKey(name, string);
            }
            catch (Exception exception) {
                throw new KeyException("Could not return decryption key: " + exception.getMessage());
            }
        }
        throw new UserNotLoggedInException("The user is not logged in!");
    }

    public synchronized PrivateKey getDecryptionKey() throws KeyException, UserNotLoggedInException {
        if (this.a != null && this.a.isLoggedOn()) {
            try {
                return this.a.getDecryptionKey();
            }
            catch (Exception exception) {
                throw new KeyException("Could not return decryption key: " + exception.getMessage());
            }
        }
        throw new UserNotLoggedInException("The user is not logged in!");
    }

    public Name[] getDecryptionIssuers() throws Base64Exception, CodingException, UnsupportedEncodingException, UserNotLoggedInException {
        if (this.a != null && this.a.isLoggedOn()) {
            return this.a.getDecryptionIssuers();
        }
        throw new UserNotLoggedInException("The user is not logged in!");
    }

    public synchronized CredentialWriter getCredentialWriter() {
        return this.h;
    }

    public synchronized CredentialReader getCredentialReader() {
        return this.i;
    }

    public synchronized ClientSettings getClientSettings() {
        return this.j;
    }

    public synchronized CollectionCS getCertificateStore() throws UserNotLoggedInException {
        if (this.a != null && this.a.isLoggedOn()) {
            return this.k.getCertificateStore();
        }
        throw new UserNotLoggedInException("The user is not logged in!");
    }

    public synchronized ValidationInfo getCertVerifier() throws UserNotLoggedInException {
        if (this.a != null && this.a.isLoggedOn()) {
            return this.k;
        }
        throw new UserNotLoggedInException("The user is not logged in!");
    }

    public synchronized X509Certificate[] getCaCertificateChain() throws UserNotLoggedInException, UserFatalException {
        if (this.getCertificateStore() == null) {
            throw new UserNotLoggedInException("The user is not logged in!");
        }
        if (this.l != null) {
            return this.l;
        }
        try {
            X509Certificate[] x509CertificateArray = this.getCertificateStore().validate(this.getCaCertificate());
            int n2 = x509CertificateArray.length;
            this.l = new X509Certificate[n2];
            int n3 = 0;
            while (n3 < n2) {
                this.l[n3] = x509CertificateArray[n2 - n3 - 1];
                ++n3;
            }
            return this.l;
        }
        catch (Exception exception) {
            throw new UserFatalException(exception.getMessage());
        }
    }

    public synchronized X509Certificate getCaCertificate() throws UserNotLoggedInException {
        if (this.a != null && this.a.isLoggedOn()) {
            return this.a.getCaCertificate();
        }
        throw new UserNotLoggedInException("The user is not logged in!");
    }

    public synchronized boolean encryptionKeyUpdateRequired() throws UserBadPasswordException, UserNotLoggedInException {
        if (this.a != null && this.a.isLoggedOn()) {
            return this.a.encryptionKeyUpdateRequired();
        }
        throw new UserNotLoggedInException("The user is not logged in!");
    }

    public synchronized void closeConnections() {
        this.g = null;
        this.c = null;
        this.b = false;
        if (this.k != null) {
            this.k.setDirectory(null);
            this.k.getRevocationStore().requireCRL(false);
        }
    }

    public synchronized void changePassword(SecureStringBuffer secureStringBuffer, SecureStringBuffer secureStringBuffer2) throws UserNotLoggedInException, UserBadPasswordException, UserFatalException {
        if (this.a == null || !this.a.isLoggedOn()) {
            throw new UserNotLoggedInException("The user is not logged in!");
        }
        this.a.changePassword(secureStringBuffer, secureStringBuffer2);
    }

    public synchronized void blockELILogout() throws UserNotLoggedInException {
        if (this.a == null || !this.a.isLoggedOn()) {
            throw new UserNotLoggedInException("The user is not logged in!");
        }
        this.a.blockELILogout();
    }

    public void addTrustedCertificate(X509Certificate x509Certificate) throws CertificationRootException {
        this.k.getCertificateStore().addTrustedCertificate(x509Certificate);
    }

    public synchronized void addLogoutListener(LogoutListener logoutListener) {
        if (this.d == null) {
            this.d = new Vector();
        }
        this.d.addElement(logoutListener);
    }

    public User(String string, SecureStringBuffer secureStringBuffer, String string2) throws UserFatalException, UserCertificateRevokedException, FileNotFoundException, UserBadPasswordException {
        try {
            FilenameProfileReader filenameProfileReader = new FilenameProfileReader(string);
            FilenameProfileWriter filenameProfileWriter = new FilenameProfileWriter(string, null, 0);
            this.setConnections(string2);
            this.setCredentialWriter(filenameProfileWriter);
            this.login(filenameProfileReader, secureStringBuffer);
        }
        catch (KeyException keyException) {
            throw new UserFatalException(keyException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new UserFatalException(noSuchAlgorithmException.getMessage());
        }
        catch (CertificateException certificateException) {
            throw new UserFatalException(certificateException.getMessage());
        }
    }

    public User() {
    }
}

