/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.x509.X509Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;

public class CrossCertificatePair {
    X509Certificate a = null;
    X509Certificate b = null;

    public X509Certificate getReverseCertificate() {
        return this.a;
    }

    public X509Certificate getForwardCertificate() {
        return this.b;
    }

    public CrossCertificatePair(byte[] byArray) throws CertificateException {
        try {
            ASN1Object aSN1Object = new ASN1(byArray).toASN1Object();
            if (aSN1Object.getAsnType() != ASN.SEQUENCE) {
                throw new CodingException();
            }
            if (aSN1Object.countComponents() == 0) {
                return;
            }
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(0);
            if (!aSN1Object2.isA(ASN.CON_SPEC)) {
                throw new CodingException();
            }
            if (aSN1Object2.getAsnType().getTag() == 0) {
                this.b = new X509Certificate(new ASN1(aSN1Object2.getComponentAt(0)).toByteArray());
                if (aSN1Object.countComponents() > 1) {
                    aSN1Object2 = aSN1Object.getComponentAt(1);
                    if (!aSN1Object2.isA(ASN.CON_SPEC)) {
                        throw new CodingException();
                    }
                } else {
                    return;
                }
            }
            if (aSN1Object2.getAsnType().getTag() != 1) {
                throw new CodingException();
            }
            this.a = new X509Certificate(new ASN1(aSN1Object2.getComponentAt(0)).toByteArray());
        }
        catch (CodingException codingException) {
            throw new CertificateEncodingException(codingException.getMessage());
        }
    }
}

