/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.credentials;

import com.entrust.toolkit.credentials.CredentialReader;
import com.entrust.toolkit.credentials.x;
import com.entrust.toolkit.exceptions.UserFatalException;
import com.entrust.toolkit.security.provider.ECParameters;
import com.entrust.toolkit.util.AuthorizationCode;
import com.entrust.toolkit.util.SecureStringBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;

public final class CredentialCreator
extends CredentialReader {
    public static final int PKIX5Version = 5;
    public static final int PKIX4Version = 4;
    public static final int ECDSASignature = 2;
    public static final int DSASignature = 1;
    public static final int RSASignature = 0;

    public String getType() {
        return "CredentialCreator";
    }

    public CredentialCreator(SecureStringBuffer secureStringBuffer, AuthorizationCode authorizationCode, int n2, AlgorithmParameterSpec algorithmParameterSpec, int n3) throws UserFatalException, NoSuchAlgorithmException {
        if (secureStringBuffer == null) {
            throw new IllegalArgumentException("'referenceNumber' cannot be null");
        }
        if (authorizationCode == null) {
            throw new IllegalArgumentException("'authroizationCode' cannot be null");
        }
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Invalid 'signingKeyAlgorithm', allowed: 0, 1, or 2; found: " + n2);
        }
        if (n3 != 4 && n3 != 5) {
            throw new IllegalArgumentException("Invalid 'pkixVersion', allowed: 4 or 5; found: " + n3);
        }
        if (n2 == 2 && n3 == 4) {
            throw new IllegalArgumentException("Invalid 'signingKeyAlgorithm' for proto-PKIX, allowed: 0 or 1; found: " + n2);
        }
        if (!(algorithmParameterSpec instanceof ECParameters)) {
            throw new IllegalArgumentException("Invalid 'signingKeyParameter', must contain elliptic curve parameters");
        }
        this.a = n2 == 2 ? new x(secureStringBuffer, authorizationCode, n2, algorithmParameterSpec, n3) : new x(secureStringBuffer, authorizationCode, n2, 1024, n3);
    }

    public CredentialCreator(SecureStringBuffer secureStringBuffer, AuthorizationCode authorizationCode, int n2, int n3, int n4) throws UserFatalException, NoSuchAlgorithmException {
        if (secureStringBuffer == null) {
            throw new IllegalArgumentException("'referenceNumber' cannot be null");
        }
        if (authorizationCode == null) {
            throw new IllegalArgumentException("'authroizationCode' cannot be null");
        }
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("Invalid 'signingKeyAlgorithm', allowed: 0, 1, or 2; found: " + n2);
        }
        if (n2 == 0 && n3 != 512 && n3 != 1024 && n3 != 2048) {
            throw new IllegalArgumentException("Invalid 'signingKeyStrength' for RSA, allowed: 512, 1024, or 2048; found: " + n3);
        }
        if (n2 == 1 && n3 != 512 && n3 != 1024) {
            throw new IllegalArgumentException("Invalid 'signingKeyStrength' for DSA, allowed: 512 or 1024; found: " + n3);
        }
        if (n4 != 4 && n4 != 5) {
            throw new IllegalArgumentException("Invalid 'pkixVersion', allowed: 4 or 5; found: " + n4);
        }
        if (n2 == 2 && n4 == 4) {
            throw new IllegalArgumentException("Invalid 'signingKeyAlgorithm' for proto-PKIX, allowed: 0 or 1; found: " + n2);
        }
        this.a = new x(secureStringBuffer, authorizationCode, n2, n3, n4);
    }
}

