/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.credentials;

import com.entrust.toolkit.User;
import com.entrust.toolkit.credentials.CredentialReader;
import com.entrust.toolkit.credentials.CredentialWriter;
import com.entrust.toolkit.credentials.StreamProfileWriter;
import com.entrust.toolkit.credentials.u;
import com.entrust.toolkit.credentials.w;
import com.entrust.toolkit.exceptions.CertificationException;
import com.entrust.toolkit.exceptions.CertificationRootException;
import com.entrust.toolkit.exceptions.ProfileException;
import com.entrust.toolkit.exceptions.UserBadPasswordException;
import com.entrust.toolkit.exceptions.UserCertificateRevokedException;
import com.entrust.toolkit.exceptions.UserFatalException;
import com.entrust.toolkit.exceptions.UserNotLoggedInException;
import com.entrust.toolkit.security.provider.ConfinedKey;
import com.entrust.toolkit.security.provider.ECDSAKeyPairGenerator;
import com.entrust.toolkit.security.provider.ECDSAPublicKey;
import com.entrust.toolkit.security.provider.ECParameters;
import com.entrust.toolkit.security.provider.k;
import com.entrust.toolkit.util.ByteArray;
import com.entrust.toolkit.util.ExtendedHasher;
import com.entrust.toolkit.util.IniFile;
import com.entrust.toolkit.util.PEMString;
import com.entrust.toolkit.util.PKIX;
import com.entrust.toolkit.util.PKIX4;
import com.entrust.toolkit.util.PKIXCMP;
import com.entrust.toolkit.util.SecureStringBuffer;
import com.entrust.toolkit.util.ZuluTime;
import com.entrust.toolkit.x509.CertVerifier;
import com.entrust.toolkit.x509.LdapDirectory;
import com.entrust.toolkit.x509.X509CertificateWrapper;
import com.entrust.toolkit.x509.certstore.CertificateGraph;
import com.entrust.toolkit.x509.policies.ClientSettings;
import iaik.asn1.ASN1;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.Name;
import iaik.asn1.structures.PolicyInformation;
import iaik.security.dsa.DSAPublicKey;
import iaik.security.rsa.RSAPublicKey;
import iaik.utils.Base64Exception;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.CertificatePolicies;
import iaik.x509.extensions.PrivateKeyUsagePeriod;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.crypto.Cipher;

public final class Profile {
    private boolean v = false;
    private boolean u = false;
    private User c = null;
    private boolean g = false;
    private int a = 0;
    private String m = null;
    private Vector k = null;
    private int h = 0;
    private ByteArray[] i = null;
    private int l = 0;
    private Vector t = null;
    int d = 0;
    private boolean n = false;
    private int q = 0;
    private String j = "";
    private String[] r = null;
    private PrivateKey[] p = null;
    private PrivateKey e = null;
    private X509Certificate o = null;
    private X509Certificate b = null;
    private X509Certificate f = null;
    private X509Certificate s = null;

    public void writeProfile() throws UserFatalException {
        if (this.m()) {
            throw new UserFatalException("It's not possible to write a profile when logged in over Single Login!");
        }
        if (this.c.getCredentialWriter() == null) {
            throw new UserFatalException("No CredentialWriter set in user!");
        }
        if (this.c.getCredentialReader().getType().equals("CredentialCreator") && this.c.getCredentialWriter().getType().equals("PKCS12Writer")) {
            throw new UserFatalException("You cannot write a PKCS#12 file directly during credential creation. You must first create an epf file, then export it to a PKCS#12 file.");
        }
        if (!this.c.getCredentialWriter().writePossible()) {
            throw new UserFatalException("The credentials were already written to the specified CredentialWriter. The credentials can't be written more times to this credential writer!");
        }
        u u2 = this.c.getCredentialWriter().a();
        int n2 = 0;
        while (n2 < this.k.size()) {
            if (((String)this.k.elementAt(n2)).startsWith("CertificatePublicationPending=")) {
                this.k.removeElementAt(n2);
            }
            ++n2;
        }
        this.k.addElement(new String("CertificatePublicationPending=" + this.q));
        try {
            u2.a(this.t, this.h());
            u2.c(this.a);
            u2.a(this.a);
            u2.b(this.k);
            u2.a(this.m);
            u2.b(this.l);
            u2.a(this.p, this.l);
            u2.a(this.r, this.l);
            u2.b(this.o);
            u2.a(this.e);
            u2.d(this.b);
            u2.a(this.s);
            if (this.f != null) {
                u2.c(this.f);
            }
            u2.setName(this.m);
            u2.a(this.k);
            u2.a(this.h, this.i);
            u2.b();
        }
        catch (Exception exception) {
            throw new UserFatalException("Could not write credentials: " + exception.getMessage());
        }
    }

    private final void b(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = 0;
            ++n2;
        }
        byArray = null;
    }

    public synchronized boolean updateSigningKeys() throws UserBadPasswordException, UserFatalException {
        if (!this.l()) {
            return false;
        }
        try {
            if (this.f() && this.d()) {
                this.d |= 8;
            }
        }
        catch (UserFatalException userFatalException) {
            this.d |= 0x80;
            return false;
        }
        catch (CertificateException certificateException) {
            throw new UserFatalException("Cannot determine encryption certificate status");
        }
        try {
            if (this.e()) {
                this.d |= 0x10;
                if ((this.d & 0x40) != 0) {
                    this.d ^= 0x40;
                }
            }
        }
        catch (UserFatalException userFatalException) {
            this.d |= 0x40;
            return false;
        }
        try {
            this.s = this.c.getClientSettings().getCaCertificate();
            this.f = this.c.getClientSettings().getRootCaCertificate();
            this.writeProfile();
        }
        catch (CertificateException certificateException) {}
        return true;
    }

    private void a(PKIX pKIX) throws ProfileException {
        if (this.k == null || this.j == null) {
            return;
        }
        if (this.j.equals("PKIX_2") || pKIX instanceof PKIX4) {
            return;
        }
        String string = null;
        try {
            int n2 = 0;
            while (n2 < this.k.size()) {
                string = (String)this.k.elementAt(n2);
                string.trim();
                if (string.startsWith("ProfileType")) {
                    this.k.setElementAt(new String("ProfileType=PKIX_2"), n2);
                    this.j = "PKIX_2";
                    break;
                }
                ++n2;
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new ProfileException("Failed to update profile Options:" + nullPointerException.toString());
        }
    }

    public synchronized boolean updateEncryptionKeys() throws UserBadPasswordException, UserFatalException {
        if (!this.l()) {
            return false;
        }
        try {
            if (this.d()) {
                this.d |= 8;
                if ((this.d & 0x80) != 0) {
                    this.d ^= 0x80;
                }
            }
        }
        catch (UserFatalException userFatalException) {
            this.d |= 0x80;
            throw new UserFatalException(userFatalException.toString());
        }
        try {
            if (this.o() && this.e()) {
                this.d |= 0x10;
                if ((this.d & 0x40) != 0) {
                    this.d ^= 0x40;
                }
            }
        }
        catch (UserFatalException userFatalException) {
            this.d |= 0x40;
            return false;
        }
        catch (CertificateException certificateException) {
            throw new UserFatalException("Cannot determine verification certificate status");
        }
        try {
            this.s = this.c.getClientSettings().getCaCertificate();
            this.f = this.c.getClientSettings().getRootCaCertificate();
            this.writeProfile();
        }
        catch (CertificateException certificateException) {}
        return true;
    }

    public void unblockELILogout() {
        if (!this.n) {
            return;
        }
        this.u = false;
        if (this.v) {
            this.logout();
        }
    }

    private byte[] a(byte[] byArray) {
        int n2 = 0;
        while (ByteArray.toInt((byte)byArray[n2]) > 127) {
            ++n2;
        }
        if (ByteArray.toInt((byte)byArray[++n2]) > 127) {
            n2 += ByteArray.toInt((byte)byArray[n2]) - 128;
        }
        byte[] byArray2 = new byte[byArray.length - ++n2];
        System.arraycopy(byArray, n2, byArray2, 0, byArray.length - n2);
        return byArray2;
    }

    public boolean signingKeyUpdateRequired() throws UserBadPasswordException {
        if (this.g) {
            throw new UserBadPasswordException("The password is not valid according to the password rule, change the password first with the method changePassword() before calling this function");
        }
        PrivateKeyUsagePeriod privateKeyUsagePeriod = null;
        Date date = null;
        Date date2 = null;
        double d2 = 0.5;
        long l = 8640000000L;
        long l2 = 0L;
        long l3 = 0L;
        try {
            privateKeyUsagePeriod = (PrivateKeyUsagePeriod)this.b.getExtension(new PrivateKeyUsagePeriod().getObjectID());
            date = privateKeyUsagePeriod.getNotAfter();
        }
        catch (Exception exception) {
            date = this.b.getNotAfter();
        }
        date2 = new Date(date.getTime() - this.b.getNotBefore().getTime());
        l3 = (long)((double)date2.getTime() * d2);
        if (l3 > l) {
            l3 = l;
        }
        date.setTime(date.getTime() - l3);
        ZuluTime zuluTime = new ZuluTime(new Date());
        if (date.getTime() < zuluTime.getTime()) {
            this.d |= 0x40;
            return true;
        }
        return false;
    }

    private boolean o() throws CertificateException {
        ClientSettings clientSettings = this.c.getClientSettings();
        X509Certificate x509Certificate = clientSettings.getCaCertificate();
        if (x509Certificate.equals(this.s)) {
            return false;
        }
        return !this.c.getClientSettings().issuedByUpdatedCAkey(this.b);
    }

    private void a(X509Certificate x509Certificate, PrivateKey privateKey, X509Certificate x509Certificate2) throws InvalidKeyException {
        X509CertificateWrapper x509CertificateWrapper = new X509CertificateWrapper(x509Certificate);
        String string = x509CertificateWrapper.getHistoryName();
        int n2 = 0;
        while (n2 < this.l) {
            if (string.equals(this.r[n2])) {
                x509CertificateWrapper = new X509CertificateWrapper(x509Certificate2);
                this.r[n2] = x509CertificateWrapper.getHistoryName();
                this.p[n2] = privateKey;
            }
            ++n2;
        }
    }

    private ClientSettings a(boolean bl) throws CertificationRootException {
        ClientSettings clientSettings = this.c.getClientSettings();
        if (bl) {
            clientSettings.clear();
        }
        if (clientSettings.initialized()) {
            return clientSettings;
        }
        clientSettings.init(new ClientSettings(this.c, this.s, this.b, this.f));
        return clientSettings;
    }

    private void n() {
        PrivateKey[] privateKeyArray = new PrivateKey[this.l - 1];
        String[] stringArray = new String[this.l - 1];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.l) {
            if (n3 != this.l - 2) {
                privateKeyArray[n2] = this.p[n3];
                stringArray[n2] = this.r[n3];
                ++n2;
            }
            ++n3;
        }
        this.p = privateKeyArray;
        this.r = stringArray;
        --this.l;
    }

    private void a(int n2) {
        int n3 = this.i.length - n2;
        ByteArray[] byteArrayArray = new ByteArray[n3];
        int n4 = 0;
        while (n4 < n3) {
            byteArrayArray[n4] = this.i[n4 + n2];
            ++n4;
        }
        this.i = byteArrayArray;
    }

    public void logout() {
        int n2;
        if (this.m() && this.u) {
            this.v = true;
            return;
        }
        this.n = false;
        ((com.entrust.toolkit.security.provider.PrivateKey)this.e).destroyCriticalData();
        this.e = null;
        if (this.p != null) {
            n2 = 0;
            while (n2 < this.p.length) {
                ((com.entrust.toolkit.security.provider.PrivateKey)this.p[n2]).destroyCriticalData();
                this.p[n2] = null;
                ++n2;
            }
            this.p = null;
        }
        this.s = null;
        this.b = null;
        this.o = null;
        n2 = 0;
        while (n2 < this.r.length) {
            this.r[n2] = null;
            ++n2;
        }
        this.r = null;
        this.j = new String("");
        this.q = 0;
        this.d = 0;
        this.l = 0;
        if (this.i != null) {
            int n3 = 0;
            while (n3 < this.i.length) {
                this.i[n3] = null;
                ++n3;
            }
        }
        this.i = null;
        this.h = 0;
        if (this.k != null) {
            this.k.removeAllElements();
            this.k = null;
        }
        this.m = null;
        this.a = 0;
        this.g = false;
        this.c = null;
        if (this.t != null) {
            this.t.removeAllElements();
            this.t = null;
        }
    }

    private synchronized void a(CredentialReader credentialReader, User user, SecureStringBuffer secureStringBuffer) throws KeyException, CertificateException, UserCertificateRevokedException, UserFatalException, UserBadPasswordException {
        boolean bl;
        Object object;
        Object object2;
        this.c = user;
        w w2 = credentialReader.a();
        w2.b(user, secureStringBuffer);
        this.a = w2.p();
        if (this.a < 3) {
            throw new UserFatalException("Cannot logon - profile version: " + this.a + " is not supported.");
        }
        this.s = w2.b();
        this.f = w2.l();
        Date date = new Date();
        if (date.after(this.s.getNotAfter())) {
            throw new CertificateException("CA certificate is expired!");
        }
        this.e = w2.m();
        this.b = w2.o();
        if (this.c.getDirectory() != null) {
            this.c.getDirectory().setClientCredentials((java.security.cert.X509Certificate)this.b, (java.security.cert.X509Certificate)this.s, this.e);
        }
        if (this.c.getManagerTransport() != null) {
            this.c.getManagerTransport().setClientCredentials((java.security.cert.X509Certificate)this.b, (java.security.cert.X509Certificate)this.s, this.e);
        }
        this.l = w2.h();
        if (this.l < 1) {
            throw new UserFatalException("Could not get private key history");
        }
        this.r = w2.c();
        this.p = new PrivateKey[this.l];
        this.p = w2.d();
        this.o = w2.e();
        PrivateKeyUsagePeriod privateKeyUsagePeriod = null;
        try {
            privateKeyUsagePeriod = (PrivateKeyUsagePeriod)this.b.getExtension(new PrivateKeyUsagePeriod().getObjectID());
        }
        catch (Exception exception) {
            privateKeyUsagePeriod = null;
        }
        if (privateKeyUsagePeriod != null) {
            long l = privateKeyUsagePeriod.getNotAfter().getTime();
            object2 = new ZuluTime(new Date());
            if (((ZuluTime)object2).getTime() > l) {
                throw new KeyException("The private key usage period has expired.");
            }
        }
        this.d |= w2.n();
        this.i = w2.k();
        this.h = w2.j();
        this.t = new Vector(w2.g());
        this.t = w2.a();
        this.k = w2.i();
        String string = null;
        int n2 = 0;
        while (n2 < this.k.size()) {
            string = (String)this.k.elementAt(n2);
            object2 = new StringTokenizer(string, "=");
            if ((string = ((StringTokenizer)object2).nextToken()).equals("ProfileType")) {
                object = ((StringTokenizer)object2).nextToken();
                ((String)object).trim();
                this.j = object;
            } else if (string.equals("CertificatePublicationPending")) {
                object = ((StringTokenizer)object2).nextToken();
                ((String)object).trim();
                this.q = Integer.parseInt((String)object);
            }
            ++n2;
        }
        this.m = w2.f();
        try {
            user.setPolicyCertificate(this.a(false).getCertificates());
        }
        catch (CertificationRootException certificationRootException) {
            throw new UserFatalException(certificationRootException.toString());
        }
        if (credentialReader.getType().equals("SingleLoginReader") && user.getClientSettings().getPasswordRuleTester().getDisableSLO()) {
            throw new UserFatalException("An attempt was made to login using ELI, but the user's client settings do not permit Single Login");
        }
        boolean bl2 = bl = !this.j.equals("PKIX") && (credentialReader.getType().equals("CredentialCreator") || credentialReader.getType().equals("CredentialRecoverer"));
        if (!credentialReader.getType().equals("UALCredentialReader") && !bl) {
            try {
                credentialReader.checkPwd(user, secureStringBuffer);
                object = this.c.getCredentialWriter();
                if (object != null) {
                    ((CredentialWriter)object).checkPwd(user, secureStringBuffer);
                }
            }
            catch (UserBadPasswordException userBadPasswordException) {
                if (credentialReader.getType().equals("CredentialCreator") || credentialReader.getType().equals("CredentialRecoverer")) {
                    throw userBadPasswordException;
                }
                this.d |= 0x100;
            }
        }
        if (!credentialReader.getType().equals("SingleLoginReader") && user.getClientSettings().getPasswordRuleTester().checkExpiry(this.h)) {
            this.d |= 0x20;
        }
        if (user.getClientSettings().getEnforceTokenUse() && !w2.t()) {
            throw new UserFatalException("This user's client settings require a token-based profile");
        }
        if (credentialReader.getType().equals("CredentialCreator") || credentialReader.getType().equals("CredentialRecoverer") || credentialReader.getType().equals("TokenCredentialCreator") || credentialReader.getType().equals("TokenCredentialRecoverer")) {
            this.a(this.b, this.e);
            this.q = (int)(System.currentTimeMillis() / 1000L);
            this.b();
            this.writeProfile();
            credentialReader.a().s();
        } else if (this.b()) {
            try {
                this.writeProfile();
            }
            catch (Exception exception) {}
        }
        object = null;
        if (this.f != null) {
            if (!this.b(this.f)) {
                throw new UserFatalException("The root CA certificate must be self-signed.");
            }
            object = new CertVerifier(this.f, user.getDirectory(), user.getClientSettings());
            CertificateGraph.Graph().addCertificate(this.s);
        } else {
            if (!this.b(this.s)) {
                throw new UserFatalException("The CA certificate must be self-signed.");
            }
            object = new CertVerifier(this.s, user.getDirectory(), user.getClientSettings());
        }
        if (!(credentialReader.getType().equals("CredentialCreator") || credentialReader.getType().equals("CredentialRecoverer") || credentialReader.getType().equals("TokenCredentialCreator") || credentialReader.getType().equals("TokenCredentialRecoverer"))) {
            this.a((CertVerifier)object);
        }
        this.n = true;
        if ((this.d & 0x120) != 0) {
            this.g = true;
        }
        if (credentialReader.getType().equals("UALCredentialReader")) {
            try {
                if (this.c.isOnline() && this.j()) {
                    credentialReader.b();
                }
            }
            catch (Exception exception) {
                throw new UserFatalException(exception.getMessage());
            }
        }
    }

    private boolean m() {
        return this.g() == 3 || this.g() == 4;
    }

    public boolean keyUpdateRequired() throws UserBadPasswordException {
        if (!(this.j.equals("PKIX") || this.j.equals("PKIX_2") || this.j.equals("") || this.j.equals("Entrust/Manager"))) {
            return false;
        }
        return this.signingKeyUpdateRequired() || this.encryptionKeyUpdateRequired();
    }

    private synchronized boolean l() throws UserBadPasswordException, UserFatalException {
        if (!this.n) {
            return false;
        }
        if (this.q != 0 && (int)(System.currentTimeMillis() / 1000L) <= this.q + 86400) {
            return false;
        }
        if (this.g) {
            throw new UserBadPasswordException("The password is not valid according to the password rule, change the password first with the method changePassword() before calling this function");
        }
        if (this.c.getManagerTransport() == null) {
            throw new UserFatalException("Cannot perform update while no ManagerTransport set in user!");
        }
        if (!this.c.isOnline()) {
            throw new UserFatalException("Cannot perform update while offline, directory must be set!");
        }
        if (this.c.getCredentialWriter() == null) {
            throw new UserFatalException("Cannot perform update while no CredentialWriter set in user!");
        }
        if (this.c.getCredentialWriter() instanceof StreamProfileWriter) {
            throw new UserFatalException("Cannot perform update using a StreamProfileWriter.  Use a FilenameProfileWriter instead.");
        }
        if (!this.c.getCredentialWriter().writePossible()) {
            throw new UserFatalException("Cannot perform update because cannot write to the CredentialWriter set in user!");
        }
        if (this.m()) {
            throw new UserFatalException("It's not allowed to do key update when using Single Login!");
        }
        try {
            this.c.getClientSettings().getFresh(this.c, this.s, this.b, this.f);
            this.c.setPolicyCertificate(this.c.getClientSettings().getCertificates());
        }
        catch (CertificateException certificateException) {
            throw new UserFatalException("Cannot perform a key update without a valid policy certificate");
        }
        return true;
    }

    private synchronized boolean k() {
        if (!this.n || this.g || this.c.getManagerTransport() == null || this.c.getCredentialWriter() == null || this.c.getCredentialWriter() instanceof StreamProfileWriter || !this.c.getCredentialWriter().writePossible()) {
            return false;
        }
        if (this.q != 0 && (int)(System.currentTimeMillis() / 1000L) <= this.q + 86400) {
            return false;
        }
        try {
            if (this.m()) {
                return false;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean j() throws X509ExtensionInitException, UserBadPasswordException, UserNotLoggedInException {
        X509Certificate x509Certificate = this.b;
        CertificatePolicies certificatePolicies = (CertificatePolicies)x509Certificate.getExtension(CertificatePolicies.oid);
        if (certificatePolicies != null) {
            String string = "1.2.840.113533.7.75.3";
            PolicyInformation[] policyInformationArray = certificatePolicies.getPolicyInformation();
            if (policyInformationArray != null) {
                int n2 = 0;
                while (n2 < policyInformationArray.length) {
                    ObjectID objectID = policyInformationArray[n2].getPolicyIdentifier();
                    if (objectID.getID().compareTo(string) == 0) {
                        return true;
                    }
                    ++n2;
                }
            }
        }
        return this.c.getClientSettings().getAllowServerLogin();
    }

    private boolean b(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN());
    }

    public boolean isLoggedOn() {
        return this.n;
    }

    public X509Certificate getVerificationCertificate() throws UserBadPasswordException {
        if (!this.n) {
            return null;
        }
        if (this.g) {
            throw new UserBadPasswordException("The password is not valid according to the password rule, change the password first with the method changePassword() before calling this function");
        }
        return this.b;
    }

    public int getStatus() {
        if (!this.n) {
            return 0;
        }
        return this.d;
    }

    public PrivateKey getSigningKey() throws UserBadPasswordException, InvalidKeyException, NoSuchAlgorithmException {
        if (!this.n) {
            return null;
        }
        if (this.g) {
            throw new UserBadPasswordException("The password is not valid according to the password rule, change the password first with the method changePassword() before calling this function");
        }
        if (((com.entrust.toolkit.security.provider.PrivateKey)this.e).getType().equals("EntrustPrivateKey")) {
            ConfinedKey confinedKey = new ConfinedKey((k)this.e);
            return confinedKey;
        }
        if (((com.entrust.toolkit.security.provider.PrivateKey)this.e).getType().equals("TokenPrivateKey")) {
            return this.e;
        }
        return null;
    }

    public X509Certificate getRootCertificate() {
        if (!this.n) {
            return null;
        }
        return this.f;
    }

    private PKIX i() throws UserFatalException, NoSuchAlgorithmException {
        String string;
        boolean bl;
        boolean bl2 = bl = this.j.equals("") || this.j.equals("Entrust/Manager");
        if (!(this.j.equals("PKIX") || this.j.equals("PKIX_2") || bl)) {
            throw new UserFatalException("The user profile contains an invalid \"ProfileType\" setting.");
        }
        PKIX pKIX = null;
        IniFile iniFile = this.c.getIniFile();
        if (iniFile != null && (string = iniFile.getString("Entrust Settings", "Authority")) != null && string.length() != 0) {
            pKIX = new PKIXCMP();
        }
        if (pKIX == null) {
            if (bl) {
                throw new UserFatalException("Java toolkit cannot perform key management on a SEP profile.");
            }
            pKIX = this.j.equals("PKIX") ? new PKIX4() : new PKIXCMP();
        }
        return pKIX;
    }

    private byte[] a(X509Certificate x509Certificate) {
        return this.a(x509Certificate.getExtensionValue("2.5.29.14"));
    }

    public X509Certificate getEncryptionCertificate() throws UserBadPasswordException {
        if (!this.n) {
            return null;
        }
        if (this.g) {
            throw new UserBadPasswordException("The password is not valid according to the password rule, change the password first with the method changePassword() before calling this function");
        }
        return this.o;
    }

    public String[] getDecryptionSerialNumbers() {
        String[] stringArray = new String[this.r.length];
        int n2 = 0;
        while (n2 < this.r.length) {
            String string = this.r[n2];
            int n3 = string.indexOf(",");
            stringArray[n2] = string.substring(n3 + 1);
            ++n2;
        }
        return stringArray;
    }

    public PrivateKey[] getDecryptionKeys() throws UserBadPasswordException, NoSuchAlgorithmException, InvalidKeyException {
        if (!this.n) {
            return null;
        }
        if (this.g) {
            throw new UserBadPasswordException("The password is not valid according to the password rule, change the password first with the method changePassword() before calling this function");
        }
        if (this.p == null) {
            return null;
        }
        PrivateKey[] privateKeyArray = new PrivateKey[this.p.length];
        int n2 = 0;
        while (n2 < this.p.length) {
            if (((com.entrust.toolkit.security.provider.PrivateKey)this.p[n2]).getType().equals("EntrustPrivateKey")) {
                privateKeyArray[n2] = new ConfinedKey((k)this.p[n2]);
            } else if (((com.entrust.toolkit.security.provider.PrivateKey)this.p[n2]).getType().equals("TokenPrivateKey")) {
                privateKeyArray[n2] = this.p[n2];
            } else {
                throw new InvalidKeyException("Key of unspecified type!");
            }
            ++n2;
        }
        return privateKeyArray;
    }

    private PrivateKey a(Name name, String string) throws NoSuchAlgorithmException, InvalidKeyException, CodingException {
        byte[] byArray = new ASN1(name.toASN1Object()).toByteArray();
        String string2 = null;
        try {
            string2 = new String(Util.Base64Encode((byte[])byArray), "iso_8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                string2 = new String(Util.Base64Encode((byte[])byArray), "iso8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                string2 = new String(Util.Base64Encode((byte[])byArray));
            }
        }
        PEMString pEMString = new PEMString(string2);
        String string3 = String.valueOf(pEMString.getPemString()) + "," + string;
        int n2 = 0;
        while (n2 < this.l) {
            if (string3.equals(this.r[n2])) {
                return this.p[n2];
            }
            ++n2;
        }
        return null;
    }

    private PrivateKey h() throws NoSuchAlgorithmException, InvalidKeyException {
        PrivateKey privateKey = null;
        try {
            privateKey = this.a((Name)this.o.getIssuerDN(), this.o.getSerialNumber().toString());
        }
        catch (Exception exception) {
            throw new InvalidKeyException(exception.getMessage());
        }
        return privateKey;
    }

    public PrivateKey getDecryptionKey(Name name, String string) throws UserBadPasswordException, NoSuchAlgorithmException, InvalidKeyException, CodingException {
        if (!this.n) {
            return null;
        }
        if (this.g) {
            throw new UserBadPasswordException("The password is not valid according to the password rule, change the password first with the method changePassword() before calling this function");
        }
        PrivateKey privateKey = this.a(name, string);
        if (privateKey == null) {
            return null;
        }
        if (((com.entrust.toolkit.security.provider.PrivateKey)privateKey).getType().equals("EntrustPrivateKey")) {
            ConfinedKey confinedKey = new ConfinedKey((k)privateKey);
            return confinedKey;
        }
        if (((com.entrust.toolkit.security.provider.PrivateKey)privateKey).getType().equals("TokenPrivateKey")) {
            return privateKey;
        }
        throw new InvalidKeyException("Decryption key of unspecified type!");
    }

    public PrivateKey getDecryptionKey() throws UserBadPasswordException, NoSuchAlgorithmException, InvalidKeyException {
        if (!this.n) {
            return null;
        }
        if (this.g) {
            throw new UserBadPasswordException("The password is not valid according to the password rule, change the password first with the method changePassword() before calling this function");
        }
        PrivateKey privateKey = null;
        try {
            privateKey = this.getDecryptionKey((Name)this.o.getIssuerDN(), this.o.getSerialNumber().toString());
        }
        catch (Exception exception) {
            throw new InvalidKeyException(exception.getMessage());
        }
        return privateKey;
    }

    public Name[] getDecryptionIssuers() throws Base64Exception, CodingException, UnsupportedEncodingException {
        Name[] nameArray = new Name[this.r.length];
        int n2 = 0;
        while (n2 < this.r.length) {
            String string = this.r[n2];
            int n3 = string.indexOf(",");
            String string2 = string.substring(0, n3);
            byte[] byArray = Util.decodeByteArray((String)string2);
            nameArray[n2] = new Name(byArray);
            ++n2;
        }
        return nameArray;
    }

    public X509Certificate getCaCertificate() {
        if (!this.n) {
            return null;
        }
        return this.s;
    }

    private int g() {
        return (Integer)this.t.elementAt(0);
    }

    private KeyPair a(AlgorithmParameterSpec algorithmParameterSpec, String string) throws InvalidAlgorithmParameterException, NoSuchProviderException, NoSuchAlgorithmException {
        ECDSAKeyPairGenerator eCDSAKeyPairGenerator = (ECDSAKeyPairGenerator)KeyPairGenerator.getInstance(string, "Entrust");
        eCDSAKeyPairGenerator.initialize((ECParameters)algorithmParameterSpec);
        return eCDSAKeyPairGenerator.generateKeyPair();
    }

    private KeyPair a(int n2, String string) throws NoSuchProviderException, NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = null;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance(string, "Entrust");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                keyPairGenerator = KeyPairGenerator.getInstance(string, "IAIK");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                keyPairGenerator = KeyPairGenerator.getInstance(string);
            }
        }
        keyPairGenerator.initialize(n2);
        return ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
    }

    public boolean forcedKeyUpdateRequired() {
        LdapDirectory ldapDirectory = this.c.getDirectory();
        if (ldapDirectory == null) {
            return false;
        }
        byte[][] byArray = null;
        try {
            Principal principal = this.o.getSubjectDN();
            byArray = ldapDirectory.getAttr(principal.toString(), "userCertificate");
        }
        catch (Exception exception) {}
        if (byArray != null && byArray.length != 0) {
            int n2 = 0;
            while (n2 < byArray.length) {
                X509Certificate x509Certificate = null;
                try {
                    x509Certificate = new X509Certificate(byArray[n2]);
                }
                catch (Exception exception) {}
                long l = x509Certificate.getNotBefore().getTime() / 1000L;
                long l2 = this.o.getNotBefore().getTime() / 1000L;
                if (x509Certificate != null && l > l2) {
                    this.d |= 0x40;
                    this.d |= 0x80;
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean encryptionKeyUpdateRequired() throws UserBadPasswordException {
        if (this.g) {
            throw new UserBadPasswordException("The password is not valid according to the password rule, change the password first with the method changePassword() before calling this function");
        }
        Date date = null;
        Date date2 = null;
        double d2 = 0.5;
        long l = 8640000000L;
        long l2 = 0L;
        long l3 = 0L;
        date2 = new Date(this.o.getNotAfter().getTime() - this.o.getNotBefore().getTime());
        l3 = (long)((double)date2.getTime() * d2);
        if (l3 > l) {
            l3 = l;
        }
        date = new Date(this.o.getNotAfter().getTime() - l3);
        ZuluTime zuluTime = new ZuluTime(new Date());
        if (date.getTime() < zuluTime.getTime()) {
            this.d |= 0x80;
            return true;
        }
        return false;
    }

    private boolean f() throws CertificateException {
        ClientSettings clientSettings = this.c.getClientSettings();
        X509Certificate x509Certificate = clientSettings.getCaCertificate();
        if (x509Certificate.equals(this.s)) {
            return false;
        }
        return !this.c.getClientSettings().issuedByUpdatedCAkey(this.o);
    }

    private synchronized byte[] a(SecureStringBuffer secureStringBuffer, PublicKey publicKey) throws InvalidKeyException, GeneralSecurityException, NoSuchAlgorithmException {
        byte[] byArray = null;
        Cipher cipher = Cipher.getInstance("RSA/2/PKCS1Padding");
        cipher.init(1, publicKey);
        try {
            byArray = cipher.doFinal(secureStringBuffer.getStringBuffer().toString().getBytes("iso_8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                byArray = cipher.doFinal(secureStringBuffer.getStringBuffer().toString().getBytes("iso8859-1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                byArray = cipher.doFinal(secureStringBuffer.getStringBuffer().toString().getBytes());
            }
        }
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized boolean e() throws UserFatalException {
        Object object;
        PKIX pKIX = null;
        try {
            pKIX = this.i();
        }
        catch (Exception exception) {
            throw new UserFatalException("Could not update signing keys: " + exception.getMessage());
        }
        int n2 = 0;
        String string = null;
        ECParameters eCParameters = null;
        String string2 = this.c.getClientSettings().getSigningKeyType();
        try {
            string = string2.substring(0, string2.indexOf("-"));
            object = string2.substring(string2.indexOf("-") + 1, string2.length());
            n2 = Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            throw new UserFatalException("Invalid format for 'entrustSignKeyType' in the policy certificate: " + string);
        }
        if (pKIX.getVersion() == 0 && string.equalsIgnoreCase("ECDSA") || this.g() == 2) {
            string = this.e.getAlgorithm();
            if (string.equalsIgnoreCase("RSA")) {
                n2 = ((RSAPublicKey)this.b.getPublicKey()).getModulus().bitLength();
            } else {
                if (!string.equalsIgnoreCase("DSA")) throw new UserFatalException("Current signing key is of an unknown type: " + string);
                n2 = ((DSAPublicKey)this.b.getPublicKey()).getParams().getP().bitLength();
            }
        } else if (string.equalsIgnoreCase("ECDSA") && this.e.getAlgorithm().equalsIgnoreCase("ECDSA")) {
            object = (ECDSAPublicKey)this.b.getPublicKey();
            try {
                eCParameters = object.getECParameters();
            }
            catch (CodingException codingException) {}
        }
        object = null;
        boolean bl = false;
        if (this.g() == 2) {
            try {
                object = this.c.getCredentialWriter().a().a(this.t, this.b);
                bl = true;
            }
            catch (Exception exception) {}
        }
        if (!bl) {
            try {
                object = string.equalsIgnoreCase("ECDSA") && eCParameters != null ? this.a((AlgorithmParameterSpec)eCParameters, string) : this.a(n2, string);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new UserFatalException("Could not update signing keys: " + generalSecurityException.getMessage());
            }
        }
        this.c.getManagerTransport().beginNewSession();
        try {
            if (pKIX.getVersion() == 0) {
                ((PKIX4)pKIX).updateSigningKeys(this.c.getManagerTransport(), this.c.getDirectory(), this.e, this.b, this.c.getClientSettings().getCaCertificate(), (KeyPair)object, this.c.getCertVerifier());
            } else {
                ((PKIXCMP)pKIX).updateSigningKeys(this.c.getManagerTransport(), this.e, (KeyPair)object, this.b, this.c.getCertVerifier());
            }
        }
        catch (Exception exception) {
            throw new UserFatalException("Could not update signing keys: " + exception.getMessage());
        }
        X509Certificate x509Certificate = this.b;
        try {
            this.e = pKIX.getSigningKey();
        }
        catch (Exception exception) {
            throw new UserFatalException("Could not get signing key!");
        }
        this.b = pKIX.getVerificationCertificate();
        try {
            this.a(x509Certificate, this.e, this.b);
            this.a(pKIX);
        }
        catch (Exception exception) {
            throw new UserFatalException("Could not get signing key: " + exception.toString());
        }
        this.writeProfile();
        try {
            pKIX.sendConfirmation(this.c.getManagerTransport());
            if (this.g() == 2) {
                Object[] objectArray = this.c.getCredentialWriter().a().b(this.t, this.b);
                this.e = (PrivateKey)objectArray[0];
                this.p = (PrivateKey[])objectArray[1];
                this.r = (String[])objectArray[2];
            }
            this.c.getManagerTransport().endSession();
            return true;
        }
        catch (Exception exception) {
            throw new UserFatalException("Could not complete key update: " + exception.getMessage());
        }
    }

    private synchronized boolean d() throws UserFatalException {
        PrivateKey[] privateKeyArray;
        PrivateKey[] privateKeyArray2;
        Object object;
        Object object2;
        PKIX pKIX = null;
        try {
            pKIX = this.i();
        }
        catch (Exception exception) {
            throw new UserFatalException("Could not update encryption keys: " + exception.getMessage());
        }
        PrivateKey privateKey = null;
        try {
            privateKey = this.h();
        }
        catch (Exception exception) {
            throw new UserFatalException("Could not update encryption keys!");
        }
        String string = null;
        int n2 = 0;
        String string2 = this.c.getClientSettings().getUserEncKeyAlgm();
        try {
            string = string2.substring(0, string2.indexOf("-"));
            object2 = string2.substring(string2.indexOf("-") + 1, string2.length());
            n2 = Integer.parseInt((String)object2);
        }
        catch (Exception exception) {
            throw new UserFatalException("Invalid format for 'entrustUserEncAlgm' in the policy certificate: " + string);
        }
        object2 = null;
        try {
            object2 = this.a(n2, string);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new UserFatalException("Unable to generate protocol encryption keys: " + generalSecurityException.getMessage());
        }
        KeyPair keyPair = null;
        boolean bl = true;
        if (!this.c.getClientSettings().getKeyBackupAllowed()) {
            object = null;
            int n3 = 0;
            privateKeyArray2 = this.c.getClientSettings().getEncryptionKeyType();
            try {
                object = privateKeyArray2.substring(0, privateKeyArray2.indexOf("-"));
                privateKeyArray = privateKeyArray2.substring(privateKeyArray2.indexOf("-") + 1, privateKeyArray2.length());
                n3 = Integer.parseInt((String)privateKeyArray);
            }
            catch (Exception exception) {
                throw new UserFatalException("Invalid format for 'entrustEncKeyType' in the policy certificate: " + string);
            }
            if (this.g() == 2) {
                object = this.p[0].getAlgorithm();
                if (object.equalsIgnoreCase("RSA")) {
                    n3 = ((RSAPublicKey)this.o.getPublicKey()).getModulus().bitLength();
                } else {
                    throw new UserFatalException("Current decryption key is of an unknown type: " + (String)object);
                }
            }
            try {
                keyPair = this.a(n3, (String)object);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new UserFatalException("Unable to generate new encryption keys: " + generalSecurityException.getMessage());
            }
        }
        this.c.getManagerTransport().beginNewSession();
        try {
            if (pKIX.getVersion() == 0) {
                ((PKIX4)pKIX).updateEncryptionKeys(this.c.getManagerTransport(), (KeyPair)object2, this.c.getDirectory(), this.e, this.b, this.p, this.o, this.r, this.c.getClientSettings().getCaCertificate(), this.c.getCertVerifier());
            } else {
                ((PKIXCMP)pKIX).updateEncryptionKeys(this.c.getManagerTransport(), (KeyPair)object2, this.e, keyPair, this.b, this.o, this.c.getCertVerifier());
            }
            this.q = (int)(System.currentTimeMillis() / 1000L);
        }
        catch (Exception exception) {
            throw new UserFatalException("Could not update encryption keys: " + exception.getMessage());
        }
        this.o = pKIX.getEncryptionCertificate();
        if (pKIX.getVersion() == 0) {
            this.r = pKIX.getCertificateHistory();
            try {
                this.p = pKIX.getDecryptionKeys();
            }
            catch (Exception exception) {
                throw new UserFatalException("Could not get decryption private keys!");
            }
            this.l = pKIX.getNumberOfPrivateKeys();
        } else {
            object = new String[this.r.length + 1];
            System.arraycopy(this.r, 0, object, 0, this.r.length);
            X509CertificateWrapper x509CertificateWrapper = new X509CertificateWrapper(this.o);
            object[this.r.length] = x509CertificateWrapper.getHistoryName();
            this.r = object;
            privateKeyArray2 = new PrivateKey[this.p.length + 1];
            System.arraycopy(this.p, 0, privateKeyArray2, 0, this.p.length);
            try {
                privateKeyArray = pKIX.getDecryptionKeys();
                privateKeyArray2[this.p.length] = privateKeyArray[privateKeyArray.length - 1];
            }
            catch (Exception exception) {
                throw new UserFatalException("Could not get decryption private keys!");
            }
            this.p = privateKeyArray2;
            this.l = this.p.length;
        }
        try {
            this.a(privateKey, this.o.getPublicKey());
            this.a(pKIX);
        }
        catch (Exception exception) {
            throw new UserFatalException("Failed to update the encryption key: " + exception.toString());
        }
        this.writeProfile();
        try {
            if (this.g() == 2) {
                object = this.c.getCredentialWriter().a().c(this.t);
                this.p = (PrivateKey[])object[0];
                this.r = (String[])object[1];
            }
            pKIX.sendConfirmation(this.c.getManagerTransport());
            this.c.getManagerTransport().endSession();
        }
        catch (Exception exception) {
            throw new UserFatalException("Could not complete key update: " + exception.getMessage());
        }
        return true;
    }

    public void doRequiredKeyUpdates() throws UserFatalException {
        block12: {
            if (this.g || !this.n) {
                return;
            }
            try {
                if (this.DNChangeRequired()) {
                    if (this.k()) {
                        this.DNChange();
                    }
                    break block12;
                }
                if (this.forcedKeyUpdateRequired()) {
                    if (this.k()) {
                        this.c.updateSigningKeys();
                        this.c.updateEncryptionKeys();
                    }
                    break block12;
                }
                if (this.signingKeyUpdateRequired() && this.k()) {
                    this.c.updateSigningKeys();
                }
                boolean bl = false;
                try {
                    this.c.getCertVerifier().getCertificateStore().validate(this.o);
                }
                catch (CertificationException certificationException) {
                    bl = true;
                }
                if (this.encryptionKeyUpdateRequired()) {
                    bl = true;
                }
                if (bl && this.k()) {
                    this.c.updateEncryptionKeys();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized boolean c() throws UserBadPasswordException, UserFatalException {
        Object object;
        Object object2;
        ECParameters eCParameters;
        Object object3;
        String string;
        Object object4;
        PKIX pKIX = null;
        try {
            pKIX = this.i();
        }
        catch (Exception exception) {
            throw new UserFatalException("Could not change-DN: " + exception.getMessage());
        }
        PrivateKey privateKey = null;
        try {
            privateKey = this.h();
        }
        catch (Exception exception) {
            throw new UserFatalException("Could not update encryption keys!");
        }
        String string2 = null;
        int n2 = 0;
        String string3 = this.c.getClientSettings().getUserEncKeyAlgm();
        try {
            string2 = string3.substring(0, string3.indexOf("-"));
            object4 = string3.substring(string3.indexOf("-") + 1, string3.length());
            n2 = Integer.parseInt((String)object4);
        }
        catch (Exception exception) {
            throw new UserFatalException("Invalid format for 'entrustUserEncAlgm' in the policy certificate: " + string2);
        }
        object4 = null;
        try {
            object4 = this.a(n2, string2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new UserFatalException("Unable to generate protocol encryption keys: " + generalSecurityException.getMessage());
        }
        KeyPair keyPair = null;
        boolean bl = true;
        if (!this.c.getClientSettings().getKeyBackupAllowed()) {
            string = null;
            int n3 = 0;
            object3 = this.c.getClientSettings().getEncryptionKeyType();
            try {
                string = ((String)object3).substring(0, ((String)object3).indexOf("-"));
                eCParameters = ((String)object3).substring(((String)object3).indexOf("-") + 1, ((String)object3).length());
                n3 = Integer.parseInt((String)eCParameters);
            }
            catch (Exception exception) {
                throw new UserFatalException("Invalid format for 'entrustEncKeyType' in the policy certificate: " + string2);
            }
            if (this.g() == 2) {
                string = this.p[0].getAlgorithm();
                if (!string.equalsIgnoreCase("RSA")) throw new UserFatalException("Current decryption key is of an unknown type: " + string);
                n3 = ((RSAPublicKey)this.o.getPublicKey()).getModulus().bitLength();
            }
            try {
                keyPair = this.a(n3, string);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new UserFatalException("Unable to generate new encryption keys: " + generalSecurityException.getMessage());
            }
        }
        this.c.getManagerTransport().beginNewSession();
        try {
            if (pKIX.getVersion() == 0) {
                ((PKIX4)pKIX).updateEncryptionKeys(this.c.getManagerTransport(), (KeyPair)object4, this.c.getDirectory(), this.e, this.b, this.p, this.o, this.r, this.c.getClientSettings().getCaCertificate(), this.c.getCertVerifier());
            } else {
                ((PKIXCMP)pKIX).updateEncryptionKeys(this.c.getManagerTransport(), (KeyPair)object4, this.e, keyPair, this.b, this.o, this.c.getCertVerifier());
            }
            this.q = (int)(System.currentTimeMillis() / 1000L);
        }
        catch (Exception exception) {
            throw new UserFatalException("Could not update encryption keys: " + exception.getMessage());
        }
        string = this.o;
        this.o = pKIX.getEncryptionCertificate();
        if (string.getSubjectDN().equals(this.o.getSubjectDN())) {
            throw new UserFatalException("DN change was not performed");
        }
        if (pKIX.getVersion() == 0) {
            this.r = pKIX.getCertificateHistory();
            try {
                this.p = pKIX.getDecryptionKeys();
            }
            catch (Exception exception) {
                throw new UserFatalException("Could not get decryption private keys!");
            }
            this.l = pKIX.getNumberOfPrivateKeys();
        } else {
            String[] stringArray = new String[this.r.length + 1];
            System.arraycopy(this.r, 0, stringArray, 0, this.r.length);
            object3 = new X509CertificateWrapper(this.o);
            stringArray[this.r.length] = ((X509CertificateWrapper)object3).getHistoryName();
            this.r = stringArray;
            eCParameters = new PrivateKey[this.p.length + 1];
            System.arraycopy(this.p, 0, eCParameters, 0, this.p.length);
            try {
                object2 = pKIX.getDecryptionKeys();
                eCParameters[this.p.length] = object2[((PrivateKey[])object2).length - 1];
            }
            catch (Exception exception) {
                throw new UserFatalException("Could not get decryption private keys!");
            }
            this.p = eCParameters;
            this.l = this.p.length;
        }
        try {
            this.a(privateKey, this.o.getPublicKey());
            this.a(pKIX);
        }
        catch (Exception exception) {
            throw new UserFatalException("Failed to update the encryption key: " + exception.toString());
        }
        this.writeProfile();
        try {
            if (this.g() == 2) {
                Object[] objectArray = this.c.getCredentialWriter().a().c(this.t);
                this.p = (PrivateKey[])objectArray[0];
                this.r = (String[])objectArray[1];
            }
            pKIX.sendConfirmation(this.c.getManagerTransport());
            this.c.getManagerTransport().endSession();
        }
        catch (Exception exception) {
            throw new UserFatalException("Could not complete key update: " + exception.getMessage());
        }
        int n4 = 0;
        object3 = null;
        eCParameters = null;
        object2 = this.c.getClientSettings().getSigningKeyType();
        try {
            object3 = ((String)object2).substring(0, ((String)object2).indexOf("-"));
            object = ((String)object2).substring(((String)object2).indexOf("-") + 1, ((String)object2).length());
            n4 = Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            throw new UserFatalException("Invalid format for 'entrustSignKeyType' in the policy certificate: " + (String)object3);
        }
        if (pKIX.getVersion() == 0 && ((String)object3).equalsIgnoreCase("ECDSA") || this.g() == 2) {
            object3 = this.e.getAlgorithm();
            if (((String)object3).equalsIgnoreCase("RSA")) {
                n4 = ((RSAPublicKey)this.b.getPublicKey()).getModulus().bitLength();
            } else {
                if (!((String)object3).equalsIgnoreCase("DSA")) throw new UserFatalException("Current signing key is of an unknown type: " + (String)object3);
                n4 = ((DSAPublicKey)this.b.getPublicKey()).getParams().getP().bitLength();
            }
        } else if (((String)object3).equalsIgnoreCase("ECDSA") && this.e.getAlgorithm().equalsIgnoreCase("ECDSA")) {
            object = (ECDSAPublicKey)this.b.getPublicKey();
            try {
                eCParameters = object.getECParameters();
            }
            catch (CodingException codingException) {}
        }
        object = null;
        boolean bl2 = false;
        if (this.g() == 2) {
            try {
                object = this.c.getCredentialWriter().a().a(this.t, this.b);
                bl2 = true;
            }
            catch (Exception exception) {}
        }
        if (!bl2) {
            try {
                object = ((String)object3).equalsIgnoreCase("ECDSA") && n4 == 0 ? this.a((AlgorithmParameterSpec)eCParameters, (String)object3) : this.a(n4, (String)object3);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new UserFatalException("Could not update signing keys: " + generalSecurityException.getMessage());
            }
        }
        this.c.getManagerTransport().beginNewSession();
        try {
            if (pKIX.getVersion() == 0) {
                ((PKIX4)pKIX).updateSigningKeys(this.c.getManagerTransport(), this.c.getDirectory(), this.e, this.b, this.c.getClientSettings().getCaCertificate(), (KeyPair)object, this.c.getCertVerifier());
            } else {
                ((PKIXCMP)pKIX).updateSigningKeys(this.c.getManagerTransport(), this.e, (KeyPair)object, this.b, this.c.getCertVerifier());
            }
        }
        catch (Exception exception) {
            throw new UserFatalException("Could not update signing keys: " + exception.getMessage());
        }
        X509Certificate x509Certificate = this.b;
        try {
            this.e = pKIX.getSigningKey();
        }
        catch (Exception exception) {
            throw new UserFatalException("Could not get signing key!");
        }
        this.b = pKIX.getVerificationCertificate();
        if (!this.b.getSubjectDN().equals(this.o.getSubjectDN())) {
            throw new UserFatalException("Signing and Encryption Certificate DNs were not equal");
        }
        try {
            this.a(x509Certificate, this.e, this.b);
            this.a(pKIX);
        }
        catch (Exception exception) {
            throw new UserFatalException("Could not get signing key: " + exception.toString());
        }
        this.m = this.o.getSubjectDN().toString();
        this.writeProfile();
        try {
            pKIX.sendConfirmation(this.c.getManagerTransport());
            this.c.getManagerTransport().endSession();
            if (this.g() != 2) return true;
            Object[] objectArray = this.c.getCredentialWriter().a().b(this.t, this.b);
            this.e = (PrivateKey)objectArray[0];
            this.p = (PrivateKey[])objectArray[1];
            this.r = (String[])objectArray[2];
            return true;
        }
        catch (Exception exception) {
            throw new UserFatalException("Could not complete key update: " + exception.getMessage());
        }
    }

    private synchronized SecureStringBuffer a(byte[] byArray, PrivateKey privateKey) throws InvalidKeyException, GeneralSecurityException, NoSuchAlgorithmException {
        SecureStringBuffer secureStringBuffer = null;
        Cipher cipher = Cipher.getInstance("RSA/2/PKCS1Padding");
        cipher.init(2, privateKey);
        try {
            secureStringBuffer = new SecureStringBuffer(new StringBuffer(new String(cipher.doFinal(byArray), "iso_8859-1")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                secureStringBuffer = new SecureStringBuffer(new StringBuffer(new String(cipher.doFinal(byArray), "iso8859-1")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                secureStringBuffer = new SecureStringBuffer(new StringBuffer(new String(cipher.doFinal(byArray))));
            }
        }
        return secureStringBuffer;
    }

    private synchronized void a(PrivateKey privateKey, PublicKey publicKey) throws UserFatalException, NoSuchAlgorithmException {
        byte[] byArray = (byte[])this.t.elementAt(1);
        try {
            byArray = this.a(this.a(byArray, privateKey), publicKey);
        }
        catch (Exception exception) {
            if (exception instanceof NoSuchAlgorithmException) {
                throw new NoSuchAlgorithmException(exception.getMessage());
            }
            throw new UserFatalException("Could not encrypt password with new encryption key!");
        }
        this.t.setElementAt(byArray, 1);
    }

    private boolean b() {
        LdapDirectory ldapDirectory = this.c.getDirectory();
        if (this.q != 0 && ldapDirectory != null) {
            byte[][] byArray = null;
            try {
                Principal principal = this.o.getSubjectDN();
                byArray = ldapDirectory.getAttr(principal.toString(), "userCertificate");
            }
            catch (Exception exception) {}
            if (byArray != null && byArray.length != 0) {
                int n2 = 0;
                while (n2 < byArray.length) {
                    X509Certificate x509Certificate = null;
                    try {
                        x509Certificate = new X509Certificate(byArray[n2]);
                    }
                    catch (Exception exception) {}
                    if (x509Certificate != null && x509Certificate.getSerialNumber().equals(this.o.getSerialNumber())) {
                        this.q = 0;
                        if ((this.d & 0x800) != 0) {
                            this.d ^= 0x800;
                        }
                        return true;
                    }
                    if (n2 == byArray.length - 1 && (int)(System.currentTimeMillis() / 1000L) > this.q + 86400) {
                        this.d |= 0x800;
                    }
                    ++n2;
                }
            }
        }
        return false;
    }

    public void checkPwd(CredentialWriter credentialWriter) throws UserBadPasswordException {
        byte[] byArray = (byte[])this.t.elementAt(1);
        try {
            SecureStringBuffer secureStringBuffer = this.a(byArray, this.h());
            credentialWriter.checkPwd(this.c, secureStringBuffer);
        }
        catch (Exception exception) {
            throw new UserBadPasswordException("The current password is not valid for this credential writer.");
        }
    }

    private void a(CertVerifier certVerifier) throws UserBadPasswordException, UserFatalException, CertificateException, UserCertificateRevokedException {
        if (certVerifier == null) {
            return;
        }
        try {
            certVerifier.getCertificateStore().validate(this.s);
        }
        catch (CertificationException certificationException) {
            throw new CertificateException("The ca certificate is not valid: " + certificationException.getMessage());
        }
        try {
            certVerifier.getCertificateStore().validate(this.b);
        }
        catch (CertificationException certificationException) {
            throw new CertificateException("The signing certificate is not valid: " + certificationException.getMessage());
        }
    }

    public synchronized void changePassword(SecureStringBuffer secureStringBuffer, SecureStringBuffer secureStringBuffer2) throws UserBadPasswordException, UserFatalException {
        if (this.c.getCredentialWriter() == null) {
            throw new UserFatalException("Cannot change password if no CredentialWriter is set in user!");
        }
        if (this.m()) {
            if (!this.c.getCredentialWriter().getType().equals("SingleLoginWriter")) {
                throw new UserFatalException("Wrong CredentialWriter used. For SingleLogin, only SingleLoginWriter can be used!");
            }
            this.c.getCredentialWriter().a().a(this.t, secureStringBuffer, secureStringBuffer2);
            this.g = false;
            return;
        }
        byte[] byArray = null;
        try {
            int n2;
            if (!this.n) {
                throw new UserFatalException("Not logged on!");
            }
            this.c.isOnline();
            if (this.c.getCredentialWriter() == null) {
                throw new UserFatalException("Cannot change password if no CredentialWriter is set in user!");
            }
            ClientSettings clientSettings = this.a(false);
            try {
                clientSettings.getPasswordRuleTester().validatePassword(secureStringBuffer2, this.i);
            }
            catch (Exception exception) {
                throw new UserFatalException("New password violates password rules: " + exception.getMessage());
            }
            try {
                byArray = this.a(secureStringBuffer2, this.o.getPublicKey());
            }
            catch (Exception exception) {
                throw new UserFatalException("Failure by changing the Password: " + exception.getMessage());
            }
            if (this.g() == 2) {
                if (this.c.getCredentialWriter().getType().equals("TokenWriter")) {
                    this.c.getCredentialWriter().a().a(this.t, secureStringBuffer, secureStringBuffer2);
                } else {
                    throw new UserFatalException("Wrong CredentialWriter used. For tokens, only TokenWriter can be used!");
                }
            }
            if ((n2 = this.c.getClientSettings().getPasswordRuleTester().getNotReuseLastPasswords()) != 0) {
                if (n2 <= this.i.length) {
                    this.a(this.i.length - n2 + 1);
                }
                this.a(secureStringBuffer2);
            } else {
                this.i = new ByteArray[0];
                this.h = 0;
            }
        }
        catch (Exception exception) {
            secureStringBuffer2.wipe();
            secureStringBuffer.wipe();
            throw new UserFatalException("Could not change password: " + exception.getMessage());
        }
        secureStringBuffer2.wipe();
        secureStringBuffer.wipe();
        this.t.setElementAt(byArray, 1);
        this.writeProfile();
        this.g = false;
        this.doRequiredKeyUpdates();
    }

    public void blockELILogout() {
        if (!this.n) {
            return;
        }
        this.u = true;
    }

    private void a(SecureStringBuffer secureStringBuffer) throws UserFatalException {
        ExtendedHasher extendedHasher = null;
        extendedHasher = new ExtendedHasher();
        try {
            extendedHasher.setInput(secureStringBuffer.toString().getBytes("iso_8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                extendedHasher.setInput(secureStringBuffer.toString().getBytes("iso8859-1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                extendedHasher.setInput(secureStringBuffer.toString().getBytes());
            }
        }
        ByteArray[] byteArrayArray = this.i;
        int n2 = this.i.length;
        this.i = new ByteArray[n2 + 1];
        int n3 = 0;
        while (n3 < n2) {
            this.i[n3] = byteArrayArray[n3];
            ++n3;
        }
        this.i[n2] = new ByteArray(extendedHasher.getOutput(20, 2));
        this.h = (int)(System.currentTimeMillis() / 1000L);
    }

    private void a(X509Certificate x509Certificate, PrivateKey privateKey) throws InvalidKeyException {
        X509CertificateWrapper x509CertificateWrapper = new X509CertificateWrapper(x509Certificate);
        String string = x509CertificateWrapper.getHistoryName();
        PrivateKey[] privateKeyArray = new PrivateKey[this.p.length + 1];
        System.arraycopy(this.p, 0, privateKeyArray, 1, this.p.length);
        privateKeyArray[0] = privateKey;
        this.p = privateKeyArray;
        String[] stringArray = new String[this.r.length + 1];
        System.arraycopy(this.r, 0, stringArray, 1, this.r.length);
        stringArray[0] = string;
        this.r = stringArray;
        ++this.l;
    }

    void a() {
        if (!this.n) {
            return;
        }
        if (this.u) {
            this.v = true;
        } else {
            this.logout();
        }
    }

    public boolean DNChangeRequired() {
        LdapDirectory ldapDirectory = this.c.getDirectory();
        if (ldapDirectory == null) {
            return false;
        }
        byte[][] byArray = null;
        try {
            Principal principal = this.o.getSubjectDN();
            byArray = ldapDirectory.getAttr(principal.toString(), "userCertificate");
        }
        catch (Exception exception) {}
        if (byArray == null || byArray.length == 0) {
            this.d |= 0x400;
            return true;
        }
        return false;
    }

    public synchronized boolean DNChange() throws UserBadPasswordException, UserFatalException {
        if (!this.l()) {
            return false;
        }
        if (this.c.getCredentialReader().getType().equals("SingleLoginReader")) {
            return false;
        }
        if (this.c()) {
            this.d |= 0x200;
            if ((this.d & 0x400) != 0) {
                this.d ^= 0x400;
            }
        } else {
            this.d |= 0x400;
            return false;
        }
        try {
            this.s = this.c.getClientSettings().getCaCertificate();
            this.f = this.c.getClientSettings().getRootCaCertificate();
            this.writeProfile();
        }
        catch (CertificateException certificateException) {}
        return true;
    }

    public Profile(CredentialReader credentialReader, User user, SecureStringBuffer secureStringBuffer) throws KeyException, CertificateException, UserCertificateRevokedException, UserFatalException, UserBadPasswordException {
        this.a(credentialReader, user, secureStringBuffer);
    }
}

