/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.credentials;

import com.entrust.toolkit.User;
import com.entrust.toolkit.credentials.c;
import com.entrust.toolkit.credentials.u;
import com.entrust.toolkit.exceptions.PasswordException;
import com.entrust.toolkit.exceptions.UserBadPasswordException;
import com.entrust.toolkit.exceptions.UserFatalException;
import com.entrust.toolkit.security.provider.AnsiRandom;
import com.entrust.toolkit.security.provider.SeedGenerator;
import com.entrust.toolkit.security.provider.k;
import com.entrust.toolkit.util.ByteArray;
import com.entrust.toolkit.util.ExtendedHasher;
import com.entrust.toolkit.util.IniFile;
import com.entrust.toolkit.util.MacGenerator;
import com.entrust.toolkit.util.PEMString;
import com.entrust.toolkit.util.SecureStringBuffer;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.security.cipher.SecretKey;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import java.util.Vector;
import javax.crypto.Cipher;

class m
extends u {
    private boolean a = true;
    protected static final int DEFAULT_HASH_COUNT = 10000;
    protected static final int DEFAULT_PROTECTION_LEN = 128;
    protected static final String DEFAULT_ALGORITHM = "pbeWithSHA1AndCAST5-CBC";
    protected SecretKey m_protectionKey = null;
    protected SecretKey m_tamperKey = null;
    protected AlgorithmParameterSpec m_protectionParms = null;
    protected int m_hashCount = 0;
    byte[] c = null;
    protected String m_token = null;
    protected String m_salt = null;
    protected int m_protectionLen = 0;
    protected String m_protectionAlg = null;
    protected IniFile m_iniFile = new IniFile();
    OutputStream b = null;

    boolean c() {
        return this.a;
    }

    synchronized void b() throws UserFatalException {
        this.a = false;
        this.m_iniFile.writeStream(this.b);
        try {
            this.b.close();
            this.b = null;
        }
        catch (IOException iOException) {
            throw new UserFatalException("Could not close output stream: " + iOException.getMessage());
        }
    }

    private final void a(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = 0;
            ++n2;
        }
        byArray = null;
    }

    void a() {
        this.m_tamperKey.destroyCriticalData();
        this.m_protectionKey.destroyCriticalData();
    }

    Object[] b(Vector vector, X509Certificate x509Certificate) throws UserFatalException {
        return null;
    }

    KeyPair a(Vector vector, X509Certificate x509Certificate) throws UserFatalException {
        return null;
    }

    Object[] c(Vector vector) throws UserFatalException {
        return null;
    }

    void c(int n2) {
        this.m_iniFile.putInt("Password Token", "Profile Version", n2);
    }

    void d(String string) {
        this.m_iniFile.putString("Password Token", "Token", string);
    }

    void a(PrivateKey privateKey) throws KeyException {
        String string = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        ExtendedHasher extendedHasher = null;
        byte[] byArray5 = null;
        try {
            if (privateKey instanceof k) {
                byArray = ((k)privateKey).a();
                int n2 = 17;
                byArray2 = new byte[n2];
                byArray3 = new byte[byArray.length - n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                System.arraycopy(byArray, n2, byArray3, 0, byArray3.length);
                n2 = 0;
                extendedHasher = new ExtendedHasher();
                extendedHasher.setInput(byArray2);
                byArray5 = new byte[byArray3.length];
                byArray4 = extendedHasher.getOutput(byArray3.length, 1);
                int n3 = 0;
                while (n3 < byArray3.length) {
                    byArray5[n3] = (byte)(byArray4[n3] & 0xFF ^ byArray3[n3] & 0xFF);
                    ++n3;
                }
                string = this.a(byArray5, "Digital Signature", "Key");
                extendedHasher.wipe();
                this.a(byArray5);
                byArray5 = null;
                this.a(byArray);
                byArray = null;
                this.a(byArray3);
                byArray3 = null;
                this.a(byArray2);
                byArray2 = null;
                this.a(byArray4);
                byArray4 = null;
            } else {
                string = this.a(privateKey.getEncoded(), "Digital Signature", "Key");
            }
        }
        catch (Exception exception) {
            this.a(byArray5);
            byArray5 = null;
            this.a(byArray);
            byArray = null;
            this.a(byArray3);
            byArray3 = null;
            this.a(byArray2);
            byArray2 = null;
            this.a(byArray4);
            byArray4 = null;
            throw new KeyException("Could not set signing key: " + exception.getMessage());
        }
        this.m_iniFile.putString("Digital Signature", "&Key", string);
    }

    void d(X509Certificate x509Certificate) throws CertificateException {
        String string = null;
        try {
            string = this.a(x509Certificate.getEncoded(), "Digital Signature", "Certificate");
        }
        catch (Exception exception) {
            throw new CertificateException("Could not set signing certificate: " + exception.getMessage());
        }
        this.m_iniFile.putString("Digital Signature", "&Certificate", string);
    }

    private void c(String string) {
        this.m_iniFile.putString("Password Token", "SaltValue", string);
    }

    void c(X509Certificate x509Certificate) throws CertificateException {
        try {
            String string = this.a(x509Certificate.getEncoded(), "ROOT CA", "Certificate");
            this.m_iniFile.putString("ROOT CA", "&Certificate", string);
        }
        catch (Exception exception) {
            throw new CertificateException("Could not set Root CA: " + exception.getMessage());
        }
    }

    private void e(int n2) {
        this.m_iniFile.putInt("Password Token", "Protection", n2);
    }

    private void b(String string) {
        this.m_protectionAlg = string;
        this.m_iniFile.putString("Password Token", "MAC Algorithm", string);
    }

    void a(int n2, ByteArray[] byteArrayArray) throws UserFatalException {
        byte[] byArray = new byte[4];
        int n3 = 0;
        while (n3 < 4) {
            int n4 = (int)Math.pow(256.0, n3 + 1);
            int n5 = n2 % n4;
            n2 -= n5;
            byArray[3 - n3] = (byte)((double)n5 / Math.pow(256.0, n3));
            ++n3;
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        BigInteger bigInteger = new BigInteger(byArray);
        INTEGER iNTEGER = new INTEGER(bigInteger);
        sEQUENCE.addComponent((ASN1Object)iNTEGER);
        SEQUENCE sEQUENCE2 = new SEQUENCE();
        OCTET_STRING oCTET_STRING = new OCTET_STRING();
        int n6 = 0;
        while (n6 < byteArrayArray.length) {
            oCTET_STRING = new OCTET_STRING(byteArrayArray[n6].getArray());
            sEQUENCE2.addComponent((ASN1Object)oCTET_STRING);
            ++n6;
        }
        sEQUENCE.addComponent((ASN1Object)sEQUENCE2);
        ASN1 aSN1 = null;
        String string = null;
        try {
            aSN1 = new ASN1((ASN1Object)sEQUENCE);
            byte[] byArray2 = aSN1.toByteArray();
            string = this.a(byArray2, "Protected", "pwHistory");
        }
        catch (Exception exception) {
            throw new UserFatalException("Could not set password history token: " + exception.getMessage());
        }
        this.m_iniFile.putString("Protected", "&pwHistory", string);
    }

    void b(Vector vector) throws UserFatalException {
        String string;
        StringBuffer stringBuffer = new StringBuffer("Options");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            int n2 = string.indexOf("=");
            stringBuffer.append(string.substring(0, n2));
            stringBuffer.append(string.substring(n2 + 1));
        }
        string = com.entrust.toolkit.credentials.c.a(stringBuffer.toString(), this.m_protectionAlg, this.m_tamperKey);
        this.m_iniFile.putString("Password Token", "Options MAC", string);
    }

    void a(Vector vector) {
        this.m_iniFile.putSection("Options", vector);
    }

    void b(int n2) {
        this.m_iniFile.putInt("Private Keys", "KeyCount", n2);
    }

    void a(String string) throws UserFatalException {
        StringBuffer stringBuffer = new StringBuffer("User X.500 NameX500name");
        stringBuffer.append(string);
        String string2 = com.entrust.toolkit.credentials.c.a(stringBuffer.toString(), this.m_protectionAlg, this.m_tamperKey);
        this.m_iniFile.putString("Password Token", "User X.500 Name MAC", string2);
    }

    void setName(String string) {
        this.m_iniFile.putString("User X.500 Name", "X500name", string);
    }

    private void d(int n2) {
        this.m_iniFile.putInt("Password Token", "HashCount", n2);
    }

    void a(PrivateKey[] privateKeyArray, int n2) throws KeyException {
        String string = "";
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        ExtendedHasher extendedHasher = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        int n3 = 0;
        while (n3 < n2) {
            try {
                if (privateKeyArray[n3] instanceof k) {
                    byArray = ((k)privateKeyArray[n3]).a();
                    int n4 = 17;
                    byArray2 = new byte[n4];
                    byArray3 = new byte[byArray.length - n4];
                    System.arraycopy(byArray, 0, byArray2, 0, n4);
                    System.arraycopy(byArray, n4, byArray3, 0, byArray3.length);
                    n4 = 0;
                    extendedHasher = new ExtendedHasher();
                    extendedHasher.setInput(byArray2);
                    byArray5 = new byte[byArray3.length];
                    byArray4 = extendedHasher.getOutput(byArray3.length, 1);
                    int n5 = 0;
                    while (n5 < byArray3.length) {
                        byArray5[n5] = (byte)(byArray4[n5] & 0xFF ^ byArray3[n5] & 0xFF);
                        ++n5;
                    }
                    string = this.a(byArray5, "Private Keys", "Key" + new Integer(n3 + 1).toString());
                    extendedHasher.wipe();
                    this.a(byArray5);
                    byArray5 = null;
                    this.a(byArray);
                    byArray = null;
                    this.a(byArray3);
                    byArray3 = null;
                    this.a(byArray2);
                    byArray2 = null;
                    this.a(byArray4);
                    byArray4 = null;
                } else {
                    string = this.a(privateKeyArray[n3].getEncoded(), "Private Keys", "Key" + new Integer(n3 + 1).toString());
                }
            }
            catch (Exception exception) {
                this.a(byArray5);
                byArray5 = null;
                this.a(byArray);
                byArray = null;
                this.a(byArray3);
                byArray3 = null;
                this.a(byArray2);
                byArray2 = null;
                this.a(byArray4);
                byArray4 = null;
                throw new KeyException("Could not set encryption key: " + exception.getMessage());
            }
            this.m_iniFile.putString("Private Keys", "&Key" + new Integer(n3 + 1).toString(), string);
            ++n3;
        }
    }

    void b(X509Certificate x509Certificate) throws CertificateException {
        String string = null;
        try {
            string = this.a(x509Certificate.getEncoded(), "User Certificate", "Certificate");
        }
        catch (Exception exception) {
            throw new CertificateException("Could not set encryption certificate: " + exception.getMessage());
        }
        this.m_iniFile.putString("User Certificate", "&Certificate", string);
    }

    void a(String[] stringArray, int n2) throws UserFatalException {
        int n3 = 1;
        while (n3 <= n2) {
            String string = null;
            try {
                try {
                    string = this.a(stringArray[n3 - 1].getBytes("iso_8859-1"), "Certificate History", "Name" + new Integer(n3));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    try {
                        string = this.a(stringArray[n3 - 1].getBytes("iso8859-1"), "Certificate History", "Name" + new Integer(n3));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException2) {
                        string = this.a(stringArray[n3 - 1].getBytes(), "Certificate History", "Name" + new Integer(n3));
                    }
                }
            }
            catch (Exception exception) {
                throw new UserFatalException("Could not set certificate history: " + exception.getMessage());
            }
            this.m_iniFile.putString("Certificate History", "&Name" + new Integer(n3), string);
            ++n3;
        }
    }

    void a(X509Certificate x509Certificate) throws CertificateException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        String string = null;
        try {
            sEQUENCE.addComponent(new ASN1(x509Certificate.getEncoded()).toASN1Object());
            string = this.a(new ASN1((ASN1Object)sEQUENCE).toByteArray(), "CA Certificates", "Certificate");
        }
        catch (Exception exception) {
            throw new CertificateException("Could not set CA certificate: " + exception.getMessage());
        }
        this.m_iniFile.putString("CA Certificates", "&Certificate", string);
    }

    void a(int n2) {
        String string = com.entrust.toolkit.credentials.c.a(this.m_salt, this.m_token, this.m_protectionLen, n2, this.m_protectionAlg, this.m_hashCount);
        this.m_iniFile.putString("Password Token", "CRC", string);
    }

    private synchronized String a(byte[] byArray, String string, String string2) throws GeneralSecurityException, InvalidKeyException, NoSuchAlgorithmException, UserFatalException {
        if (this.m_protectionAlg == null) {
            throw new UserFatalException("Protection algorithm not set!");
        }
        if (this.m_tamperKey == null || this.m_protectionKey == null || this.m_protectionParms == null) {
            throw new UserFatalException("The attributes are not set!");
        }
        Cipher cipher = null;
        if (this.m_protectionAlg.equals(DEFAULT_ALGORITHM)) {
            cipher = Cipher.getInstance("CAST5/CBC/PKCS5Padding");
        } else if (this.m_protectionAlg.equals("pbeWithSHA1AndDES-CBC")) {
            cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
        } else if (this.m_protectionAlg.equals("pbeWithSHA1AndDES-EDE3-CBC")) {
            cipher = Cipher.getInstance("3DES/CBC/PKCS5Padding");
        } else if (this.m_protectionAlg.equals("pbeWithSHA1AndIDEA-CBC")) {
            cipher = Cipher.getInstance("IDEA/CBC/PKCS5Padding");
        } else {
            throw new NoSuchAlgorithmException("Unknown algorithm: " + this.m_protectionAlg);
        }
        byte[] byArray2 = null;
        try {
            byArray2 = new byte[string.length() + string2.length() + byArray.length];
            System.arraycopy(string.getBytes("iso_8859-1"), 0, byArray2, 0, string.length());
            System.arraycopy(string2.getBytes("iso_8859-1"), 0, byArray2, string.length(), string2.length());
            System.arraycopy(byArray, 0, byArray2, string.length() + string2.length(), byArray.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                byArray2 = new byte[string.length() + string2.length() + byArray.length];
                System.arraycopy(string.getBytes("iso8859-1"), 0, byArray2, 0, string.length());
                System.arraycopy(string2.getBytes("iso8859-1"), 0, byArray2, string.length(), string2.length());
                System.arraycopy(byArray, 0, byArray2, string.length() + string2.length(), byArray.length);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                byArray2 = new byte[string.length() + string2.length() + byArray.length];
                System.arraycopy(string.getBytes(), 0, byArray2, 0, string.length());
                System.arraycopy(string2.getBytes(), 0, byArray2, string.length(), string2.length());
                System.arraycopy(byArray, 0, byArray2, string.length() + string2.length(), byArray.length);
            }
        }
        byte[] byArray3 = MacGenerator.generate((String)this.m_protectionAlg, (Key)this.m_tamperKey, (byte[])byArray2);
        byte[] byArray4 = new byte[byArray2.length + 8];
        System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
        System.arraycopy(byArray3, 0, byArray4, byArray2.length, 8);
        cipher.init(1, (Key)this.m_protectionKey, this.m_protectionParms);
        String string3 = null;
        try {
            string3 = new String(Util.Base64Encode((byte[])cipher.doFinal(byArray4)), "iso_8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                string3 = new String(Util.Base64Encode((byte[])cipher.doFinal(byArray4)), "iso8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException3) {
                string3 = new String(Util.Base64Encode((byte[])cipher.doFinal(byArray4)));
            }
        }
        PEMString pEMString = new PEMString(string3);
        return pEMString.getPemString();
    }

    void a(Vector vector, PrivateKey privateKey) throws UserFatalException {
        int n2 = (Integer)vector.elementAt(0);
        if (n2 == 0) {
            if (this.m_protectionAlg == null) {
                this.m_protectionAlg = (String)vector.elementAt(2);
                this.m_protectionLen = (Integer)vector.elementAt(3);
            }
            if (this.m_hashCount == 0) {
                this.m_hashCount = (Integer)vector.elementAt(4);
            }
            this.m_salt = (String)vector.elementAt(5);
        } else if (n2 == 1 || n2 == 1 || n2 == 5) {
            if (this.m_protectionAlg == null) {
                this.m_protectionAlg = DEFAULT_ALGORITHM;
                this.m_protectionLen = 128;
            }
            if (this.m_hashCount == 0) {
                this.m_hashCount = 10000;
            }
            try {
                this.m_salt = this.d();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new UserFatalException("Could not generate salt: " + noSuchAlgorithmException.getMessage());
            }
        } else if (n2 != 3) {
            throw new UserFatalException("Credentials read with the used CredentialReader can't be written with that CredentialWriter!");
        }
        byte[] byArray = (byte[])vector.elementAt(1);
        SecureStringBuffer secureStringBuffer = null;
        try {
            secureStringBuffer = this.a(byArray, privateKey);
        }
        catch (Exception exception) {
            throw new UserFatalException("Could not decrypt password: " + exception.getMessage());
        }
        try {
            com.entrust.toolkit.credentials.c.a(secureStringBuffer, this.m_salt, this.m_protectionLen, this.m_hashCount, this.m_protectionAlg);
            this.m_protectionKey = com.entrust.toolkit.credentials.c.a();
            this.m_tamperKey = com.entrust.toolkit.credentials.c.c();
            this.m_protectionParms = com.entrust.toolkit.credentials.c.b();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            secureStringBuffer.wipe();
            throw new UserFatalException("Could not generate symmetric keys: " + noSuchAlgorithmException.getMessage());
        }
        this.c(this.m_salt);
        this.m_token = com.entrust.toolkit.credentials.c.a(this.m_protectionAlg, this.m_protectionKey, this.m_protectionParms);
        this.d(this.m_token);
        this.e(this.m_protectionLen);
        this.b(this.m_protectionAlg);
        this.d(this.m_hashCount);
    }

    private String d() throws NoSuchAlgorithmException {
        SeedGenerator seedGenerator = new SeedGenerator();
        byte[] byArray = new byte[20];
        byArray = seedGenerator.getStrongSeed(null);
        AnsiRandom ansiRandom = new AnsiRandom();
        ansiRandom.setSeed(byArray);
        byte[] byArray2 = new byte[8];
        ansiRandom.nextBytes(byArray2);
        try {
            return new String(Util.Base64Encode((byte[])byArray2), "iso_8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                return new String(Util.Base64Encode((byte[])byArray2), "iso8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                return new String(Util.Base64Encode((byte[])byArray2));
            }
        }
    }

    private synchronized SecureStringBuffer a(byte[] byArray, PrivateKey privateKey) throws PasswordException, InvalidKeyException, GeneralSecurityException, NoSuchAlgorithmException {
        SecureStringBuffer secureStringBuffer = null;
        Cipher cipher = Cipher.getInstance("RSA/2/PKCS1Padding");
        cipher.init(2, privateKey);
        try {
            secureStringBuffer = new SecureStringBuffer(new StringBuffer(new String(cipher.doFinal(byArray), "iso_8859-1")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                secureStringBuffer = new SecureStringBuffer(new StringBuffer(new String(cipher.doFinal(byArray), "iso8859-1")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                secureStringBuffer = new SecureStringBuffer(new StringBuffer(new String(cipher.doFinal(byArray))));
            }
        }
        return secureStringBuffer;
    }

    void a(User user, SecureStringBuffer secureStringBuffer) throws CertificateException, UserBadPasswordException {
        user.getClientSettings().getPasswordRuleTester().validatePassword(secureStringBuffer);
    }

    void a(Vector vector, SecureStringBuffer secureStringBuffer, SecureStringBuffer secureStringBuffer2) throws UserFatalException {
    }

    public m(String string, int n2) throws NoSuchAlgorithmException, UserFatalException {
        if (string != null) {
            this.m_protectionAlg = string;
            if (string.equals(DEFAULT_ALGORITHM)) {
                this.m_protectionLen = 128;
            }
            if (string.equals("pbeWithSHA1AndDES-CBC")) {
                this.m_protectionLen = 64;
            }
            if (string.equals("pbeWithSHA1AndDES-EDE3-CBC")) {
                this.m_protectionLen = 192;
            }
            if (string.equals("pbeWithSHA1AndIDEA-CBC")) {
                this.m_protectionLen = 128;
            }
            if (this.m_protectionLen == 0) {
                throw new NoSuchAlgorithmException("Invalid algorithm: " + string);
            }
        }
        if (n2 != 0 && n2 < 2000) {
            throw new UserFatalException("Invalid hash count, when specified (not zero) it must be at least 2000, found " + n2);
        }
        this.m_hashCount = n2;
    }

    m(OutputStream outputStream, String string, int n2) throws NoSuchAlgorithmException, UserFatalException {
        this(string, n2);
        this.b = outputStream;
    }
}

