/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.util;

import com.entrust.toolkit.util.LdapURLParser;
import iaik.asn1.structures.Name;

public class LdapURL {
    private LdapURLParser a;
    protected String extensions = null;
    protected String filter = null;
    protected int scope = -1;
    protected String attributes = null;
    protected Name dn = null;
    protected int port = -1;
    protected String host = null;
    protected String scheme = null;
    public static final int SCOPE_SUB = 3;
    public static final int SCOPE_ONE = 2;
    public static final int SCOPE_BASE = 1;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.scheme != null) {
            stringBuffer.append(String.valueOf(this.scheme) + ":");
        }
        if (this.host != null) {
            stringBuffer.append("//" + this.host);
        }
        if (this.port != -1) {
            stringBuffer.append(":" + this.port);
        }
        if (this.dn != null) {
            stringBuffer.append("/" + this.dn);
        }
        if (this.attributes != null) {
            stringBuffer.append("?" + this.attributes);
        }
        if (this.scope != -1) {
            switch (this.scope) {
                case 1: {
                    stringBuffer.append("?base");
                    break;
                }
                case 2: {
                    stringBuffer.append("?one");
                    break;
                }
                case 3: {
                    stringBuffer.append("?sub");
                    break;
                }
                case -1: {
                    stringBuffer.append("?InvalidScope");
                    break;
                }
            }
        }
        if (this.filter != null) {
            stringBuffer.append("?" + this.filter);
        }
        if (this.extensions != null) {
            stringBuffer.append("?" + this.extensions);
        }
        return stringBuffer.toString();
    }

    private void a() {
        this.scheme = this.a.parseScheme();
        this.host = this.a.parseHost();
        this.port = this.a.parsePort();
        this.dn = this.a.parseDN();
        this.attributes = this.a.parseAttributes();
        this.filter = this.a.parseFilter();
        this.scope = this.a.parseScope();
        this.extensions = this.a.parseExtensions();
    }

    public static boolean isLdapURL(String string) {
        return string.startsWith("ldap://");
    }

    public boolean isLdapURL() {
        return this.a.isLdapURL();
    }

    public boolean isEmpty() {
        return this.host.equals(null) && this.dn.equals(null);
    }

    public int getScope() {
        return this.scope;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getExtensions() {
        return this.extensions;
    }

    public Name getDN() {
        return this.dn;
    }

    public String getAttributes() {
        return this.attributes;
    }

    public LdapURL(String string) throws Exception {
        this.a = new LdapURLParser(string);
        this.a();
    }
}

