/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.util;

import com.entrust.toolkit.exceptions.LdapURLException;
import iaik.asn1.structures.Name;
import iaik.utils.RFC2253NameParser;
import iaik.utils.RFC2253NameParserException;

public class LdapURLParser {
    private int f = -1;
    private int e = -1;
    private int b = -1;
    private int h = -1;
    private int g = -1;
    private int c = -1;
    private int d = -1;
    private int i;
    private String a;

    private String a(String string) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            switch (c2) {
                case '%': {
                    try {
                        stringBuffer.append((char)Integer.parseInt(string.substring(n2 + 1, n2 + 3), 16));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    n2 += 2;
                    break;
                }
                default: {
                    stringBuffer.append(c2);
                    break;
                }
            }
            ++n2;
        }
        String string2 = stringBuffer.toString();
        byte[] byArray = string2.getBytes("8859_1");
        return new String(byArray);
    }

    public int parseScope() {
        if (this.b == -1 || this.b >= this.i - 1 || this.b == this.e - 1) {
            return 1;
        }
        String string = this.e == -1 ? this.a.substring(this.b + 1) : this.a.substring(this.b + 1, this.e);
        if (string.equals("base")) {
            return 1;
        }
        if (string.equals("one")) {
            return 2;
        }
        if (string.equals("sub")) {
            return 3;
        }
        return -1;
    }

    public String parseScheme() {
        if (this.isLdapURL()) {
            if (this.d != -1) {
                return this.a.substring(0, this.d);
            }
            return this.a.substring(0, this.d - 3);
        }
        return null;
    }

    public int parsePort() {
        if (this.c == -1 || this.c >= this.i - 1) {
            return 389;
        }
        if (this.g == -1) {
            String string = this.a.substring(this.c + 1);
            return Integer.parseInt(string);
        }
        String string = this.a.substring(this.c + 1, this.g);
        return Integer.parseInt(string);
    }

    public String parseHost() {
        if (this.d == -1 || this.d + 2 >= this.i - 1 || this.d + 2 == this.g - 1) {
            return null;
        }
        if (this.g == -1) {
            return this.a.substring(this.d + 3);
        }
        if (this.c == -1) {
            return this.a.substring(this.d + 3, this.g);
        }
        return this.a.substring(this.d + 3, this.c);
    }

    public String parseFilter() {
        if (this.e == -1 || this.e >= this.i - 1 || this.e == this.f - 1) {
            return "(objectclass=*)";
        }
        if (this.f == -1) {
            return this.a.substring(this.e + 1);
        }
        return this.a.substring(this.e + 1, this.f);
    }

    public String parseExtensions() {
        if (this.f == -1 || this.f >= this.i - 1) {
            return null;
        }
        return this.a.substring(this.f + 1);
    }

    public Name parseDN() {
        if (this.g == -1 || this.g >= this.i - 1 || this.g + 1 == this.h) {
            return null;
        }
        String string = this.h == -1 ? this.a.substring(this.g + 1) : this.a.substring(this.g + 1, this.h);
        if (string == null) {
            return null;
        }
        try {
            RFC2253NameParser rFC2253NameParser = new RFC2253NameParser(string);
            Name name = rFC2253NameParser.parse();
            return name;
        }
        catch (RFC2253NameParserException rFC2253NameParserException) {
            System.out.println("DN parse error: " + rFC2253NameParserException.getMessage());
            return null;
        }
        catch (Exception exception) {
            System.out.println("DN parse error: " + exception.getMessage());
            return null;
        }
    }

    public String parseAttributes() {
        if (this.h == -1 || this.h >= this.i - 1 || this.h == this.b - 1) {
            return null;
        }
        if (this.b == -1) {
            return this.a.substring(this.h + 1);
        }
        return this.a.substring(this.h + 1, this.b);
    }

    public boolean isLdapURL() {
        return this.a.startsWith("ldap://");
    }

    public LdapURLParser(String string) throws LdapURLException {
        try {
            this.a = this.a(string);
        }
        catch (Exception exception) {
            throw new LdapURLException("URL string contains invalid charecter" + exception.getMessage());
        }
        this.i = this.a.length();
        if (!this.isLdapURL()) {
            throw new LdapURLException("Not a LDAP URL.");
        }
        try {
            this.d = this.a.indexOf(58);
            if (this.d < this.i) {
                this.c = this.a.indexOf(58, this.d + 1);
                this.g = this.a.indexOf(47, this.d + 3);
            }
            if (this.g != -1 && this.g < this.i) {
                this.h = this.a.indexOf(63, this.g + 1);
                if (this.h != -1 && this.h < this.i) {
                    this.b = this.a.indexOf(63, this.h + 1);
                    if (this.b != -1 && this.b < this.i) {
                        this.e = this.a.indexOf(63, this.b + 1);
                        if (this.e != -1 && this.e < this.i) {
                            this.f = this.a.indexOf(63, this.e + 1);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            String string2 = "Invalid LDAP URL format." + exception.getMessage();
            System.out.print(string2);
            throw new LdapURLException(string2);
        }
    }
}

