/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.util;

import com.entrust.toolkit.util.ByteArray;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class ManagerTransport {
    private boolean c = false;
    private static int e = 180000;
    private int a = 0;
    private String b = null;
    protected String recipientAddress = null;
    private Socket d = null;
    protected OutputStream out = null;
    protected InputStream in = null;

    private static final int a(byte by) {
        if (by < 0) {
            return by + 256;
        }
        return by;
    }

    public void setStreams(InputStream inputStream, OutputStream outputStream, String string) {
        this.c = false;
        this.in = inputStream;
        this.out = outputStream;
        this.recipientAddress = string;
        this.DNSLookup();
    }

    public void setClientCredentials(X509Certificate x509Certificate, X509Certificate x509Certificate2, PrivateKey privateKey) {
    }

    public byte[] readPKIXCMPResponse(boolean bl) throws GeneralSecurityException, IOException {
        int n2;
        this.out.flush();
        if (!bl) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(this.in);
        int n3 = dataInputStream.readInt();
        byte by = (byte)this.in.read();
        if (by != 5) {
            throw new IOException("The TCP stream header is incorrect.  flag:" + by + " IP: " + this.b + " port: " + this.a);
        }
        byte[] byArray = new byte[--n3];
        int n4 = n2 = this.in.read(byArray);
        while (n4 < n3) {
            n2 = this.in.read(byArray, n4, n3 - n4);
            n4 += n2;
        }
        return byArray;
    }

    public byte[] readPKIX4Response(boolean bl) throws GeneralSecurityException {
        byte[] byArray = null;
        try {
            this.out.flush();
            if (bl) {
                byArray = ManagerTransport.readManagerTransportMessage(this.in);
            }
            return byArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static final byte[] readManagerTransportMessage(InputStream inputStream) throws GeneralSecurityException, IOException {
        byte[] byArray = null;
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 10);
        byte[] byArray2 = new byte[9];
        int n2 = 0;
        pushbackInputStream.read(byArray2);
        ByteArray byteArray = new ByteArray(byArray2);
        n2 = ManagerTransport.calculateASNLength(byteArray.getArray());
        pushbackInputStream.unread(byArray2);
        byArray = new byte[n2];
        int n3 = -1;
        for (int j = 0; j < n2; ++j) {
            n3 = pushbackInputStream.read();
            if (n3 != -1) {
                byArray[j] = ByteArray.toByte((int)n3);
                continue;
            }
            throw new GeneralSecurityException("The input stream ended before all of the content could be read!");
        }
        return byArray;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public String getAddress() {
        if (this.recipientAddress == null) {
            return "<address not set>";
        }
        return this.recipientAddress;
    }

    public void endSession() {
        block6: {
            try {
                if (this.in != null) {
                    this.in.close();
                    this.in = null;
                }
                if (this.out != null) {
                    this.out.close();
                    this.out = null;
                }
            }
            catch (Exception exception) {}
            if (this.d == null) break block6;
            try {
                this.d.close();
                this.d = null;
            }
            catch (IOException iOException) {}
        }
    }

    void a(byte[] byArray) throws IOException {
        this.out.write(byArray);
        this.out.flush();
    }

    private void a(Socket socket) throws IOException {
        this.d = socket;
        this.d.setTcpNoDelay(true);
        this.d.setSoTimeout(e);
        this.d.setSoLinger(true, e);
        this.in = this.d.getInputStream();
        this.out = this.d.getOutputStream();
        this.a = this.d.getPort();
        if (this.recipientAddress == null || this.recipientAddress.length() == 0) {
            this.recipientAddress = this.d.getInetAddress().getHostAddress();
        }
    }

    public static final int calculateASNLength(byte[] byArray) {
        int n2;
        int n3 = 1;
        byte by = byArray[0];
        int n4 = ManagerTransport.a(by);
        if ((n4 & 0x1F) == 31) {
            do {
                n4 = ManagerTransport.a(byArray[n3]);
                ++n3;
            } while (n4 > 128);
        }
        if ((n2 = ManagerTransport.a(byArray[n3])) < 128) {
            return n2 + 2;
        }
        int n5 = 0;
        int n6 = n3 + 1;
        int n7 = (n2 -= 128) + 2;
        --n2;
        while (n2 >= 0) {
            int n8 = 1;
            int n9 = 0;
            while (n9 < n2) {
                n8 *= 256;
                ++n9;
            }
            int n10 = ManagerTransport.a(byArray[n6]) * n8;
            n5 += n10;
            --n2;
            ++n6;
        }
        return n5 + n7;
    }

    public void beginNewSession() {
        if (!this.c) {
            this.DNSLookup();
            return;
        }
        if (this.d != null) {
            try {
                this.d.close();
            }
            catch (IOException iOException) {}
        }
        boolean bl = this.b == null || this.a == 0;
        try {
            this.a(new Socket(this.b, this.a));
        }
        catch (IOException iOException) {}
    }

    protected void DNSLookup() {
        block2: {
            if (this.recipientAddress == null || this.recipientAddress.length() == 0) break block2;
            try {
                InetAddress inetAddress = InetAddress.getByName(this.recipientAddress);
                this.recipientAddress = inetAddress.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {}
        }
    }

    public ManagerTransport(String string, String string2, String string3) {
        this(string, Integer.parseInt(string2), string3);
    }

    public ManagerTransport(String string, String string2) {
        this(string, Integer.parseInt(string2));
    }

    public ManagerTransport(String string, int n2, String string2) {
        this.c = true;
        this.b = string;
        this.a = n2;
        this.recipientAddress = string2;
        this.DNSLookup();
    }

    public ManagerTransport(String string, int n2) {
        this.c = true;
        this.b = string;
        this.a = n2;
    }

    public ManagerTransport(InputStream inputStream, OutputStream outputStream, String string) {
        this.setStreams(inputStream, outputStream, string);
    }

    public ManagerTransport() {
    }
}

