/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.util;

import com.entrust.toolkit.exceptions.PKIXException;
import com.entrust.toolkit.security.provider.AnsiRandom;
import com.entrust.toolkit.security.provider.ECDSAPrivateKey;
import com.entrust.toolkit.security.provider.SeedGenerator;
import com.entrust.toolkit.security.provider.k;
import com.entrust.toolkit.util.ManagerTransport;
import com.entrust.toolkit.util.SecureStringBuffer;
import com.entrust.toolkit.x509.X509CertificateWrapper;
import iaik.security.dsa.DSAPrivateKey;
import iaik.security.rsa.RSAPrivateKey;
import iaik.x509.X509Certificate;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.util.Vector;

public abstract class PKIX {
    protected AnsiRandom ansiRandom;
    protected X509Certificate m_cert;
    protected PrivateKey m_key;
    protected SecureStringBuffer m_authCode;
    protected SecureStringBuffer m_refNo;
    protected byte[] m_recipNonce;
    protected byte[] m_senderNonce;
    protected long m_usagePeriodExpiryTime;
    protected Vector m_decryptionKeys;
    protected PrivateKey m_signingKey;
    protected Vector m_certHistories;
    protected X509Certificate m_encryptionCertificate;
    protected X509Certificate m_signingCertificate;
    protected X509Certificate m_rootCa;
    protected X509Certificate m_caCertificate;

    protected void setVerificationCertificate(X509Certificate x509Certificate) {
        this.m_signingCertificate = x509Certificate;
    }

    protected void setSigningKey(PrivateKey privateKey) {
        this.m_signingKey = privateKey;
    }

    protected void setEncryptionCertificate(X509Certificate x509Certificate) {
        this.m_encryptionCertificate = x509Certificate;
    }

    protected synchronized void setCaCertificate(X509Certificate x509Certificate) {
        this.m_caCertificate = x509Certificate;
    }

    public abstract void sendConfirmation(ManagerTransport var1) throws PKIXException, NoSuchAlgorithmException;

    public abstract int getVersion();

    public X509Certificate getVerificationCertificate() {
        return this.m_signingCertificate;
    }

    public PrivateKey getSigningKey() throws KeyException {
        if (this.m_signingKey instanceof RSAPrivateKey || this.m_signingKey instanceof DSAPrivateKey || this.m_signingKey instanceof ECDSAPrivateKey) {
            try {
                return new k(0, this.m_signingKey.getEncoded(), true, false, null);
            }
            catch (Exception exception) {
                throw new KeyException("Could not get signing key: " + exception.getMessage());
            }
        }
        return this.m_signingKey;
    }

    public X509Certificate getRootCa() {
        return this.m_rootCa;
    }

    public int getNumberOfPrivateKeys() {
        return this.m_decryptionKeys.size();
    }

    public String getName() {
        Principal principal = this.m_signingCertificate.getSubjectDN();
        return principal.getName();
    }

    public X509Certificate getEncryptionCertificate() {
        return this.m_encryptionCertificate;
    }

    public PrivateKey[] getDecryptionKeys() throws KeyException {
        int n2 = this.m_decryptionKeys.size();
        PrivateKey[] privateKeyArray = new PrivateKey[n2];
        int n3 = 0;
        while (n3 < n2) {
            PrivateKey privateKey = (PrivateKey)this.m_decryptionKeys.elementAt(n3);
            if (privateKey instanceof RSAPrivateKey) {
                try {
                    privateKeyArray[n3] = new k(0, privateKey.getEncoded(), false, true, null);
                }
                catch (Exception exception) {
                    throw new KeyException("Could not get decryption key: " + exception.getMessage());
                }
            } else {
                privateKeyArray[n3] = privateKey;
            }
            ++n3;
        }
        return privateKeyArray;
    }

    public String[] getCertificateHistory() {
        String[] stringArray = new String[this.m_certHistories.size()];
        return this.m_certHistories.toArray(stringArray);
    }

    public X509Certificate getCaCertificate() {
        return this.m_caCertificate;
    }

    protected void addToHistory(X509Certificate x509Certificate) {
        X509CertificateWrapper x509CertificateWrapper = new X509CertificateWrapper(x509Certificate);
        this.m_certHistories.add(x509CertificateWrapper.getHistoryName());
    }

    protected void addDecryptionKey(PrivateKey privateKey) {
        this.m_decryptionKeys.add(privateKey);
    }

    public PKIX() throws NoSuchAlgorithmException {
        SeedGenerator seedGenerator = new SeedGenerator();
        byte[] byArray = new byte[20];
        byArray = seedGenerator.getStrongSeed(null);
        this.ansiRandom = new AnsiRandom();
        this.ansiRandom.setSeed(byArray);
        this.m_decryptionKeys = new Vector();
        this.m_certHistories = new Vector();
    }
}

