/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.util;

import com.entrust.toolkit.asn1.structures.FullCertTemplate;
import com.entrust.toolkit.asn1.structures.PKIHeader;
import com.entrust.toolkit.exceptions.CertificationException;
import com.entrust.toolkit.exceptions.PKIXException;
import com.entrust.toolkit.security.provider.ConfinedKey;
import com.entrust.toolkit.security.provider.k;
import com.entrust.toolkit.util.ByteArray;
import com.entrust.toolkit.util.ExtendedHasher;
import com.entrust.toolkit.util.MacGenerator;
import com.entrust.toolkit.util.ManagerTransport;
import com.entrust.toolkit.util.PKIX;
import com.entrust.toolkit.util.SecureStringBuffer;
import com.entrust.toolkit.util.ZuluTime;
import com.entrust.toolkit.x509.CertVerifier;
import com.entrust.toolkit.x509.LdapDirectory;
import com.entrust.toolkit.x509.ValidationInfo;
import com.entrust.toolkit.x509.X509CertificateWrapper;
import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.IA5String;
import iaik.asn1.INTEGER;
import iaik.asn1.NULL;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.Name;
import iaik.security.cipher.SecretKey;
import iaik.security.dsa.DSAParams;
import iaik.security.dsa.DSAPublicKey;
import iaik.security.rsa.RSAPrivateKey;
import iaik.security.rsa.RSAPublicKey;
import iaik.x509.X509Certificate;
import iaik.x509.extensions.KeyUsage;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;

public final class PKIX4
extends PKIX {
    private final byte f = 23;
    private final byte d = 21;
    private final byte g = 19;
    private final byte b = 11;
    private final byte c = 9;
    private final byte a = (byte)7;
    private final byte e = 0;

    private final void b(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = 0;
            ++n2;
        }
        byArray = null;
    }

    private void a(SEQUENCE sEQUENCE, X509Certificate x509Certificate, LdapDirectory ldapDirectory) throws PKIXException {
        try {
            Name name;
            Calendar calendar;
            Object object;
            ASN1Object aSN1Object;
            SEQUENCE sEQUENCE2 = (SEQUENCE)((CON_SPEC)sEQUENCE.getComponentAt(1)).getValue();
            if (sEQUENCE2.getComponentAt(0).isA(ASN.SEQUENCE)) {
                CON_SPEC cON_SPEC = (CON_SPEC)sEQUENCE2.getComponentAt(2);
                String string = (String)((IA5String)cON_SPEC.getValue()).getValue();
                throw new PKIXException(string);
            }
            if (sEQUENCE.countComponents() < 4) {
                throw new PKIXException("Missing message protection information");
            }
            ObjectID objectID = null;
            long l = 0L;
            SEQUENCE sEQUENCE3 = (SEQUENCE)sEQUENCE.getComponentAt(0);
            Enumeration enumeration = sEQUENCE3.getComponents();
            while (enumeration.hasMoreElements()) {
                aSN1Object = (ASN1Object)enumeration.nextElement();
                if (!aSN1Object.isA(ASN.CON_SPEC)) continue;
                switch (((CON_SPEC)aSN1Object).getAsnType().getTag()) {
                    case 0: {
                        object = (String)((ASN1Object)aSN1Object.getValue()).getValue();
                        calendar = Calendar.getInstance();
                        calendar.set(1, Integer.valueOf(((String)object).substring(0, 4)));
                        calendar.set(2, Integer.valueOf(((String)object).substring(4, 6)) - 1);
                        calendar.set(5, Integer.valueOf(((String)object).substring(6, 8)));
                        calendar.set(11, Integer.valueOf(((String)object).substring(8, 10)));
                        calendar.set(12, Integer.valueOf(((String)object).substring(10, 12)));
                        calendar.set(13, Integer.valueOf(((String)object).substring(12, 14)));
                        l = calendar.getTime().getTime();
                        break;
                    }
                    case 1: {
                        objectID = (ObjectID)((ASN1Object)aSN1Object.getValue()).getComponentAt(0);
                        break;
                    }
                }
            }
            aSN1Object = (BIT_STRING)((CON_SPEC)sEQUENCE.getComponentAt(2)).getValue();
            object = (SEQUENCE)((CON_SPEC)sEQUENCE.getComponentAt(3)).getValue();
            calendar = new X509Certificate(new ASN1(object.getComponentAt(0)).toByteArray());
            CertVerifier certVerifier = new CertVerifier(x509Certificate, ldapDirectory, null);
            try {
                certVerifier.validate((X509Certificate)calendar);
            }
            catch (CertificationException certificationException) {
                throw new PKIXException("Could not validate the certificate that signed the message!");
            }
            SEQUENCE sEQUENCE4 = new SEQUENCE();
            sEQUENCE4.addComponent(sEQUENCE.getComponentAt(0));
            sEQUENCE4.addComponent(sEQUENCE.getComponentAt(1));
            if (objectID == null) {
                throw new PKIXException("No protection OID in message header");
            }
            AlgorithmID algorithmID = new AlgorithmID(objectID);
            Signature signature = null;
            try {
                signature = Signature.getInstance(algorithmID.getImplementationName(), "Entrust");
            }
            catch (Exception exception) {
                signature = Signature.getInstance(algorithmID.getImplementationName());
            }
            signature.initVerify(calendar.getPublicKey());
            signature.update(new ASN1((ASN1Object)sEQUENCE4).toByteArray());
            if (!signature.verify((byte[])aSN1Object.getValue())) {
                throw new PKIXException("Could not verify protection signature using " + objectID.getName());
            }
            Name name2 = (Name)x509Certificate.getIssuerDN();
            if (!name2.equals((Object)(name = (Name)calendar.getSubjectDN()))) {
                throw new PKIXException("Protocol certificate not issued to our CA");
            }
            KeyUsage keyUsage = (KeyUsage)calendar.getExtension(KeyUsage.oid);
            if (keyUsage != null && keyUsage.isCritical() && (keyUsage.get() & 1) == 0) {
                throw new PKIXException("No digital signature bit in keyUsage extension");
            }
        }
        catch (Exception exception) {
            throw new PKIXException(exception.getMessage());
        }
    }

    public void updateSigningKeys(ManagerTransport managerTransport, LdapDirectory ldapDirectory, PrivateKey privateKey, X509Certificate x509Certificate, X509Certificate x509Certificate2, KeyPair keyPair, ValidationInfo validationInfo) throws PKIXException, NoSuchAlgorithmException {
        byte[] byArray = null;
        Object var10_9 = null;
        Object var11_10 = null;
        Object var12_11 = null;
        this.m_cert = null;
        this.m_key = null;
        int n2 = this.ansiRandom.nextInt();
        try {
            this.m_senderNonce = new Integer(n2).toString().getBytes("iso_8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                this.m_senderNonce = new Integer(n2).toString().getBytes("iso8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                this.m_senderNonce = new Integer(n2).toString().getBytes();
            }
        }
        this.m_recipNonce = null;
        byArray = this.a(0, managerTransport.getAddress(), keyPair, privateKey, x509Certificate);
        try {
            managerTransport.getOutputStream().write(byArray);
            managerTransport.getOutputStream().flush();
        }
        catch (IOException iOException) {
            throw new PKIXException("Could not send signing key update request to the PKI: " + iOException.getMessage());
        }
        this.b(managerTransport, ldapDirectory, managerTransport.getAddress(), privateKey, x509Certificate2);
        this.setSigningKey(keyPair.getPrivate());
        this.m_cert = x509Certificate;
        this.m_key = privateKey;
    }

    public void updateEncryptionKeys(ManagerTransport managerTransport, KeyPair keyPair, LdapDirectory ldapDirectory, PrivateKey privateKey, X509Certificate x509Certificate, PrivateKey[] privateKeyArray, X509Certificate x509Certificate2, String[] stringArray, X509Certificate x509Certificate3, ValidationInfo validationInfo) throws PKIXException, NoSuchAlgorithmException {
        int n2;
        byte[] byArray = null;
        Object var13_12 = null;
        Object var14_13 = null;
        Object var15_14 = null;
        if (privateKeyArray != null) {
            n2 = 0;
            while (n2 < privateKeyArray.length) {
                this.addDecryptionKey(privateKeyArray[n2]);
                ++n2;
            }
        }
        this.setEncryptionCertificate(x509Certificate2);
        if (stringArray != null) {
            n2 = 0;
            while (n2 < stringArray.length) {
                this.m_certHistories.add(stringArray[n2]);
                ++n2;
            }
        }
        this.m_cert = null;
        this.m_key = null;
        int n3 = this.ansiRandom.nextInt();
        try {
            this.m_senderNonce = new Integer(n3).toString().getBytes("iso_8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                this.m_senderNonce = new Integer(n3).toString().getBytes("iso8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                this.m_senderNonce = new Integer(n3).toString().getBytes();
            }
        }
        this.m_recipNonce = null;
        byArray = this.a(1, managerTransport.getAddress(), keyPair, privateKey, x509Certificate);
        try {
            managerTransport.getOutputStream().write(byArray);
            managerTransport.getOutputStream().flush();
        }
        catch (IOException iOException) {
            throw new PKIXException("Could not send encryption key update request to the PKI: " + iOException.getMessage());
        }
        this.a(managerTransport, ldapDirectory, managerTransport.getAddress(), keyPair.getPrivate(), x509Certificate3);
        this.m_cert = x509Certificate;
        this.m_key = privateKey;
    }

    private byte[] a(byte[] byArray) {
        int n2 = 0;
        while (ByteArray.toInt((byte)byArray[n2]) > 127) {
            ++n2;
        }
        if (ByteArray.toInt((byte)byArray[++n2]) > 127) {
            n2 += ByteArray.toInt((byte)byArray[n2]) - 128;
        }
        byte[] byArray2 = new byte[byArray.length - ++n2];
        System.arraycopy(byArray, n2, byArray2, 0, byArray.length - n2);
        return byArray2;
    }

    private BIT_STRING a(ASN1Object aSN1Object, PrivateKey privateKey) throws PKIXException, NoSuchAlgorithmException {
        Signature signature = null;
        String string = new String();
        if (privateKey.getAlgorithm().compareTo("RSA") == 0) {
            signature = Signature.getInstance("SHA-1/RSA");
            string = "RSA";
        } else if (privateKey.getAlgorithm().compareTo("DSA") == 0) {
            try {
                signature = Signature.getInstance("DSA", "Entrust");
            }
            catch (Exception exception) {
                throw new NoSuchAlgorithmException("Could not find signature algorithm 'DSA' in provider 'Entrust'");
            }
            string = "DSA";
        } else {
            throw new PKIXException("Unknown signing key type!");
        }
        try {
            ConfinedKey confinedKey = null;
            if (privateKey instanceof k) {
                confinedKey = new ConfinedKey((k)privateKey);
            }
            if (confinedKey != null) {
                signature.initSign((PrivateKey)confinedKey);
            } else {
                signature.initSign(privateKey);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PKIXException("Old signing key is invalid: " + invalidKeyException.getMessage());
        }
        try {
            signature.update(new ASN1(aSN1Object).toByteArray());
            return new BIT_STRING(signature.sign());
        }
        catch (CodingException codingException) {
            throw new PKIXException(codingException.getMessage());
        }
        catch (SignatureException signatureException) {
            throw new PKIXException("Signing failed: " + signatureException.getMessage());
        }
    }

    public void sendConfirmation(ManagerTransport managerTransport) throws PKIXException, NoSuchAlgorithmException {
        if (this.m_refNo == null && this.m_cert == null) {
            throw new PKIXException("In wrong state to call writeComplete.");
        }
        byte[] byArray = this.m_refNo != null ? this.a(managerTransport.getAddress(), this.m_refNo, this.m_authCode) : this.a(managerTransport.getAddress(), this.m_cert, this.m_key);
        if (this.m_refNo != null) {
            this.m_refNo.wipe();
        }
        if (this.m_authCode != null) {
            this.m_authCode.wipe();
        }
        this.m_refNo = null;
        this.m_authCode = null;
        this.m_cert = null;
        this.m_key = null;
        try {
            managerTransport.getOutputStream().write(byArray);
            managerTransport.getOutputStream().flush();
            try {
                byte[] byArray2 = managerTransport.readPKIX4Response(false);
            }
            catch (Exception exception) {}
        }
        catch (IOException iOException) {
            throw new PKIXException("Could not send acknowledgement to the PKI: " + iOException.getMessage());
        }
    }

    public void recoverCertificates(KeyPair keyPair, KeyPair keyPair2, ManagerTransport managerTransport, SecureStringBuffer secureStringBuffer, SecureStringBuffer secureStringBuffer2) throws PKIXException, NoSuchAlgorithmException {
        byte[] byArray = null;
        Object var8_7 = null;
        Object var9_8 = null;
        int n2 = this.ansiRandom.nextInt();
        try {
            this.m_senderNonce = new Integer(n2).toString().getBytes("iso_8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                this.m_senderNonce = new Integer(n2).toString().getBytes("iso8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                this.m_senderNonce = new Integer(n2).toString().getBytes();
            }
        }
        this.m_recipNonce = null;
        managerTransport.beginNewSession();
        byArray = this.a(managerTransport.getAddress(), secureStringBuffer2, secureStringBuffer, keyPair, keyPair2.getPublic());
        try {
            managerTransport.getOutputStream().write(byArray);
            managerTransport.getOutputStream().flush();
        }
        catch (IOException iOException) {
            throw new PKIXException("Could not send recovery request to the PKI: " + iOException.getMessage());
        }
        this.b(managerTransport, managerTransport.getAddress(), secureStringBuffer, keyPair2.getPrivate());
        this.setSigningKey(keyPair.getPrivate());
        this.m_refNo = secureStringBuffer2;
        this.m_authCode = secureStringBuffer;
    }

    private void b(ManagerTransport managerTransport, LdapDirectory ldapDirectory, String string, PrivateKey privateKey, X509Certificate x509Certificate) throws PKIXException {
        SEQUENCE sEQUENCE = null;
        SEQUENCE sEQUENCE2 = null;
        SEQUENCE sEQUENCE3 = null;
        sEQUENCE2 = this.a(managerTransport);
        this.a((SEQUENCE)sEQUENCE2.getComponentAt(0), string);
        this.a(sEQUENCE2, x509Certificate, ldapDirectory);
        sEQUENCE = (SEQUENCE)((CON_SPEC)sEQUENCE2.getComponentAt(1)).getValue();
        try {
            this.m_caCertificate = new X509Certificate(new ASN1((ASN1Object)((SEQUENCE)((CON_SPEC)sEQUENCE.getComponentAt(0)).getValue())).toByteArray());
            sEQUENCE3 = (SEQUENCE)((SEQUENCE)sEQUENCE.getComponentAt(1)).getComponentAt(0);
            this.m_signingCertificate = new X509Certificate(new ASN1((ASN1Object)((SEQUENCE)((CON_SPEC)((SEQUENCE)sEQUENCE3.getComponentAt(2)).getComponentAt(0)).getValue())).toByteArray());
        }
        catch (CodingException codingException) {
            throw new PKIXException("Error Parsing Signing Update Response: " + codingException.getMessage());
        }
        catch (CertificateException certificateException) {
            throw new PKIXException("Failure reading CA certificate in update response: " + certificateException.getMessage());
        }
        CertVerifier certVerifier = new CertVerifier(x509Certificate, ldapDirectory, null);
        try {
            certVerifier.validate(this.getVerificationCertificate());
        }
        catch (Exception exception) {
            throw new PKIXException("Could not verify the new verification certificate!");
        }
    }

    private void b(ManagerTransport managerTransport, String string, SecureStringBuffer secureStringBuffer, PrivateKey privateKey) throws PKIXException, NoSuchAlgorithmException {
        CON_SPEC cON_SPEC = null;
        SEQUENCE sEQUENCE = null;
        Object var7_7 = null;
        Object var8_8 = null;
        SEQUENCE sEQUENCE2 = null;
        Object var10_10 = null;
        SecretKey secretKey = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        sEQUENCE = this.a(managerTransport);
        this.a(sEQUENCE, secureStringBuffer);
        this.a((SEQUENCE)sEQUENCE.getComponentAt(0), string);
        cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(1);
        if (cON_SPEC.getAsnType().getTag() != 10) {
            throw new PKIXException("This is not a key recovery response!");
        }
        SEQUENCE sEQUENCE3 = (SEQUENCE)cON_SPEC.getValue();
        CON_SPEC cON_SPEC2 = (CON_SPEC)sEQUENCE3.getComponentAt(1);
        SEQUENCE sEQUENCE4 = (SEQUENCE)cON_SPEC2.getValue();
        SEQUENCE sEQUENCE5 = (SEQUENCE)sEQUENCE4.getComponentAt(0);
        CON_SPEC cON_SPEC3 = (CON_SPEC)sEQUENCE3.getComponentAt(2);
        SEQUENCE sEQUENCE6 = (SEQUENCE)cON_SPEC3.getValue();
        SEQUENCE sEQUENCE7 = (SEQUENCE)sEQUENCE6.getComponentAt(0);
        CON_SPEC cON_SPEC4 = (CON_SPEC)sEQUENCE3.getComponentAt(3);
        SEQUENCE sEQUENCE8 = (SEQUENCE)cON_SPEC4.getValue();
        try {
            this.m_signingCertificate = new X509Certificate(new ASN1((ASN1Object)sEQUENCE4).toByteArray());
            this.m_caCertificate = new X509Certificate(new ASN1((ASN1Object)sEQUENCE7).toByteArray());
        }
        catch (CodingException codingException) {
            throw new PKIXException("Error Parsing Recovery Response: " + codingException.getMessage());
        }
        catch (CertificateException certificateException) {
            throw new PKIXException("Error reading CA certificate from recovery response: " + certificateException.getMessage());
        }
        int n2 = sEQUENCE8.countComponents();
        Cipher cipher = null;
        IvParameterSpec ivParameterSpec = null;
        int n3 = 0;
        while (n3 < n2) {
            sEQUENCE2 = (SEQUENCE)sEQUENCE8.getComponentAt(n3);
            CON_SPEC cON_SPEC5 = (CON_SPEC)sEQUENCE2.getComponentAt(1);
            SEQUENCE sEQUENCE9 = (SEQUENCE)cON_SPEC5.getValue();
            byArray3 = (byte[])((BIT_STRING)sEQUENCE9.getComponentAt(0)).getValue();
            X509Certificate x509Certificate = null;
            try {
                x509Certificate = new X509Certificate(new ASN1((ASN1Object)((SEQUENCE)((CON_SPEC)sEQUENCE2.getComponentAt(0)).getValue())).toByteArray());
            }
            catch (CodingException codingException) {
                throw new PKIXException("Error Parsing Recovery Response: " + codingException.getMessage());
            }
            catch (CertificateException certificateException) {
                throw new PKIXException("Error reading encryption certificate from recovery response: " + certificateException.getMessage());
            }
            try {
                ASN1 aSN1;
                Object object;
                if (n3 == 0) {
                    byArray = (byte[])((BIT_STRING)((CON_SPEC)sEQUENCE9.getComponentAt(2)).getValue()).getValue();
                    cipher = Cipher.getInstance("RSA/2/PKCS1Padding");
                    try {
                        cipher.init(2, privateKey);
                    }
                    catch (InvalidKeyException invalidKeyException) {
                        throw new PKIXException("Could not get symmetric encryption key, invalid protocol key: " + invalidKeyException.getMessage());
                    }
                    byArray2 = cipher.doFinal(byArray);
                    object = (CON_SPEC)sEQUENCE9.getComponentAt(1);
                    aSN1 = (SEQUENCE)object.getValue();
                    SEQUENCE sEQUENCE10 = (SEQUENCE)aSN1.getComponentAt(1);
                    OCTET_STRING oCTET_STRING = (OCTET_STRING)sEQUENCE10.getComponentAt(0);
                    byArray4 = (byte[])oCTET_STRING.getValue();
                    secretKey = new SecretKey(byArray2, "CAST128");
                }
                ivParameterSpec = new IvParameterSpec(byArray4);
                cipher = Cipher.getInstance("CAST5/CBC/PKCS5Padding");
                try {
                    cipher.init(2, (Key)secretKey, ivParameterSpec);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new PKIXException("Could not get private encryption key, invalid symmetric encryption key: " + invalidKeyException.getMessage());
                }
                object = cipher.doFinal(byArray3);
                aSN1 = null;
                try {
                    aSN1 = new ASN1(object);
                }
                catch (CodingException codingException) {
                    throw new PKIXException("Error Parsing Recovery Response: " + codingException.getMessage());
                }
                try {
                    this.addDecryptionKey((PrivateKey)new RSAPrivateKey(aSN1.toByteArray()));
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new PKIXException("Could not store private encryption key, invalid key: " + invalidKeyException.getMessage());
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new PKIXException("Error Parsing Recovery Response: " + generalSecurityException.getMessage());
            }
            this.addToHistory(x509Certificate);
            if (n3 == n2 - 1) {
                this.m_encryptionCertificate = x509Certificate;
            }
            ++n3;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void a(ManagerTransport var1_1, LdapDirectory var2_2, String var3_3, PrivateKey var4_4, X509Certificate var5_5) throws PKIXException, NoSuchAlgorithmException {
        var6_6 = null;
        var7_7 = null;
        var8_8 = null;
        var9_9 = null;
        var10_10 = null;
        var11_11 = null;
        var12_12 = null;
        var13_13 = null;
        var14_14 = null;
        var15_15 = null;
        var16_16 = null;
        var17_17 = null;
        var18_18 = null;
        var19_19 = null;
        var20_20 = 0;
        var7_7 = this.a(var1_1);
        this.a((SEQUENCE)var7_7.getComponentAt(0), var3_3);
        this.a(var7_7, var5_5, var2_2);
        var6_6 = (SEQUENCE)((CON_SPEC)var7_7.getComponentAt(1)).getValue();
        try {
            this.m_caCertificate = new X509Certificate(new ASN1((ASN1Object)((SEQUENCE)((CON_SPEC)var6_6.getComponentAt(0)).getValue())).toByteArray());
        }
        catch (CodingException var21_21) {
            throw new PKIXException("Error Parsing Encryption Update Response: " + var21_21.getMessage());
        }
        catch (CertificateException var21_22) {
            throw new PKIXException("Error reading CA certificate from update response: " + var21_22.getMessage());
        }
        var8_8 = (SEQUENCE)((SEQUENCE)var6_6.getComponentAt(1)).getComponentAt(0);
        var9_9 = (SEQUENCE)var8_8.getComponentAt(2);
        var10_10 = (SEQUENCE)((CON_SPEC)var9_9.getComponentAt(0)).getValue();
        try {
            this.setEncryptionCertificate(new X509Certificate(new ASN1((ASN1Object)var10_10).toByteArray()));
        }
        catch (CodingException var21_23) {
            throw new PKIXException("Error Parsing Encryption Update Response: " + var21_23.getMessage());
        }
        catch (CertificateException var21_24) {
            throw new PKIXException("Failure reading encryption certificate in update response: " + var21_24.getMessage());
        }
        var11_11 = (SEQUENCE)((CON_SPEC)var9_9.getComponentAt(1)).getValue();
        var14_14 = (BIT_STRING)var11_11.getComponentAt(0);
        var15_15 = (BIT_STRING)((CON_SPEC)var11_11.getComponentAt(2)).getValue();
        try {
            block17: {
                var17_17 = Cipher.getInstance("RSA/2/PKCS1Padding");
                try {
                    var17_17.init(2, var4_4);
                }
                catch (InvalidKeyException var21_25) {
                    throw new PKIXException("Could not get symmetric encryption key, invalid protocol key: " + var21_25.getMessage());
                }
                var16_16 = new SecretKey(var17_17.doFinal((byte[])var15_15.getValue()), "CAST128");
                var12_12 = (SEQUENCE)((CON_SPEC)var11_11.getComponentAt(1)).getValue();
                try {
                    var13_13 = (SEQUENCE)var12_12.getComponentAt(1);
                    var19_19 = (byte[])((OCTET_STRING)var13_13.getComponentAt(0)).getValue();
                    var20_20 = ((BigInteger)((INTEGER)var13_13.getComponentAt(1)).getValue()).intValue();
                    break block17;
                }
                catch (Exception v0) {
                    var20_20 = 128;
                    var19_19 = new byte[8];
                    var21_26 = 0;
                    ** while (var21_26 < 8)
                }
lbl-1000:
                // 1 sources

                {
                    var19_19[var21_26] = 0;
                    ++var21_26;
                    continue;
                }
            }
            var18_18 = new IvParameterSpec(var19_19);
            var17_17 = Cipher.getInstance("CAST5/CBC/PKCS5Padding");
            try {
                var17_17.init(2, (Key)var16_16, var18_18);
                this.addDecryptionKey((PrivateKey)new RSAPrivateKey(var17_17.doFinal((byte[])var14_14.getValue())));
            }
            catch (InvalidKeyException var21_27) {
                throw new PKIXException("Could not get private key, invalid symmetric encryption key: " + var21_27.getMessage());
            }
        }
        catch (GeneralSecurityException var21_28) {
            throw new PKIXException("Error Parsing Encryption Update Response: " + var21_28.getMessage());
        }
        var21_29 = new CertVerifier(var5_5, var2_2, null);
        try {
            var21_29.validate(this.getEncryptionCertificate());
        }
        catch (Exception v1) {
            throw new PKIXException("Could not verify the new encryption certificate!");
        }
        this.addToHistory(this.m_encryptionCertificate);
    }

    private void a(ManagerTransport managerTransport, String string, SecureStringBuffer secureStringBuffer, PrivateKey privateKey) throws PKIXException, NoSuchAlgorithmException {
        Object var5_5 = null;
        SEQUENCE sEQUENCE = null;
        ASN1Object aSN1Object = null;
        CON_SPEC cON_SPEC = null;
        ASN1Object aSN1Object2 = null;
        SEQUENCE sEQUENCE2 = null;
        SEQUENCE sEQUENCE3 = null;
        SEQUENCE sEQUENCE4 = null;
        ASN1Object aSN1Object3 = null;
        int n2 = -1;
        int n3 = 0;
        Object var16_16 = null;
        Object var17_17 = null;
        Object var18_18 = null;
        Object var19_19 = null;
        ASN1Object aSN1Object4 = null;
        SEQUENCE sEQUENCE5 = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        SecretKey secretKey = null;
        Cipher cipher = null;
        byte[] byArray4 = null;
        Object var28_28 = null;
        Object var29_29 = null;
        ASN1Object aSN1Object5 = null;
        sEQUENCE = this.a(managerTransport);
        this.a(sEQUENCE, secureStringBuffer);
        SEQUENCE sEQUENCE6 = null;
        Object var32_32 = null;
        sEQUENCE6 = (SEQUENCE)sEQUENCE.getComponentAt(0);
        this.a(sEQUENCE6, string);
        aSN1Object = sEQUENCE.getComponentAt(1);
        if (!aSN1Object.isA(ASN.CON_SPEC)) {
            throw new PKIXException("Format for return message incorrect - body is not context specific.");
        }
        cON_SPEC = (CON_SPEC)aSN1Object;
        if (cON_SPEC.getAsnType().getTag() == 23) {
            aSN1Object = (ASN1Object)cON_SPEC.getValue();
            String string2 = null;
            try {
                string2 = (String)((ASN1Object)aSN1Object.getComponentAt(2).getValue()).getValue();
            }
            catch (CodingException codingException) {
                throw new PKIXException("Body does not have correct tag in return message: " + codingException.getMessage());
            }
            throw new PKIXException(string2);
        }
        if (cON_SPEC.getAsnType().getTag() != 1) {
            throw new PKIXException("Body does not have correct tag in return message.");
        }
        aSN1Object = (ASN1Object)cON_SPEC.getValue();
        aSN1Object2 = ((SEQUENCE)aSN1Object).getComponentAt(n3);
        if (aSN1Object2.isA(ASN.CON_SPEC)) {
            aSN1Object2 = (ASN1Object)((CON_SPEC)aSN1Object2).getValue();
            ++n3;
            try {
                byte[] byArray5 = new ASN1(aSN1Object2).toByteArray();
                X509Certificate x509Certificate = null;
                try {
                    x509Certificate = new X509Certificate(byArray5);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new PKIXException("Failure by reading CA certificate: " + generalSecurityException.getMessage());
                }
                this.setCaCertificate(x509Certificate);
            }
            catch (CodingException codingException) {
                throw new PKIXException("The format of the CA certificate is incorrect: " + codingException.getMessage());
            }
        }
        if ((sEQUENCE2 = (SEQUENCE)((SEQUENCE)aSN1Object).getComponentAt(n3)).countComponents() != 2) {
            throw new PKIXException("Number of elements in the cert response sequence !=2.");
        }
        int n4 = 0;
        while (n4 < 2) {
            Object object;
            sEQUENCE3 = (SEQUENCE)sEQUENCE2.getComponentAt(n4);
            aSN1Object3 = sEQUENCE3.getComponentAt(0);
            n2 = ((BigInteger)aSN1Object3.getValue()).intValue();
            if (n2 == 1) {
                aSN1Object5 = ((SEQUENCE)sEQUENCE3.getComponentAt(2)).getComponentAt(0);
                if (!aSN1Object5.isA(ASN.CON_SPEC)) {
                    throw new PKIXException("Signing certificate is not in the correct format.");
                }
                sEQUENCE4 = (SEQUENCE)aSN1Object5.getValue();
                try {
                    byte[] byArray6 = new ASN1((ASN1Object)sEQUENCE4).toByteArray();
                    object = null;
                    try {
                        object = new X509Certificate(byArray6);
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        throw new PKIXException("Failure by reading signing certificate: " + generalSecurityException.getMessage());
                    }
                    this.setVerificationCertificate((X509Certificate)object);
                }
                catch (CodingException codingException) {
                    throw new PKIXException("Could not decode signing certificate: " + codingException.getMessage());
                }
            }
            if (n2 == 2) {
                int n5 = 0;
                while (n5 < 2) {
                    Object object2;
                    try {
                        aSN1Object4 = sEQUENCE3.getComponentAt(2).getComponentAt(n5);
                    }
                    catch (CodingException codingException) {
                        throw new PKIXException("Could not parse out encryption certificate: " + codingException.getMessage());
                    }
                    if (aSN1Object4 == null) break;
                    if (!aSN1Object4.isA(ASN.CON_SPEC)) {
                        throw new PKIXException("Certificate is not an optional context specific value.");
                    }
                    if (((CON_SPEC)aSN1Object4).getAsnType().getTag() == 0) {
                        sEQUENCE4 = (SEQUENCE)((CON_SPEC)aSN1Object4).getValue();
                        try {
                            object = new ASN1((ASN1Object)sEQUENCE4).toByteArray();
                            object2 = null;
                            try {
                                object2 = new X509Certificate((byte[])object);
                            }
                            catch (GeneralSecurityException generalSecurityException) {
                                throw new PKIXException("Failure by reading encryption certificate: " + generalSecurityException.getMessage());
                            }
                            this.setEncryptionCertificate((X509Certificate)object2);
                        }
                        catch (CodingException codingException) {
                            throw new PKIXException("Encryption Certificate could not be parsed: " + codingException.getMessage());
                        }
                    }
                    if (((CON_SPEC)aSN1Object4).getAsnType().getTag() == 2) {
                        sEQUENCE5 = (SEQUENCE)aSN1Object4.getValue();
                        byArray = (byte[])sEQUENCE5.getComponentAt(0).getValue();
                        int n6 = 1;
                        while (n6 < sEQUENCE5.countComponents()) {
                            aSN1Object4 = sEQUENCE5.getComponentAt(n6);
                            if (!aSN1Object4.isA(ASN.CON_SPEC)) {
                                throw new PKIXException("Interesting format in private key structure.  Can't read it.");
                            }
                            if (((CON_SPEC)aSN1Object4).getAsnType().getTag() == 2) {
                                byArray3 = (byte[])((BIT_STRING)aSN1Object4.getValue()).getValue();
                            }
                            ++n6;
                        }
                        try {
                            object2 = Cipher.getInstance("RSA/2/PKCS1Padding");
                            try {
                                ((Cipher)object2).init(2, privateKey);
                            }
                            catch (InvalidKeyException invalidKeyException) {
                                throw new PKIXException("Could not get symmetric encryption key, invalid protocol key: " + invalidKeyException.getMessage());
                            }
                            byArray2 = ((Cipher)object2).doFinal(byArray3);
                            secretKey = new SecretKey(byArray2, "CAST128");
                            cipher = Cipher.getInstance("CAST5/CBC/PKCS5Padding");
                            byte[] byArray7 = new byte[8];
                            int n7 = 0;
                            while (n7 < 8) {
                                byArray7[n7] = 0;
                                ++n7;
                            }
                            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray7);
                            try {
                                cipher.init(2, (Key)secretKey, ivParameterSpec);
                            }
                            catch (InvalidKeyException invalidKeyException) {
                                throw new PKIXException("Could not get private key, invalid symmetric encryption key: " + invalidKeyException.getMessage());
                            }
                            byArray4 = cipher.doFinal(byArray);
                            try {
                                this.addDecryptionKey((PrivateKey)new RSAPrivateKey(byArray4));
                            }
                            catch (InvalidKeyException invalidKeyException) {
                                throw new PKIXException("Could not read encryption private keys, invalid format: " + invalidKeyException.getMessage());
                            }
                            this.addToHistory(this.m_encryptionCertificate);
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            throw new PKIXException("Failure by parsing certificate request: " + generalSecurityException.getMessage());
                        }
                    }
                    throw new PKIXException("Unexpected value returned in encryption template.");
                    ++n5;
                }
            }
            ++n4;
        }
    }

    private ASN1Object e() throws PKIXException {
        Object var1_1 = null;
        Object var2_2 = null;
        Object var3_3 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        FullCertTemplate fullCertTemplate = new FullCertTemplate();
        fullCertTemplate.setCertReqId(2);
        byte[] byArray = new byte[]{32};
        fullCertTemplate.setKeyUsage(new BIT_STRING(byArray, 5));
        fullCertTemplate.setKeyEscrow(true);
        fullCertTemplate.setPublication(true);
        try {
            return fullCertTemplate.toASN1Object();
        }
        catch (CodingException codingException) {
            throw new PKIXException("Could not generate encryption certificate template." + codingException.getMessage());
        }
    }

    private byte[] a(String string, SecureStringBuffer secureStringBuffer, SecureStringBuffer secureStringBuffer2, KeyPair keyPair, RSAPublicKey rSAPublicKey) throws PKIXException, NoSuchAlgorithmException {
        SEQUENCE sEQUENCE = null;
        Object var7_7 = null;
        BIT_STRING bIT_STRING = null;
        SEQUENCE sEQUENCE2 = null;
        SEQUENCE sEQUENCE3 = null;
        SEQUENCE sEQUENCE4 = null;
        sEQUENCE = new SEQUENCE();
        try {
            PKIHeader pKIHeader = new PKIHeader(0);
            pKIHeader.setRecipient(new GeneralName(GeneralName.iPAddress, (Object)string));
            pKIHeader.setProtectionAlg(new AlgorithmID(this.b()));
            try {
                pKIHeader.setSenderKID((ASN1Object)new OCTET_STRING(secureStringBuffer.getStringBuffer().toString().getBytes("iso_8859-1")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    pKIHeader.setSenderKID((ASN1Object)new OCTET_STRING(secureStringBuffer.getStringBuffer().toString().getBytes("iso8859-1")));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    pKIHeader.setSenderKID((ASN1Object)new OCTET_STRING(secureStringBuffer.getStringBuffer().toString().getBytes()));
                }
            }
            pKIHeader.setSenderNonce(new OCTET_STRING(this.m_senderNonce));
            sEQUENCE.addComponent(pKIHeader.toASN1Object());
        }
        catch (CodingException codingException) {
            throw new PKIXException("Unable to create header: " + codingException.getMessage());
        }
        sEQUENCE4 = (SEQUENCE)rSAPublicKey.toASN1Object();
        sEQUENCE3 = new SEQUENCE();
        sEQUENCE3.addComponent(this.e());
        sEQUENCE3.addComponent(this.a(keyPair, secureStringBuffer2));
        sEQUENCE2 = new SEQUENCE();
        sEQUENCE2.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)sEQUENCE4));
        sEQUENCE2.addComponent((ASN1Object)sEQUENCE3);
        sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)sEQUENCE2));
        bIT_STRING = this.a((ASN1Object)sEQUENCE, secureStringBuffer2);
        sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)bIT_STRING));
        return this.a((ASN1Object)sEQUENCE, (byte)0);
    }

    private BIT_STRING a(ASN1Object aSN1Object, SecureStringBuffer secureStringBuffer) throws PKIXException, NoSuchAlgorithmException {
        ExtendedHasher extendedHasher = new ExtendedHasher();
        try {
            extendedHasher.setInput(secureStringBuffer.getStringBuffer().toString().getBytes("iso_8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                extendedHasher.setInput(secureStringBuffer.getStringBuffer().toString().getBytes("iso8859-1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                extendedHasher.setInput(secureStringBuffer.getStringBuffer().toString().getBytes());
            }
        }
        SecretKey secretKey = new SecretKey(extendedHasher.getOutput(10, 1000), "CAST128");
        try {
            return new BIT_STRING(MacGenerator.generate((String)"pbeWithSHA1AndCAST5-CBC", (Key)secretKey, (byte[])new ASN1(aSN1Object).toByteArray()));
        }
        catch (Exception exception) {
            throw new PKIXException("Could not perform mac protection: " + exception.getMessage());
        }
    }

    public int getVersion() {
        return 0;
    }

    private byte[] a(X509Certificate x509Certificate) {
        return this.a(x509Certificate.getExtensionValue("2.5.29.14"));
    }

    private PrivateKey d() {
        return this.m_signingKey;
    }

    private PrivateKey[] c() {
        PrivateKey[] privateKeyArray = new PrivateKey[this.m_decryptionKeys.size()];
        return this.m_decryptionKeys.toArray(privateKeyArray);
    }

    private ASN1Object b() {
        SEQUENCE sEQUENCE = null;
        SEQUENCE sEQUENCE2 = null;
        SEQUENCE sEQUENCE3 = null;
        SEQUENCE sEQUENCE4 = null;
        SEQUENCE sEQUENCE5 = null;
        AlgorithmID algorithmID = new AlgorithmID("1.2.840.113533.7.66.13", "passwordBasedMAC");
        AlgorithmID algorithmID2 = new AlgorithmID("1.2.840.113533.7.66.11", "cast5MAC");
        sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent((ASN1Object)new ObjectID("1.2.840.113533.7.66.13"));
        sEQUENCE2 = new SEQUENCE();
        byte[] byArray = new byte[]{};
        sEQUENCE2.addComponent((ASN1Object)new OCTET_STRING(byArray));
        sEQUENCE3 = new SEQUENCE();
        sEQUENCE3.addComponent((ASN1Object)AlgorithmID.sha1.getAlgorithm());
        sEQUENCE2.addComponent((ASN1Object)sEQUENCE3);
        sEQUENCE2.addComponent((ASN1Object)new INTEGER(1000));
        sEQUENCE4 = new SEQUENCE();
        sEQUENCE4.addComponent((ASN1Object)new ObjectID("1.2.840.113533.7.66.11"));
        sEQUENCE5 = new SEQUENCE();
        sEQUENCE5.addComponent((ASN1Object)new INTEGER(64));
        sEQUENCE5.addComponent((ASN1Object)new INTEGER(80));
        sEQUENCE4.addComponent((ASN1Object)sEQUENCE5);
        sEQUENCE2.addComponent((ASN1Object)sEQUENCE4);
        sEQUENCE.addComponent((ASN1Object)sEQUENCE2);
        return sEQUENCE;
    }

    private ASN1Object a(KeyPair keyPair, PrivateKey privateKey, X509Certificate x509Certificate) throws PKIXException, NoSuchAlgorithmException {
        Object var4_4 = null;
        SEQUENCE sEQUENCE = null;
        SEQUENCE sEQUENCE2 = null;
        Object var7_7 = null;
        Object var8_8 = null;
        SEQUENCE sEQUENCE3 = null;
        Object var10_10 = null;
        Object var11_11 = null;
        SEQUENCE sEQUENCE4 = null;
        FullCertTemplate fullCertTemplate = new FullCertTemplate();
        fullCertTemplate.setCertReqId(1);
        fullCertTemplate.setUserPublicKey(keyPair.getPublic());
        byte[] byArray = new byte[]{-128};
        fullCertTemplate.setKeyUsage(new BIT_STRING(byArray, 7));
        try {
            sEQUENCE3 = (SEQUENCE)new ASN1(keyPair.getPublic().getEncoded()).toASN1Object();
        }
        catch (CodingException codingException) {
            throw new PKIXException("Could not create signing certificate template: " + codingException.getMessage());
        }
        sEQUENCE2 = new SEQUENCE();
        X509CertificateWrapper x509CertificateWrapper = new X509CertificateWrapper(x509Certificate);
        sEQUENCE2.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)new CON_SPEC(4, x509CertificateWrapper.getASN1Subject())));
        sEQUENCE2.addComponent((ASN1Object)sEQUENCE3);
        sEQUENCE = new SEQUENCE();
        SEQUENCE sEQUENCE5 = new SEQUENCE();
        Signature signature = null;
        if (keyPair.getPrivate().getAlgorithm().compareTo("RSA") == 0) {
            sEQUENCE5.addComponent((ASN1Object)AlgorithmID.sha1WithRSAEncryption.getAlgorithm());
            signature = Signature.getInstance("SHA-1/RSA");
        } else if (keyPair.getPrivate().getAlgorithm().compareTo("DSA") == 0) {
            sEQUENCE5.addComponent((ASN1Object)AlgorithmID.dsaWithSHA1.getAlgorithm());
            try {
                signature = Signature.getInstance("DSA", "Entrust");
            }
            catch (Exception exception) {
                throw new NoSuchAlgorithmException("Could not find signature algorithm 'DSA' in provider 'Entrust'");
            }
        } else {
            throw new PKIXException("Unknown signing key type!");
        }
        try {
            signature.initSign(keyPair.getPrivate());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PKIXException("Could not sign protect, signing key is invalid: " + invalidKeyException.getMessage());
        }
        try {
            signature.update(new ASN1((ASN1Object)sEQUENCE2).toByteArray());
        }
        catch (CodingException codingException) {
            throw new PKIXException(codingException.getMessage());
        }
        catch (SignatureException signatureException) {
            throw new PKIXException("Signing failed: " + signatureException.getMessage());
        }
        sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)sEQUENCE2));
        sEQUENCE.addComponent((ASN1Object)sEQUENCE5);
        try {
            sEQUENCE.addComponent((ASN1Object)new BIT_STRING(signature.sign()));
        }
        catch (SignatureException signatureException) {
            throw new PKIXException("Signing failed: " + signatureException.getMessage());
        }
        fullCertTemplate.setPopoSigningKey((ASN1Object)sEQUENCE);
        sEQUENCE4 = new SEQUENCE();
        sEQUENCE4.addComponent((ASN1Object)new CON_SPEC(4, x509CertificateWrapper.getIssuer().toASN1Object()));
        sEQUENCE4.addComponent((ASN1Object)new INTEGER(x509Certificate.getSerialNumber()));
        fullCertTemplate.setCertId((ASN1Object)sEQUENCE4);
        try {
            return fullCertTemplate.toASN1Object();
        }
        catch (CodingException codingException) {
            throw new PKIXException("Could not create signing certificate template: " + codingException.getMessage());
        }
    }

    private byte[] a(int n2, String string, KeyPair keyPair, PrivateKey privateKey, X509Certificate x509Certificate) throws PKIXException, NoSuchAlgorithmException {
        DSAPublicKey dSAPublicKey;
        SEQUENCE sEQUENCE = null;
        Object var7_7 = null;
        BIT_STRING bIT_STRING = null;
        SEQUENCE sEQUENCE2 = null;
        SEQUENCE sEQUENCE3 = null;
        SEQUENCE sEQUENCE4 = null;
        try {
            this.m_senderNonce = new Integer(this.ansiRandom.nextInt()).toString().getBytes("iso_8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                this.m_senderNonce = new Integer(this.ansiRandom.nextInt()).toString().getBytes("iso8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                this.m_senderNonce = new Integer(this.ansiRandom.nextInt()).toString().getBytes();
            }
        }
        sEQUENCE = new SEQUENCE();
        PKIHeader pKIHeader = new PKIHeader(0);
        pKIHeader.setSender(new GeneralName(GeneralName.directoryName, (Object)x509Certificate.getSubjectDN()));
        pKIHeader.setRecipient(new GeneralName(GeneralName.iPAddress, (Object)string));
        if (privateKey.getAlgorithm().compareTo("RSA") == 0) {
            pKIHeader.setProtectionAlg(AlgorithmID.sha1WithRSAEncryption);
        } else if (privateKey.getAlgorithm().compareTo("DSA") == 0) {
            dSAPublicKey = (DSAPublicKey)x509Certificate.getPublicKey();
            pKIHeader.setProtectionAlg(new AlgorithmID(AlgorithmID.dsaWithSHA1.getAlgorithm(), ((DSAParams)dSAPublicKey.getParams()).toASN1Object()));
        }
        pKIHeader.setSenderKID((ASN1Object)new OCTET_STRING(this.a(x509Certificate)));
        pKIHeader.setSenderNonce(new OCTET_STRING(this.m_senderNonce));
        try {
            sEQUENCE.addComponent(pKIHeader.toASN1Object());
        }
        catch (CodingException codingException) {
            throw new PKIXException("Could not generate update request: " + codingException.getMessage());
        }
        sEQUENCE2 = new SEQUENCE();
        sEQUENCE3 = new SEQUENCE();
        if (n2 == 0) {
            sEQUENCE3.addComponent(this.a(keyPair, privateKey, x509Certificate));
        } else {
            dSAPublicKey = new SEQUENCE();
            ASN1 aSN1 = null;
            try {
                aSN1 = new ASN1(keyPair.getPublic().getEncoded());
            }
            catch (CodingException codingException) {
                throw new PKIXException("Couldn't get the protocol keys: " + codingException.getMessage());
            }
            sEQUENCE4 = (SEQUENCE)aSN1.toASN1Object();
            sEQUENCE2.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)sEQUENCE4));
            sEQUENCE3.addComponent(this.a());
        }
        sEQUENCE2.addComponent((ASN1Object)new CON_SPEC(1, (ASN1Object)sEQUENCE3));
        sEQUENCE.addComponent((ASN1Object)new CON_SPEC(7, (ASN1Object)sEQUENCE2));
        bIT_STRING = this.a((ASN1Object)sEQUENCE, privateKey);
        sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)bIT_STRING));
        return this.a((ASN1Object)sEQUENCE, (byte)7);
    }

    private byte[] b(String string, X509Certificate x509Certificate, PrivateKey privateKey) throws PKIXException, NoSuchAlgorithmException {
        DSAPublicKey dSAPublicKey;
        SEQUENCE sEQUENCE = null;
        Object var5_5 = null;
        BIT_STRING bIT_STRING = null;
        sEQUENCE = new SEQUENCE();
        PKIHeader pKIHeader = new PKIHeader(0);
        pKIHeader.setSender(new GeneralName(GeneralName.directoryName, (Object)x509Certificate.getSubjectDN()));
        pKIHeader.setRecipient(new GeneralName(GeneralName.iPAddress, (Object)string));
        if (privateKey.getAlgorithm().compareTo("RSA") == 0) {
            pKIHeader.setProtectionAlg(AlgorithmID.sha1WithRSAEncryption);
        } else if (privateKey.getAlgorithm().compareTo("DSA") == 0) {
            dSAPublicKey = (DSAPublicKey)x509Certificate.getPublicKey();
            pKIHeader.setProtectionAlg(new AlgorithmID(AlgorithmID.dsaWithSHA1.getAlgorithm(), ((DSAParams)dSAPublicKey.getParams()).toASN1Object()));
        }
        pKIHeader.setSenderKID((ASN1Object)new OCTET_STRING(this.a(x509Certificate)));
        pKIHeader.setSenderNonce(new OCTET_STRING(this.m_senderNonce));
        pKIHeader.setRecipNonce(new OCTET_STRING(this.m_recipNonce));
        try {
            sEQUENCE.addComponent(pKIHeader.toASN1Object());
        }
        catch (CodingException codingException) {
            throw new PKIXException("Could not generate update non confirmation: " + codingException.getMessage());
        }
        dSAPublicKey = new SEQUENCE();
        dSAPublicKey.addComponent((ASN1Object)new INTEGER(2));
        SEQUENCE sEQUENCE2 = new SEQUENCE();
        sEQUENCE2.addComponent((ASN1Object)dSAPublicKey);
        sEQUENCE2.addComponent((ASN1Object)new INTEGER(-99));
        sEQUENCE2.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)new IA5String("transaction cancelled by client")));
        CON_SPEC cON_SPEC = new CON_SPEC(23, (ASN1Object)sEQUENCE2);
        sEQUENCE.addComponent((ASN1Object)cON_SPEC);
        bIT_STRING = this.a((ASN1Object)sEQUENCE, privateKey);
        sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)bIT_STRING));
        return this.a((ASN1Object)sEQUENCE, (byte)23);
    }

    private ASN1Object a() throws PKIXException {
        Object var1_1 = null;
        Object var2_2 = null;
        Object var3_3 = null;
        FullCertTemplate fullCertTemplate = new FullCertTemplate();
        fullCertTemplate.setCertReqId(2);
        byte[] byArray = new byte[]{32};
        fullCertTemplate.setKeyUsage(new BIT_STRING(byArray, 5));
        fullCertTemplate.setKeyEscrow(true);
        fullCertTemplate.setPublication(true);
        SEQUENCE sEQUENCE = new SEQUENCE();
        X509CertificateWrapper x509CertificateWrapper = new X509CertificateWrapper(this.m_encryptionCertificate);
        sEQUENCE.addComponent((ASN1Object)new CON_SPEC(4, x509CertificateWrapper.getIssuer().toASN1Object()));
        sEQUENCE.addComponent((ASN1Object)new INTEGER(this.m_encryptionCertificate.getSerialNumber()));
        fullCertTemplate.setCertId((ASN1Object)sEQUENCE);
        try {
            return fullCertTemplate.toASN1Object();
        }
        catch (CodingException codingException) {
            throw new PKIXException("Could create encryption template: " + codingException.getMessage());
        }
    }

    private byte[] a(String string, X509Certificate x509Certificate, PrivateKey privateKey) throws PKIXException, NoSuchAlgorithmException {
        DSAPublicKey dSAPublicKey;
        SEQUENCE sEQUENCE = null;
        Object var5_5 = null;
        BIT_STRING bIT_STRING = null;
        sEQUENCE = new SEQUENCE();
        PKIHeader pKIHeader = new PKIHeader(0);
        pKIHeader.setSender(new GeneralName(GeneralName.directoryName, (Object)x509Certificate.getSubjectDN()));
        pKIHeader.setRecipient(new GeneralName(GeneralName.iPAddress, (Object)string));
        if (privateKey.getAlgorithm().compareTo("RSA") == 0) {
            pKIHeader.setProtectionAlg(AlgorithmID.sha1WithRSAEncryption);
        } else if (privateKey.getAlgorithm().compareTo("DSA") == 0) {
            dSAPublicKey = (DSAPublicKey)x509Certificate.getPublicKey();
            pKIHeader.setProtectionAlg(new AlgorithmID(AlgorithmID.dsaWithSHA1.getAlgorithm(), ((DSAParams)dSAPublicKey.getParams()).toASN1Object()));
        }
        pKIHeader.setSenderKID((ASN1Object)new OCTET_STRING(this.a(x509Certificate)));
        pKIHeader.setSenderNonce(new OCTET_STRING(this.m_senderNonce));
        pKIHeader.setRecipNonce(new OCTET_STRING(this.m_recipNonce));
        try {
            sEQUENCE.addComponent(pKIHeader.toASN1Object());
        }
        catch (CodingException codingException) {
            throw new PKIXException("Could not generate update confirmation: " + codingException.getMessage());
        }
        dSAPublicKey = new CON_SPEC(19, (ASN1Object)new NULL());
        sEQUENCE.addComponent((ASN1Object)dSAPublicKey);
        bIT_STRING = this.a((ASN1Object)sEQUENCE, privateKey);
        sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)bIT_STRING));
        return this.a((ASN1Object)sEQUENCE, (byte)19);
    }

    private ASN1Object a(KeyPair keyPair, SecureStringBuffer secureStringBuffer) throws PKIXException, NoSuchAlgorithmException {
        Object var3_3 = null;
        SEQUENCE sEQUENCE = null;
        SEQUENCE sEQUENCE2 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        SEQUENCE sEQUENCE3 = null;
        Object var9_9 = null;
        Object var10_10 = null;
        FullCertTemplate fullCertTemplate = new FullCertTemplate();
        fullCertTemplate.setCertReqId(1);
        fullCertTemplate.setUserPublicKey(keyPair.getPublic());
        byte[] byArray = new byte[]{-128};
        fullCertTemplate.setKeyUsage(new BIT_STRING(byArray, 7));
        try {
            sEQUENCE3 = (SEQUENCE)new ASN1(keyPair.getPublic().getEncoded()).toASN1Object();
        }
        catch (CodingException codingException) {
            throw new PKIXException("Could not create signing certificate template: " + codingException.getMessage());
        }
        sEQUENCE2 = new SEQUENCE();
        sEQUENCE2.addComponent((ASN1Object)new CON_SPEC(1, (ASN1Object)this.a((ASN1Object)sEQUENCE3, secureStringBuffer)));
        sEQUENCE2.addComponent((ASN1Object)sEQUENCE3);
        sEQUENCE = new SEQUENCE();
        PrivateKey privateKey = keyPair.getPrivate();
        SEQUENCE sEQUENCE4 = new SEQUENCE();
        Signature signature = null;
        if (privateKey.getAlgorithm().equals("RSA")) {
            sEQUENCE4.addComponent((ASN1Object)AlgorithmID.sha1WithRSAEncryption.getAlgorithm());
            signature = Signature.getInstance("SHA-1/RSA");
        } else if (privateKey.getAlgorithm().equals("DSA")) {
            sEQUENCE4.addComponent((ASN1Object)AlgorithmID.dsaWithSHA1.getAlgorithm());
            try {
                signature = Signature.getInstance("DSA", "Entrust");
            }
            catch (Exception exception) {
                throw new NoSuchAlgorithmException("Could not find signature algorithm 'DSA' in provider 'Entrust'");
            }
        } else {
            throw new PKIXException("Unknown signing algorithm " + privateKey.getAlgorithm());
        }
        sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)sEQUENCE2));
        sEQUENCE.addComponent((ASN1Object)sEQUENCE4);
        try {
            signature.initSign(privateKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PKIXException("Could not generate signing cert template, signing key not valid: " + invalidKeyException.getMessage());
        }
        try {
            signature.update(new ASN1((ASN1Object)sEQUENCE2).toByteArray());
            sEQUENCE.addComponent((ASN1Object)new BIT_STRING(signature.sign()));
            fullCertTemplate.setPopoSigningKey((ASN1Object)sEQUENCE);
            return fullCertTemplate.toASN1Object();
        }
        catch (CodingException codingException) {
            throw new PKIXException(codingException.getMessage());
        }
        catch (SignatureException signatureException) {
            throw new PKIXException("Signing failed: " + signatureException.getMessage());
        }
    }

    private byte[] a(String string, SecureStringBuffer secureStringBuffer, SecureStringBuffer secureStringBuffer2, KeyPair keyPair, PublicKey publicKey) throws PKIXException, NoSuchAlgorithmException {
        SEQUENCE sEQUENCE = null;
        Object var7_7 = null;
        BIT_STRING bIT_STRING = null;
        SEQUENCE sEQUENCE2 = null;
        SEQUENCE sEQUENCE3 = null;
        SEQUENCE sEQUENCE4 = null;
        sEQUENCE = new SEQUENCE();
        try {
            PKIHeader pKIHeader = new PKIHeader(0);
            pKIHeader.setRecipient(new GeneralName(GeneralName.iPAddress, (Object)string));
            pKIHeader.setProtectionAlg(new AlgorithmID(this.b()));
            try {
                pKIHeader.setSenderKID((ASN1Object)new OCTET_STRING(secureStringBuffer.getStringBuffer().toString().getBytes("iso_8859-1")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    pKIHeader.setSenderKID((ASN1Object)new OCTET_STRING(secureStringBuffer.getStringBuffer().toString().getBytes("iso8859-1")));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    pKIHeader.setSenderKID((ASN1Object)new OCTET_STRING(secureStringBuffer.getStringBuffer().toString().getBytes()));
                }
            }
            pKIHeader.setSenderNonce(new OCTET_STRING(this.m_senderNonce));
            sEQUENCE.addComponent(pKIHeader.toASN1Object());
        }
        catch (CodingException codingException) {
            throw new PKIXException("Unable to create header: " + codingException.getMessage());
        }
        try {
            sEQUENCE4 = (SEQUENCE)new ASN1(publicKey.getEncoded()).toASN1Object();
        }
        catch (CodingException codingException) {
            throw new PKIXException("Could not encode protocol key: " + codingException.getMessage());
        }
        sEQUENCE3 = new SEQUENCE();
        sEQUENCE3.addComponent(this.a(keyPair, secureStringBuffer2));
        sEQUENCE2 = new SEQUENCE();
        sEQUENCE2.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)sEQUENCE4));
        sEQUENCE2.addComponent((ASN1Object)sEQUENCE3);
        sEQUENCE.addComponent((ASN1Object)new CON_SPEC(9, (ASN1Object)sEQUENCE2));
        bIT_STRING = this.a((ASN1Object)sEQUENCE, secureStringBuffer2);
        sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)bIT_STRING));
        return this.a((ASN1Object)sEQUENCE, (byte)9);
    }

    private byte[] b(String string, SecureStringBuffer secureStringBuffer, SecureStringBuffer secureStringBuffer2) throws PKIXException, NoSuchAlgorithmException {
        PKIHeader pKIHeader;
        SEQUENCE sEQUENCE = null;
        Object var5_5 = null;
        BIT_STRING bIT_STRING = null;
        sEQUENCE = new SEQUENCE();
        try {
            pKIHeader = new PKIHeader(0);
            pKIHeader.setRecipient(new GeneralName(GeneralName.iPAddress, (Object)string));
            pKIHeader.setProtectionAlg(new AlgorithmID(this.b()));
            try {
                pKIHeader.setSenderKID((ASN1Object)new OCTET_STRING(secureStringBuffer.getStringBuffer().toString().getBytes("iso_8859-1")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    pKIHeader.setSenderKID((ASN1Object)new OCTET_STRING(secureStringBuffer.getStringBuffer().toString().getBytes("iso8859-1")));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    pKIHeader.setSenderKID((ASN1Object)new OCTET_STRING(secureStringBuffer.getStringBuffer().toString().getBytes()));
                }
            }
            pKIHeader.setSenderNonce(new OCTET_STRING(this.m_senderNonce));
            pKIHeader.setRecipNonce(new OCTET_STRING(this.m_recipNonce));
            sEQUENCE.addComponent(pKIHeader.toASN1Object());
        }
        catch (CodingException codingException) {
            throw new PKIXException("Unable to create header: " + codingException.getMessage());
        }
        pKIHeader = new SEQUENCE();
        pKIHeader.addComponent((ASN1Object)new INTEGER(2));
        SEQUENCE sEQUENCE2 = new SEQUENCE();
        sEQUENCE2.addComponent((ASN1Object)pKIHeader);
        sEQUENCE2.addComponent((ASN1Object)new INTEGER(-99));
        sEQUENCE2.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)new IA5String("transaction cancelled by client")));
        CON_SPEC cON_SPEC = new CON_SPEC(23, (ASN1Object)sEQUENCE2);
        sEQUENCE.addComponent((ASN1Object)cON_SPEC);
        bIT_STRING = this.a((ASN1Object)sEQUENCE, secureStringBuffer2);
        sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)bIT_STRING));
        return this.a((ASN1Object)sEQUENCE, (byte)23);
    }

    private KeyPair a(int n2, String string) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = null;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance(string, "Entrust");
        }
        catch (Exception exception) {
            try {
                keyPairGenerator = KeyPairGenerator.getInstance(string, "IAIK");
            }
            catch (Exception exception2) {
                keyPairGenerator = KeyPairGenerator.getInstance(string);
            }
        }
        keyPairGenerator.initialize(n2, (SecureRandom)this.ansiRandom);
        return ((KeyPairGeneratorSpi)keyPairGenerator).generateKeyPair();
    }

    private byte[] a(String string, SecureStringBuffer secureStringBuffer, SecureStringBuffer secureStringBuffer2) throws PKIXException, NoSuchAlgorithmException {
        PKIHeader pKIHeader;
        SEQUENCE sEQUENCE = null;
        Object var5_5 = null;
        BIT_STRING bIT_STRING = null;
        sEQUENCE = new SEQUENCE();
        try {
            pKIHeader = new PKIHeader(0);
            pKIHeader.setRecipient(new GeneralName(GeneralName.iPAddress, (Object)string));
            pKIHeader.setProtectionAlg(new AlgorithmID(this.b()));
            try {
                pKIHeader.setSenderKID((ASN1Object)new OCTET_STRING(secureStringBuffer.getStringBuffer().toString().getBytes("iso_8859-1")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    pKIHeader.setSenderKID((ASN1Object)new OCTET_STRING(secureStringBuffer.getStringBuffer().toString().getBytes("iso8859-1")));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    pKIHeader.setSenderKID((ASN1Object)new OCTET_STRING(secureStringBuffer.getStringBuffer().toString().getBytes()));
                }
            }
            pKIHeader.setSenderNonce(new OCTET_STRING(this.m_senderNonce));
            pKIHeader.setRecipNonce(new OCTET_STRING(this.m_recipNonce));
            sEQUENCE.addComponent(pKIHeader.toASN1Object());
        }
        catch (CodingException codingException) {
            throw new PKIXException("Unable to create header: " + codingException.getMessage());
        }
        pKIHeader = new CON_SPEC(19, (ASN1Object)new NULL());
        sEQUENCE.addComponent((ASN1Object)pKIHeader);
        bIT_STRING = this.a((ASN1Object)sEQUENCE, secureStringBuffer2);
        sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)bIT_STRING));
        return this.a((ASN1Object)sEQUENCE, (byte)19);
    }

    private SEQUENCE a(ManagerTransport managerTransport) throws PKIXException {
        CON_SPEC cON_SPEC = null;
        CON_SPEC cON_SPEC2 = null;
        SEQUENCE sEQUENCE = null;
        ASN1Object aSN1Object = null;
        byte[] byArray = null;
        try {
            byArray = managerTransport.readPKIX4Response(true);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PKIXException("Could not read data from PKI by extracting GULS: " + generalSecurityException.getMessage());
        }
        ASN1 aSN1 = null;
        try {
            aSN1 = new ASN1(byArray);
        }
        catch (CodingException codingException) {
            throw new PKIXException("Could not parse the message from PKIX: " + codingException.getMessage());
        }
        byArray = null;
        cON_SPEC = (CON_SPEC)aSN1.toASN1Object();
        if (cON_SPEC == null) {
            throw new PKIXException("Could not extract the PKIMessage from the GULS Headers. (ContextGULS)");
        }
        if (cON_SPEC.getAsnType().getTag() != 0) {
            throw new PKIXException("An error occurred at the manager end.  Check that your clock is set properly, and that you entered the correct reference number and authorization code.");
        }
        try {
            cON_SPEC.forceImplicitlyTagged(ASN.SEQUENCE);
        }
        catch (CodingException codingException) {
            throw new PKIXException("Could not parse DER encoding:" + codingException.getMessage());
        }
        aSN1Object = (ASN1Object)cON_SPEC.getValue();
        if (aSN1Object == null) {
            throw new PKIXException("Could not extract the PKIMessage from the GULS Headers. (GULSMsg)");
        }
        try {
            cON_SPEC2 = (CON_SPEC)aSN1Object.getComponentAt(2);
        }
        catch (CodingException codingException) {
            throw new PKIXException("Could not extract the PKIMessage from the GULS Headers (ContextPKI): " + codingException.getMessage());
        }
        if (cON_SPEC2 == null) {
            throw new PKIXException("Could not extract the PKIMessage from the GULS Headers. (ContextPKI)");
        }
        sEQUENCE = (SEQUENCE)cON_SPEC2.getValue();
        if (sEQUENCE == null) {
            throw new PKIXException("Could not extract the PKIMessage from the GULS Headers.");
        }
        return sEQUENCE;
    }

    public void createUser(KeyPair keyPair, KeyPair keyPair2, ManagerTransport managerTransport, SecureStringBuffer secureStringBuffer, SecureStringBuffer secureStringBuffer2) throws PKIXException, NoSuchAlgorithmException {
        Object var7_6 = null;
        byte[] byArray = null;
        Object var9_8 = null;
        Object var10_9 = null;
        Object var11_10 = null;
        Object var12_11 = null;
        int n2 = this.ansiRandom.nextInt();
        try {
            this.m_senderNonce = new Integer(n2).toString().getBytes("iso_8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                this.m_senderNonce = new Integer(n2).toString().getBytes("iso8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                this.m_senderNonce = new Integer(n2).toString().getBytes();
            }
        }
        managerTransport.beginNewSession();
        byArray = this.a(managerTransport.getAddress(), secureStringBuffer2, secureStringBuffer, keyPair, (RSAPublicKey)keyPair2.getPublic());
        try {
            managerTransport.getOutputStream().write(byArray);
            managerTransport.getOutputStream().flush();
        }
        catch (IOException iOException) {
            throw new PKIXException("Could not send certificate request to the PKI: " + iOException.getMessage());
        }
        this.a(managerTransport, managerTransport.getAddress(), secureStringBuffer, keyPair2.getPrivate());
        this.m_refNo = secureStringBuffer2;
        this.m_authCode = secureStringBuffer;
        this.setSigningKey(keyPair.getPrivate());
    }

    private void a(SEQUENCE sEQUENCE, SecureStringBuffer secureStringBuffer) throws PKIXException, NoSuchAlgorithmException {
        byte[] byArray = null;
        byte[] byArray2 = null;
        SEQUENCE sEQUENCE2 = null;
        BIT_STRING bIT_STRING = null;
        if (sEQUENCE.countComponents() < 3) {
            throw new PKIXException("Unexpected format in Manager response(perhaps user has already initialized ?) ");
        }
        sEQUENCE2 = new SEQUENCE();
        sEQUENCE2.addComponent(sEQUENCE.getComponentAt(0));
        sEQUENCE2.addComponent(sEQUENCE.getComponentAt(1));
        bIT_STRING = this.a((ASN1Object)sEQUENCE2, secureStringBuffer);
        byArray = (byte[])bIT_STRING.getValue();
        byArray2 = (byte[])((ASN1Object)((CON_SPEC)sEQUENCE.getComponentAt(2)).getValue()).getValue();
        if (byArray.length != byArray2.length) {
            throw new PKIXException("Verifying the protection failed!");
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] != byArray2[n2]) {
                throw new PKIXException("Verifying the protection failed!");
            }
            ++n2;
        }
    }

    private void a(SEQUENCE sEQUENCE, String string) throws PKIXException {
        Enumeration enumeration = null;
        byte[] byArray = null;
        int n2 = 3600000;
        CON_SPEC cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(1);
        if (cON_SPEC.getAsnType().getTag() != GeneralName.iPAddress) {
            throw new PKIXException("Sender name is not an IP address.");
        }
        GeneralName generalName = null;
        try {
            generalName = new GeneralName((ASN1Object)cON_SPEC);
        }
        catch (CodingException codingException) {
            throw new PKIXException("The sender IP could not be parsed.");
        }
        String string2 = (String)generalName.getName();
        if (!string.equals(string2)) {
            throw new PKIXException("Sender was not our recipient.");
        }
        enumeration = sEQUENCE.getComponents();
        while (enumeration.hasMoreElements()) {
            ASN1Object aSN1Object = (ASN1Object)enumeration.nextElement();
            if (!aSN1Object.isA(ASN.CON_SPEC)) continue;
            switch (((CON_SPEC)aSN1Object).getAsnType().getTag()) {
                case 0: {
                    String string3 = (String)((ASN1Object)aSN1Object.getValue()).getValue();
                    Calendar calendar = Calendar.getInstance();
                    calendar.set(1, Integer.valueOf(string3.substring(0, 4)));
                    calendar.set(2, Integer.valueOf(string3.substring(4, 6)) - 1);
                    calendar.set(5, Integer.valueOf(string3.substring(6, 8)));
                    calendar.set(11, Integer.valueOf(string3.substring(8, 10)));
                    calendar.set(12, Integer.valueOf(string3.substring(10, 12)));
                    calendar.set(13, Integer.valueOf(string3.substring(12, 14)));
                    long l = calendar.getTime().getTime();
                    ZuluTime zuluTime = new ZuluTime(new Date());
                    if (Math.abs(zuluTime.getTime() - l) <= (long)(n2 * 2)) break;
                    throw new PKIXException("There is more than a 2 hour time discrepancy between the Client and the Manager.");
                }
                case 5: {
                    this.m_recipNonce = (byte[])((ASN1Object)aSN1Object.getValue()).getValue();
                    break;
                }
                case 6: {
                    byArray = (byte[])((ASN1Object)aSN1Object.getValue()).getValue();
                    ByteArray byteArray = new ByteArray(byArray);
                    byteArray.isEqual(this.m_senderNonce);
                    break;
                }
            }
        }
    }

    private byte[] a(ASN1Object aSN1Object, byte by) throws PKIXException {
        int n2;
        Object var3_3 = null;
        CON_SPEC cON_SPEC = null;
        byte[] byArray = null;
        cON_SPEC = new CON_SPEC(0, aSN1Object);
        byte[] byArray2 = null;
        try {
            byArray2 = new ASN1((ASN1Object)cON_SPEC).toByteArray();
        }
        catch (CodingException codingException) {
            throw new PKIXException("Could not do GULS wrapping: " + codingException.getMessage());
        }
        int n3 = n2 = 6 + byArray2.length + 3;
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        if (n2 > 127 && n2 < 256) {
            ++n4;
        } else if (n2 > 255) {
            n4 += 2;
        }
        byArray = new byte[n2 + 1 + n4];
        byArray[0] = -96;
        if (n4 == 1) {
            byArray[1] = (byte)n2;
        } else if (n4 == 2) {
            byArray[1] = -127;
            byArray[2] = (byte)n2;
        } else {
            byArray[1] = -126;
            byArray[2] = (byte)(n2 >> 8);
            byArray[3] = (byte)(n2 & 0xFF);
        }
        n6 = n4 + 1;
        byte[] byArray3 = new byte[]{2, 1, 10, 2, 1, by};
        n5 = 0;
        while (n5 < byArray3.length) {
            byArray[n6] = byArray3[n5];
            ++n5;
            ++n6;
        }
        n5 = 0;
        while (n5 < byArray2.length) {
            byArray[n6] = byArray2[n5];
            ++n5;
            ++n6;
        }
        byte[] byArray4 = new byte[]{-127, 1, -1};
        n5 = 0;
        while (n5 < byArray4.length) {
            byArray[n6] = byArray4[n5];
            ++n5;
            ++n6;
        }
        return byArray;
    }

    public PKIX4() throws NoSuchAlgorithmException {
        this.c = (byte)9;
        this.b = (byte)11;
        this.g = (byte)19;
        this.d = (byte)21;
        this.f = (byte)23;
    }
}

