/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.util;

import com.entrust.toolkit.asn1.structures.AlgorithmIdentifier;
import com.entrust.toolkit.asn1.structures.CertTemplateCMP;
import com.entrust.toolkit.asn1.structures.Controls;
import com.entrust.toolkit.asn1.structures.PKIHeader;
import com.entrust.toolkit.asn1.structures.SubjectPublicKeyInfo;
import com.entrust.toolkit.exceptions.PKIXException;
import com.entrust.toolkit.security.provider.ConfinedKey;
import com.entrust.toolkit.security.provider.k;
import com.entrust.toolkit.util.ExtendedHasher;
import com.entrust.toolkit.util.MacGenerator;
import com.entrust.toolkit.util.ManagerTransport;
import com.entrust.toolkit.util.PKIX;
import com.entrust.toolkit.util.SecureStringBuffer;
import com.entrust.toolkit.x509.ValidationInfo;
import com.entrust.toolkit.x509.certstore.CertificateGraph;
import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.GeneralizedTime;
import iaik.asn1.INTEGER;
import iaik.asn1.NULL;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.asn1.structures.GeneralName;
import iaik.security.cipher.SecretKey;
import iaik.security.rsa.RSAPrivateKey;
import iaik.utils.CryptoUtils;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509Extensions;
import iaik.x509.extensions.KeyUsage;
import iaik.x509.extensions.SubjectKeyIdentifier;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Date;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;

public final class PKIXCMP
extends PKIX {
    private byte[] b;
    private byte[] a;
    private byte[] c;
    private static final byte n = 23;
    private static final byte l = 22;
    private static final byte m = 21;
    private static final byte o = 19;
    private static final byte g = 10;
    private static final byte f = 9;
    private static final byte i = 8;
    private static final byte h = 7;
    private static final byte k = 1;
    private static final byte j = 0;
    private static byte e;
    private static byte d;
    protected static int TRACE_LEVEL;
    protected static boolean DEBUG;

    private void a(byte[] byArray, String string) {
        if (!DEBUG) {
            return;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {}
    }

    private void a(ASN1Object aSN1Object, String string) {
        this.a(DerCoder.encode((ASN1Object)aSN1Object), string);
    }

    private void a(byte[] byArray, byte[] byArray2, PublicKey publicKey) throws PKIXException {
        boolean bl = false;
        try {
            Signature signature = null;
            String string = publicKey.getAlgorithm();
            try {
                try {
                    signature = Signature.getInstance("SHA-1/" + string, "Entrust");
                }
                catch (Exception exception) {
                    signature = Signature.getInstance("SHA-1/" + string);
                }
            }
            catch (Exception exception) {
                throw new PKIXException("Unknown signing algorithm - SHA-1/" + string);
            }
            try {
                signature.initVerify(publicKey);
            }
            catch (Exception exception) {
                throw new PKIXException("Verification key not valid: " + exception.getMessage());
            }
            signature.update(byArray);
            if (!signature.verify(byArray2)) {
                throw new PKIXException("Signed data has been modified");
            }
        }
        catch (Exception exception) {
            throw new PKIXException("Unable to verify signature: " + exception.getMessage());
        }
    }

    public void updateSigningKeys(ManagerTransport managerTransport, PrivateKey privateKey, KeyPair keyPair, X509Certificate x509Certificate, ValidationInfo validationInfo) throws PKIXException {
        managerTransport.beginNewSession();
        ASN1Object aSN1Object = this.a(keyPair, privateKey, x509Certificate);
        this.a(aSN1Object, "KUR.bin");
        byte[] byArray = this.a(aSN1Object, d);
        try {
            managerTransport.getOutputStream().write(byArray);
            managerTransport.getOutputStream().flush();
        }
        catch (Exception exception) {
            throw new PKIXException("Could not send the signing key-update request to the PKI: " + exception.getMessage());
        }
        SEQUENCE sEQUENCE = null;
        try {
            byte[] byArray2 = managerTransport.readPKIXCMPResponse(true);
            this.a(byArray2, "KUP.bin");
            sEQUENCE = (SEQUENCE)DerCoder.decode((byte[])byArray2);
        }
        catch (Exception exception) {
            throw new PKIXException("Could not receive the signing key-update response from the PKI: " + exception.getMessage());
        }
        this.b(sEQUENCE, validationInfo);
        this.setSigningKey(keyPair.getPrivate());
        this.m_cert = x509Certificate;
        this.m_key = privateKey;
        this.m_refNo = null;
    }

    public void updateEncryptionKeys(ManagerTransport managerTransport, KeyPair keyPair, PrivateKey privateKey, KeyPair keyPair2, X509Certificate x509Certificate, X509Certificate x509Certificate2, ValidationInfo validationInfo) throws PKIXException {
        managerTransport.beginNewSession();
        ASN1Object aSN1Object = this.a(keyPair2, keyPair, privateKey, x509Certificate2, x509Certificate);
        this.a(aSN1Object, "KUR.bin");
        byte[] byArray = this.a(aSN1Object, d);
        try {
            managerTransport.getOutputStream().write(byArray);
            managerTransport.getOutputStream().flush();
        }
        catch (Exception exception) {
            throw new PKIXException("Could not send the encryption key-update request to the PKI: " + exception.getMessage());
        }
        SEQUENCE sEQUENCE = null;
        try {
            byte[] byArray2 = managerTransport.readPKIXCMPResponse(true);
            this.a(byArray2, "KUP.bin");
            sEQUENCE = (SEQUENCE)DerCoder.decode((byte[])byArray2);
        }
        catch (Exception exception) {
            throw new PKIXException("Could not receive the encryption key-update response from the PKI: " + exception.getMessage());
        }
        this.a(sEQUENCE, keyPair2, keyPair, validationInfo);
        this.m_cert = x509Certificate;
        this.m_key = keyPair2 == null ? privateKey : null;
        this.m_refNo = null;
    }

    private synchronized void c(X509Certificate x509Certificate) {
        this.m_rootCa = x509Certificate;
    }

    public void sendConfirmation(ManagerTransport managerTransport) throws PKIXException {
        ASN1Object aSN1Object = null;
        aSN1Object = this.m_refNo != null ? (this.m_authCode != null ? this.a(this.m_refNo, this.m_authCode) : this.a(this.m_refNo, this.b)) : (this.m_key != null ? this.a(this.m_cert, this.m_key) : this.a(this.m_cert, this.b));
        this.a(aSN1Object, "CONF.bin");
        byte[] byArray = this.a(aSN1Object, e);
        try {
            managerTransport.getOutputStream().write(byArray);
            managerTransport.getOutputStream().flush();
        }
        catch (Exception exception) {
            throw new PKIXException("Could not send the confirmation to the PKI: " + exception.getMessage());
        }
        if (this.m_refNo != null) {
            this.m_refNo.wipe();
        }
        if (this.m_authCode != null) {
            this.m_authCode.wipe();
        }
        this.m_refNo = null;
        this.m_authCode = null;
        this.m_cert = null;
        this.m_key = null;
    }

    public void recoverUser(ManagerTransport managerTransport, SecureStringBuffer secureStringBuffer, SecureStringBuffer secureStringBuffer2, KeyPair keyPair, KeyPair keyPair2, KeyPair keyPair3) throws PKIXException {
        managerTransport.beginNewSession();
        ASN1Object aSN1Object = this.b(secureStringBuffer2, secureStringBuffer, keyPair2, keyPair3, keyPair);
        this.a(aSN1Object, "RR.bin");
        byte[] byArray = this.a(aSN1Object, d);
        try {
            managerTransport.getOutputStream().write(byArray);
            managerTransport.getOutputStream().flush();
        }
        catch (Exception exception) {
            throw new PKIXException("Could not send recovery request to the PKI: " + exception.getMessage());
        }
        SEQUENCE sEQUENCE = null;
        try {
            byte[] byArray2 = managerTransport.readPKIXCMPResponse(true);
            this.a(byArray2, "RP.bin");
            sEQUENCE = (SEQUENCE)DerCoder.decode((byte[])byArray2);
        }
        catch (Exception exception) {
            throw new PKIXException("Could not receive the recovery response from the PKI: " + exception.getMessage());
        }
        this.b(sEQUENCE, secureStringBuffer, keyPair3, keyPair);
        this.setSigningKey(keyPair2.getPrivate());
        this.m_refNo = secureStringBuffer2;
        this.m_authCode = keyPair3 == null ? secureStringBuffer : null;
    }

    private void b(SEQUENCE sEQUENCE, ValidationInfo validationInfo) throws PKIXException {
        CON_SPEC cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(1);
        int n2 = cON_SPEC.getAsnType().getTag();
        if (n2 == 23) {
            this.a(cON_SPEC);
        }
        this.a((SEQUENCE)sEQUENCE.getComponentAt(0));
        this.a(sEQUENCE, validationInfo);
        if (n2 != 8) {
            throw new PKIXException("Body does not have correct tag in return message.");
        }
        SEQUENCE sEQUENCE2 = null;
        try {
            sEQUENCE2 = (SEQUENCE)cON_SPEC.getValue();
        }
        catch (Exception exception) {
            throw new PKIXException("Could not read the response!");
        }
        try {
            SEQUENCE sEQUENCE3 = (SEQUENCE)sEQUENCE2.getComponentAt(1);
            SEQUENCE sEQUENCE4 = (SEQUENCE)sEQUENCE3.getComponentAt(0);
            SEQUENCE sEQUENCE5 = (SEQUENCE)sEQUENCE4.getComponentAt(2);
            ASN1Object aSN1Object = (ASN1Object)sEQUENCE5.getComponentAt(0).getValue();
            this.setVerificationCertificate(new X509Certificate(DerCoder.encode((ASN1Object)aSN1Object)));
        }
        catch (Exception exception) {
            throw new PKIXException("Unable to extract the verification certificate from the response: " + exception.getMessage());
        }
    }

    private void b(SEQUENCE sEQUENCE, SecureStringBuffer secureStringBuffer, KeyPair keyPair, KeyPair keyPair2) throws PKIXException {
        block33: {
            CON_SPEC cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(1);
            int n2 = cON_SPEC.getAsnType().getTag();
            if (n2 == 23) {
                this.a(cON_SPEC);
            }
            this.a((SEQUENCE)sEQUENCE.getComponentAt(0));
            this.a(sEQUENCE, secureStringBuffer, this.c);
            if (n2 != 10) {
                throw new PKIXException("Body does not have correct tag in return message.");
            }
            SEQUENCE sEQUENCE2 = null;
            try {
                sEQUENCE2 = (SEQUENCE)cON_SPEC.getValue();
            }
            catch (Exception exception) {
                throw new PKIXException("Could not read the response!");
            }
            try {
                X509Certificate x509Certificate;
                int n3;
                Object object;
                CON_SPEC cON_SPEC2;
                SEQUENCE sEQUENCE3 = (SEQUENCE)sEQUENCE2.getComponentAt(0);
                INTEGER iNTEGER = (INTEGER)sEQUENCE3.getComponentAt(0);
                int n4 = ((BigInteger)iNTEGER.getValue()).intValue();
                if (n4 != 0 && n4 != 1) {
                    throw new PKIXException("The recovery failed, the returned status is: " + iNTEGER.getValue());
                }
                int n5 = 1;
                while (n5 < sEQUENCE2.countComponents()) {
                    cON_SPEC2 = (CON_SPEC)sEQUENCE2.getComponentAt(n5);
                    n2 = cON_SPEC2.getAsnType().getTag();
                    if (n2 == 0) {
                        try {
                            object = (ASN1Object)cON_SPEC2.getValue();
                            this.setVerificationCertificate(new X509Certificate(DerCoder.encode((ASN1Object)object)));
                        }
                        catch (Exception exception) {
                            throw new PKIXException("Unable to extract the verification certificate from the response: " + exception.getMessage());
                        }
                    }
                    if (n2 == 1) {
                        try {
                            object = ((SEQUENCE)cON_SPEC2.getValue()).getComponentAt(0);
                            this.setCaCertificate(new X509Certificate(DerCoder.encode((ASN1Object)object)));
                        }
                        catch (Exception exception) {
                            throw new PKIXException("Unable to extract the ca certificate from the response: " + exception.getMessage());
                        }
                    }
                    if (n2 == 2) {
                        try {
                            object = (SEQUENCE)cON_SPEC2.getValue();
                            n3 = object.countComponents();
                            this.m_decryptionKeys = new Vector();
                            int n6 = 0;
                            while (n6 < n3) {
                                Object object2;
                                X509Certificate x509Certificate2;
                                x509Certificate = (SEQUENCE)object.getComponentAt(n6);
                                CON_SPEC cON_SPEC3 = (CON_SPEC)x509Certificate.getComponentAt(0);
                                try {
                                    x509Certificate2 = null;
                                    if (cON_SPEC3.getAsnType().getTag() == 0) {
                                        x509Certificate2 = new X509Certificate(DerCoder.encode((ASN1Object)((ASN1Object)cON_SPEC3.getValue())));
                                    } else {
                                        object2 = (SEQUENCE)cON_SPEC3.getValue();
                                        byte[] byArray = null;
                                        if (keyPair != null) {
                                            byArray = this.a((ASN1Object)object2, keyPair.getPrivate());
                                            this.addDecryptionKey(keyPair.getPrivate());
                                        } else {
                                            byArray = this.a((ASN1Object)object2, keyPair2.getPrivate());
                                        }
                                        x509Certificate2 = new X509Certificate(byArray);
                                    }
                                    this.addToHistory(x509Certificate2);
                                    if (n6 == n3 - 1) {
                                        this.setEncryptionCertificate(x509Certificate2);
                                    }
                                }
                                catch (Exception exception) {
                                    throw new PKIXException("Unable to extract certOrEncCert: " + exception.getMessage());
                                }
                                if (x509Certificate.countComponents() > 1) {
                                    try {
                                        x509Certificate2 = (SEQUENCE)x509Certificate.getComponentAt(1).getValue();
                                        object2 = null;
                                        object2 = keyPair != null ? (Object)this.a((ASN1Object)x509Certificate2, keyPair.getPrivate()) : (Object)this.a((ASN1Object)x509Certificate2, keyPair2.getPrivate());
                                        this.addDecryptionKey((PrivateKey)new RSAPrivateKey((byte[])object2));
                                    }
                                    catch (Exception exception) {
                                        throw new PKIXException("Unable to extract privateKey: " + exception.getMessage());
                                    }
                                }
                                ++n6;
                            }
                        }
                        catch (Exception exception) {
                            throw new PKIXException("Unable to extract keyPairHist: " + exception.getMessage());
                        }
                    }
                    ++n5;
                }
                if (sEQUENCE.countComponents() <= 3) break block33;
                try {
                    this.c(this.getCaCertificate());
                    cON_SPEC2 = (SEQUENCE)sEQUENCE.getComponentAt(3).getValue();
                    object = this.getEncryptionCertificate().getIssuerDN();
                    n3 = 0;
                    while (n3 < cON_SPEC2.countComponents()) {
                        SEQUENCE sEQUENCE4 = (SEQUENCE)cON_SPEC2.getComponentAt(n3);
                        x509Certificate = new X509Certificate(DerCoder.encode((ASN1Object)sEQUENCE4));
                        if (x509Certificate.getSubjectDN().equals(object)) {
                            this.setCaCertificate(x509Certificate);
                        } else {
                            CertificateGraph.Graph().addCertificate(x509Certificate);
                        }
                        ++n3;
                    }
                }
                catch (Exception exception) {
                    throw new PKIXException("Could not read subordinate CA certificates: " + exception.getMessage());
                }
            }
            catch (Exception exception) {
                throw new PKIXException("Unable to extract keys and certificates from response: " + exception.getMessage());
            }
        }
    }

    private void a(SEQUENCE sEQUENCE, SecureStringBuffer secureStringBuffer, KeyPair keyPair, KeyPair keyPair2) throws PKIXException {
        block23: {
            CON_SPEC cON_SPEC;
            CON_SPEC cON_SPEC2 = (CON_SPEC)sEQUENCE.getComponentAt(1);
            int n2 = cON_SPEC2.getAsnType().getTag();
            if (n2 == 23) {
                this.a(cON_SPEC2);
            }
            this.a((SEQUENCE)sEQUENCE.getComponentAt(0));
            this.a(sEQUENCE, secureStringBuffer, this.c);
            if (n2 != 1) {
                throw new PKIXException("Body does not have correct tag in return message.");
            }
            SEQUENCE sEQUENCE2 = null;
            try {
                sEQUENCE2 = (SEQUENCE)cON_SPEC2.getValue();
            }
            catch (Exception exception) {
                throw new PKIXException("Could not read the response!");
            }
            int n3 = sEQUENCE2.countComponents();
            if (n3 > 1) {
                try {
                    cON_SPEC = (CON_SPEC)sEQUENCE2.getComponentAt(0);
                    SEQUENCE sEQUENCE3 = (SEQUENCE)((SEQUENCE)cON_SPEC.getValue()).getComponentAt(0);
                    this.setCaCertificate(new X509Certificate(DerCoder.encode((ASN1Object)sEQUENCE3)));
                }
                catch (Exception exception) {
                    throw new PKIXException("Unable to extract the ca certificate from the response: " + exception.getMessage());
                }
            }
            try {
                Object object;
                ASN1Object aSN1Object;
                SEQUENCE sEQUENCE4;
                cON_SPEC = (SEQUENCE)sEQUENCE2.getComponentAt(n3 - 1);
                int n4 = 0;
                while (n4 < 2) {
                    sEQUENCE4 = (SEQUENCE)cON_SPEC.getComponentAt(n4);
                    int n5 = ((BigInteger)sEQUENCE4.getComponentAt(0).getValue()).intValue();
                    SEQUENCE sEQUENCE5 = (SEQUENCE)sEQUENCE4.getComponentAt(2);
                    if (n5 == 0) {
                        try {
                            aSN1Object = (ASN1Object)sEQUENCE5.getComponentAt(0).getValue();
                            this.setVerificationCertificate(new X509Certificate(DerCoder.encode((ASN1Object)aSN1Object)));
                        }
                        catch (Exception exception) {
                            throw new PKIXException("Unable to extract the verification certificate from the response: " + exception.getMessage());
                        }
                    }
                    if (n5 == 1) {
                        try {
                            if (keyPair != null) {
                                aSN1Object = (ASN1Object)sEQUENCE5.getComponentAt(0).getValue();
                                object = this.a(aSN1Object, keyPair.getPrivate());
                                this.setEncryptionCertificate(new X509Certificate((byte[])object));
                                this.addDecryptionKey(keyPair.getPrivate());
                            } else {
                                aSN1Object = (ASN1Object)sEQUENCE5.getComponentAt(0).getValue();
                                this.setEncryptionCertificate(new X509Certificate(DerCoder.encode((ASN1Object)aSN1Object)));
                                object = (ASN1Object)sEQUENCE5.getComponentAt(1).getValue();
                                byte[] byArray = this.a((ASN1Object)object, keyPair2.getPrivate());
                                this.addDecryptionKey((PrivateKey)new RSAPrivateKey(byArray));
                            }
                        }
                        catch (Exception exception) {
                            throw new PKIXException("Unable to extract the encryption certificate from the response: " + exception.getMessage());
                        }
                    }
                    ++n4;
                }
                if (sEQUENCE.countComponents() <= 3) break block23;
                try {
                    this.c(this.getCaCertificate());
                    sEQUENCE4 = (SEQUENCE)sEQUENCE.getComponentAt(3).getValue();
                    Principal principal = this.getEncryptionCertificate().getIssuerDN();
                    int n6 = 0;
                    while (n6 < sEQUENCE4.countComponents()) {
                        aSN1Object = (SEQUENCE)sEQUENCE4.getComponentAt(n6);
                        object = new X509Certificate(DerCoder.encode((ASN1Object)aSN1Object));
                        if (object.getSubjectDN().equals(principal)) {
                            this.setCaCertificate((X509Certificate)object);
                        } else {
                            CertificateGraph.Graph().addCertificate((X509Certificate)object);
                        }
                        ++n6;
                    }
                }
                catch (Exception exception) {
                    throw new PKIXException("Could not read subordinate CA certificates: " + exception.getMessage());
                }
            }
            catch (Exception exception) {
                throw new PKIXException("Unable to extract keys and certificates from response: " + exception.getMessage());
            }
        }
    }

    private void a(CON_SPEC cON_SPEC) throws PKIXException {
        SEQUENCE sEQUENCE = null;
        try {
            sEQUENCE = (SEQUENCE)cON_SPEC.getValue();
        }
        catch (Exception exception) {
            throw new PKIXException("Unable to parse the error message: " + exception.getMessage());
        }
        String string = null;
        try {
            string = (String)sEQUENCE.getComponentAt(2).getComponentAt(0).getValue();
        }
        catch (Exception exception) {
            try {
                string = (String)sEQUENCE.getComponentAt(0).getComponentAt(1).getComponentAt(0).getValue();
            }
            catch (Exception exception2) {
                throw new PKIXException("Unable to parse the error message: " + exception2.getMessage());
            }
        }
        throw new PKIXException(string);
    }

    private void a(SEQUENCE sEQUENCE, KeyPair keyPair, KeyPair keyPair2, ValidationInfo validationInfo) throws PKIXException {
        CON_SPEC cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(1);
        int n2 = cON_SPEC.getAsnType().getTag();
        if (n2 == 23) {
            this.a(cON_SPEC);
        }
        this.a((SEQUENCE)sEQUENCE.getComponentAt(0));
        this.a(sEQUENCE, validationInfo);
        if (n2 != 8) {
            throw new PKIXException("Body does not have correct tag in return message.");
        }
        SEQUENCE sEQUENCE2 = null;
        try {
            sEQUENCE2 = (SEQUENCE)cON_SPEC.getValue();
        }
        catch (Exception exception) {
            throw new PKIXException("Could not read the response!");
        }
        try {
            SEQUENCE sEQUENCE3 = (SEQUENCE)sEQUENCE2.getComponentAt(1);
            SEQUENCE sEQUENCE4 = (SEQUENCE)sEQUENCE3.getComponentAt(0);
            SEQUENCE sEQUENCE5 = (SEQUENCE)sEQUENCE4.getComponentAt(2);
            if (keyPair != null) {
                ASN1Object aSN1Object = (ASN1Object)sEQUENCE5.getComponentAt(0).getValue();
                byte[] byArray = this.a(aSN1Object, keyPair.getPrivate());
                this.setEncryptionCertificate(new X509Certificate(byArray));
                this.addDecryptionKey(keyPair.getPrivate());
            } else {
                ASN1Object aSN1Object = (ASN1Object)sEQUENCE5.getComponentAt(0).getValue();
                this.setEncryptionCertificate(new X509Certificate(DerCoder.encode((ASN1Object)aSN1Object)));
                ASN1Object aSN1Object2 = (ASN1Object)sEQUENCE5.getComponentAt(1).getValue();
                byte[] byArray = this.a(aSN1Object2, keyPair2.getPrivate());
                this.addDecryptionKey((PrivateKey)new RSAPrivateKey(byArray));
            }
        }
        catch (Exception exception) {
            throw new PKIXException("Unable to extract the encryption certificate from the response: " + exception.getMessage());
        }
    }

    private byte[] a(SEQUENCE sEQUENCE, SecureStringBuffer secureStringBuffer) throws PKIXException {
        CON_SPEC cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(1);
        int n2 = cON_SPEC.getAsnType().getTag();
        if (n2 == 23) {
            this.a(cON_SPEC);
        }
        this.a((SEQUENCE)sEQUENCE.getComponentAt(0));
        this.a(sEQUENCE, secureStringBuffer, this.c);
        if (n2 != 22) {
            throw new PKIXException("Body does not have correct tag in return message.");
        }
        byte[] byArray = null;
        try {
            SEQUENCE sEQUENCE2 = (SEQUENCE)cON_SPEC.getValue();
            SEQUENCE sEQUENCE3 = (SEQUENCE)sEQUENCE2.getComponentAt(0);
            OCTET_STRING oCTET_STRING = (OCTET_STRING)sEQUENCE3.getComponentAt(1);
            byArray = (byte[])oCTET_STRING.getValue();
        }
        catch (Exception exception) {
            throw new PKIXException("Unable to extract client settings from the response: " + exception.getMessage());
        }
        return byArray;
    }

    public int getVersion() {
        return 1;
    }

    private AlgorithmID a(Key key) throws PKIXException {
        String string = key.getAlgorithm();
        if (string.equals("RSA")) {
            return AlgorithmID.sha1WithRSAEncryption;
        }
        if (string.equals("DSA")) {
            return AlgorithmID.dsaWithSHA1;
        }
        if (string.equals("ECDSA")) {
            return AlgorithmID.ecdsaWithSHA1;
        }
        throw new PKIXException("Unsupported signing algorithm found in 'verificationCert': " + string);
    }

    private byte[] b(X509Certificate x509Certificate) throws PKIXException {
        try {
            V3Extension v3Extension = x509Certificate.getExtension(SubjectKeyIdentifier.oid);
            return ((SubjectKeyIdentifier)v3Extension).get();
        }
        catch (Exception exception) {
            throw new PKIXException("Unable to extract keyID from the certificate: " + exception.getMessage());
        }
    }

    public byte[] getClientSettings(ManagerTransport managerTransport, SecureStringBuffer secureStringBuffer, SecureStringBuffer secureStringBuffer2) throws PKIXException {
        managerTransport.beginNewSession();
        ASN1Object aSN1Object = this.b(secureStringBuffer, secureStringBuffer2);
        this.a(aSN1Object, "GENM.bin");
        byte[] byArray = this.a(aSN1Object, d);
        try {
            managerTransport.getOutputStream().write(byArray);
            managerTransport.getOutputStream().flush();
        }
        catch (Exception exception) {
            throw new PKIXException("Could not send the client settings request to the PKI: " + exception.getMessage());
        }
        SEQUENCE sEQUENCE = null;
        try {
            byte[] byArray2 = managerTransport.readPKIXCMPResponse(true);
            this.a(byArray2, "GENP.bin");
            sEQUENCE = (SEQUENCE)DerCoder.decode((byte[])byArray2);
        }
        catch (Exception exception) {
            throw new PKIXException("Could not receive the client settings response from the PKI: " + exception.getMessage());
        }
        return this.a(sEQUENCE, secureStringBuffer2);
    }

    private ASN1Object a(KeyPair keyPair, PrivateKey privateKey, X509Certificate x509Certificate) throws PKIXException {
        try {
            SEQUENCE sEQUENCE = new SEQUENCE();
            this.m_senderNonce = new byte[16];
            this.ansiRandom.nextBytes(this.m_senderNonce);
            this.m_recipNonce = null;
            try {
                this.a = new Integer(this.ansiRandom.nextInt()).toString().getBytes("iso_8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    this.a = new Integer(this.ansiRandom.nextInt()).toString().getBytes("iso8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    this.a = new Integer(this.ansiRandom.nextInt()).toString().getBytes();
                }
            }
            PKIHeader pKIHeader = this.a(x509Certificate);
            sEQUENCE.addComponent(pKIHeader.toASN1Object());
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(this.a(0, keyPair, null, null, privateKey, x509Certificate));
            sEQUENCE.addComponent((ASN1Object)new CON_SPEC(7, (ASN1Object)sEQUENCE2));
            byte[] byArray = this.a(DerCoder.encode((ASN1Object)sEQUENCE), privateKey);
            sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)new BIT_STRING(byArray)));
            return sEQUENCE;
        }
        catch (Exception exception) {
            throw new PKIXException("Unable to generate the signing key-update request: " + exception.getMessage());
        }
    }

    private ASN1Object a(int n2, KeyPair keyPair, SecureStringBuffer secureStringBuffer, KeyPair keyPair2, PrivateKey privateKey, X509Certificate x509Certificate) throws PKIXException {
        try {
            byte[] byArray;
            SEQUENCE sEQUENCE;
            BigInteger bigInteger;
            GeneralName generalName;
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            SEQUENCE sEQUENCE3 = new SEQUENCE();
            sEQUENCE3.addComponent((ASN1Object)new INTEGER(n2));
            CertTemplateCMP certTemplateCMP = new CertTemplateCMP();
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo();
            subjectPublicKeyInfo.decode(DerCoder.decode((byte[])keyPair.getPublic().getEncoded()));
            certTemplateCMP.setPublicKey(subjectPublicKeyInfo);
            X509Extensions x509Extensions = new X509Extensions();
            KeyUsage keyUsage = new KeyUsage(1);
            x509Extensions.addExtension((V3Extension)keyUsage);
            certTemplateCMP.setExtensions((SEQUENCE)x509Extensions.toASN1Object());
            sEQUENCE3.addComponent(certTemplateCMP.toASN1Object());
            Controls controls = new Controls();
            controls.setPublicationInfo(false);
            controls.setArchiveKey(false);
            if (keyPair2 != null) {
                controls.setProtocolEncryptionKey(keyPair2.getPublic());
            }
            if (x509Certificate != null) {
                generalName = new GeneralName(GeneralName.directoryName, (Object)x509Certificate.getIssuerDN());
                bigInteger = x509Certificate.getSerialNumber();
                controls.setOldCertId(generalName, new INTEGER(bigInteger));
            }
            sEQUENCE3.addComponent(controls.toASN1Object());
            sEQUENCE2.addComponent((ASN1Object)sEQUENCE3);
            generalName = new SEQUENCE();
            bigInteger = new SEQUENCE();
            if (secureStringBuffer != null) {
                sEQUENCE = new SEQUENCE();
                byArray = new byte[10];
                sEQUENCE.addComponent(this.a(byArray).toASN1Object());
                byte[] byArray2 = this.a(keyPair.getPublic().getEncoded(), secureStringBuffer, byArray);
                sEQUENCE.addComponent((ASN1Object)new BIT_STRING(byArray2));
                bigInteger.addComponent((ASN1Object)sEQUENCE);
            } else {
                sEQUENCE = new GeneralName(GeneralName.directoryName, (Object)x509Certificate.getSubjectDN());
                bigInteger.addComponent((ASN1Object)new CON_SPEC(0, sEQUENCE.toASN1Object()));
            }
            bigInteger.addComponent(subjectPublicKeyInfo.toASN1Object());
            generalName.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)bigInteger, true));
            sEQUENCE = this.a(keyPair.getPrivate());
            generalName.addComponent(sEQUENCE.toASN1Object(false));
            byArray = this.a(DerCoder.encode((ASN1Object)bigInteger), keyPair.getPrivate());
            generalName.addComponent((ASN1Object)new BIT_STRING(byArray));
            sEQUENCE2.addComponent((ASN1Object)new CON_SPEC(1, (ASN1Object)generalName, true));
            return sEQUENCE2;
        }
        catch (Exception exception) {
            throw new PKIXException("Could not generate signing certificate request: " + exception.getMessage());
        }
    }

    private ASN1Object b(SecureStringBuffer secureStringBuffer, SecureStringBuffer secureStringBuffer2, KeyPair keyPair, KeyPair keyPair2, KeyPair keyPair3) throws PKIXException {
        try {
            SEQUENCE sEQUENCE = new SEQUENCE();
            this.m_senderNonce = new byte[16];
            this.ansiRandom.nextBytes(this.m_senderNonce);
            this.m_recipNonce = null;
            try {
                this.a = new Integer(this.ansiRandom.nextInt()).toString().getBytes("iso_8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    this.a = new Integer(this.ansiRandom.nextInt()).toString().getBytes("iso8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    this.a = new Integer(this.ansiRandom.nextInt()).toString().getBytes();
                }
            }
            PKIHeader pKIHeader = this.a(secureStringBuffer);
            sEQUENCE.addComponent(pKIHeader.toASN1Object());
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            if (keyPair2 == null) {
                sEQUENCE2.addComponent(this.a(0, keyPair, secureStringBuffer2, keyPair3, null, null));
            } else {
                sEQUENCE2.addComponent(this.a(0, keyPair, secureStringBuffer2, null, null, null));
                sEQUENCE2.addComponent(this.a(1, keyPair2, keyPair3, null));
            }
            sEQUENCE.addComponent((ASN1Object)new CON_SPEC(9, (ASN1Object)sEQUENCE2));
            byte[] byArray = this.a(DerCoder.encode((ASN1Object)sEQUENCE), secureStringBuffer2, this.c);
            sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)new BIT_STRING(byArray)));
            return sEQUENCE;
        }
        catch (Exception exception) {
            throw new PKIXException("Unable to generate the recovery request: " + exception.getMessage());
        }
    }

    private PKIHeader a(X509Certificate x509Certificate) throws PKIXException {
        try {
            PKIHeader pKIHeader = new PKIHeader(1);
            pKIHeader.setSender(new GeneralName(GeneralName.directoryName, (Object)x509Certificate.getSubjectDN()));
            pKIHeader.setRecipient(new GeneralName(GeneralName.directoryName, (Object)x509Certificate.getIssuerDN()));
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(this.a(x509Certificate.getPublicKey()));
            algorithmIdentifier.setNoParameters(true);
            pKIHeader.setProtectionAlg(algorithmIdentifier);
            pKIHeader.setSenderKID((ASN1Object)new OCTET_STRING(this.b(x509Certificate)));
            pKIHeader.setTransactionID(new OCTET_STRING(this.a));
            pKIHeader.setSenderNonce(new OCTET_STRING(this.m_senderNonce));
            if (this.m_recipNonce != null) {
                pKIHeader.setRecipNonce(new OCTET_STRING(this.m_recipNonce));
            }
            String[] stringArray = new String[]{"Entrust Version 5.0", "Entrust User 5.0"};
            pKIHeader.setFreeText(stringArray);
            return pKIHeader;
        }
        catch (Exception exception) {
            throw new PKIXException("Unable to create the PKIHeader: " + exception.getMessage());
        }
    }

    private PKIHeader a(SecureStringBuffer secureStringBuffer) throws PKIXException {
        try {
            PKIHeader pKIHeader = new PKIHeader(1);
            this.c = new byte[10];
            pKIHeader.setProtectionAlg(this.a(this.c));
            try {
                pKIHeader.setSenderKID((ASN1Object)new OCTET_STRING(secureStringBuffer.toByteArray("iso_8859-1")));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    pKIHeader.setSenderKID((ASN1Object)new OCTET_STRING(secureStringBuffer.toByteArray("iso8859-1")));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    pKIHeader.setSenderKID((ASN1Object)new OCTET_STRING(secureStringBuffer.toByteArray()));
                }
            }
            pKIHeader.setTransactionID(new OCTET_STRING(this.a));
            pKIHeader.setSenderNonce(new OCTET_STRING(this.m_senderNonce));
            if (this.m_recipNonce != null) {
                pKIHeader.setRecipNonce(new OCTET_STRING(this.m_recipNonce));
            }
            String[] stringArray = new String[]{"Entrust Version 5.0", "Entrust User 5.0"};
            pKIHeader.setFreeText(stringArray);
            return pKIHeader;
        }
        catch (Exception exception) {
            throw new PKIXException("Unable to create the PKIHeader: " + exception.getMessage());
        }
    }

    private AlgorithmID a(byte[] byArray) {
        AlgorithmID algorithmID = new AlgorithmID("1.2.840.113533.7.66.13", "passwordBasedMac");
        SEQUENCE sEQUENCE = new SEQUENCE();
        this.ansiRandom.nextBytes(byArray);
        sEQUENCE.addComponent((ASN1Object)new OCTET_STRING(byArray));
        sEQUENCE.addComponent(AlgorithmID.sha1.toASN1Object(false));
        sEQUENCE.addComponent((ASN1Object)new INTEGER(1000));
        AlgorithmID algorithmID2 = new AlgorithmID("1.2.840.113533.7.66.11", "cast5Mac");
        SEQUENCE sEQUENCE2 = new SEQUENCE();
        sEQUENCE2.addComponent((ASN1Object)new INTEGER(64));
        sEQUENCE2.addComponent((ASN1Object)new INTEGER(80));
        algorithmID2.setParameter((ASN1Object)sEQUENCE2);
        sEQUENCE.addComponent(algorithmID2.toASN1Object());
        algorithmID.setParameter((ASN1Object)sEQUENCE);
        return algorithmID;
    }

    private ASN1Object a(SecureStringBuffer secureStringBuffer, SecureStringBuffer secureStringBuffer2, KeyPair keyPair, KeyPair keyPair2, KeyPair keyPair3) throws PKIXException {
        try {
            SEQUENCE sEQUENCE = new SEQUENCE();
            this.m_senderNonce = new byte[16];
            this.ansiRandom.nextBytes(this.m_senderNonce);
            this.m_recipNonce = null;
            try {
                this.a = new Integer(this.ansiRandom.nextInt()).toString().getBytes("iso_8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    this.a = new Integer(this.ansiRandom.nextInt()).toString().getBytes("iso8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    this.a = new Integer(this.ansiRandom.nextInt()).toString().getBytes();
                }
            }
            PKIHeader pKIHeader = this.a(secureStringBuffer);
            sEQUENCE.addComponent(pKIHeader.toASN1Object());
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(this.a(0, keyPair, secureStringBuffer2, null, null, null));
            sEQUENCE2.addComponent(this.a(1, keyPair2, keyPair3, null));
            sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)sEQUENCE2));
            byte[] byArray = this.a(DerCoder.encode((ASN1Object)sEQUENCE), secureStringBuffer2, this.c);
            sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)new BIT_STRING(byArray)));
            return sEQUENCE;
        }
        catch (Exception exception) {
            throw new PKIXException("Unable to generate the initialization request: " + exception.getMessage());
        }
    }

    private ASN1Object a(KeyPair keyPair, KeyPair keyPair2, PrivateKey privateKey, X509Certificate x509Certificate, X509Certificate x509Certificate2) throws PKIXException {
        try {
            SEQUENCE sEQUENCE = new SEQUENCE();
            this.m_senderNonce = new byte[16];
            this.ansiRandom.nextBytes(this.m_senderNonce);
            this.m_recipNonce = null;
            try {
                this.a = new Integer(this.ansiRandom.nextInt()).toString().getBytes("iso_8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    this.a = new Integer(this.ansiRandom.nextInt()).toString().getBytes("iso8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    this.a = new Integer(this.ansiRandom.nextInt()).toString().getBytes();
                }
            }
            PKIHeader pKIHeader = this.a(x509Certificate2);
            sEQUENCE.addComponent(pKIHeader.toASN1Object());
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(this.a(0, keyPair, keyPair2, x509Certificate));
            sEQUENCE.addComponent((ASN1Object)new CON_SPEC(7, (ASN1Object)sEQUENCE2));
            byte[] byArray = this.a(DerCoder.encode((ASN1Object)sEQUENCE), privateKey);
            sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)new BIT_STRING(byArray)));
            return sEQUENCE;
        }
        catch (Exception exception) {
            throw new PKIXException("Unable to generate the encryption key-update request: " + exception.getMessage());
        }
    }

    private ASN1Object a(int n2, KeyPair keyPair, KeyPair keyPair2, X509Certificate x509Certificate) throws PKIXException {
        try {
            SubjectPublicKeyInfo subjectPublicKeyInfo;
            SEQUENCE sEQUENCE = new SEQUENCE();
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent((ASN1Object)new INTEGER(n2));
            CertTemplateCMP certTemplateCMP = new CertTemplateCMP();
            if (keyPair != null) {
                subjectPublicKeyInfo = new SubjectPublicKeyInfo();
                subjectPublicKeyInfo.decode(DerCoder.decode((byte[])keyPair.getPublic().getEncoded()));
                certTemplateCMP.setPublicKey(subjectPublicKeyInfo);
            }
            subjectPublicKeyInfo = new X509Extensions();
            KeyUsage keyUsage = new KeyUsage(4);
            subjectPublicKeyInfo.addExtension((V3Extension)keyUsage);
            certTemplateCMP.setExtensions((SEQUENCE)subjectPublicKeyInfo.toASN1Object());
            sEQUENCE2.addComponent(certTemplateCMP.toASN1Object());
            Controls controls = new Controls();
            controls.setPublicationInfo(true);
            if (keyPair2 != null) {
                controls.setProtocolEncryptionKey(keyPair2.getPublic());
            }
            if (keyPair == null) {
                controls.setArchiveKey(true);
            } else {
                controls.setArchiveKey(false);
            }
            if (x509Certificate != null) {
                GeneralName generalName = new GeneralName(GeneralName.directoryName, (Object)x509Certificate.getIssuerDN());
                BigInteger bigInteger = x509Certificate.getSerialNumber();
                controls.setOldCertId(generalName, new INTEGER(bigInteger));
            }
            sEQUENCE2.addComponent(controls.toASN1Object());
            sEQUENCE.addComponent((ASN1Object)sEQUENCE2);
            return sEQUENCE;
        }
        catch (Exception exception) {
            throw new PKIXException("Could not generate encryption certificate request: " + exception.getMessage());
        }
    }

    private ASN1Object b(SecureStringBuffer secureStringBuffer, SecureStringBuffer secureStringBuffer2) throws PKIXException {
        try {
            SEQUENCE sEQUENCE = new SEQUENCE();
            this.m_senderNonce = new byte[16];
            this.ansiRandom.nextBytes(this.m_senderNonce);
            this.m_recipNonce = null;
            try {
                this.a = new Integer(this.ansiRandom.nextInt()).toString().getBytes("iso_8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    this.a = new Integer(this.ansiRandom.nextInt()).toString().getBytes("iso8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    this.a = new Integer(this.ansiRandom.nextInt()).toString().getBytes();
                }
            }
            PKIHeader pKIHeader = this.a(secureStringBuffer);
            sEQUENCE.addComponent(pKIHeader.toASN1Object());
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            SEQUENCE sEQUENCE3 = new SEQUENCE();
            sEQUENCE3.addComponent((ASN1Object)new ObjectID("1.2.840.113533.7.78.0", "policyCertificateRequest"));
            sEQUENCE2.addComponent((ASN1Object)sEQUENCE3);
            sEQUENCE.addComponent((ASN1Object)new CON_SPEC(21, (ASN1Object)sEQUENCE2));
            byte[] byArray = this.a(DerCoder.encode((ASN1Object)sEQUENCE), secureStringBuffer2, this.c);
            sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)new BIT_STRING(byArray)));
            return sEQUENCE;
        }
        catch (Exception exception) {
            throw new PKIXException("Unable to generate the client settings request: " + exception.getMessage());
        }
    }

    private ASN1Object a(X509Certificate x509Certificate, byte[] byArray) throws PKIXException {
        try {
            SEQUENCE sEQUENCE = new SEQUENCE();
            PKIHeader pKIHeader = this.a(x509Certificate);
            this.c = new byte[10];
            pKIHeader.setProtectionAlg(this.a(this.c));
            sEQUENCE.addComponent(pKIHeader.toASN1Object());
            sEQUENCE.addComponent((ASN1Object)new CON_SPEC(19, (ASN1Object)new NULL()));
            byte[] byArray2 = this.a(DerCoder.encode((ASN1Object)sEQUENCE), byArray, this.c);
            sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)new BIT_STRING(byArray2)));
            return sEQUENCE;
        }
        catch (Exception exception) {
            throw new PKIXException("Unable to generate the confirmation: " + exception.getMessage());
        }
    }

    private ASN1Object a(X509Certificate x509Certificate, PrivateKey privateKey) throws PKIXException {
        try {
            SEQUENCE sEQUENCE = new SEQUENCE();
            PKIHeader pKIHeader = this.a(x509Certificate);
            sEQUENCE.addComponent(pKIHeader.toASN1Object());
            sEQUENCE.addComponent((ASN1Object)new CON_SPEC(19, (ASN1Object)new NULL()));
            byte[] byArray = this.a(DerCoder.encode((ASN1Object)sEQUENCE), privateKey);
            sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)new BIT_STRING(byArray)));
            return sEQUENCE;
        }
        catch (Exception exception) {
            throw new PKIXException("Unable to generate the confirmation: " + exception.getMessage());
        }
    }

    private ASN1Object a(SecureStringBuffer secureStringBuffer, byte[] byArray) throws PKIXException {
        try {
            SEQUENCE sEQUENCE = new SEQUENCE();
            PKIHeader pKIHeader = this.a(secureStringBuffer);
            GeneralName generalName = new GeneralName(GeneralName.directoryName, (Object)this.m_caCertificate.getIssuerDN());
            pKIHeader.setRecipient(generalName);
            sEQUENCE.addComponent(pKIHeader.toASN1Object());
            sEQUENCE.addComponent((ASN1Object)new CON_SPEC(19, (ASN1Object)new NULL()));
            byte[] byArray2 = this.a(DerCoder.encode((ASN1Object)sEQUENCE), byArray, this.c);
            sEQUENCE.addComponent((ASN1Object)new CON_SPEC(0, (ASN1Object)new BIT_STRING(byArray2)));
            return sEQUENCE;
        }
        catch (Exception exception) {
            throw new PKIXException("Unable to generate the confirmation: " + exception.getMessage());
        }
    }

    private ASN1Object a(SecureStringBuffer secureStringBuffer, SecureStringBuffer secureStringBuffer2) throws PKIXException {
        byte[] byArray = null;
        try {
            byArray = secureStringBuffer2.toByteArray("iso_8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                byArray = secureStringBuffer2.toByteArray("iso8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                byArray = secureStringBuffer2.toByteArray();
            }
        }
        return this.a(secureStringBuffer, byArray);
    }

    private byte[] a(ASN1Object aSN1Object, PrivateKey privateKey) throws PKIXException {
        try {
            Object object;
            Object object2;
            Object object3;
            AlgorithmID algorithmID = null;
            byte[] byArray = null;
            byte[] byArray2 = null;
            try {
                object3 = (CON_SPEC)aSN1Object.getComponentAt(0);
                object3.forceImplicitlyTagged(ASN.SEQUENCE);
                algorithmID = new AlgorithmID((ASN1Object)((SEQUENCE)object3.getValue()));
                object3 = (CON_SPEC)aSN1Object.getComponentAt(1);
                object3.forceImplicitlyTagged(ASN.BIT_STRING);
                byArray = (byte[])((BIT_STRING)object3.getValue()).getValue();
                byArray2 = (byte[])((BIT_STRING)aSN1Object.getComponentAt(2)).getValue();
            }
            catch (Exception exception) {
                throw new PKIXException("Failed decoding EncryptedValue: " + exception.getMessage());
            }
            object3 = algorithmID.getName();
            int n2 = ((String)object3).lastIndexOf("-");
            Object object4 = object3;
            String string = null;
            if (n2 != -1) {
                object4 = ((String)object3).substring(0, n2);
                string = ((String)object3).substring(n2 + 1, ((String)object3).length());
            }
            SecretKey secretKey = null;
            try {
                object2 = Cipher.getInstance(privateKey.getAlgorithm(), "Entrust");
                ((Cipher)object2).init(2, privateKey);
                object = ((Cipher)object2).doFinal(byArray);
                secretKey = new SecretKey((byte[])object, (String)object4);
                this.b = object;
            }
            catch (Exception exception) {
                throw new PKIXException("Failed decrypting encSymmKey: " + exception.getMessage());
            }
            try {
                object = null;
                object = string == null ? (Object)Cipher.getInstance((String)object4) : (Object)Cipher.getInstance(String.valueOf(object4) + "/" + string + "/PKCS5Padding");
                byte[] byArray3 = new byte[8];
                CryptoUtils.zeroBlock((byte[])byArray3);
                IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray3);
                ((Cipher)object).init(2, (Key)secretKey, ivParameterSpec);
                object2 = ((Cipher)object).doFinal(byArray2);
            }
            catch (Exception exception) {
                throw new PKIXException("Failed decrypting encValue: " + exception.getMessage());
            }
            return object2;
        }
        catch (Exception exception) {
            throw new PKIXException("Unable to decrypt EncryptedValue: " + exception.getMessage());
        }
    }

    public void createUser(ManagerTransport managerTransport, SecureStringBuffer secureStringBuffer, SecureStringBuffer secureStringBuffer2, KeyPair keyPair, KeyPair keyPair2, KeyPair keyPair3) throws PKIXException {
        managerTransport.beginNewSession();
        ASN1Object aSN1Object = this.a(secureStringBuffer2, secureStringBuffer, keyPair2, keyPair3, keyPair);
        this.a(aSN1Object, "IR.bin");
        byte[] byArray = this.a(aSN1Object, d);
        try {
            managerTransport.getOutputStream().write(byArray);
            managerTransport.getOutputStream().flush();
        }
        catch (Exception exception) {
            throw new PKIXException("Could not send the initialization request to the PKI: " + exception.getMessage());
        }
        SEQUENCE sEQUENCE = null;
        try {
            byte[] byArray2 = managerTransport.readPKIXCMPResponse(true);
            this.a(byArray2, "IP.bin");
            sEQUENCE = (SEQUENCE)DerCoder.decode((byte[])byArray2);
        }
        catch (Exception exception) {
            throw new PKIXException("Could not receive the initialization response from the PKI: " + exception.getMessage());
        }
        this.a(sEQUENCE, secureStringBuffer, keyPair3, keyPair);
        this.setSigningKey(keyPair2.getPrivate());
        this.m_refNo = secureStringBuffer2;
        this.m_authCode = keyPair3 == null ? secureStringBuffer : null;
    }

    private byte[] a(ASN1Object aSN1Object, byte by) throws PKIXException {
        byte[] byArray = null;
        try {
            byArray = DerCoder.encode((ASN1Object)aSN1Object);
        }
        catch (Exception exception) {
            throw new PKIXException("Failed to encode request: " + exception.getMessage());
        }
        byte[] byArray2 = new byte[5 + byArray.length];
        int n2 = byArray.length + 1;
        int n3 = 0;
        while (n3 < 4) {
            byArray2[n3] = (byte)((double)n2 % Math.pow(256.0, n3) / Math.pow(256.0, 3 - n3));
            ++n3;
        }
        byArray2[4] = by;
        int n4 = 0;
        while (n4 < byArray.length) {
            byArray2[n4 + 5] = byArray[n4];
            ++n4;
        }
        return byArray2;
    }

    private byte[] a(byte[] byArray, PrivateKey privateKey) throws PKIXException {
        try {
            Signature signature = null;
            String string = privateKey.getAlgorithm();
            try {
                try {
                    signature = Signature.getInstance("SHA-1/" + string, "Entrust");
                }
                catch (Exception exception) {
                    signature = Signature.getInstance("SHA-1/" + string);
                }
            }
            catch (Exception exception) {
                throw new PKIXException("Unknown signing algorithm - SHA-1/" + string);
            }
            try {
                if (privateKey instanceof k) {
                    signature.initSign((PrivateKey)new ConfinedKey((k)privateKey));
                } else {
                    signature.initSign(privateKey);
                }
            }
            catch (Exception exception) {
                throw new PKIXException("Signing key not valid: " + exception.getMessage());
            }
            signature.update(byArray);
            return signature.sign();
        }
        catch (Exception exception) {
            throw new PKIXException("Unable to sign data: " + exception.getMessage());
        }
    }

    private byte[] a(byte[] byArray, byte[] byArray2, byte[] byArray3) throws PKIXException {
        try {
            byte[] byArray4 = new byte[byArray2.length + byArray3.length];
            System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
            System.arraycopy(byArray3, 0, byArray4, byArray2.length, byArray3.length);
            ExtendedHasher extendedHasher = new ExtendedHasher();
            extendedHasher.setInput(byArray4);
            SecretKey secretKey = new SecretKey(extendedHasher.getOutput(10, 1000), "Cast128");
            return MacGenerator.generate((String)"pbeWithSHA1AndCAST5-CBC", (Key)secretKey, (byte[])byArray);
        }
        catch (Exception exception) {
            throw new PKIXException("MAC creation failed: " + exception.getMessage());
        }
    }

    private byte[] a(byte[] byArray, SecureStringBuffer secureStringBuffer, byte[] byArray2) throws PKIXException {
        byte[] byArray3 = null;
        try {
            byArray3 = secureStringBuffer.toByteArray("iso_8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                byArray3 = secureStringBuffer.toByteArray("iso8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                byArray3 = secureStringBuffer.toByteArray();
            }
        }
        return this.a(byArray, byArray3, byArray2);
    }

    private void a(SEQUENCE sEQUENCE, ValidationInfo validationInfo) throws PKIXException {
        SEQUENCE sEQUENCE2;
        Object object;
        SEQUENCE sEQUENCE3;
        AlgorithmID algorithmID = null;
        try {
            sEQUENCE3 = (SEQUENCE)sEQUENCE.getComponentAt(0);
            int n2 = 3;
            while (n2 < sEQUENCE3.countComponents()) {
                object = (CON_SPEC)sEQUENCE3.getComponentAt(n2);
                if (object.getAsnType().getTag() == 1) {
                    algorithmID = new AlgorithmID((ASN1Object)object.getValue());
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            throw new PKIXException("Unable to extract protection algorithm from response: " + exception.getMessage());
        }
        if (algorithmID == null) {
            throw new PKIXException("Response does not contain a protection algorithm");
        }
        sEQUENCE3 = null;
        try {
            sEQUENCE2 = (SEQUENCE)((CON_SPEC)sEQUENCE.getComponentAt(3)).getValue();
            sEQUENCE3 = new X509Certificate(DerCoder.encode((ASN1Object)sEQUENCE2.getComponentAt(0)));
        }
        catch (Exception exception) {
            throw new PKIXException("Unable to extract verification certificate from response: " + exception.getMessage());
        }
        sEQUENCE2 = new SEQUENCE();
        sEQUENCE2.addComponent(sEQUENCE.getComponentAt(0));
        sEQUENCE2.addComponent(sEQUENCE.getComponentAt(1));
        if (sEQUENCE.countComponents() < 3) {
            throw new PKIXException("Response was not protected");
        }
        object = null;
        try {
            object = (byte[])((ASN1Object)((CON_SPEC)sEQUENCE.getComponentAt(2)).getValue()).getValue();
        }
        catch (Exception exception) {
            throw new PKIXException("Unable to extract protection from response");
        }
        this.a(DerCoder.encode((ASN1Object)sEQUENCE2), (byte[])object, sEQUENCE3.getPublicKey());
        try {
            validationInfo.getCertificateStore().validate((X509Certificate)sEQUENCE3);
        }
        catch (Exception exception) {
            throw new PKIXException("Could not validate the certificate that signed the message");
        }
    }

    private void a(SEQUENCE sEQUENCE, SecureStringBuffer secureStringBuffer, byte[] byArray) throws PKIXException {
        SEQUENCE sEQUENCE2 = new SEQUENCE();
        sEQUENCE2.addComponent(sEQUENCE.getComponentAt(0));
        sEQUENCE2.addComponent(sEQUENCE.getComponentAt(1));
        byte[] byArray2 = this.a(DerCoder.encode((ASN1Object)sEQUENCE2), secureStringBuffer, byArray);
        if (sEQUENCE.countComponents() < 3) {
            throw new PKIXException("Response was not protected");
        }
        byte[] byArray3 = null;
        try {
            byArray3 = (byte[])((ASN1Object)((CON_SPEC)sEQUENCE.getComponentAt(2)).getValue()).getValue();
        }
        catch (Exception exception) {
            throw new PKIXException("Unable to extract protection from response");
        }
        int n2 = byArray2.length;
        if (n2 != byArray3.length) {
            throw new PKIXException("Protection verification failed");
        }
        int n3 = 0;
        while (n3 < n2) {
            if (byArray2[n3] != byArray3[n3]) {
                throw new PKIXException("Protection verification failed");
            }
            ++n3;
        }
    }

    private void a(SEQUENCE sEQUENCE) throws PKIXException {
        try {
            int n2 = 0;
            try {
                n2 = ((BigInteger)((INTEGER)sEQUENCE.getComponentAt(0)).getValue()).intValue();
            }
            catch (Exception exception) {
                throw new PKIXException("Unable to extract version from PKIHeader");
            }
            if (n2 != this.getVersion()) {
                throw new PKIXException("Invalid PKIX message version: " + n2);
            }
            CON_SPEC cON_SPEC = null;
            int n3 = 3;
            while (n3 < sEQUENCE.countComponents()) {
                cON_SPEC = (CON_SPEC)sEQUENCE.getComponentAt(n3);
                int n4 = cON_SPEC.getAsnType().getTag();
                switch (n4) {
                    case 0: {
                        GeneralizedTime generalizedTime = null;
                        try {
                            generalizedTime = (GeneralizedTime)cON_SPEC.getValue();
                        }
                        catch (Exception exception) {
                            throw new PKIXException("'messageTime' must be a GeneralizedTime");
                        }
                        Date date = new ChoiceOfTime((ASN1Object)generalizedTime).getDate();
                        long l = 3600000L;
                        long l2 = System.currentTimeMillis();
                        if (Math.abs(date.getTime() - l2) <= 2L * l) break;
                        throw new PKIXException("There is more than a 2 hour time difference between the client and the server");
                    }
                    case 5: {
                        try {
                            this.m_recipNonce = (byte[])((OCTET_STRING)cON_SPEC.getValue()).getValue();
                            break;
                        }
                        catch (Exception exception) {
                            throw new CodingException("'senderNonce' must be an OCTET_STRING");
                        }
                    }
                    case 6: {
                        byte[] byArray = null;
                        try {
                            byArray = (byte[])((OCTET_STRING)cON_SPEC.getValue()).getValue();
                        }
                        catch (Exception exception) {
                            throw new CodingException("'recipNonce' must be an OCTET_STRING");
                        }
                        int n5 = byArray.length;
                        if (n5 != this.m_senderNonce.length) {
                            throw new PKIXException("The received recipient nonce does not match the sender nonce sent.");
                        }
                        int n6 = 0;
                        while (n6 < n5) {
                            if (byArray[n6] != this.m_senderNonce[n6]) {
                                throw new PKIXException("The received recipient nonce does not match the sender nonce sent.");
                            }
                            ++n6;
                        }
                        break;
                    }
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            throw new PKIXException("Problem with received PKIHeader: " + exception.getMessage());
        }
    }

    static {
        try {
            TRACE_LEVEL = Integer.getInteger("com.entrust.toolkit.util.PKIXCMP.trace", 0);
            DEBUG = TRACE_LEVEL > 0;
        }
        catch (Throwable throwable) {}
        d = 0;
        e = (byte)5;
    }
}

