/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.x509;

import com.entrust.toolkit.util.PEMString;
import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.structures.Name;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.UnsupportedEncodingException;

public class X509CertificateWrapper {
    private X509Certificate a = null;

    public Name getIssuer() {
        try {
            ASN1 aSN1 = new ASN1(this.a.getTBSCertificate());
            if (aSN1.getComponentAt(0).isA(ASN.CON_SPEC)) {
                return new Name(aSN1.getComponentAt(3));
            }
            return new Name(aSN1.getComponentAt(2));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getHistoryName() {
        try {
            Name name = this.getIssuer();
            byte[] byArray = new ASN1(name.toASN1Object()).toByteArray();
            String string = null;
            try {
                string = new String(Util.Base64Encode((byte[])byArray), "iso_8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    string = new String(Util.Base64Encode((byte[])byArray), "iso8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    string = new String(Util.Base64Encode((byte[])byArray));
                }
            }
            PEMString pEMString = new PEMString(string);
            return String.valueOf(pEMString.getPemString()) + "," + this.a.getSerialNumber().toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public ASN1Object getASN1Subject() {
        try {
            ASN1 aSN1 = new ASN1(this.a.getTBSCertificate());
            if (aSN1.getComponentAt(0).isA(ASN.CON_SPEC)) {
                return aSN1.getComponentAt(5);
            }
            return aSN1.getComponentAt(4);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public X509CertificateWrapper(X509Certificate x509Certificate) {
        this.a = x509Certificate;
    }
}

