/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.x509.certstore;

import com.entrust.toolkit.CertificateSet;
import com.entrust.toolkit.exceptions.UserFatalException;
import com.entrust.toolkit.util.CRC;
import com.entrust.toolkit.util.ExtendedHasher;
import com.entrust.toolkit.util.IniFile;
import com.entrust.toolkit.util.PEMString;
import com.entrust.toolkit.x509.certstore.CertificateGraph;
import com.entrust.toolkit.x509.certstore.CertificateStore;
import com.entrust.toolkit.x509.certstore.i;
import iaik.asn1.structures.Name;
import iaik.security.cipher.SecretKey;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.BasicConstraints;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;

public class ArchiveCertCache
extends CertificateStore {
    public static int USER_AND_CROSS_CERT;
    public static int CROSS_CERT_ONLY;
    public static int USER_CERT_ONLY;
    private static final String e = "Ron McEwen and Lee Dilkie";
    private static final int d = 100;
    private static final int f = 128;
    private AlgorithmParameterSpec a = null;
    private SecretKey b = null;
    private i c = null;

    public void write(OutputStream outputStream, int n2) throws UserFatalException {
        i i2 = this.c;
        IniFile iniFile = new IniFile();
        while (i2 != null) {
            Name name = i2.getName();
            X509Certificate[] x509CertificateArray = i2.getCerts();
            String string = name.toString().toLowerCase();
            int n3 = 0;
            while (n3 < x509CertificateArray.length) {
                if ((n2 != USER_CERT_ONLY || this.a(x509CertificateArray[n3])) && (n2 != CROSS_CERT_ONLY || this.b(x509CertificateArray[n3]))) {
                    String string2 = Integer.toString(n3);
                    if (string2.length() == 1) {
                        string2 = "0" + string2;
                    }
                    String string3 = "Certificate" + string2;
                    String string4 = this.a(string, string3, x509CertificateArray[n3]);
                    string3 = "@" + string3;
                    iniFile.putString(string, string3, string4);
                }
                ++n3;
            }
            i2 = i2.next();
        }
        iniFile.writeStream(outputStream);
    }

    private synchronized void a(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = 0;
            ++n2;
        }
    }

    private byte[] a(String string, String string2, String string3) throws UserFatalException {
        try {
            Cipher cipher = Cipher.getInstance("CAST5/CBC/PKCS5Padding");
            cipher.init(2, (Key)this.b, this.a);
            byte[] byArray = null;
            try {
                byArray = string.getBytes("iso_8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    byArray = string.getBytes("iso8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    byArray = string.getBytes();
                }
            }
            byte[] byArray2 = cipher.doFinal(Util.Base64Decode((byte[])byArray));
            byte[] byArray3 = new byte[byArray2.length - 2];
            System.arraycopy(byArray2, 2, byArray3, 0, byArray3.length);
            byte[] byArray4 = new byte[]{byArray2[0], byArray2[1]};
            CRC cRC = new CRC();
            int n2 = cRC.calculateCRC(byArray3);
            byte[] byArray5 = new byte[]{(byte)(n2 >> 8 & 0xFF), (byte)(n2 & 0xFF)};
            if (byArray5[0] != byArray4[0] || byArray5[1] != byArray4[1]) {
                throw new UserFatalException("CRC check failed.");
            }
            StringBuffer stringBuffer = new StringBuffer(String.valueOf(string2) + string3);
            int n3 = 0;
            while (n3 < stringBuffer.length()) {
                if (stringBuffer.charAt(n3) != (char)byArray3[n3]) {
                    this.a(byArray2);
                    this.a(byArray3);
                    throw new UserFatalException("The value for entry " + string3 + " has been tampered.");
                }
                ++n3;
            }
            int n4 = string2.length() + string3.length();
            byte[] byArray6 = new byte[byArray3.length - n4];
            System.arraycopy(byArray3, n4, byArray6, 0, byArray6.length);
            this.a(byArray2);
            this.a(byArray3);
            return byArray6;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new UserFatalException(exception.getMessage());
        }
    }

    private String a(String string, String string2, X509Certificate x509Certificate) throws UserFatalException {
        try {
            byte[] byArray = x509Certificate.getEncoded();
            int n2 = string.length();
            int n3 = string2.length();
            int n4 = byArray.length;
            byte[] byArray2 = new byte[n2 + n3 + n4];
            try {
                System.arraycopy(string.getBytes("iso_8859-1"), 0, byArray2, 0, n2);
                System.arraycopy(string2.getBytes("iso_8859-1"), 0, byArray2, n2, n3);
                System.arraycopy(byArray, 0, byArray2, n2 + n3, n4);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    System.arraycopy(string.getBytes("iso8859-1"), 0, byArray2, 0, n2);
                    System.arraycopy(string2.getBytes("iso8859-1"), 0, byArray2, n2, n3);
                    System.arraycopy(byArray, 0, byArray2, n2 + n3, n4);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    System.arraycopy(string.getBytes(), 0, byArray2, 0, n2);
                    System.arraycopy(string2.getBytes(), 0, byArray2, n2, n3);
                    System.arraycopy(byArray, 0, byArray2, n2 + n3, n4);
                }
            }
            CRC cRC = new CRC();
            int n5 = cRC.calculateCRC(byArray2);
            byte[] byArray3 = new byte[byArray2.length + 2];
            byArray3[0] = (byte)(n5 >> 8 & 0xFF);
            byArray3[1] = (byte)(n5 & 0xFF);
            System.arraycopy(byArray2, 0, byArray3, 2, byArray2.length);
            Cipher cipher = Cipher.getInstance("CAST5/CBC/PKCS5Padding");
            cipher.init(1, (Key)this.b, this.a);
            byte[] byArray4 = Util.Base64Encode((byte[])cipher.doFinal(byArray3));
            String string3 = null;
            try {
                string3 = new String(byArray4, "iso_8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    string3 = new String(byArray4, "iso8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException3) {
                    string3 = new String(byArray4);
                }
            }
            return new PEMString(string3).getPemString();
        }
        catch (Exception exception) {
            throw new UserFatalException(exception.getMessage());
        }
    }

    private void a(IniFile iniFile) throws UserFatalException {
        try {
            Enumeration enumeration = iniFile.getSectionNames();
            String string = null;
            Vector vector = null;
            Vector<X509Certificate> vector2 = null;
            Object object = this.c;
            if (object != null) {
                while (((i)object).next() != null) {
                    object = ((i)object).next();
                }
            }
            while (enumeration.hasMoreElements()) {
                Object object2;
                int n2;
                Object object3;
                string = (String)enumeration.nextElement();
                vector = iniFile.getSection(string);
                if (vector == null) continue;
                int n3 = vector.size();
                vector2 = new Vector<X509Certificate>();
                int n4 = 0;
                while (n4 < n3) {
                    object3 = (String)vector.elementAt(n4);
                    n2 = ((String)object3).indexOf(61);
                    object2 = ((String)object3).substring(1, n2);
                    String string2 = ((String)object3).substring(n2 + 1);
                    if (((String)object2).startsWith("Certificate")) {
                        byte[] byArray = this.a(string2, string, (String)object2);
                        vector2.addElement(new X509Certificate(byArray));
                    }
                    ++n4;
                }
                object3 = new X509Certificate[vector2.size()];
                n2 = 0;
                while (n2 < ((Object)object3).length) {
                    object3[n2] = (X509Certificate)vector2.elementAt(n2);
                    ++n2;
                }
                object2 = new i(this, new Name(string), (X509Certificate[])object3);
                if (object == null) {
                    object = this.c = object2;
                    continue;
                }
                ((i)object).setSuccessor((i)object2);
                object = object2;
            }
        }
        catch (Exception exception) {
            throw new UserFatalException(exception.getMessage());
        }
    }

    public void parse(InputStream inputStream) throws UserFatalException {
        IniFile iniFile = new IniFile(inputStream);
        this.a(iniFile);
    }

    private boolean b(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return false;
        }
        try {
            BasicConstraints basicConstraints = (BasicConstraints)x509Certificate.getExtension(BasicConstraints.oid);
            if (basicConstraints == null) {
                return true;
            }
            return basicConstraints.ca();
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            return true;
        }
    }

    private boolean a(X509Certificate x509Certificate) {
        if (x509Certificate == null) {
            return false;
        }
        try {
            BasicConstraints basicConstraints = (BasicConstraints)x509Certificate.getExtension(BasicConstraints.oid);
            if (basicConstraints == null) {
                return true;
            }
            return basicConstraints.ca() ^ true;
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            return true;
        }
    }

    public void initMemoryCache() {
        i i2 = this.c;
        while (i2 != null) {
            X509Certificate[] x509CertificateArray = i2.getCerts();
            int n2 = 0;
            while (n2 < x509CertificateArray.length) {
                CertificateGraph.Graph().addCertificate(x509CertificateArray[n2]);
                ++n2;
            }
            i2 = i2.next();
        }
    }

    private void a() {
        ExtendedHasher extendedHasher = new ExtendedHasher();
        try {
            extendedHasher.setInput(e.getBytes("iso_8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                extendedHasher.setInput(e.getBytes("iso8859-1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                extendedHasher.setInput(e.getBytes());
            }
        }
        this.b = new SecretKey(extendedHasher.getOutput(16, 100), "CAST-128");
        this.a = new IvParameterSpec(extendedHasher.getOutput(8, 100));
    }

    public CertificateSet find(Principal principal) {
        i i2 = this.c;
        Object var3_3 = null;
        while (i2 != null) {
            Name name = i2.getName();
            if (name.equals((Object)principal)) {
                return new CertificateSet(i2.getCerts());
            }
            i2 = i2.next();
        }
        return null;
    }

    public void cleanup() {
        i i2 = this.c;
        i i3 = null;
        Date date = new Date();
        while (i2 != null) {
            X509Certificate[] x509CertificateArray;
            X509Certificate[] x509CertificateArray2 = i2.getCerts();
            Vector<X509Certificate> vector = new Vector<X509Certificate>();
            int n2 = 0;
            while (n2 < x509CertificateArray2.length) {
                x509CertificateArray = x509CertificateArray2[n2].getNotAfter();
                if (date.before((Date)x509CertificateArray)) {
                    vector.addElement(x509CertificateArray2[n2]);
                }
                ++n2;
            }
            if (vector.size() == 0) {
                if (i3 == null) {
                    this.c = i2.next();
                } else {
                    i3.setSuccessor(i2.next());
                }
                i2 = i2.next();
                continue;
            }
            if (vector.size() != x509CertificateArray2.length) {
                x509CertificateArray = new X509Certificate[vector.size()];
                int n3 = 0;
                while (n3 < x509CertificateArray.length) {
                    x509CertificateArray[n3] = (X509Certificate)vector.elementAt(n3);
                    ++n3;
                }
                i2.setCerts(x509CertificateArray);
                i3 = i2;
                i2 = i2.next();
                continue;
            }
            i3 = i2;
            i2 = i2.next();
        }
    }

    public void addMemoryCache() {
        this.addCertificates(CertificateGraph.Graph().getCertificates());
    }

    public void addCertificates(X509Certificate[] x509CertificateArray) {
        int n2 = 0;
        while (n2 < x509CertificateArray.length) {
            this.addCertificate(x509CertificateArray[n2]);
            ++n2;
        }
    }

    public void addCertificate(X509Certificate x509Certificate) {
        Name name;
        Name name2 = (Name)x509Certificate.getSubjectDN();
        i i2 = this.c;
        i i3 = null;
        while (i2 != null) {
            name = i2.getName();
            if (name.equals((Object)name2)) {
                X509Certificate[] x509CertificateArray = i2.getCerts();
                int n2 = 0;
                while (n2 < x509CertificateArray.length) {
                    if (x509CertificateArray[n2].equals(x509Certificate)) {
                        return;
                    }
                    ++n2;
                }
                X509Certificate[] x509CertificateArray2 = new X509Certificate[x509CertificateArray.length + 1];
                System.arraycopy(x509CertificateArray, 0, x509CertificateArray2, 0, x509CertificateArray.length);
                x509CertificateArray2[x509CertificateArray.length] = x509Certificate;
                i2.setCerts(x509CertificateArray2);
                return;
            }
            i3 = i2;
            i2 = i2.next();
        }
        name = new Name[]{x509Certificate};
        i i4 = new i(this, name2, (X509Certificate[])name);
        if (i3 == null) {
            this.c = i4;
        } else {
            i3.setSuccessor(i4);
        }
    }

    public ArchiveCertCache(InputStream inputStream) throws UserFatalException {
        this.a();
        IniFile iniFile = new IniFile(inputStream);
        this.a(iniFile);
    }

    public ArchiveCertCache() {
        this.a();
    }

    static {
        USER_CERT_ONLY = 1;
        CROSS_CERT_ONLY = 2;
        USER_AND_CROSS_CERT = 3;
    }
}

