/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.x509.certstore;

import com.entrust.toolkit.CertificateSet;
import com.entrust.toolkit.exceptions.CertificationException;
import com.entrust.toolkit.exceptions.CertificationRootException;
import com.entrust.toolkit.exceptions.LifespanException;
import com.entrust.toolkit.exceptions.RevocationException;
import com.entrust.toolkit.x509.ValidationInfo;
import com.entrust.toolkit.x509.certstore.CACrossCertCS;
import com.entrust.toolkit.x509.certstore.CertificateGraph;
import com.entrust.toolkit.x509.certstore.CertificateStore;
import com.entrust.toolkit.x509.certstore.c;
import com.entrust.toolkit.x509.certstore.d;
import com.entrust.toolkit.x509.certstore.h;
import com.entrust.toolkit.x509.policies.ClientSettings;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.KeyUsage;
import java.security.Principal;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class CollectionCS
extends CertificateStore {
    private h g;
    private Vector c;
    private CertificateGraph e = CertificateGraph.Graph();
    private ValidationInfo a = null;
    private c d = null;
    private static int b;
    private static boolean f;

    public X509Certificate[] validate(X509Certificate x509Certificate) throws CertificationException {
        Object object;
        Object object2;
        try {
            x509Certificate.checkValidity();
        }
        catch (CertificateExpiredException certificateExpiredException) {
            throw new LifespanException("certificate expired on " + x509Certificate.getNotAfter().toString(), certificateExpiredException);
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            throw new LifespanException("certificate not valid until " + x509Certificate.getNotBefore().toString(), certificateNotYetValidException);
        }
        boolean bl = true;
        X509Certificate x509Certificate2 = this.a.getRootOfTrust();
        if (x509Certificate2.hashCode() == x509Certificate.hashCode()) {
            X509Certificate[] x509CertificateArray = new X509Certificate[]{x509Certificate2};
            return x509CertificateArray;
        }
        try {
            object2 = (BasicConstraints)x509Certificate.getExtension(BasicConstraints.oid);
            if (object2 != null && object2.ca()) {
                bl = false;
            }
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {}
        object2 = null;
        Vector vector = new Vector();
        X509Certificate[] x509CertificateArray = null;
        int n2 = 0;
        if (!bl) {
            this.e.a(x509Certificate, true);
            vector.addElement(this.e.b(x509Certificate));
        } else {
            vector = this.e.a(x509Certificate);
        }
        CertificationException certificationException = null;
        if (vector != null) {
            n2 = vector.size();
        }
        while (vector != null && vector.size() > 0) {
            object2 = (c)vector.elementAt(0);
            vector.removeElementAt(0);
            try {
                x509CertificateArray = this.a(((c)object2).k);
                if (x509CertificateArray == null && (x509CertificateArray = this.d.a((c)object2, new Vector(20), this.a)) != null) {
                    this.g.a(x509CertificateArray);
                }
                if (x509CertificateArray == null) continue;
                if (!bl) {
                    ((c)object2).h();
                    return x509CertificateArray;
                }
                return this.a(x509CertificateArray, x509Certificate);
            }
            catch (RevocationException revocationException) {
                if (!revocationException.getCertificate().equals(x509Certificate)) continue;
                throw revocationException;
            }
            catch (CertificationException certificationException2) {
                if (!bl) {
                    ((c)object2).h();
                }
                certificationException = certificationException2;
            }
        }
        if (n2 == 1 && certificationException != null) {
            throw certificationException;
        }
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
        Vector<Object> vector2 = new Vector<Object>();
        vector2.addElement(x509Certificate);
        this.d.a();
        Enumeration enumeration = this.d.h.elements();
        while (enumeration.hasMoreElements()) {
            object = (c)enumeration.nextElement();
            vector2.addElement(((c)object).k);
        }
        this.d.d();
        object = String.valueOf(x509Certificate.getIssuerDN().toString()) + x509Certificate.getSerialNumber().toString();
        hashtable.put(object, x509Certificate);
        while (vector2.size() > 0) {
            String string;
            Object object3;
            Object object4;
            X509Certificate x509Certificate3 = (X509Certificate)vector2.elementAt(0);
            vector2.removeElementAt(0);
            CertificateSet certificateSet = this.e.find(x509Certificate3.getIssuerDN());
            CertificateSet certificateSet2 = this.e.find(x509Certificate3.getSubjectDN());
            if (certificateSet != null && certificateSet2 != null) {
                certificateSet = (CertificateSet)certificateSet.union(certificateSet2);
            } else if (certificateSet2 != null) {
                certificateSet = certificateSet2;
            } else if (certificateSet == null) {
                certificateSet = new CertificateSet(new X509Certificate[0]);
            }
            Enumeration enumeration2 = certificateSet.elements();
            while (enumeration2.hasMoreElements()) {
                object4 = enumeration2.nextElement();
                object3 = (X509Certificate)object4;
                string = String.valueOf(object3.getIssuerDN().toString()) + object3.getSerialNumber().toString();
                if (hashtable.containsKey(string)) continue;
                vector2.addElement(object4);
                hashtable.put(string, object4);
            }
            object4 = this.c.elements();
            while (object4.hasMoreElements()) {
                object3 = (CertificateStore)object4.nextElement();
                certificateSet = ((CertificateStore)object3).find(x509Certificate3.getIssuerDN());
                certificateSet2 = ((CertificateStore)object3).find(x509Certificate3.getSubjectDN());
                if (certificateSet != null && certificateSet2 != null) {
                    certificateSet = (CertificateSet)certificateSet.union(certificateSet2);
                } else if (certificateSet2 != null) {
                    certificateSet = certificateSet2;
                } else if (certificateSet == null) {
                    certificateSet = new CertificateSet(new X509Certificate[0]);
                }
                enumeration2 = certificateSet.elements();
                while (enumeration2.hasMoreElements()) {
                    string = (X509Certificate)enumeration2.nextElement();
                    String string2 = String.valueOf(string.getIssuerDN().toString()) + string.getSerialNumber().toString();
                    if (hashtable.containsKey(string2)) continue;
                    vector2.addElement(string);
                    hashtable.put(string2, string);
                    this.e.addCertificate((X509Certificate)string);
                }
                if (bl) {
                    Vector vector3 = vector = vector == null || vector.size() == 0 ? this.e.a(x509Certificate) : vector;
                    if (vector == null || vector.size() == 0) {
                        throw new CertificationException("Could not find the CA certificate that issued this certificate");
                    }
                } else {
                    vector = new Vector();
                    vector.addElement(this.e.b(x509Certificate));
                }
                if (vector != null) {
                    n2 = vector.size();
                }
                while (vector != null && vector.size() > 0) {
                    try {
                        object2 = (c)vector.elementAt(0);
                        vector.removeElementAt(0);
                        x509CertificateArray = this.d.a((c)object2, new Vector(20), this.a);
                        if (x509CertificateArray == null) continue;
                        this.g.a(x509CertificateArray);
                        if (!bl) {
                            ((c)object2).h();
                            return x509CertificateArray;
                        }
                        return this.a(x509CertificateArray, x509Certificate);
                    }
                    catch (RevocationException revocationException) {
                        if (!revocationException.getCertificate().equals(x509Certificate)) continue;
                        throw revocationException;
                    }
                    catch (CertificationException certificationException3) {
                        if (!bl) {
                            ((c)object2).h();
                        }
                        certificationException = certificationException3;
                    }
                }
            }
        }
        if (n2 == 1 && certificationException != null) {
            throw certificationException;
        }
        if (!bl) {
            ((c)object2).h();
        }
        throw new CertificationRootException("no chain found for " + x509Certificate.getSubjectDN());
    }

    private X509Certificate[] a(X509Certificate x509Certificate) {
        X509Certificate[] x509CertificateArray = this.g.a(x509Certificate);
        if (x509CertificateArray == null) {
            return null;
        }
        try {
            this.a.getExtensionTester().validate(x509CertificateArray);
            this.a.getRevocationStore().check(x509CertificateArray);
            if (b > 2) {
                System.out.println("The certificate chain table has returned a valid chain");
                h.b(x509CertificateArray);
            }
        }
        catch (CertificationException certificationException) {
            this.g.b(x509Certificate);
            x509CertificateArray = null;
        }
        return x509CertificateArray;
    }

    public CertificateSet find(Principal principal) {
        CertificateStore certificateStore = null;
        CertificateSet certificateSet = null;
        certificateSet = this.e.find(principal);
        if (certificateSet != null) {
            return certificateSet;
        }
        Enumeration enumeration = this.c.elements();
        while (enumeration.hasMoreElements()) {
            certificateStore = (CertificateStore)enumeration.nextElement();
            certificateSet = certificateStore.find(principal);
            if (certificateSet == null) continue;
            return certificateSet;
        }
        return null;
    }

    private X509Certificate[] a(X509Certificate[] x509CertificateArray, X509Certificate x509Certificate) throws CertificationException {
        X509Certificate[] x509CertificateArray2 = new X509Certificate[x509CertificateArray.length + 1];
        System.arraycopy(x509CertificateArray, 0, x509CertificateArray2, 0, x509CertificateArray.length);
        x509CertificateArray2[x509CertificateArray.length] = x509Certificate;
        this.a.getExtensionTester().validate(x509CertificateArray2);
        this.a.getRevocationStore().check(x509CertificateArray2);
        if (f) {
            X509Certificate x509Certificate2 = x509CertificateArray2[0];
            System.out.println("Validated chain FROM \"" + x509Certificate2.getIssuerDN().toString() + " " + x509Certificate2.getSubjectDN().toString() + " " + x509Certificate2.getSerialNumber().toString() + "\"" + " TO  \"" + x509Certificate.getIssuerDN().toString() + " " + x509Certificate.getSubjectDN().toString() + " " + x509Certificate.getSerialNumber().toString() + "\"");
        }
        return x509CertificateArray2;
    }

    public void attach(CertificateStore certificateStore) {
        this.c.addElement(certificateStore);
    }

    public void addTrustedCertificate(X509Certificate x509Certificate) throws CertificationRootException {
        Object object;
        if (x509Certificate == null) {
            return;
        }
        ClientSettings clientSettings = this.a.getClientSettings();
        if (!clientSettings.getPermitCApab() && !clientSettings.getPermitPAB()) {
            throw new CertificationRootException("Private Address Book not permitted");
        }
        boolean bl = false;
        try {
            object = (BasicConstraints)x509Certificate.getExtension(BasicConstraints.oid);
            if (object != null) {
                if (object.ca()) {
                    bl = true;
                }
            } else {
                KeyUsage keyUsage = (KeyUsage)x509Certificate.getExtension(KeyUsage.oid);
                if ((keyUsage.get() & 0x20) != 0) {
                    bl = true;
                }
            }
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            bl = true;
        }
        if (bl) {
            if (!clientSettings.getPermitCApab()) {
                throw new CertificationRootException("Private Address Book for CA certificates not permitted");
            }
        } else if (!clientSettings.getPermitPAB()) {
            throw new CertificationRootException("Private Address Book for end user certificates not permitted");
        }
        this.e.a(x509Certificate, true);
        object = this.e.b(x509Certificate);
        ((c)object).a(this.d);
    }

    public CollectionCS(ValidationInfo validationInfo) throws NullPointerException {
        this.c = new Vector();
        this.g = new h();
        if (validationInfo == null) {
            throw new NullPointerException();
        }
        this.a = validationInfo;
        this.e.a(validationInfo.getRootOfTrust(), true);
        c c2 = this.e.b(validationInfo.getRootOfTrust());
        this.d = new c(null);
        c2.a(this.d);
        this.c.addElement(new d(validationInfo));
        this.c.addElement(new CACrossCertCS(validationInfo));
    }

    static {
        f = false;
        b = 0;
        try {
            b = Integer.getInteger("com.entrust.toolkit.x509.certstore.CollectionCS.trace");
            f |= b > 1;
        }
        catch (Throwable throwable) {}
    }
}

