/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.x509.directory;

import com.entrust.toolkit.util.ByteArray;
import com.entrust.toolkit.util.SecureStringBuffer;
import com.entrust.toolkit.x509.LdapDirectory;
import com.entrust.toolkit.x509.directory.DirectoryConnector;
import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.x509.X509CRL;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.PrivateKey;
import java.security.cert.CRLException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.naming.CommunicationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class JNDIDirectory
implements LdapDirectory {
    private int b = 0;
    private boolean i = false;
    private Vector j = new Vector();
    private SecureStringBuffer d = null;
    private String c = null;
    private String e = null;
    private DirContext h = null;
    private String f = null;
    private String k = null;
    private final String l = "{ASN}";
    private static final int m = 1;
    private static final int n = 2;
    private static final String o = ";binary";
    public static final String LDAP_VERSION_3 = "3";
    public static final String LDAP_VERSION_2 = "2";
    private static int a;
    private static boolean g;

    private void a(byte[][] byArray, String string, String string2) {
        try {
            String string3 = string.equalsIgnoreCase("certificateRevocationList") || string.equalsIgnoreCase("authorityRevocationList") ? ".crl" : (string.equalsIgnoreCase("userCertificate") || string.equalsIgnoreCase("caCertificate") ? ".cer" : ".ber");
            int n2 = 0;
            while (n2 < byArray.length) {
                String string4 = String.valueOf(string) + "_" + string2 + (byArray.length > 1 ? "_[" + n2 + "]" : "") + string3;
                FileOutputStream fileOutputStream = new FileOutputStream(string4);
                fileOutputStream.write(byArray[n2]);
                fileOutputStream.close();
                ++n2;
            }
        }
        catch (Throwable throwable) {}
    }

    public void setLdapVersion(String string) throws NamingException {
        if (!string.equals(LDAP_VERSION_2) && !string.equals(LDAP_VERSION_3)) {
            throw new NamingException("Invalid LDAP version!");
        }
        this.f = string;
    }

    private void b(String string) {
        if (this.i) {
            return;
        }
        if (string.equals(LDAP_VERSION_3)) {
            this.j.addElement("userCertificate");
            this.j.addElement("crossCertificatePair");
            this.j.addElement("caCertificate");
            this.j.addElement("cACertificate");
            this.j.addElement("certificateRevocationList");
            this.j.addElement("authorityRevocationList");
            this.j.addElement("entrustRoamFileEncInfo");
            this.j.addElement("entrustRoamingProfile");
        }
        this.i = true;
    }

    public void setConnectionTimeout(int n2) {
        this.b = n2;
    }

    public void setClientCredentials(X509Certificate x509Certificate, X509Certificate x509Certificate2, PrivateKey privateKey) {
    }

    public void setAuthentication(String string, String string2, SecureStringBuffer secureStringBuffer) {
        this.resetAuthentication();
        this.e = string;
        this.c = string2;
        this.d = new SecureStringBuffer(secureStringBuffer);
    }

    public void resetAuthentication() {
        if (this.d != null) {
            this.d.wipe();
        }
        this.e = null;
        this.c = null;
        this.d = null;
    }

    public boolean isAvailable() {
        if (this.h != null) {
            return true;
        }
        if (this.k != null) {
            try {
                this.connect();
            }
            catch (NamingException namingException) {
                if (a > 0) {
                    System.out.println("Connect failed: " + namingException.toString());
                }
                return false;
            }
            if (this.h != null) {
                return true;
            }
        }
        return false;
    }

    private byte[] a(String string) {
        ByteArray byteArray = new ByteArray();
        byteArray.fromHexString(string.substring("{ASN}".length()));
        return byteArray.getArray();
    }

    public String getURL() {
        return this.k;
    }

    public String getLdapVersion() {
        return this.f;
    }

    public X509CRL[] getCRLs(String string, boolean bl) throws CRLException, NamingException {
        if (string == null) {
            return null;
        }
        String string2 = bl ? "authorityRevocationList" : "certificateRevocationList";
        byte[][] byArray = this.getAttr(string, string2);
        if (byArray == null) {
            return null;
        }
        X509CRL[] x509CRLArray = new X509CRL[byArray.length];
        int n2 = 0;
        while (n2 < byArray.length) {
            x509CRLArray[n2] = new X509CRL(byArray[n2]);
            ++n2;
        }
        return x509CRLArray;
    }

    public synchronized byte[][] getAttr(String string, String string2) throws NamingException {
        String[] stringArray = new String[1];
        Attributes attributes = null;
        NamingException namingException = null;
        boolean bl = false;
        boolean bl2 = true;
        int n2 = 0;
        while (n2 < 2) {
            int n3 = 0;
            while (n3 < 2) {
                String string3 = string2;
                boolean bl3 = bl = n3 == 0 ? this.j.contains(string2) : bl ^ true;
                if (bl) {
                    string3 = String.valueOf(string2) + o;
                }
                stringArray[0] = string3;
                try {
                    Object object;
                    if (g) {
                        System.out.println("Searching for  \"" + string3 + "\" at \"" + string + "\".");
                    }
                    int n4 = 0;
                    while (n4 < 2) {
                        object = null;
                        try {
                            if (this.h == null) {
                                if (this.k != null) {
                                    if (g) {
                                        System.out.println("Trying to " + (n4 == 0 ? "connect" : "reconnect") + " to Directory...");
                                    }
                                    this.connect();
                                } else {
                                    return null;
                                }
                            }
                            attributes = this.h.getAttributes("\"" + string + "\"", stringArray);
                            break;
                        }
                        catch (CommunicationException communicationException) {
                            object = communicationException;
                        }
                        catch (ServiceUnavailableException serviceUnavailableException) {
                            object = serviceUnavailableException;
                        }
                        catch (NamingException namingException2) {
                            throw namingException2;
                        }
                        if (n4 == 1) {
                            throw object;
                        }
                        if (this.h != null) {
                            this.h.close();
                            this.h = null;
                        }
                        ++n4;
                    }
                    object = this.a(attributes, string3);
                    bl2 = false;
                    if (object != null) {
                        if (g) {
                            System.out.println("Found " + ((byte[][])object).length + " " + string2);
                            if (a > 2) {
                                this.a((byte[][])object, string2, string);
                            }
                        }
                        if (n3 == 1) {
                            if (bl) {
                                this.j.addElement(string2);
                            } else {
                                this.j.removeElement(string2);
                            }
                        }
                        return object;
                    }
                }
                catch (NamingException namingException3) {
                    namingException = namingException3;
                }
                if (a > 0) {
                    System.out.println("Failed to find \"" + string3 + "\" at \"" + string + "\".");
                }
                ++n3;
            }
            this.f = this.f.equals(LDAP_VERSION_2) ? LDAP_VERSION_3 : LDAP_VERSION_2;
            ++n2;
        }
        if (bl2) {
            if (a > 0) {
                System.out.println("JNDIDirectory.getAttr() throws: " + namingException.toString());
            }
            throw namingException;
        }
        return null;
    }

    private byte[][] a(Attributes attributes, String string) throws NamingException {
        Object object;
        Vector<byte[]> vector = new Vector<byte[]>();
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        while (namingEnumeration.hasMoreElements()) {
            object = namingEnumeration.next();
            if (!object.getID().equalsIgnoreCase(string)) continue;
            NamingEnumeration<?> namingEnumeration2 = object.getAll();
            while (namingEnumeration2.hasMoreElements()) {
                Object e2 = namingEnumeration2.nextElement();
                if (e2 instanceof byte[]) {
                    ASN1Object aSN1Object = null;
                    try {
                        Object object2;
                        aSN1Object = DerCoder.decode((byte[])((byte[])e2));
                        if (aSN1Object.isA(ASN.OCTET_STRING)) {
                            object2 = ((OCTET_STRING)aSN1Object).getWholeValue();
                            vector.addElement((byte[])object2);
                            continue;
                        }
                        object2 = null;
                        try {
                            object2 = new String((byte[])e2, "iso_8859-1");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            try {
                                object2 = new String((byte[])e2, "iso8859-1");
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                                object2 = new String((byte[])e2);
                            }
                        }
                        if (object2.startsWith("{ASN}")) {
                            vector.addElement(this.a((String)object2));
                            continue;
                        }
                        vector.addElement((byte[])e2);
                    }
                    catch (Exception exception) {
                        vector.addElement((byte[])e2);
                    }
                    continue;
                }
                if (!(e2 instanceof String)) continue;
                try {
                    vector.addElement(((String)e2).getBytes("iso_8859-1"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    try {
                        vector.addElement(((String)e2).getBytes("iso8859-1"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException3) {
                        vector.addElement(((String)e2).getBytes());
                    }
                }
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        object = new byte[vector.size()][];
        int n2 = 0;
        while (n2 < vector.size()) {
            object[n2] = (byte[])vector.elementAt(n2);
            ++n2;
        }
        return object;
    }

    public synchronized DirContext connect() throws NamingException {
        DirectoryConnector directoryConnector = new DirectoryConnector(this.k, this.e, this.c, this.d, this.f);
        directoryConnector.start();
        try {
            directoryConnector.join(this.b);
        }
        catch (InterruptedException interruptedException) {}
        if (directoryConnector.isAlive()) {
            if (directoryConnector.exceptionOccured()) {
                throw directoryConnector.getException();
            }
            throw new NamingException("Connecting to directory timed out!");
        }
        this.h = directoryConnector.getInitialDirContext();
        if (this.h == null) {
            throw directoryConnector.getException();
        }
        this.f = directoryConnector.getLdapVersion();
        this.b(this.f);
        if (g) {
            System.out.println("Connected to \"" + this.k + "\" by LDAP V" + this.f);
        }
        return this.h;
    }

    public synchronized byte[][] Search(String string, String string2, String string3) throws NamingException {
        Object object;
        NamingEnumeration namingEnumeration = this.Search(string, string2);
        if (this.j.contains(string3)) {
            string3 = String.valueOf(string3) + o;
        }
        Vector<byte[]> vector = new Vector<byte[]>();
        while (namingEnumeration != null && namingEnumeration.hasMore()) {
            byte[][] byArray;
            object = (SearchResult)namingEnumeration.next();
            Attributes attributes = ((SearchResult)object).getAttributes();
            if (attributes == null || (byArray = this.a(attributes, string3)) == null) continue;
            int n2 = 0;
            while (n2 < byArray.length) {
                vector.addElement(byArray[n2]);
                ++n2;
            }
        }
        if (!vector.isEmpty()) {
            object = new byte[vector.size()][];
            int n3 = 0;
            while (n3 < vector.size()) {
                object[n3] = (byte[])vector.elementAt(n3);
                ++n3;
            }
            return object;
        }
        return null;
    }

    public synchronized NamingEnumeration Search(String string, String string2) throws NamingException {
        string = string.trim();
        string2 = string2.trim();
        if (this.h == null) {
            if (this.k != null) {
                this.connect();
            } else {
                return null;
            }
        }
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        NamingException namingException = null;
        int n2 = 0;
        while (n2 < 2) {
            int n3 = 0;
            while (n3 < 2) {
                try {
                    return this.h.search(string, string2, searchControls);
                }
                catch (NamingException namingException2) {
                    namingException = namingException2;
                    if (this.k != null) {
                        this.connect();
                    }
                    ++n3;
                }
            }
            this.f = this.f.equals(LDAP_VERSION_3) ? LDAP_VERSION_2 : LDAP_VERSION_3;
            this.connect();
            ++n2;
        }
        throw namingException;
    }

    public JNDIDirectory(DirContext dirContext) {
        this.h = dirContext;
    }

    public JNDIDirectory(String string, int n2) {
        this.k = "ldap://" + string + ":" + String.valueOf(n2);
    }

    static {
        g = false;
        a = 0;
        try {
            a = Integer.getInteger("com.entrust.toolkit.x509.directory.JNDIDirectory.trace");
            g |= a > 1;
        }
        catch (Throwable throwable) {}
    }
}

