/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.x509.policies;

import com.entrust.toolkit.User;
import com.entrust.toolkit.exceptions.CertificationRootException;
import com.entrust.toolkit.util.AuthorizationCode;
import com.entrust.toolkit.util.ByteArray;
import com.entrust.toolkit.util.IniFile;
import com.entrust.toolkit.util.ManagerTransport;
import com.entrust.toolkit.util.PEMString;
import com.entrust.toolkit.util.PKIX;
import com.entrust.toolkit.util.PKIXCMP;
import com.entrust.toolkit.util.SecureStringBuffer;
import com.entrust.toolkit.x509.CertVerifier;
import com.entrust.toolkit.x509.LdapDirectory;
import com.entrust.toolkit.x509.certstore.CertificateGraph;
import com.entrust.toolkit.x509.policies.PasswordRuleTester;
import com.entrust.toolkit.x509.policies.SearchBase;
import com.entrust.toolkit.x509.policies.a;
import com.entrust.toolkit.x509.policies.b;
import com.entrust.toolkit.x509.policies.c;
import com.entrust.toolkit.x509.policies.d;
import com.entrust.toolkit.x509.policies.e;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.BOOLEAN;
import iaik.asn1.CodingException;
import iaik.asn1.IA5String;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.SET;
import iaik.asn1.UTF8String;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.Name;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.AuthorityKeyIdentifier;
import iaik.x509.extensions.SubjectKeyIdentifier;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Vector;
import javax.naming.NoInitialContextException;

public final class ClientSettings {
    private BIT_STRING n = null;
    private BIT_STRING z = null;
    private BIT_STRING i = null;
    private BIT_STRING y = null;
    private BIT_STRING w = null;
    private boolean g = false;
    private boolean h = false;
    private boolean e = true;
    private boolean m = false;
    private boolean f = true;
    private boolean d = true;
    private byte[] q = null;
    private int x = -1;
    private boolean t = false;
    private boolean l = false;
    private boolean r = false;
    private boolean j = false;
    private X509Certificate a = null;
    private X509Certificate b = null;
    private X509Certificate v = null;
    private a s = null;
    private a k = null;
    private ObjectID c = null;
    private d u = null;
    private final String o;
    private final String p = new String("RSA-2048");
    private final int mb = 2;
    private final int nb = 1;
    private final int lb = -1;
    private static final String ab = "2.5.29.9";
    private static final int cb = 7;
    private static final int ib = 6;
    private static final int gb = 5;
    private static final int jb = 4;
    private static final int hb = 3;
    private static final int db = 2;
    private static final int kb = 1;
    private static final int fb = 0;
    private static final int eb = -1;
    static final int tb = 2;
    static final int ub = 1;
    static final int rb = 0;
    static final int sb = -1;
    private static final int pb = 5;
    private static final int qb = 4;
    private static final int ob = 0;
    private static final long vb = 108000000L;
    private static final String bb = "{ASN}";
    static final boolean wb = false;

    private boolean a(String string, X509Certificate x509Certificate, boolean bl) {
        CertVerifier certVerifier = null;
        if (bl) {
            certVerifier = new CertVerifier(this.b, com.entrust.toolkit.x509.policies.d.a(this.u), null);
            CertificateGraph.Graph().addCertificate(this.v);
        } else {
            certVerifier = new CertVerifier(this.v, com.entrust.toolkit.x509.policies.d.a(this.u), null);
        }
        X509Certificate[] x509CertificateArray = null;
        try {
            x509CertificateArray = certVerifier.validate(x509Certificate);
        }
        catch (Exception exception) {
            return false;
        }
        if (!bl) {
            int n2 = x509CertificateArray.length;
            while (n2 > 0) {
                if (!x509CertificateArray[--n2].getSubjectDN().getName().equals(string)) {
                    return false;
                }
                if (x509CertificateArray[n2].getIssuerDN().getName().equals(string)) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.k != null) {
            stringBuffer.append("Main policy certificate:\n" + this.k.toString() + "\n");
        }
        try {
            Object object;
            Vector vector = this.i();
            stringBuffer.append("Roles: " + vector.size() + "\n");
            int n2 = 0;
            while (n2 < vector.size()) {
                object = ((b)vector.elementAt(n2)).getDefaultPolicyDN();
                stringBuffer.append("Role: " + n2 + ": " + object.getName() + "\n");
                ++n2;
            }
            stringBuffer.append("\n");
            object = this.getSearchBaseList();
            stringBuffer.append("SearchBases: " + ((Vector)object).size() + "\n");
            int n3 = 0;
            while (n3 < ((Vector)object).size()) {
                Name name = ((SearchBase)((Vector)object).elementAt(n3)).getName();
                String string = ((SearchBase)((Vector)object).elementAt(n3)).getFriendlyName();
                stringBuffer.append("SearchBase: " + n3 + ": " + name.getName() + " " + string + "\n");
                ++n3;
            }
            stringBuffer.append("\n");
            if (this.s != null) {
                stringBuffer.append("Client settings policy certificate:\n" + this.s.toString() + "\n");
            }
            stringBuffer.append((Object)this.m());
            stringBuffer.append(this.getPasswordRuleTester().toString());
        }
        catch (Exception exception) {}
        return stringBuffer.toString();
    }

    private StringBuffer m() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append("authority version: " + this.getAuthorityVersion() + "\n");
            stringBuffer.append("key backup allowed: " + this.getKeyBackupAllowed() + "\n");
            stringBuffer.append("client PKIX type: " + this.getClientNKeyType() + "\n");
            stringBuffer.append("allowed encryption algorithms: " + this.getAllowedEncryptionAlgorithms().toString() + "\n");
            Vector vector = this.getAllowedHashAlgorithms();
            if (vector != null) {
                stringBuffer.append("allowed hash algorithms: " + vector.toString() + "\n");
            }
            stringBuffer.append("enforce token use: " + this.getEnforceTokenUse() + "\n");
            stringBuffer.append("message of the day: " + this.getMessageOfTheDay() + "\n");
            stringBuffer.append("application flags: " + this.getApplicationFlags() + "\n");
            stringBuffer.append("signing key type: " + this.getSigningKeyType() + "\n");
            stringBuffer.append("encryption key type: " + this.getEncryptionKeyType() + "\n");
            stringBuffer.append("acceptable policy oids: " + this.getAcceptablePolicyOids().toString() + "\n");
            stringBuffer.append("business control flags: " + this.getBusinessControlFlags().toString() + "\n");
            stringBuffer.append("policy certificate default lifetime: " + this.getPolicyCertificateLifeTime() + " days" + "\n");
            stringBuffer.append("DN encodings: " + this.getDNencoding() + "\n");
            stringBuffer.append("directory consistency checking: " + this.getDirectoryConsistencyChecking() + "\n");
        }
        catch (Exception exception) {}
        return stringBuffer;
    }

    private void l() {
        this.q = null;
        if (!this.r) {
            return;
        }
        try {
            Attribute attribute = this.s.t();
            if (attribute == null) {
                return;
            }
            ASN1Object[] aSN1ObjectArray = attribute.getValue();
            byte[] byArray = (byte[])((BIT_STRING)aSN1ObjectArray[0]).getValue();
            this.q = byArray;
            String string = ((BIT_STRING)aSN1ObjectArray[0]).getBinaryString();
            this.d = string.length() > 0 && string.charAt(0) == '1';
            this.f = string.length() > 1 && string.charAt(1) == '1';
            this.m = string.length() > 2 && string.charAt(2) == '1';
            this.e = string.length() > 3 && string.charAt(3) == '1';
            this.h = string.length() > 4 && string.charAt(4) == '1';
            this.g = string.length() > 5 && string.charAt(5) == '1';
        }
        catch (Exception exception) {}
    }

    private void b(int n2) {
        com.entrust.toolkit.x509.policies.d.a(this.u, n2);
    }

    private boolean a(X509Certificate x509Certificate, a a2) {
        if (a2 == null) {
            return false;
        }
        try {
            SubjectKeyIdentifier subjectKeyIdentifier = null;
            AuthorityKeyIdentifier authorityKeyIdentifier = null;
            subjectKeyIdentifier = (SubjectKeyIdentifier)x509Certificate.getExtension(SubjectKeyIdentifier.oid);
            authorityKeyIdentifier = a2.q();
            if (authorityKeyIdentifier == null) {
                return true;
            }
            try {
                String string = new String(authorityKeyIdentifier.getKeyIdentifier(), "iso_8859-1");
                String string2 = new String(subjectKeyIdentifier.get(), "iso_8859-1");
                if (!string.equals(string2)) {
                    return false;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    String string = new String(authorityKeyIdentifier.getKeyIdentifier(), "iso8859-1");
                    String string3 = new String(subjectKeyIdentifier.get(), "iso8859-1");
                    if (!string.equals(string3)) {
                        return false;
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    String string = new String(authorityKeyIdentifier.getKeyIdentifier());
                    String string4 = new String(subjectKeyIdentifier.get());
                    if (!string.equals(string4)) {
                        return false;
                    }
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean c(a a2) {
        if (a2 == null) {
            return false;
        }
        try {
            Name name = a2.d();
            Name name2 = (Name)this.v.getSubjectDN();
            if (name.equals((Object)name2)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public boolean issuedByUpdatedCAkey(X509Certificate x509Certificate) throws CertificateException {
        block11: {
            if (this.k == null || !this.j) {
                throw new CertificateException("Policy certificate has not been validated");
            }
            try {
                AuthorityKeyIdentifier authorityKeyIdentifier = null;
                AuthorityKeyIdentifier authorityKeyIdentifier2 = null;
                authorityKeyIdentifier = (AuthorityKeyIdentifier)x509Certificate.getExtension(AuthorityKeyIdentifier.oid);
                authorityKeyIdentifier2 = this.k.q();
                if (authorityKeyIdentifier2 == null) {
                    return false;
                }
                byte[] byArray = authorityKeyIdentifier2.getKeyIdentifier();
                byte[] byArray2 = authorityKeyIdentifier.getKeyIdentifier();
                if (byArray == null) break block11;
                try {
                    String string = new String(byArray, "iso_8859-1");
                    String string2 = new String(byArray2, "iso_8859-1");
                    if (string.equals(string2)) {
                        return true;
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    try {
                        String string = new String(byArray, "iso8859-1");
                        String string3 = new String(byArray2, "iso8859-1");
                        if (string.equals(string3)) {
                            return true;
                        }
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException2) {
                        String string = new String(byArray);
                        String string4 = new String(byArray2);
                        if (string.equals(string4)) {
                            return true;
                        }
                    }
                }
            }
            catch (Exception exception) {
                throw new CertificateException("Failure checking authority key identifiers");
            }
        }
        return false;
    }

    private boolean b(a a2) throws CertificateException {
        if (a2 == null || this.v == null) {
            return false;
        }
        if (!this.c(a2)) {
            throw new CertificateException("Policy certificate was not issued by my CA");
        }
        try {
            Signature signature;
            AlgorithmID algorithmID = a2.j();
            try {
                signature = algorithmID.getSignatureInstance("Entrust");
            }
            catch (Exception exception) {
                signature = algorithmID.getSignatureInstance();
            }
            signature.initVerify(this.v.getPublicKey());
            signature.update(a2.l());
            if (!signature.verify(a2.i())) {
                throw new CertificateException();
            }
        }
        catch (Exception exception) {
            throw new CertificateException("Verification of policy certificate signature failed: " + exception.getMessage());
        }
        this.a(a2);
        return true;
    }

    public boolean isValid() {
        return this.j && this.r;
    }

    private boolean a(X509Certificate x509Certificate) throws X509ExtensionInitException {
        block8: {
            Name name;
            if (x509Certificate == null) {
                return false;
            }
            Name name2 = (Name)x509Certificate.getIssuerDN();
            if (!name2.equals((Object)(name = (Name)x509Certificate.getSubjectDN()))) {
                return false;
            }
            SubjectKeyIdentifier subjectKeyIdentifier = null;
            AuthorityKeyIdentifier authorityKeyIdentifier = null;
            subjectKeyIdentifier = (SubjectKeyIdentifier)x509Certificate.getExtension(SubjectKeyIdentifier.oid);
            authorityKeyIdentifier = (AuthorityKeyIdentifier)x509Certificate.getExtension(AuthorityKeyIdentifier.oid);
            try {
                String string = new String(authorityKeyIdentifier.getKeyIdentifier(), "iso_8859-1");
                String string2 = new String(subjectKeyIdentifier.get(), "iso_8859-1");
                if (!string.equals(string2)) {
                    return false;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    String string = new String(authorityKeyIdentifier.getKeyIdentifier(), "iso8859-1");
                    String string3 = new String(subjectKeyIdentifier.get(), "iso8859-1");
                    if (!string.equals(string3)) {
                        return false;
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    String string = new String(authorityKeyIdentifier.getKeyIdentifier());
                    String string4 = new String(subjectKeyIdentifier.get());
                    if (string.equals(string4)) break block8;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean initialized() {
        if (!this.j) {
            return false;
        }
        if (this.k.a().equals(com.entrust.toolkit.x509.policies.a.ic)) {
            return true;
        }
        return this.r;
    }

    private PasswordRuleTester a(int n2) throws CertificateException {
        PasswordRuleTester passwordRuleTester = new PasswordRuleTester();
        if (n2 != 0) {
            passwordRuleTester.h = 10;
        }
        if (!this.j && !this.r) {
            return passwordRuleTester;
        }
        SEQUENCE sEQUENCE = null;
        try {
            if (this.r) {
                sEQUENCE = this.s.a(-1);
            }
        }
        catch (Exception exception) {}
        try {
            if (sEQUENCE == null && this.j) {
                sEQUENCE = this.k.a(n2);
            }
        }
        catch (Exception exception) {}
        if (sEQUENCE == null) {
            return passwordRuleTester;
        }
        try {
            passwordRuleTester.i = ((BigInteger)((INTEGER)sEQUENCE.getComponentAt(0)).getValue()).intValue();
            passwordRuleTester.d = ((BigInteger)((INTEGER)sEQUENCE.getComponentAt(1)).getValue()).intValue();
            passwordRuleTester.f = ((BigInteger)((INTEGER)sEQUENCE.getComponentAt(2)).getValue()).intValue();
            passwordRuleTester.h = ((BigInteger)((INTEGER)sEQUENCE.getComponentAt(3)).getValue()).intValue();
            byte[] byArray = (byte[])((BIT_STRING)sEQUENCE.getComponentAt(4)).getValue();
            BigInteger bigInteger = new BigInteger(1, byArray);
            passwordRuleTester.j = bigInteger.testBit(0);
            passwordRuleTester.l = bigInteger.testBit(1);
            passwordRuleTester.c = bigInteger.testBit(2);
            passwordRuleTester.b = bigInteger.testBit(3);
            passwordRuleTester.k = bigInteger.testBit(4);
            passwordRuleTester.g = bigInteger.testBit(5);
            passwordRuleTester.a = bigInteger.testBit(6);
            passwordRuleTester.e = bigInteger.testBit(7);
        }
        catch (Exception exception) {
            throw new CertificateException("Error in finding password rules in policy certificate: " + exception.getMessage());
        }
        return passwordRuleTester;
    }

    private void d(String string) throws NoInitialContextException, CertificateException {
        a a2 = null;
        if (string == null) {
            return;
        }
        try {
            byte[] byArray = com.entrust.toolkit.x509.policies.d.a(this.u, string, com.entrust.toolkit.x509.policies.a.hc);
            a2 = new c(this.a(byArray));
            this.k = a2;
            return;
        }
        catch (Exception exception) {
            try {
                byte[] byArray = com.entrust.toolkit.x509.policies.d.a(this.u, string, com.entrust.toolkit.x509.policies.a.ic);
                a2 = new e(this.a(byArray));
            }
            catch (Exception exception2) {
                throw new CertificateException("Failed to get a policy certificate from certificate source: " + exception2.getMessage());
            }
            this.k = a2;
            return;
        }
    }

    private void a(LdapDirectory ldapDirectory, User user) {
    }

    private void k() throws CertificateException {
        if (this.k == null) {
            return;
        }
        this.s = null;
        this.r = false;
        try {
            Name name = this.e();
            String string = name.getName().toString();
            byte[] byArray = com.entrust.toolkit.x509.policies.d.a(this.u, string, this.b());
            this.s = new c(this.a(byArray));
            if (!this.a(this.s, string)) {
                throw new CertificateException("Owner name in client settings certificate does not match policy certificate");
            }
        }
        catch (Exception exception) {
            throw new CertificateException("Failed to get client settings certificate: " + exception.getMessage());
        }
    }

    private void j() throws NoInitialContextException, CertificationRootException, CertificateException {
        String string = this.v.getSubjectDN().getName();
        this.d(string);
        if (!this.a(this.k, string)) {
            throw new CertificateException("Owner name in main policy certificate does not match CA name");
        }
        if (!this.a(this.v, this.k)) {
            X509Certificate x509Certificate = this.a(string, this.k, this.v, this.b != null);
            if (this.a(string, x509Certificate, this.b != null)) {
                this.v = x509Certificate;
            } else if (com.entrust.toolkit.x509.policies.d.c(this.u) == 2) {
                throw new CertificationRootException("Could not find a valid certificate chain from this user's root of trust (serial number " + this.v.getSerialNumber() + ") to the updated CA certificate (" + x509Certificate.getSerialNumber() + ")");
            }
        }
        this.j = this.b(this.k);
        if (this.k instanceof c) {
            this.k();
            this.r = this.b(this.s);
        }
    }

    private void b(byte[] byArray) throws CertificateException {
        if (byArray == null) {
            return;
        }
        try {
            c c2 = new c(byArray);
            this.k = c2;
            return;
        }
        catch (Exception exception) {
            try {
                e e2 = new e(byArray);
                this.k = e2;
                return;
            }
            catch (Exception exception2) {
                throw new CertificateException("Could not parse attribute or policy certificate: " + exception2.getMessage());
            }
        }
    }

    public void init(ClientSettings clientSettings) {
        this.u = clientSettings.u;
        this.c = clientSettings.c;
        this.k = clientSettings.k;
        this.s = clientSettings.s;
        this.v = clientSettings.v;
        this.b = clientSettings.b;
        this.l = clientSettings.l;
        this.t = clientSettings.t;
        this.a = clientSettings.a;
        this.j = clientSettings.j;
        this.r = clientSettings.r;
        this.x = clientSettings.x;
        this.q = clientSettings.q;
        this.d = clientSettings.d;
        this.f = clientSettings.f;
        this.m = clientSettings.m;
        this.e = clientSettings.e;
        this.h = clientSettings.h;
        this.g = clientSettings.g;
        this.w = clientSettings.w;
        this.y = clientSettings.y;
        this.i = clientSettings.i;
        this.z = clientSettings.z;
        this.n = clientSettings.n;
    }

    private void a(PKIX pKIX, ManagerTransport managerTransport, SecureStringBuffer secureStringBuffer, AuthorizationCode authorizationCode) throws CertificateException {
        if (!(pKIX instanceof PKIXCMP)) {
            return;
        }
        Object var5_5 = null;
        try {
            byte[] byArray = ((PKIXCMP)pKIX).getClientSettings(managerTransport, secureStringBuffer, authorizationCode.getValidatedAuthorizationCode());
            ASN1 aSN1 = new ASN1(byArray);
            ASN1 aSN12 = new ASN1(aSN1.getComponentAt(0));
            this.b(aSN12.toByteArray());
            aSN12 = new ASN1(aSN1.getComponentAt(1));
            this.s = new c(aSN12.toByteArray());
            this.j = true;
            this.r = true;
        }
        catch (Exception exception) {
            throw new CertificateException("Failed to get policy certificate by PKIX-CMP: " + exception.getMessage());
        }
    }

    private byte[] c(String string) {
        ByteArray byteArray = new ByteArray();
        byteArray.fromHexString(string.substring(bb.length()));
        return byteArray.getArray();
    }

    public String getUserEncKeyAlgm() {
        String string;
        block8: {
            if (!this.j) {
                return this.p;
            }
            string = this.p;
            try {
                ASN1Object[] aSN1ObjectArray = this.k.a(com.entrust.toolkit.x509.policies.a.p).getValue();
                if (aSN1ObjectArray == null) break block8;
                OCTET_STRING oCTET_STRING = (OCTET_STRING)aSN1ObjectArray[0];
                byte[] byArray = null;
                if (oCTET_STRING != null) {
                    byArray = (byte[])oCTET_STRING.getValue();
                }
                try {
                    string = new String(byArray, "iso_8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    try {
                        string = new String(byArray, "iso8859-1");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException2) {
                        string = new String(byArray);
                    }
                }
            }
            catch (Exception exception) {}
        }
        return string;
    }

    public boolean getSkipRLcheck() {
        boolean bl = false;
        if (!this.r) {
            return bl;
        }
        try {
            Attribute attribute = this.s.a(com.entrust.toolkit.x509.policies.a.q);
            if (attribute == null) {
                return bl;
            }
            ASN1Object[] aSN1ObjectArray = attribute.getValue();
            if (aSN1ObjectArray == null) {
                return bl;
            }
            Boolean bl2 = (Boolean)aSN1ObjectArray[0].getValue();
            bl = bl2 ^ true;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getSigningKeyType() {
        if (!this.r) {
            return this.p;
        }
        try {
            ASN1Object[] aSN1ObjectArray = this.s.a(com.entrust.toolkit.x509.policies.a.r).getValue();
            return ((UTF8String)aSN1ObjectArray[0]).getValue().toString();
        }
        catch (Exception exception) {
            return this.p;
        }
    }

    public Vector getSearchBaseList() {
        Vector<SearchBase> vector = new Vector<SearchBase>();
        try {
            SEQUENCE sEQUENCE = this.k.w();
            int n2 = 0;
            while (n2 < sEQUENCE.countComponents()) {
                ASN1Object aSN1Object = sEQUENCE.getComponentAt(n2);
                Name name = new Name(aSN1Object.getComponentAt(0));
                IA5String iA5String = (IA5String)aSN1Object.getComponentAt(1);
                String string = new String((String)iA5String.getValue());
                vector.addElement(new SearchBase(name, string));
                ++n2;
            }
        }
        catch (Exception exception) {}
        return vector;
    }

    public X509Certificate getRootCaCertificate() {
        if (this.b == null) {
            return null;
        }
        if (this.t) {
            return this.b;
        }
        X509Certificate x509Certificate = null;
        this.t = true;
        x509Certificate = this.a();
        if (x509Certificate != null && this.a(this.b.getSubjectDN().getName(), x509Certificate, true)) {
            this.b = x509Certificate;
        }
        return this.b;
    }

    private Vector i() throws CodingException {
        ASN1Object[] aSN1ObjectArray = this.k.v();
        SEQUENCE sEQUENCE = (SEQUENCE)aSN1ObjectArray[0];
        Vector<b> vector = new Vector<b>();
        int n2 = 0;
        while (n2 < sEQUENCE.countComponents()) {
            ASN1Object aSN1Object = sEQUENCE.getComponentAt(n2);
            int n3 = ((BigInteger)((INTEGER)aSN1Object.getComponentAt(0)).getValue()).intValue();
            SEQUENCE sEQUENCE2 = (SEQUENCE)aSN1Object.getComponentAt(1);
            Name name = new Name(aSN1Object.getComponentAt(2));
            vector.addElement(new b(n3, sEQUENCE2, name));
            ++n2;
        }
        return vector;
    }

    private int h() {
        int n2 = 2;
        if (this.a == null) {
            return n2;
        }
        ObjectID objectID = new ObjectID(ab);
        ObjectID objectID2 = new ObjectID(com.entrust.toolkit.x509.policies.a.o);
        try {
            SEQUENCE sEQUENCE = (SEQUENCE)this.a.getExtension(objectID).toASN1Object();
            int n3 = 0;
            while (n3 < sEQUENCE.countComponents()) {
                SEQUENCE sEQUENCE2 = (SEQUENCE)sEQUENCE.getComponentAt(n3);
                ObjectID objectID3 = (ObjectID)sEQUENCE2.getComponentAt(0);
                if (objectID3.equals((Object)objectID2)) {
                    INTEGER iNTEGER = (INTEGER)((SET)sEQUENCE2.getComponentAt(1)).getComponentAt(0);
                    n2 = ((BigInteger)iNTEGER.getValue()).intValue();
                    break;
                }
                ++n3;
            }
        }
        catch (Exception exception) {}
        return n2;
    }

    public boolean getRequirePolicyOIDs() {
        boolean bl = false;
        if (this.w == null) {
            this.getBusinessControlFlags();
        }
        if (this.w == null) {
            return bl;
        }
        byte[] byArray = (byte[])this.w.getValue();
        if (byArray.length > 0) {
            return (byArray[0] & 0x40) == 64;
        }
        return bl;
    }

    public boolean getPublicTokenCerts() {
        boolean bl = false;
        try {
            ASN1Object[] aSN1ObjectArray = this.s.a(com.entrust.toolkit.x509.policies.a.ab).getValue();
            BOOLEAN bOOLEAN = (BOOLEAN)aSN1ObjectArray[0];
            bl = (Boolean)bOOLEAN.getValue();
        }
        catch (Exception exception) {}
        return bl;
    }

    public int getPolicyCertificateLifeTime() {
        int n2 = 30;
        if (!this.r) {
            return n2;
        }
        try {
            ASN1Object[] aSN1ObjectArray = this.s.a(com.entrust.toolkit.x509.policies.a.eb).getValue();
            n2 = ((BigInteger)((INTEGER)aSN1ObjectArray[0]).getValue()).intValue();
        }
        catch (Exception exception) {}
        return n2;
    }

    public boolean getPermitRoaming() {
        try {
            if (this.q == null) {
                this.l();
            }
        }
        catch (Exception exception) {}
        return this.d;
    }

    public boolean getPermitPAB() {
        try {
            if (this.q == null) {
                this.l();
            }
        }
        catch (Exception exception) {}
        return this.e;
    }

    public boolean getPermitP12Export() {
        boolean bl = false;
        if (!this.r) {
            return bl;
        }
        try {
            Attribute attribute = this.s.a(com.entrust.toolkit.x509.policies.a.fb);
            if (attribute == null) {
                return bl;
            }
            ASN1Object[] aSN1ObjectArray = attribute.getValue();
            if (aSN1ObjectArray == null) {
                return bl;
            }
            Boolean bl2 = (Boolean)aSN1ObjectArray[0].getValue();
            bl = bl2;
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean getPermitNonRoaming() {
        try {
            if (this.q == null) {
                this.l();
            }
        }
        catch (Exception exception) {}
        return this.f;
    }

    public boolean getPermitGroupKeyExport() {
        try {
            if (this.q == null) {
                this.l();
            }
        }
        catch (Exception exception) {}
        return this.g;
    }

    public boolean getPermitCApab() {
        try {
            if (this.q == null) {
                this.l();
            }
        }
        catch (Exception exception) {}
        return this.h;
    }

    private String a(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (string2.equals(com.entrust.toolkit.x509.policies.a.ic)) {
                return "polcert";
            }
            String string3 = string.toLowerCase();
            int n2 = 0;
            while (n2 < string3.length()) {
                stringBuffer.append(string3.charAt(n2));
                if (string3.charAt(n2) == ',' && string3.charAt(n2 + 1) == ' ') {
                    ++n2;
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        return stringBuffer.toString();
    }

    private String b(String string) {
        if (string.equals(com.entrust.toolkit.x509.policies.a.ic)) {
            return "polcert";
        }
        return "PolicyCert";
    }

    public PasswordRuleTester getPasswordRuleTester(String string) throws CertificateException {
        return this.a(this.a(string));
    }

    public PasswordRuleTester getPasswordRuleTester() throws CertificateException {
        return this.a(0);
    }

    public int getPKCS12ExportMinimumHashCount() {
        int n2 = 2000;
        try {
            Attribute attribute = this.s.a(com.entrust.toolkit.x509.policies.a.db);
            if (attribute == null) {
                return n2;
            }
            ASN1Object[] aSN1ObjectArray = attribute.getValue();
            if (aSN1ObjectArray == null) {
                return n2;
            }
            BigInteger bigInteger = (BigInteger)aSN1ObjectArray[0].getValue();
            n2 = bigInteger.intValue();
            return n2;
        }
        catch (Exception exception) {
            return n2;
        }
    }

    public boolean getOfflineProfileUse() {
        Object object;
        Object object2;
        if (!this.r) {
            return false;
        }
        if (this.i == null) {
            try {
                object2 = this.s.a(com.entrust.toolkit.x509.policies.a.gb);
                object = object2.getValue();
                this.i = (BIT_STRING)object[0];
            }
            catch (Exception exception) {
                return false;
            }
        }
        try {
            if (this.i != null && ((Attribute)(object2 = (Object)((byte[])this.i.getValue()))).length != 0 && ((String)(object = this.i.getBinaryString())).length() > 0 && ((String)object).charAt(0) == '1') {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public String getMessageOfTheDay() {
        if (!this.r) {
            return null;
        }
        try {
            ASN1Object[] aSN1ObjectArray = this.s.a(com.entrust.toolkit.x509.policies.a.hb).getValue();
            return ((UTF8String)aSN1ObjectArray[0]).getValue().toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private byte[] g() {
        if (this.k == null) {
            return null;
        }
        return this.k.b();
    }

    private void a(String string, String string2, boolean bl) {
    }

    public boolean getKeyBackupAllowed() {
        boolean bl = true;
        if (!this.j) {
            return bl;
        }
        try {
            Attribute attribute = this.c();
            if (attribute == null) {
                return bl;
            }
            ASN1Object[] aSN1ObjectArray = attribute.getValue();
            SEQUENCE sEQUENCE = (SEQUENCE)aSN1ObjectArray[0];
            if (sEQUENCE.countComponents() > 2) {
                BigInteger bigInteger = new BigInteger((byte[])((BIT_STRING)sEQUENCE.getComponentAt(2)).getValue());
                bl = bigInteger.testBit(0);
            }
        }
        catch (Exception exception) {}
        return bl;
    }

    public boolean getInhibitPolicyMapping() {
        boolean bl = false;
        if (this.w == null) {
            this.getBusinessControlFlags();
        }
        if (this.w == null) {
            return bl;
        }
        byte[] byArray = (byte[])this.w.getValue();
        if (byArray.length > 0) {
            return (byArray[0] & 0x80) == 128;
        }
        return bl;
    }

    public String getHttpProxy() {
        if (!this.r) {
            return null;
        }
        try {
            ASN1Object[] aSN1ObjectArray = this.s.a(com.entrust.toolkit.x509.policies.a.ib).getValue();
            return ((UTF8String)aSN1ObjectArray[0]).getValue().toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void getFresh(User user, X509Certificate x509Certificate, X509Certificate x509Certificate2, X509Certificate x509Certificate3) throws CertificateException {
        if (this.l) {
            return;
        }
        this.clear();
        this.u = new d(this);
        com.entrust.toolkit.x509.policies.d.a(this.u, user.getDirectory());
        com.entrust.toolkit.x509.policies.d.a(this.u, user.getPolicyCertificate());
        this.v = x509Certificate;
        this.b = x509Certificate3;
        this.a = x509Certificate2;
        this.b(2);
        try {
            this.j();
            this.l = true;
        }
        catch (Exception exception) {
            throw new CertificateException("Failed to get fresh policy certificate from Directory" + exception.getMessage());
        }
    }

    public boolean getEnforceTokenUse() {
        try {
            if (this.q == null) {
                this.l();
            }
        }
        catch (Exception exception) {}
        return this.m;
    }

    public boolean getEnforceIdentityUse() {
        Object object;
        Object object2;
        if (!this.r) {
            return false;
        }
        if (this.n == null) {
            try {
                object2 = this.s.a(com.entrust.toolkit.x509.policies.a.jb);
                object = object2.getValue();
                this.n = (BIT_STRING)object[0];
            }
            catch (Exception exception) {
                return false;
            }
        }
        try {
            if (this.n != null && ((Attribute)(object2 = (Object)((byte[])this.n.getValue()))).length != 0 && ((String)(object = this.n.getBinaryString())).length() > 0 && ((String)object).charAt(0) == '1') {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public String getEncryptionKeyType() {
        if (!this.r) {
            return this.p;
        }
        try {
            Attribute attribute = this.s.a(com.entrust.toolkit.x509.policies.a.kb);
            if (attribute == null) {
                return this.p;
            }
            ASN1Object[] aSN1ObjectArray = attribute.getValue();
            return ((UTF8String)aSN1ObjectArray[0]).getValue().toString();
        }
        catch (Exception exception) {
            return this.p;
        }
    }

    public boolean getDirectoryConsistencyChecking() {
        boolean bl = true;
        if (!this.r) {
            return bl;
        }
        try {
            Attribute attribute = this.s.a(com.entrust.toolkit.x509.policies.a.nb);
            ASN1Object[] aSN1ObjectArray = attribute.getValue();
            Object object = ((BIT_STRING)aSN1ObjectArray[0]).getValue();
            if (object != null) {
                BigInteger bigInteger = new BigInteger((byte[])object);
                bl = bigInteger.testBit(0);
            }
        }
        catch (Exception exception) {}
        return bl;
    }

    public SEQUENCE getDNencoding() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent((ASN1Object)new UTF8String("printable"));
        sEQUENCE.addComponent((ASN1Object)new UTF8String("teletex"));
        sEQUENCE.addComponent((ASN1Object)new UTF8String("utf8"));
        if (!this.r) {
            return sEQUENCE;
        }
        try {
            ASN1Object[] aSN1ObjectArray = this.s.a(com.entrust.toolkit.x509.policies.a.lb).getValue();
            return (SEQUENCE)aSN1ObjectArray[0];
        }
        catch (Exception exception) {
            return sEQUENCE;
        }
    }

    private byte[] f() {
        if (this.s == null) {
            return null;
        }
        return this.s.b();
    }

    public int getClientNKeyType() {
        int n2 = 2;
        if (!this.r) {
            return n2;
        }
        try {
            ASN1Object[] aSN1ObjectArray = this.s.a(com.entrust.toolkit.x509.policies.a.mb).getValue();
            INTEGER iNTEGER = (INTEGER)aSN1ObjectArray[0];
            n2 = ((BigInteger)iNTEGER.getValue()).intValue();
            return n2;
        }
        catch (Exception exception) {
            return n2;
        }
    }

    private Name e() throws CodingException {
        Name name = null;
        Vector vector = null;
        int n2 = this.h();
        if (this.k != null) {
            vector = this.i();
        }
        int n3 = 0;
        while (n3 < vector.size()) {
            b b2 = (b)vector.elementAt(n3);
            if (b2.getRoleId() == n2) {
                if (this.c == null) {
                    name = b2.getDefaultPolicyDN();
                    break;
                }
                SEQUENCE sEQUENCE = b2.getPolicyMap();
                int n4 = 0;
                while (n4 < sEQUENCE.countComponents()) {
                    SEQUENCE sEQUENCE2 = (SEQUENCE)sEQUENCE.getComponentAt(n4);
                    ObjectID objectID = (ObjectID)sEQUENCE2.getComponentAt(0);
                    if (objectID.equals((Object)this.c)) {
                        name = new Name(sEQUENCE2.getComponentAt(1));
                        break;
                    }
                    ++n4;
                }
            }
            ++n3;
        }
        return name;
    }

    public IniFile getCertificates() {
        PEMString pEMString;
        String string = null;
        String string2 = null;
        Object var3_3 = null;
        IniFile iniFile = new IniFile();
        if (this.j) {
            try {
                string = new String(Util.Base64Encode((byte[])this.g()), "iso_8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    string = new String(Util.Base64Encode((byte[])this.g()), "iso8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    string = new String(Util.Base64Encode((byte[])this.g()));
                }
            }
            pEMString = new PEMString(string);
            string2 = this.a(this.k.g().getName().toString(), this.d());
            iniFile.putString(string2, this.b(this.d()), pEMString.getPemString());
        }
        if (this.r) {
            try {
                string = new String(Util.Base64Encode((byte[])this.f()), "iso_8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    string = new String(Util.Base64Encode((byte[])this.f()), "iso8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException3) {
                    string = new String(Util.Base64Encode((byte[])this.f()));
                }
            }
            pEMString = new PEMString(string);
            string2 = this.a(this.s.g().getName().toString(), com.entrust.toolkit.x509.policies.a.hc);
            iniFile.putString(string2, this.b(this.d()), pEMString.getPemString());
        }
        if (!this.j && !this.r) {
            iniFile = null;
        }
        return iniFile;
    }

    private String d() {
        if (this.k == null) {
            return null;
        }
        return this.k.a();
    }

    public X509Certificate getCaCertificate() throws CertificateException {
        if (!this.j) {
            throw new CertificateException("The policy certificate has not been validated yet");
        }
        return this.v;
    }

    public int getCRLGracePeriod() {
        int n2 = 2;
        if (!this.r) {
            return n2;
        }
        try {
            Attribute attribute = this.s.a(com.entrust.toolkit.x509.policies.a.pb);
            if (attribute == null) {
                return n2;
            }
            ASN1Object[] aSN1ObjectArray = attribute.getValue();
            if (aSN1ObjectArray == null) {
                return n2;
            }
            BigInteger bigInteger = (BigInteger)aSN1ObjectArray[0].getValue();
            n2 = bigInteger.intValue();
            return n2;
        }
        catch (Exception exception) {
            return n2;
        }
    }

    private Attribute c() throws CodingException {
        return this.k.s();
    }

    public BIT_STRING getBusinessControlFlags() {
        if (this.w != null) {
            return this.w;
        }
        byte[] byArray = new byte[1];
        BIT_STRING bIT_STRING = new BIT_STRING(byArray, 4);
        if (!this.r) {
            return bIT_STRING;
        }
        try {
            Attribute attribute = this.s.a(com.entrust.toolkit.x509.policies.a.sb);
            ASN1Object[] aSN1ObjectArray = attribute.getValue();
            this.w = (BIT_STRING)aSN1ObjectArray[0];
            return this.w;
        }
        catch (Exception exception) {
            return bIT_STRING;
        }
    }

    public int getAuthorityVersion() throws CodingException {
        if (this.x == -1) {
            this.x = this.k.r();
        }
        return this.x;
    }

    private String b() {
        String string = com.entrust.toolkit.x509.policies.a.hc;
        try {
            if (this.k != null) {
                ASN1Object[] aSN1ObjectArray = this.k.a(com.entrust.toolkit.x509.policies.a.tb).getValue();
                UTF8String uTF8String = (UTF8String)aSN1ObjectArray[0];
                string = uTF8String.toString();
            }
        }
        catch (Exception exception) {}
        return string;
    }

    public Attribute getAttribute(String string) throws CodingException {
        if (this.k != null) {
            return this.k.a(string);
        }
        return null;
    }

    public boolean getApplicationFlags() {
        Object object;
        Object object2;
        if (!this.r) {
            return false;
        }
        if (this.y == null) {
            try {
                object2 = this.s.a(com.entrust.toolkit.x509.policies.a.ub);
                object = object2.getValue();
                this.y = (BIT_STRING)object[0];
            }
            catch (Exception exception) {
                return false;
            }
        }
        try {
            if (this.y != null && ((Attribute)(object2 = (Object)((byte[])this.y.getValue()))).length != 0 && ((String)(object = this.y.getBinaryString())).length() > 0 && ((String)object).charAt(0) == '1') {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public Vector getAllowedHashAlgorithms() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(this.o);
        if (!this.r) {
            return vector;
        }
        if (!this.r) {
            return vector;
        }
        try {
            Vector<String> vector2 = new Vector<String>();
            Attribute attribute = this.s.a(com.entrust.toolkit.x509.policies.a.wb);
            if (attribute == null) {
                return null;
            }
            ASN1Object[] aSN1ObjectArray = attribute.getValue();
            SEQUENCE sEQUENCE = (SEQUENCE)aSN1ObjectArray[0];
            int n2 = 0;
            while (n2 < sEQUENCE.countComponents()) {
                String string = new String((String)((UTF8String)sEQUENCE.getComponentAt(n2)).getValue());
                vector2.addElement(string);
                ++n2;
            }
            return vector2;
        }
        catch (Exception exception) {
            return vector;
        }
    }

    public Vector getAllowedEncryptionAlgorithms() {
        Vector<String> vector = new Vector<String>();
        vector.addElement(this.o);
        if (!this.r) {
            return vector;
        }
        try {
            Vector<String> vector2 = new Vector<String>();
            ASN1Object[] aSN1ObjectArray = this.s.a(com.entrust.toolkit.x509.policies.a.vb).getValue();
            SEQUENCE sEQUENCE = (SEQUENCE)aSN1ObjectArray[0];
            int n2 = 0;
            while (n2 < sEQUENCE.countComponents()) {
                String string = new String((String)((UTF8String)sEQUENCE.getComponentAt(n2)).getValue());
                vector2.addElement(string);
                ++n2;
            }
            return vector2;
        }
        catch (Exception exception) {
            return vector;
        }
    }

    public boolean getAllowServerLogin() {
        Object object;
        Object object2;
        if (!this.r) {
            return false;
        }
        if (this.z == null) {
            try {
                object2 = this.s.a(com.entrust.toolkit.x509.policies.a.xb);
                object = object2.getValue();
                this.z = (BIT_STRING)object[0];
            }
            catch (Exception exception) {
                return false;
            }
        }
        try {
            if (this.z != null && ((Attribute)(object2 = (Object)((byte[])this.z.getValue()))).length != 0 && ((String)(object = this.z.getBinaryString())).length() > 0 && ((String)object).charAt(0) == '1') {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public Vector getAcceptablePolicyOids() {
        Vector<ObjectID> vector = new Vector<ObjectID>();
        if (!this.r) {
            return vector;
        }
        try {
            ASN1Object[] aSN1ObjectArray = this.s.a(com.entrust.toolkit.x509.policies.a.rb).getValue();
            SEQUENCE sEQUENCE = (SEQUENCE)aSN1ObjectArray[0];
            int n2 = 0;
            while (n2 < sEQUENCE.countComponents()) {
                ObjectID objectID = (ObjectID)sEQUENCE.getComponentAt(n2);
                vector.addElement(objectID);
                ++n2;
            }
            return vector;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private X509Certificate a() {
        try {
            String string = this.b.getSubjectDN().getName();
            if (string == null) {
                return null;
            }
            c c2 = null;
            try {
                byte[] byArray = com.entrust.toolkit.x509.policies.d.a(this.u, string, com.entrust.toolkit.x509.policies.a.hc);
                c2 = new c(this.a(byArray));
            }
            catch (Exception exception) {
                return null;
            }
            if (!this.a(c2, string)) {
                return null;
            }
            if (!this.a(this.b, c2)) {
                return this.a(string, c2, this.b, false);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private X509Certificate a(String string, a a2, X509Certificate x509Certificate, boolean bl) throws CertificateException {
        if (com.entrust.toolkit.x509.policies.d.a(this.u) == null) {
            throw new CertificateException("Offline so cannot get the CA certificate that issued the policy certificate");
        }
        X509Certificate x509Certificate2 = null;
        try {
            byte[][] byArray = com.entrust.toolkit.x509.policies.d.a(this.u).getAttr(string, "caCertificate");
            X509Certificate[] x509CertificateArray = new X509Certificate[byArray.length];
            int n2 = 0;
            while (n2 < byArray.length) {
                x509CertificateArray[n2] = new X509Certificate(byArray[n2]);
                CertificateGraph.Graph().addCertificate(x509CertificateArray[n2]);
                if (this.a(x509CertificateArray[n2], a2) && (bl || this.a(x509CertificateArray[n2]))) {
                    x509Certificate2 = x509CertificateArray[n2];
                    break;
                }
                ++n2;
            }
            if (!x509Certificate2.getIssuerDN().getName().equals(x509Certificate.getIssuerDN().getName())) {
                throw new CertificateException("Issuers of updated CA certificate and current CA certificate are different !");
            }
            return x509Certificate2;
        }
        catch (Exception exception) {
            throw new CertificateException("The Directory did not provide a CA certificate for this policy certificate" + exception.toString());
        }
    }

    private int a(String string) {
        if (string == "adm") {
            return 1;
        }
        if (string == "officer") {
            return 2;
        }
        return 0;
    }

    private byte[] a(byte[] byArray) {
        if (byArray == null) {
            return byArray;
        }
        byte[] byArray2 = null;
        try {
            String string = null;
            try {
                string = new String(byArray, "iso_8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    string = new String(byArray, "iso8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    string = new String(byArray);
                }
            }
            byArray2 = string.startsWith(bb) ? this.c(string) : byArray;
        }
        catch (Exception exception) {}
        return byArray2;
    }

    public void clear() {
        ClientSettings clientSettings = new ClientSettings();
        this.init(clientSettings);
    }

    private void a(a a2) throws CertificateException {
        if (a2 == null) {
            return;
        }
        long l = new Date().getTime();
        long l2 = 0L;
        long l3 = 0L;
        Date date = a2.f();
        Date date2 = a2.e();
        if (date != null) {
            l2 = date.getTime();
        }
        if (date2 != null) {
            l3 = date2.getTime();
        }
        if (l > l3) {
            throw new CertificateException("Policy certificate has expired.");
        }
        if (l + 108000000L < l2) {
            throw new CertificateException("Policy certificate is not yet valid.");
        }
    }

    private boolean a(a a2, String string) {
        if (a2 == null) {
            return false;
        }
        try {
            Name name = a2.g();
            if (name.getName().toString().equals(string)) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    static String a(ClientSettings clientSettings, String string) {
        return clientSettings.b(string);
    }

    static String a(ClientSettings clientSettings, String string, String string2) {
        return clientSettings.a(string, string2);
    }

    public ClientSettings(PKIX pKIX, ManagerTransport managerTransport, SecureStringBuffer secureStringBuffer, AuthorizationCode authorizationCode) throws CertificateException {
        this();
        this.a(pKIX, managerTransport, secureStringBuffer, authorizationCode);
    }

    public ClientSettings(User user, X509Certificate x509Certificate, X509Certificate x509Certificate2, X509Certificate x509Certificate3) throws CertificationRootException {
        this.o = new String("ALL");
        this.u = new d(this);
        com.entrust.toolkit.x509.policies.d.a(this.u, user.getDirectory());
        com.entrust.toolkit.x509.policies.d.a(this.u, user.getPolicyCertificate());
        this.v = x509Certificate;
        this.b = x509Certificate3;
        this.a = x509Certificate2;
        this.b(1);
        try {
            this.j();
            return;
        }
        catch (Exception exception) {
            this.b(2);
            try {
                this.j();
                this.l = true;
            }
            catch (CertificationRootException certificationRootException) {
                throw certificationRootException;
            }
            catch (Exception exception2) {}
            return;
        }
    }

    public ClientSettings() {
        this.o = new String("ALL");
    }
}

