/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.x509.policies;

import com.entrust.toolkit.exceptions.UserBadPasswordException;
import com.entrust.toolkit.util.ByteArray;
import com.entrust.toolkit.util.SecureStringBuffer;
import java.security.MessageDigest;
import java.util.Date;

public final class PasswordRuleTester {
    boolean j = false;
    boolean l = false;
    boolean c = false;
    boolean b = false;
    boolean k = true;
    boolean g = true;
    boolean a = true;
    boolean e = false;
    int h = 15;
    int f = 8;
    int d = 8;
    int i = 0;
    private static final long m = 604800L;

    public void validatePassword(SecureStringBuffer secureStringBuffer, ByteArray[] byteArrayArray) throws UserBadPasswordException {
        this.validatePassword(secureStringBuffer);
        this.a(secureStringBuffer, byteArrayArray);
    }

    public void validatePassword(SecureStringBuffer secureStringBuffer) throws UserBadPasswordException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        char[] cArray = null;
        cArray = secureStringBuffer.getStringBuffer().toString().toCharArray();
        if (secureStringBuffer.getStringBuffer().toString().length() < this.f) {
            throw new UserBadPasswordException("Password too short, password must be at least " + this.f + " characters long.");
        }
        int n2 = 0;
        while (n2 < secureStringBuffer.getStringBuffer().toString().length()) {
            if (Character.isLowerCase(cArray[n2])) {
                bl2 = true;
            } else if (Character.isUpperCase(cArray[n2])) {
                bl3 = true;
            } else if (Character.isDigit(cArray[n2])) {
                bl4 = true;
                bl = true;
            } else if (Character.isWhitespace(cArray[n2])) {
                bl5 = true;
                bl = true;
            } else {
                bl = true;
            }
            ++n2;
        }
        if (this.e && !bl) {
            throw new UserBadPasswordException("Password must contain a non alpha character!");
        }
        if (this.a && !bl3) {
            throw new UserBadPasswordException("Password must contain an upper case character!");
        }
        if (this.g && !bl2) {
            throw new UserBadPasswordException("Password must contain a lower case character!");
        }
        if (this.k && !bl4) {
            throw new UserBadPasswordException("Password must contain a digit!");
        }
        if (!this.b && bl5) {
            throw new UserBadPasswordException("Password must not contain whitespace!");
        }
        if (!this.c && bl6) {
            throw new UserBadPasswordException("Password must not repeat characters!");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Password Rules:\n");
        if (this.d != 0) {
            stringBuffer.append("password must not repeat any of the prior " + this.d + " passwords\n");
        }
        stringBuffer.append("minimum length: " + this.f + " characters\n");
        if (this.e) {
            stringBuffer.append("must include non-alphanumeric character\n");
        }
        if (this.a) {
            stringBuffer.append("must include upper-case character\n");
        }
        if (this.g) {
            stringBuffer.append("must include lower-case character\n");
        }
        if (this.k) {
            stringBuffer.append("must include a number\n");
        }
        if (!this.b) {
            stringBuffer.append("whitespace is not allowed\n");
        }
        stringBuffer.append("Passwords expire in " + this.i + " weeks\n");
        return stringBuffer.toString();
    }

    private byte[] a(SecureStringBuffer secureStringBuffer) throws UserBadPasswordException {
        StringBuffer stringBuffer = secureStringBuffer.getStringBuffer();
        byte[] byArray = new byte[stringBuffer.length()];
        int n2 = 0;
        while (n2 < secureStringBuffer.getStringBuffer().length()) {
            byArray[n2] = (byte)stringBuffer.charAt(n2);
            ++n2;
        }
        byte[] byArray2 = null;
        try {
            MessageDigest messageDigest = null;
            messageDigest = MessageDigest.getInstance("SHA", "Entrust");
            byArray2 = messageDigest.digest(byArray);
            byte[] byArray3 = new byte[byArray2.length];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            int n3 = 0;
            while (n3 < byArray.length) {
                byArray[n3] = 0;
                ++n3;
            }
            byArray = null;
            return messageDigest.digest(byArray3);
        }
        catch (Exception exception) {
            throw new UserBadPasswordException("Failure checking password against history");
        }
    }

    public boolean getUpper() {
        return this.a;
    }

    public boolean getOkBlanks() {
        return this.b;
    }

    public boolean getOk2repeat() {
        return this.c;
    }

    public int getNotReuseLastPasswords() {
        return this.d;
    }

    public boolean getNonAlpha() {
        return this.e;
    }

    public int getMinimumPasswordLength() {
        return this.f;
    }

    public boolean getLower() {
        return this.g;
    }

    public int getLoginTimeoutInMinutes() {
        return this.h;
    }

    public int getExpirationTimeInWeeks() {
        return this.i;
    }

    public boolean getDisableSLO() {
        return this.j;
    }

    public boolean getDigit() {
        return this.k;
    }

    public boolean getCaseIgnore() {
        return this.l;
    }

    private void a(SecureStringBuffer secureStringBuffer, ByteArray[] byteArrayArray) throws UserBadPasswordException {
        if (secureStringBuffer == null || byteArrayArray == null || this.d == 0) {
            return;
        }
        byte[] byArray = this.a(secureStringBuffer);
        int n2 = 0;
        while (n2 < this.d && n2 < byteArrayArray.length) {
            ByteArray byteArray = byteArrayArray[n2];
            boolean bl = true;
            int n3 = 0;
            while (n3 < byArray.length) {
                if (byteArray.getArray()[n3] != byArray[n3]) {
                    bl = false;
                    break;
                }
                ++n3;
            }
            if (bl) {
                throw new UserBadPasswordException("New password duplicates a previously used password");
            }
            ++n2;
        }
    }

    public boolean checkExpiry(int n2) {
        boolean bl = false;
        if (this.i != 0) {
            long l = new Date().getTime();
            long l2 = (long)n2 + (long)this.i * 604800L;
            if (l > (l2 *= 1000L)) {
                bl = true;
            }
        }
        return bl;
    }

    PasswordRuleTester() {
    }
}

