/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.x509.revocation;

import com.entrust.toolkit.exceptions.UserFatalException;
import com.entrust.toolkit.util.IniFile;
import com.entrust.toolkit.util.PEMString;
import com.entrust.toolkit.x509.ValidationInfo;
import com.entrust.toolkit.x509.revocation.CachedCRLRS;
import com.entrust.toolkit.x509.revocation.DistPointAndCRL;
import com.entrust.toolkit.x509.revocation.X509CRLRS;
import iaik.asn1.ASN1Type;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.utils.Base64Exception;
import iaik.utils.Util;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.IssuingDistributionPoint;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.CRLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ArchiveCRLCache
extends X509CRLRS {
    public static final int CRL_AND_ARL = 3;
    public static final int ARL_ONLY = 2;
    public static final int CRL_ONLY = 1;
    static final boolean b = false;
    private Hashtable a = new Hashtable();

    public void write(OutputStream outputStream, int n2) throws CRLException {
        IniFile iniFile = new IniFile();
        Enumeration enumeration = this.a.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            byte[] byArray;
            Object object;
            String string2 = (String)enumeration.nextElement();
            X509CRL x509CRL = (X509CRL)this.a.get(string2);
            if (string2.endsWith("true")) {
                string2 = string2.substring(0, string2.length() - 4);
            } else if (string2.endsWith("false")) {
                string2 = string2.substring(0, string2.length() - 5);
            }
            String string3 = null;
            byte[] byArray2 = null;
            try {
                byArray2 = Util.Base64Encode((byte[])string2.getBytes("iso_8859-1"));
                string3 = new PEMString(new String(byArray2, "iso_8859-1")).getPemString();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    byArray2 = Util.Base64Encode((byte[])string2.getBytes("iso8859-1"));
                    string3 = new PEMString(new String(byArray2, "iso8859-1")).getPemString();
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    object = new String(string2.getBytes());
                    byArray2 = Util.Base64Encode((byte[])((String)object).getBytes());
                    string3 = new PEMString(new String(byArray2)).getPemString();
                }
            }
            object = x509CRL.getEncoded();
            if (n2 == 1 && !this.b(x509CRL) || n2 == 2 && !this.a(x509CRL)) continue;
            try {
                if (((Object)object).length % 2 == 0) {
                    byArray = new byte[((Object)object).length / 2];
                    System.arraycopy(object, 0, byArray, 0, byArray.length);
                    string = new String(Util.Base64Encode((byte[])byArray), "iso_8859-1");
                    string = new PEMString(string).getPemString();
                    iniFile.putString(string3, "CRL", string);
                    System.arraycopy(object, byArray.length, byArray, 0, byArray.length);
                    string = new String(Util.Base64Encode((byte[])byArray), "iso_8859-1");
                    string = new PEMString(string).getPemString();
                    iniFile.putString(string3, "CRL1", string);
                    continue;
                }
                byArray = new byte[((Object)object).length / 2];
                System.arraycopy(object, 0, byArray, 0, byArray.length);
                string = new String(Util.Base64Encode((byte[])byArray), "iso_8859-1");
                string = new PEMString(string).getPemString();
                iniFile.putString(string3, "CRL", string);
                byArray = new byte[((Object)object).length / 2 + 1];
                System.arraycopy(object, byArray.length - 1, byArray, 0, byArray.length);
                string = new String(Util.Base64Encode((byte[])byArray), "iso_8859-1");
                string = new PEMString(string).getPemString();
                iniFile.putString(string3, "CRL1", string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    if (((Object)object).length % 2 == 0) {
                        byArray = new byte[((Object)object).length / 2];
                        System.arraycopy(object, 0, byArray, 0, byArray.length);
                        string = new String(Util.Base64Encode((byte[])byArray), "iso8859-1");
                        string = new PEMString(string).getPemString();
                        iniFile.putString(string3, "CRL", string);
                        System.arraycopy(object, byArray.length, byArray, 0, byArray.length);
                        string = new String(Util.Base64Encode((byte[])byArray), "iso8859-1");
                        string = new PEMString(string).getPemString();
                        iniFile.putString(string3, "CRL1", string);
                        continue;
                    }
                    byArray = new byte[((Object)object).length / 2];
                    System.arraycopy(object, 0, byArray, 0, byArray.length);
                    string = new String(Util.Base64Encode((byte[])byArray), "iso8859-1");
                    string = new PEMString(string).getPemString();
                    iniFile.putString(string3, "CRL", string);
                    byArray = new byte[((Object)object).length / 2 + 1];
                    System.arraycopy(object, byArray.length - 1, byArray, 0, byArray.length);
                    string = new String(Util.Base64Encode((byte[])byArray), "iso8859-1");
                    string = new PEMString(string).getPemString();
                    iniFile.putString(string3, "CRL1", string);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException3) {
                    if (((Object)object).length % 2 == 0) {
                        byArray = new byte[((Object)object).length / 2];
                        System.arraycopy(object, 0, byArray, 0, byArray.length);
                        string = new String(Util.Base64Encode((byte[])byArray));
                        string = new PEMString(string).getPemString();
                        iniFile.putString(string3, "CRL", string);
                        System.arraycopy(object, byArray.length, byArray, 0, byArray.length);
                        string = new String(Util.Base64Encode((byte[])byArray));
                        string = new PEMString(string).getPemString();
                        iniFile.putString(string3, "CRL1", string);
                        continue;
                    }
                    byArray = new byte[((Object)object).length / 2];
                    System.arraycopy(object, 0, byArray, 0, byArray.length);
                    string = new String(Util.Base64Encode((byte[])byArray));
                    string = new PEMString(string).getPemString();
                    iniFile.putString(string3, "CRL", string);
                    byArray = new byte[((Object)object).length / 2 + 1];
                    System.arraycopy(object, byArray.length - 1, byArray, 0, byArray.length);
                    string = new String(Util.Base64Encode((byte[])byArray));
                    string = new PEMString(string).getPemString();
                    iniFile.putString(string3, "CRL1", string);
                }
            }
        }
        iniFile.writeStream(outputStream);
    }

    public void removeCRL(ASN1Type aSN1Type) {
        this.a.remove(String.valueOf(aSN1Type.toString()) + "false");
        this.a.remove(String.valueOf(aSN1Type.toString()) + "true");
    }

    public void parse(InputStream inputStream) throws UserFatalException {
        try {
            IniFile iniFile = new IniFile(inputStream);
            Enumeration enumeration = iniFile.getSectionNames();
            while (enumeration.hasMoreElements()) {
                Object object;
                String string = (String)enumeration.nextElement();
                String string2 = null;
                try {
                    string2 = new String(Util.Base64Decode((byte[])string.getBytes("iso_8859-1")), "iso_8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    try {
                        string2 = new String(Util.Base64Decode((byte[])string.getBytes("iso8859-1")), "iso8859-1");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException2) {
                        string2 = new String(Util.Base64Decode((byte[])string.getBytes()));
                    }
                }
                Name name = new Name(string2);
                Vector vector = iniFile.getSection(string);
                byte[] byArray = null;
                int n2 = 0;
                while (n2 < vector.size()) {
                    object = (String)vector.elementAt(n2);
                    int n3 = ((String)object).indexOf(61);
                    object = ((String)object).substring(n3 + 1);
                    byte[] byArray2 = null;
                    try {
                        byArray2 = Util.Base64Decode((byte[])((String)object).getBytes("iso_8859-1"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        try {
                            byArray2 = Util.Base64Decode((byte[])((String)object).getBytes("iso8859-1"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException3) {
                            byArray2 = Util.Base64Decode((byte[])((String)object).getBytes());
                        }
                    }
                    if (byArray == null) {
                        byArray = byArray2;
                    } else {
                        byte[] byArray3 = new byte[byArray.length + byArray2.length];
                        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
                        byArray = byArray3;
                    }
                    ++n2;
                }
                object = new X509CRL(byArray);
                this.a.put(String.valueOf(name.toString()) + this.a((X509CRL)object), object);
            }
        }
        catch (Base64Exception base64Exception) {
            throw new UserFatalException(base64Exception.getMessage());
        }
        catch (CRLException cRLException) {
            throw new UserFatalException(cRLException.getMessage());
        }
    }

    protected void loadCRLs(ASN1Type aSN1Type, Vector vector, boolean bl, X509Certificate x509Certificate, X509Certificate[] x509CertificateArray) {
        block4: {
            Object v2 = this.a.get(String.valueOf(aSN1Type.toString()) + bl);
            if (v2 == null) break block4;
            if (vector == null) {
                vector = new Vector();
            }
            try {
                ASN1Type aSN1Type2;
                X509CRL x509CRL = (X509CRL)v2;
                IssuingDistributionPoint issuingDistributionPoint = (IssuingDistributionPoint)x509CRL.getExtension(IssuingDistributionPoint.oid);
                if (issuingDistributionPoint != null && (aSN1Type2 = issuingDistributionPoint.getDistributionPointName()) != null && !aSN1Type2.equals(aSN1Type)) {
                    return;
                }
                this.validateCRL(x509CRL, x509Certificate, x509CertificateArray);
                vector.addElement(v2);
            }
            catch (Exception exception) {}
        }
    }

    private boolean b(X509CRL x509CRL) {
        if (x509CRL == null) {
            return false;
        }
        try {
            IssuingDistributionPoint issuingDistributionPoint = (IssuingDistributionPoint)x509CRL.getExtension(IssuingDistributionPoint.oid);
            if (issuingDistributionPoint == null) {
                return true;
            }
            return !issuingDistributionPoint.getOnlyContainsCaCerts() && issuingDistributionPoint.getOnlyContainsUserCerts();
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            return true;
        }
    }

    private boolean a(X509CRL x509CRL) {
        if (x509CRL == null) {
            return false;
        }
        try {
            IssuingDistributionPoint issuingDistributionPoint = (IssuingDistributionPoint)x509CRL.getExtension(IssuingDistributionPoint.oid);
            if (issuingDistributionPoint == null) {
                return true;
            }
            return issuingDistributionPoint.getOnlyContainsUserCerts() ^ true;
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            return true;
        }
    }

    public void initMemoryCache(CachedCRLRS cachedCRLRS) {
        Enumeration enumeration = this.a.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            X509CRL x509CRL = (X509CRL)this.a.get(string);
            boolean bl = true;
            if (string.endsWith("true")) {
                string = string.substring(0, string.length() - 4);
            } else if (string.endsWith("false")) {
                string = string.substring(0, string.length() - 5);
                bl = false;
            }
            if (string.startsWith("uniformResourceIdentifier")) {
                GeneralName generalName = new GeneralName(GeneralName.uniformResourceIdentifier, (Object)string.substring(27));
                cachedCRLRS.a(x509CRL, (ASN1Type)new GeneralNames(generalName), this.a(x509CRL));
                continue;
            }
            cachedCRLRS.a(x509CRL, (ASN1Type)new Name(string), this.a(x509CRL));
        }
    }

    public void cleanup() {
        Enumeration enumeration = this.a.keys();
        Date date = new Date();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            X509CRL x509CRL = (X509CRL)this.a.get(string);
            Date date2 = x509CRL.getNextUpdate();
            if (date2 == null || !date2.before(date)) continue;
            this.a.remove(string);
        }
    }

    public void addMemoryCache(CachedCRLRS cachedCRLRS) {
        this.addCRLs(cachedCRLRS.getCRLs());
    }

    public void addCRLs(DistPointAndCRL[] distPointAndCRLArray) {
        int n2 = 0;
        while (n2 < distPointAndCRLArray.length) {
            this.addCRL(distPointAndCRLArray[n2]);
            ++n2;
        }
    }

    public void addCRL(DistPointAndCRL distPointAndCRL) {
        String string = String.valueOf(distPointAndCRL.getDistPoint().toString()) + this.a(distPointAndCRL.getCRL());
        this.a.put(string, distPointAndCRL.getCRL());
    }

    public ArchiveCRLCache(InputStream inputStream, ValidationInfo validationInfo) throws UserFatalException {
        super(validationInfo);
        this.parse(inputStream);
    }

    public ArchiveCRLCache(ValidationInfo validationInfo) {
        super(validationInfo);
    }
}

