/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.x509.revocation;

import com.entrust.toolkit.exceptions.CertificationException;
import com.entrust.toolkit.x509.ValidationInfo;
import com.entrust.toolkit.x509.revocation.CachedCRLRS;
import com.entrust.toolkit.x509.revocation.DirectoryCRLRS;
import com.entrust.toolkit.x509.revocation.DistPointAndCRL;
import com.entrust.toolkit.x509.revocation.HttpCRLRS;
import com.entrust.toolkit.x509.revocation.RevocationStore;
import com.entrust.toolkit.x509.revocation.X509CRLRS;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.extensions.BasicConstraints;
import iaik.x509.extensions.IssuingDistributionPoint;
import java.util.Enumeration;
import java.util.Vector;

public class CollectionRS
extends RevocationStore {
    private boolean c = false;
    private Vector b = new Vector();
    private ValidationInfo a = null;
    static final boolean d = false;

    private void a(X509CRLRS x509CRLRS) {
        DistPointAndCRL[] distPointAndCRLArray;
        if (x509CRLRS instanceof DirectoryCRLRS) {
            distPointAndCRLArray = ((DirectoryCRLRS)x509CRLRS).getCRLs();
        } else if (x509CRLRS instanceof HttpCRLRS) {
            distPointAndCRLArray = ((HttpCRLRS)x509CRLRS).getCRLs();
        } else {
            return;
        }
        Enumeration enumeration = this.b.elements();
        CachedCRLRS cachedCRLRS = null;
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            if (!(e2 instanceof CachedCRLRS)) continue;
            cachedCRLRS = (CachedCRLRS)e2;
            break;
        }
        if (cachedCRLRS == null) {
            return;
        }
        int n2 = 0;
        while (n2 < distPointAndCRLArray.length) {
            cachedCRLRS.a(distPointAndCRLArray[n2].getCRL(), distPointAndCRLArray[n2].getDistPoint(), this.a(distPointAndCRLArray[n2].getCRL()));
            ++n2;
        }
    }

    public void setMaximumCRLLifetime(int n2) {
        long l = n2 * 60 * 60 * 1000;
        Enumeration enumeration = this.b.elements();
        while (enumeration.hasMoreElements()) {
            Object e2 = enumeration.nextElement();
            if (!(e2 instanceof X509CRLRS)) continue;
            ((X509CRLRS)e2).setMaximumCRLLifetime(l);
        }
    }

    public void requireCRL(boolean bl) {
        this.c = bl;
    }

    private boolean a(X509CRL x509CRL) {
        if (x509CRL == null) {
            return false;
        }
        try {
            IssuingDistributionPoint issuingDistributionPoint = (IssuingDistributionPoint)x509CRL.getExtension(IssuingDistributionPoint.oid);
            if (issuingDistributionPoint == null) {
                return true;
            }
            return issuingDistributionPoint.getOnlyContainsUserCerts() ^ true;
        }
        catch (X509ExtensionInitException x509ExtensionInitException) {
            return true;
        }
    }

    public CachedCRLRS getMemoryCRLCache() {
        Enumeration enumeration = this.b.elements();
        CachedCRLRS cachedCRLRS = null;
        while (enumeration.hasMoreElements()) {
            RevocationStore revocationStore = (RevocationStore)enumeration.nextElement();
            if (!(revocationStore instanceof CachedCRLRS)) continue;
            cachedCRLRS = (CachedCRLRS)revocationStore;
            break;
        }
        return cachedCRLRS;
    }

    public void check(X509Certificate[] x509CertificateArray) throws CertificationException {
        X509Certificate x509Certificate = this.a.getRootOfTrust();
        int n2 = x509CertificateArray.length;
        while (n2 > 0) {
            if (x509Certificate == null || x509Certificate.hashCode() != x509CertificateArray[n2 - 1].hashCode()) {
                this.check(x509CertificateArray[n2 - 1], x509CertificateArray);
            }
            --n2;
        }
    }

    protected boolean check(X509Certificate x509Certificate, X509Certificate[] x509CertificateArray) throws CertificationException {
        Object object;
        boolean bl = false;
        try {
            object = new BasicConstraints();
            object = (BasicConstraints)x509Certificate.getExtension(object.getObjectID());
            bl = object.ca();
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl && this.a.getClientSettings() != null && this.a.getClientSettings().getSkipRLcheck()) {
            return true;
        }
        object = this.b.elements();
        while (object.hasMoreElements()) {
            RevocationStore revocationStore = (RevocationStore)object.nextElement();
            boolean bl2 = revocationStore.check(x509Certificate, x509CertificateArray);
            this.a((X509CRLRS)revocationStore);
            if (!bl2) continue;
            return true;
        }
        if (this.c) {
            throw new CertificationException("No CRLs were available.");
        }
        return false;
    }

    public void attach(RevocationStore revocationStore) {
        this.b.addElement(revocationStore);
    }

    public CollectionRS(ValidationInfo validationInfo) {
        if (validationInfo == null) {
            throw new NullPointerException();
        }
        this.a = validationInfo;
        this.attach(new CachedCRLRS(validationInfo));
        this.attach(new DirectoryCRLRS(validationInfo));
        this.attach(new HttpCRLRS(validationInfo));
    }
}

