/*
 * Decompiled with CFR 0.152.
 */
package com.entrust.toolkit.x509.revocation;

import com.entrust.toolkit.User;
import com.entrust.toolkit.exceptions.CertificationException;
import com.entrust.toolkit.util.LdapURL;
import com.entrust.toolkit.x509.LdapDirectory;
import com.entrust.toolkit.x509.ValidationInfo;
import com.entrust.toolkit.x509.directory.JNDIDirectory;
import com.entrust.toolkit.x509.revocation.CachedCRLRS;
import com.entrust.toolkit.x509.revocation.DistPointAndCRL;
import com.entrust.toolkit.x509.revocation.X509CRLRS;
import iaik.asn1.ASN1Type;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import iaik.x509.extensions.IssuingDistributionPoint;
import java.util.Enumeration;
import java.util.Vector;

public class DirectoryCRLRS
extends X509CRLRS {
    private CachedCRLRS a;
    static final boolean b = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void loadCRLs(ASN1Type aSN1Type, Vector vector, boolean bl, X509Certificate x509Certificate, X509Certificate[] x509CertificateArray) {
        LdapDirectory ldapDirectory = this.m_validationInfo.getDirectory();
        if (ldapDirectory == null) {
            return;
        }
        X509CRL[] x509CRLArray = null;
        int n2 = 0;
        try {
            LdapURL ldapURL;
            String string;
            Name name = new Name();
            if (aSN1Type instanceof GeneralNames) {
                string = this.a((GeneralNames)aSN1Type);
                if (!LdapURL.isLdapURL(string)) return;
                ldapURL = new LdapURL(string);
                name = ldapURL.getDN();
                String string2 = ldapURL.getHost();
                int n3 = ldapURL.getPort();
                ldapDirectory = new JNDIDirectory(string2, n3);
                User user = new User();
                user.setConnections(ldapDirectory, null);
            } else {
                name = (Name)aSN1Type;
            }
            x509CRLArray = ldapDirectory.getCRLs(name.getName(), bl);
            n2 = 0;
            while (n2 < x509CRLArray.length) {
                string = (IssuingDistributionPoint)x509CRLArray[n2].getExtension(IssuingDistributionPoint.oid);
                if (string == null || !(ldapURL = string.getDistributionPointName()).equals(aSN1Type)) {
                    try {
                        this.validateCRL(x509CRLArray[n2], x509Certificate, x509CertificateArray);
                        this.a.a(x509CRLArray[n2], aSN1Type, bl);
                        vector.addElement(x509CRLArray[n2]);
                    }
                    catch (CertificationException certificationException) {}
                }
                ++n2;
            }
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String a(GeneralNames generalNames) {
        Enumeration enumeration = generalNames.getNames();
        while (enumeration.hasMoreElements()) {
            GeneralName generalName = (GeneralName)enumeration.nextElement();
            if (generalName.getType() != GeneralName.uniformResourceIdentifier) continue;
            String string = (String)generalName.getName();
            return string;
        }
        return null;
    }

    protected DistPointAndCRL[] getCRLs() {
        return this.a.getCRLs();
    }

    public DirectoryCRLRS(ValidationInfo validationInfo) {
        super(validationInfo);
        this.a = new CachedCRLRS(validationInfo);
    }
}

